/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.google.inject.spi;

import java.util.Set;
import org.apache.hadoop.hbase.shaded.com.google.inject.Binder;
import org.apache.hadoop.hbase.shaded.com.google.inject.ConfigurationException;
import org.apache.hadoop.hbase.shaded.com.google.inject.internal.util.$Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.inject.spi.Element;
import org.apache.hadoop.hbase.shaded.com.google.inject.spi.ElementVisitor;
import org.apache.hadoop.hbase.shaded.com.google.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = $Preconditions.checkNotNull(source, "source");
        this.type = $Preconditions.checkNotNull(type, "type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

