/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Request;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.Response;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.security.Authenticator;
import org.apache.hadoop.hbase.shaded.org.mortbay.jetty.security.UserRealm;

public class ClientCertAuthenticator
implements Authenticator {
    private int _maxHandShakeSeconds = 60;

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int maxHandShakeSeconds) {
        this._maxHandShakeSeconds = maxHandShakeSeconds;
    }

    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        String username;
        Principal user;
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0 || certs[0] == null) {
            if (response != null) {
                response.sendError(403, "A client certificate is required for accessing this web application but the server's listener is not configured for mutual authentication (or the client did not provide a certificate).");
            }
            return null;
        }
        Principal principal = certs[0].getSubjectDN();
        if (principal == null) {
            principal = certs[0].getIssuerDN();
        }
        if ((user = realm.authenticate(username = principal == null ? "clientcert" : principal.getName(), certs, request)) == null) {
            if (response != null) {
                response.sendError(403, "The provided client certificate does not correspond to a trusted user.");
            }
            return null;
        }
        request.setAuthType("CLIENT_CERT");
        request.setUserPrincipal(user);
        return user;
    }

    public String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

