/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.util.Arrays;
import java.util.Locale;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;

public class CreateSnapshot
extends AbstractHBaseTool {
    private SnapshotType snapshotType = SnapshotType.FLUSH;
    private TableName tableName = null;
    private String snapshotName = null;

    public static void main(String[] args) {
        new CreateSnapshot().doStaticMain(args);
    }

    @Override
    protected void addOptions() {
        this.addRequiredOptWithArg("t", "table", "The name of the table");
        this.addRequiredOptWithArg("n", "name", "The name of the created snapshot");
        this.addOptWithArg("s", "snapshot_type", "Snapshot Type. FLUSH is default. Posible values are " + Arrays.toString((Object[])SnapshotType.values()));
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.tableName = TableName.valueOf(cmd.getOptionValue('t'));
        this.snapshotName = cmd.getOptionValue('n');
        String snapshotTypeName = cmd.getOptionValue('s');
        if (snapshotTypeName != null) {
            snapshotTypeName = snapshotTypeName.toUpperCase(Locale.ROOT);
            this.snapshotType = SnapshotType.valueOf(snapshotTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() throws Exception {
        Connection connection = null;
        Admin admin = null;
        try {
            connection = ConnectionFactory.createConnection(this.getConf());
            admin = connection.getAdmin();
            admin.snapshot(new SnapshotDescription(this.snapshotName, this.tableName, this.snapshotType));
        }
        catch (Exception e) {
            System.err.println("failed to take the snapshot: " + e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return 0;
    }
}

