/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateImpl;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.emit.StandardEmitter;
import org.apache.hadoop.hbase.shaded.org.jamon.escaping.Escaping;
import org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.util.StringUtils;

public class RegionServerListTmplImpl
extends AbstractTemplateImpl
implements RegionServerListTmpl.Intf {
    private final HMaster master;
    private final List<ServerName> servers;

    protected static RegionServerListTmpl.ImplData __jamon_setOptionalArguments(RegionServerListTmpl.ImplData p_implData) {
        if (!p_implData.getServers__IsNotDefault()) {
            p_implData.setServers(null);
        }
        return p_implData;
    }

    public RegionServerListTmplImpl(TemplateManager p_templateManager, RegionServerListTmpl.ImplData p_implData) {
        super(p_templateManager, RegionServerListTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
        this.servers = p_implData.getServers();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.servers != null && this.servers.size() > 0) {
            jamonWriter.write("\n\n");
            Object[] serverNames = this.servers.toArray(new ServerName[this.servers.size()]);
            Arrays.sort(serverNames);
            jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
            this.__jamon_innerUnit__baseStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
            this.__jamon_innerUnit__memoryStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
            this.__jamon_innerUnit__requestStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
            this.__jamon_innerUnit__storeStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
            this.__jamon_innerUnit__compactionStats(jamonWriter, (ServerName[])serverNames);
            jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__baseStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n");
        int totalRegions = 0;
        int totalRequests = 0;
        int inconsistentNodeNum = 0;
        String masterVersion = VersionInfo.getVersion();
        for (ServerName serverName : serverNames) {
            ServerLoad sl = this.master.getServerManager().getLoad(serverName);
            String version = this.master.getRegionServerVersion(serverName);
            if (!masterVersion.equals(version)) {
                ++inconsistentNodeNum;
            }
            double requestsPerSecond = 0.0;
            int numRegionsOnline = 0;
            long lastContact = 0L;
            if (sl != null) {
                requestsPerSecond = sl.getRequestsPerSecond();
                numRegionsOnline = sl.getNumberOfRegions();
                totalRegions += sl.getNumberOfRegions();
                totalRequests = (int)((long)totalRequests + sl.getNumberOfRequests());
                lastContact = (System.currentTimeMillis() - sl.getReportTime()) / 1000L;
            }
            long startcode = serverName.getStartcode();
            jamonWriter.write("<tr>\n    <td>");
            this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf(version), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
            jamonWriter.write("</td>\n</tr>\n");
        }
        jamonWriter.write("<tr><td>Total:");
        Escaping.HTML.write(StandardEmitter.valueOf(this.servers.size()), jamonWriter);
        jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
        if (inconsistentNodeNum > 0) {
            jamonWriter.write("\n  <td style=\"color:red;\">");
            Escaping.HTML.write(StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
            jamonWriter.write(" nodes with inconsistent version</td>\n");
        } else {
            jamonWriter.write("\n   <td></td>\n");
        }
        jamonWriter.write("\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf(totalRequests), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf(totalRegions), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__compactionStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n");
        for (ServerName serverName : serverNames) {
            ServerLoad sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                String percentDone = "";
                if (sl.getTotalCompactingKVs() > 0L) {
                    percentDone = String.format("%.2f", Float.valueOf(100.0f * ((float)sl.getCurrentCompactedKVs() / (float)sl.getTotalCompactingKVs()))) + "%";
                }
                jamonWriter.write("<tr>\n<td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(percentDone), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</table>\n");
    }

    private void __jamon_innerUnit__emptyStat(Writer jamonWriter, ServerName serverName) throws IOException {
        jamonWriter.write("<tr>\n    <td>");
        this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
        jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
    }

    private void __jamon_innerUnit__memoryStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
        for (ServerName serverName : serverNames) {
            ServerLoad sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                jamonWriter.write("<tr>\n    <td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getUsedHeapMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getMaxHeapMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getMemstoreSizeMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</table>\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
        for (ServerName serverName : serverNames) {
            ServerLoad sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                jamonWriter.write("<tr>\n<td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getFilteredReadRequestsCount()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</table>\n");
    }

    private void __jamon_innerUnit__serverNameLink(Writer jamonWriter, ServerName serverName, ServerLoad serverLoad) throws IOException {
        int infoPort = this.master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        if (infoPort > 0) {
            jamonWriter.write("\n            <a href=\"");
            Escaping.HTML.write(StandardEmitter.valueOf(url), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
            jamonWriter.write("</a>\n        ");
        } else {
            jamonWriter.write("\n            ");
            Escaping.HTML.write(StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
            jamonWriter.write("\n        ");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, ServerName[] serverNames) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
        for (ServerName serverName : serverNames) {
            ServerLoad sl = this.master.getServerManager().getLoad(serverName);
            if (sl != null) {
                jamonWriter.write("<tr>\n<td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getStores()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getStoreUncompressedSizeMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getStorefileSizeMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getTotalStaticIndexSizeKB() * StringUtils.TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n<td>");
                Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)sl.getTotalStaticBloomSizeKB() * StringUtils.TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
                continue;
            }
            this.__jamon_innerUnit__emptyStat(jamonWriter, serverName);
            jamonWriter.write("\n");
        }
        jamonWriter.write("</table>\n");
    }
}

