/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.client.ConnectStringParser;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Canary
implements Tool {
    private static final int USAGE_EXIT_CODE = 1;
    private static final int INIT_ERROR_EXIT_CODE = 2;
    private static final int TIMEOUT_ERROR_EXIT_CODE = 3;
    private static final int ERROR_EXIT_CODE = 4;
    private static final int FAILURE_EXIT_CODE = 5;
    private static final long DEFAULT_INTERVAL = 6000L;
    private static final long DEFAULT_TIMEOUT = 600000L;
    private static final int MAX_THREADS_NUM = 16;
    private static final Log LOG = LogFactory.getLog(Canary.class);
    public static final TableName DEFAULT_WRITE_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "canary");
    private static final String CANARY_TABLE_FAMILY_NAME = "Test";
    private Configuration conf = null;
    private long interval = 0L;
    private Sink sink = null;
    private boolean useRegExp;
    private long timeout = 600000L;
    private boolean failOnError = true;
    private boolean regionServerMode = false;
    private boolean zookeeperMode = false;
    private boolean regionServerAllRegions = false;
    private boolean writeSniffing = false;
    private long configuredWriteTableTimeout = 600000L;
    private boolean treatFailureAsError = false;
    private TableName writeTableName = DEFAULT_WRITE_TABLE_NAME;
    private HashMap<String, Long> configuredReadTableTimeouts = new HashMap();
    private ExecutorService executor;

    public Canary() {
        this(new ScheduledThreadPoolExecutor(1), new RegionServerStdOutSink());
    }

    public Canary(ExecutorService executor, Sink sink) {
        this.executor = executor;
        this.sink = sink;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    private int parseArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.startsWith("-")) {
                if (index >= 0) {
                    System.err.println("Invalid command line options");
                    this.printUsageAndExit();
                }
                if (cmd.equals("-help")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("-daemon") && this.interval == 0L) {
                    this.interval = 6000L;
                    continue;
                }
                if (cmd.equals("-interval")) {
                    if (++i == args.length) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.interval = Long.parseLong(args[i]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-zookeeper")) {
                    this.zookeeperMode = true;
                    continue;
                }
                if (cmd.equals("-regionserver")) {
                    this.regionServerMode = true;
                    continue;
                }
                if (cmd.equals("-allRegions")) {
                    this.regionServerAllRegions = true;
                    continue;
                }
                if (cmd.equals("-writeSniffing")) {
                    this.writeSniffing = true;
                    continue;
                }
                if (cmd.equals("-treatFailureAsError")) {
                    this.treatFailureAsError = true;
                    continue;
                }
                if (cmd.equals("-e")) {
                    this.useRegExp = true;
                    continue;
                }
                if (cmd.equals("-t")) {
                    if (++i == args.length) {
                        System.err.println("-t needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.timeout = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-t needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-writeTableTimeout")) {
                    if (++i == args.length) {
                        System.err.println("-writeTableTimeout needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.configuredWriteTableTimeout = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-writeTableTimeout needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-writeTable")) {
                    if (++i == args.length) {
                        System.err.println("-writeTable needs a string value argument.");
                        this.printUsageAndExit();
                    }
                    this.writeTableName = TableName.valueOf(args[i]);
                    continue;
                }
                if (cmd.equals("-f")) {
                    if (++i == args.length) {
                        System.err.println("-f needs a boolean value argument (true|false).");
                        this.printUsageAndExit();
                    }
                    this.failOnError = Boolean.parseBoolean(args[i]);
                    continue;
                }
                if (cmd.equals("-readTableTimeouts")) {
                    String[] tableTimeouts;
                    if (++i == args.length) {
                        System.err.println("-readTableTimeouts needs a comma-separated list of read timeouts per table (without spaces).");
                        this.printUsageAndExit();
                    }
                    for (String tT : tableTimeouts = args[i].split(",")) {
                        String[] nameTimeout = tT.split("=");
                        if (nameTimeout.length < 2) {
                            System.err.println("Each -readTableTimeouts argument must be of the form <tableName>=<read timeout>.");
                            this.printUsageAndExit();
                        }
                        long timeoutVal = 0L;
                        try {
                            timeoutVal = Long.parseLong(nameTimeout[1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("-readTableTimeouts read timeout for each table must be a numeric value argument.");
                            this.printUsageAndExit();
                        }
                        this.configuredReadTableTimeouts.put(nameTimeout[0], timeoutVal);
                    }
                    continue;
                }
                System.err.println(cmd + " options is invalid.");
                this.printUsageAndExit();
                continue;
            }
            if (index >= 0) continue;
            index = i;
        }
        if (this.regionServerAllRegions && !this.regionServerMode) {
            System.err.println("-allRegions can only be specified in regionserver mode.");
            this.printUsageAndExit();
        }
        if (this.zookeeperMode && (this.regionServerMode || this.regionServerAllRegions || this.writeSniffing)) {
            System.err.println("-zookeeper is exclusive and cannot be combined with other modes.");
            this.printUsageAndExit();
        }
        if (!this.configuredReadTableTimeouts.isEmpty() && (this.regionServerMode || this.zookeeperMode)) {
            System.err.println("-readTableTimeouts can only be configured in region mode.");
            this.printUsageAndExit();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int run(String[] args) throws Exception {
        int index = this.parseArgs(args);
        ChoreService choreService = null;
        ScheduledChore authChore = AuthUtil.getAuthChore(this.conf);
        if (authChore != null) {
            choreService = new ChoreService("CANARY_TOOL");
            choreService.scheduleChore(authChore);
        }
        Monitor monitor = null;
        Thread monitorThread = null;
        long startTime = 0L;
        long currentTimeLength = 0L;
        try (Connection connection = ConnectionFactory.createConnection(this.conf);){
            do {
                try {
                    monitor = this.newMonitor(connection, index, args);
                    monitorThread = new Thread((Runnable)monitor, "CanaryMonitor-" + System.currentTimeMillis());
                    startTime = System.currentTimeMillis();
                    monitorThread.start();
                    while (!monitor.isDone()) {
                        Thread.sleep(1000L);
                        if (this.failOnError && monitor.hasError()) {
                            monitorThread.interrupt();
                            if (monitor.initialized) {
                                int n = monitor.errorCode;
                                return n;
                            }
                            int n = 2;
                            return n;
                        }
                        currentTimeLength = System.currentTimeMillis() - startTime;
                        if (currentTimeLength <= this.timeout) continue;
                        LOG.error((Object)("The monitor is running too long (" + currentTimeLength + ") after timeout limit:" + this.timeout + " will be killed itself !!"));
                        if (monitor.initialized) {
                            int n = 3;
                            return n;
                        }
                        int n = 2;
                        return n;
                    }
                    if (this.failOnError && monitor.finalCheckForErrors()) {
                        monitorThread.interrupt();
                        int n = monitor.errorCode;
                        return n;
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                Thread.sleep(this.interval);
            } while (this.interval > 0L);
        }
        if (choreService == null) return monitor.errorCode;
        choreService.shutdown();
        return monitor.errorCode;
    }

    public Map<String, String> getReadFailures() {
        return this.sink.getReadFailures();
    }

    public Map<String, String> getWriteFailures() {
        return this.sink.getWriteFailures();
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: hbase %s [opts] [table1 [table2]...] | [regionserver1 [regionserver2]..]%n", this.getClass().getName());
        System.err.println(" where [opts] are:");
        System.err.println("   -help          Show this help and exit.");
        System.err.println("   -regionserver  replace the table argument to regionserver,");
        System.err.println("      which means to enable regionserver mode");
        System.err.println("   -allRegions    Tries all regions on a regionserver,");
        System.err.println("      only works in regionserver mode.");
        System.err.println("   -zookeeper    Tries to grab zookeeper.znode.parent ");
        System.err.println("      on each zookeeper instance");
        System.err.println("   -daemon        Continuous check at defined intervals.");
        System.err.println("   -interval <N>  Interval between checks (sec)");
        System.err.println("   -e             Use table/regionserver as regular expression");
        System.err.println("      which means the table/regionserver is regular expression pattern");
        System.err.println("   -f <B>         stop whole program if first error occurs, default is true");
        System.err.println("   -t <N>         timeout for a check, default is 600000 (millisecs)");
        System.err.println("   -writeTableTimeout <N>         write timeout for the writeTable, default is 600000 (millisecs)");
        System.err.println("   -readTableTimeouts <tableName>=<read timeout>,<tableName>=<read timeout>, ...    comma-separated list of read timeouts per table (no spaces), default is 600000 (millisecs)");
        System.err.println("   -writeSniffing enable the write sniffing in canary");
        System.err.println("   -treatFailureAsError treats read / write failure as error");
        System.err.println("   -writeTable    The table used for write sniffing. Default is hbase:canary");
        System.err.println("   -Dhbase.canary.read.raw.enabled=<true/false> Use this flag to enable or disable raw scan during read canary test Default is false and raw is not enabled during scan");
        System.err.println("   -D<configProperty>=<value> assigning or override the configuration params");
        System.exit(1);
    }

    public Monitor newMonitor(Connection connection, int index, String[] args) {
        Monitor monitor = null;
        String[] monitorTargets = null;
        if (index >= 0) {
            int length = args.length - index;
            monitorTargets = new String[length];
            System.arraycopy(args, index, monitorTargets, 0, length);
        }
        monitor = this.regionServerMode ? new RegionServerMonitor(connection, monitorTargets, this.useRegExp, (ExtendedSink)this.sink, this.executor, this.regionServerAllRegions, this.treatFailureAsError) : (this.zookeeperMode ? new ZookeeperMonitor(connection, monitorTargets, this.useRegExp, (ZookeeperStdOutSink)this.sink, this.executor, this.treatFailureAsError) : new RegionMonitor(connection, monitorTargets, this.useRegExp, (RegionStdOutSink)this.sink, this.executor, this.writeSniffing, this.writeTableName, this.treatFailureAsError, this.configuredReadTableTimeouts, this.configuredWriteTableTimeout));
        return monitor;
    }

    private static List<Future<Void>> sniff(Admin admin, Sink sink, String tableName, ExecutorService executor, RegionTask.TaskType taskType, boolean rawScanEnabled, LongAdder readLatency) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("checking table is enabled and getting table descriptor for table %s", tableName));
        }
        if (admin.isTableEnabled(TableName.valueOf(tableName))) {
            return Canary.sniff(admin, sink, admin.getTableDescriptor(TableName.valueOf(tableName)), executor, taskType, rawScanEnabled, readLatency);
        }
        LOG.warn((Object)String.format("Table %s is not enabled", tableName));
        return new LinkedList<Future<Void>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Future<Void>> sniff(Admin admin, Sink sink, HTableDescriptor tableDesc, ExecutorService executor, RegionTask.TaskType taskType, boolean rawScanEnabled, LongAdder rwLatency) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("reading list of regions for table %s", tableDesc.getTableName()));
        }
        try (Table table = null;){
            table = admin.getConnection().getTable(tableDesc.getTableName());
        }
        ArrayList<RegionTask> tasks = new ArrayList<RegionTask>();
        try (RegionLocator regionLocator = null;){
            regionLocator = admin.getConnection().getRegionLocator(tableDesc.getTableName());
            for (HRegionLocation location : regionLocator.getAllRegionLocations()) {
                ServerName rs = location.getServerName();
                HRegionInfo region = location.getRegionInfo();
                tasks.add(new RegionTask(admin.getConnection(), region, rs, (RegionStdOutSink)sink, taskType, rawScanEnabled, rwLatency));
            }
        }
        return executor.invokeAll(tasks);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        new GenericOptionsParser(conf, args);
        int numThreads = conf.getInt("hbase.canary.threads.num", 16);
        LOG.info((Object)("Number of execution threads " + numThreads));
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads);
        Class<Sink> sinkClass = conf.getClass("hbase.canary.sink.class", RegionServerStdOutSink.class, Sink.class);
        Sink sink = ReflectionUtils.newInstance(sinkClass, new Object[0]);
        int exitCode = ToolRunner.run(conf, new Canary(executor, sink), args);
        executor.shutdown();
        System.exit(exitCode);
    }

    private static class RegionServerMonitor
    extends Monitor {
        private boolean allRegions;

        public RegionServerMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, ExtendedSink sink, ExecutorService executor, boolean allRegions, boolean treatFailureAsError) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError);
            this.allRegions = allRegions;
        }

        private ExtendedSink getSink() {
            return (ExtendedSink)this.sink;
        }

        @Override
        public void run() {
            if (this.initAdmin() && this.checkNoTableNames()) {
                Map<String, List<HRegionInfo>> rsAndRMap = this.filterRegionServerByName();
                this.initialized = true;
                this.monitorRegionServers(rsAndRMap);
            }
            this.done = true;
        }

        private boolean checkNoTableNames() {
            ArrayList<String> foundTableNames = new ArrayList<String>();
            TableName[] tableNames = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("reading list of tables", new Object[0]));
            }
            try {
                tableNames = this.admin.listTableNames();
            }
            catch (IOException e) {
                LOG.error((Object)"Get listTableNames failed", (Throwable)e);
                this.errorCode = 2;
                return false;
            }
            if (this.targets == null || this.targets.length == 0) {
                return true;
            }
            for (String target : this.targets) {
                for (TableName tableName : tableNames) {
                    if (!target.equals(tableName.getNameAsString())) continue;
                    foundTableNames.add(target);
                }
            }
            if (foundTableNames.size() > 0) {
                System.err.println("Cannot pass a tablename when using the -regionserver option, tablenames:" + ((Object)foundTableNames).toString());
                this.errorCode = 1;
            }
            return foundTableNames.isEmpty();
        }

        private void monitorRegionServers(Map<String, List<HRegionInfo>> rsAndRMap) {
            String serverName;
            ArrayList<RegionServerTask> tasks = new ArrayList<RegionServerTask>();
            HashMap<String, AtomicLong> successMap = new HashMap<String, AtomicLong>();
            Random rand = new Random();
            for (Map.Entry<String, List<HRegionInfo>> entry : rsAndRMap.entrySet()) {
                serverName = entry.getKey();
                AtomicLong successes = new AtomicLong(0L);
                successMap.put(serverName, successes);
                if (entry.getValue().isEmpty()) {
                    LOG.error((Object)String.format("Regionserver not serving any regions - %s", serverName));
                    continue;
                }
                if (this.allRegions) {
                    for (HRegionInfo region : entry.getValue()) {
                        tasks.add(new RegionServerTask(this.connection, serverName, region, this.getSink(), successes));
                    }
                    continue;
                }
                HRegionInfo region = entry.getValue().get(rand.nextInt(entry.getValue().size()));
                tasks.add(new RegionServerTask(this.connection, serverName, region, this.getSink(), successes));
            }
            try {
                for (Future future : this.executor.invokeAll(tasks)) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.error((Object)"Sniff regionserver failed!", (Throwable)e);
                        this.errorCode = 4;
                    }
                }
                if (this.allRegions) {
                    for (Map.Entry entry : rsAndRMap.entrySet()) {
                        serverName = (String)entry.getKey();
                        LOG.info((Object)("Successfully read " + successMap.get(serverName) + " regions out of " + ((List)entry.getValue()).size() + " on regionserver:" + serverName));
                    }
                }
            }
            catch (InterruptedException e) {
                this.errorCode = 4;
                LOG.error((Object)"Sniff regionserver interrupted!", (Throwable)e);
            }
        }

        private Map<String, List<HRegionInfo>> filterRegionServerByName() {
            Map<String, List<HRegionInfo>> regionServerAndRegionsMap = this.getAllRegionServerByName();
            regionServerAndRegionsMap = this.doFilterRegionServerByName(regionServerAndRegionsMap);
            return regionServerAndRegionsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, List<HRegionInfo>> getAllRegionServerByName() {
            HashMap<String, List<HRegionInfo>> rsAndRMap = new HashMap<String, List<HRegionInfo>>();
            Table table = null;
            RegionLocator regionLocator = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("reading list of tables and locations", new Object[0]));
                }
                HTableDescriptor[] tableDescs = this.admin.listTables();
                List<HRegionInfo> regions = null;
                for (HTableDescriptor tableDesc : tableDescs) {
                    table = this.admin.getConnection().getTable(tableDesc.getTableName());
                    regionLocator = this.admin.getConnection().getRegionLocator(tableDesc.getTableName());
                    for (HRegionLocation location : regionLocator.getAllRegionLocations()) {
                        ServerName rs = location.getServerName();
                        String rsName = rs.getHostname();
                        HRegionInfo r = location.getRegionInfo();
                        if (rsAndRMap.containsKey(rsName)) {
                            regions = (List)rsAndRMap.get(rsName);
                        } else {
                            regions = new ArrayList();
                            rsAndRMap.put(rsName, regions);
                        }
                        regions.add(r);
                    }
                    table.close();
                }
                for (ServerName rs : this.admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers()) {
                    String rsName = rs.getHostname();
                    if (rsAndRMap.containsKey(rsName)) continue;
                    rsAndRMap.put(rsName, Collections.emptyList());
                }
            }
            catch (IOException e) {
                String msg = "Get HTables info failed";
                LOG.error((Object)msg, (Throwable)e);
                this.errorCode = 2;
            }
            finally {
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Close table failed", (Throwable)e);
                    }
                }
            }
            return rsAndRMap;
        }

        private Map<String, List<HRegionInfo>> doFilterRegionServerByName(Map<String, List<HRegionInfo>> fullRsAndRMap) {
            Map<String, List<HRegionInfo>> filteredRsAndRMap = null;
            if (this.targets != null && this.targets.length > 0) {
                filteredRsAndRMap = new HashMap<String, List<HRegionInfo>>();
                Pattern pattern = null;
                Matcher matcher = null;
                boolean regExpFound = false;
                for (String rsName : this.targets) {
                    if (this.useRegExp) {
                        regExpFound = false;
                        pattern = Pattern.compile(rsName);
                        for (Map.Entry<String, List<HRegionInfo>> entry : fullRsAndRMap.entrySet()) {
                            matcher = pattern.matcher(entry.getKey());
                            if (!matcher.matches()) continue;
                            filteredRsAndRMap.put(entry.getKey(), entry.getValue());
                            regExpFound = true;
                        }
                        if (regExpFound) continue;
                        LOG.info((Object)("No RegionServerInfo found, regionServerPattern:" + rsName));
                        continue;
                    }
                    if (fullRsAndRMap.containsKey(rsName)) {
                        filteredRsAndRMap.put(rsName, fullRsAndRMap.get(rsName));
                        continue;
                    }
                    LOG.info((Object)("No RegionServerInfo found, regionServerName:" + rsName));
                }
            } else {
                filteredRsAndRMap = fullRsAndRMap;
            }
            return filteredRsAndRMap;
        }
    }

    private static class ZookeeperMonitor
    extends Monitor {
        private List<String> hosts;
        private final String znode;
        private final int timeout;

        protected ZookeeperMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, ExtendedSink sink, ExecutorService executor, boolean treatFailureAsError) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError);
            Configuration configuration = connection.getConfiguration();
            this.znode = configuration.get("zookeeper.znode.parent", "/hbase");
            this.timeout = configuration.getInt("zookeeper.session.timeout", 90000);
            ConnectStringParser parser = new ConnectStringParser(ZKConfig.getZKQuorumServersString(configuration));
            this.hosts = Lists.newArrayList();
            for (InetSocketAddress server : parser.getServerAddresses()) {
                this.hosts.add(server.toString());
            }
        }

        @Override
        public void run() {
            ArrayList<ZookeeperTask> tasks = Lists.newArrayList();
            for (String string : this.hosts) {
                tasks.add(new ZookeeperTask(this.connection, string, this.znode, this.timeout, this.getSink()));
            }
            try {
                for (Future future : this.executor.invokeAll(tasks)) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.error((Object)"Sniff zookeeper failed!", (Throwable)e);
                        this.errorCode = 4;
                    }
                }
            }
            catch (InterruptedException e) {
                this.errorCode = 4;
                Thread.currentThread().interrupt();
                LOG.error((Object)"Sniff zookeeper interrupted!", (Throwable)e);
            }
            this.done = true;
        }

        private ZookeeperStdOutSink getSink() {
            if (!(this.sink instanceof ZookeeperStdOutSink)) {
                throw new RuntimeException("Can only write to zookeeper sink");
            }
            return (ZookeeperStdOutSink)this.sink;
        }
    }

    private static class RegionMonitor
    extends Monitor {
        private static final int DEFAULT_WRITE_TABLE_CHECK_PERIOD = 600000;
        private static final int DEFAULT_WRITE_DATA_TTL = 86400;
        private long lastCheckTime = -1L;
        private boolean writeSniffing;
        private TableName writeTableName;
        private int writeDataTTL;
        private float regionsLowerLimit;
        private float regionsUpperLimit;
        private int checkPeriod;
        private boolean rawScanEnabled;
        private HashMap<String, Long> configuredReadTableTimeouts;
        private long configuredWriteTableTimeout;

        public RegionMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, RegionStdOutSink sink, ExecutorService executor, boolean writeSniffing, TableName writeTableName, boolean treatFailureAsError, HashMap<String, Long> configuredReadTableTimeouts, long configuredWriteTableTimeout) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError);
            Configuration conf = connection.getConfiguration();
            this.writeSniffing = writeSniffing;
            this.writeTableName = writeTableName;
            this.writeDataTTL = conf.getInt("hbase.canary.write.data.ttl", 86400);
            this.regionsLowerLimit = conf.getFloat("hbase.canary.write.perserver.regions.lowerLimit", 1.0f);
            this.regionsUpperLimit = conf.getFloat("hbase.canary.write.perserver.regions.upperLimit", 1.5f);
            this.checkPeriod = conf.getInt("hbase.canary.write.table.check.period", 600000);
            this.rawScanEnabled = conf.getBoolean("hbase.canary.read.raw.enabled", false);
            this.configuredReadTableTimeouts = new HashMap<String, Long>(configuredReadTableTimeouts);
            this.configuredWriteTableTimeout = configuredWriteTableTimeout;
        }

        private RegionStdOutSink getSink() {
            if (!(this.sink instanceof RegionStdOutSink)) {
                throw new RuntimeException("Can only write to Region sink");
            }
            return (RegionStdOutSink)this.sink;
        }

        @Override
        public void run() {
            if (this.initAdmin()) {
                try {
                    LinkedList<Future<Void>> taskFutures = new LinkedList<Future<Void>>();
                    RegionStdOutSink regionSink = this.getSink();
                    if (this.targets != null && this.targets.length > 0) {
                        String[] tables = this.generateMonitorTables(this.targets);
                        if (!new HashSet<String>(Arrays.asList(tables)).containsAll(this.configuredReadTableTimeouts.keySet())) {
                            LOG.error((Object)"-readTableTimeouts can only specify read timeouts for monitor targets passed via command line.");
                            this.errorCode = 1;
                        }
                        this.initialized = true;
                        for (String table : tables) {
                            LongAdder readLatency = regionSink.initializeAndGetReadLatencyForTable(table);
                            taskFutures.addAll(Canary.sniff(this.admin, regionSink, table, this.executor, RegionTask.TaskType.READ, this.rawScanEnabled, readLatency));
                        }
                    } else {
                        taskFutures.addAll(this.sniff(RegionTask.TaskType.READ, regionSink));
                    }
                    if (this.writeSniffing) {
                        if (EnvironmentEdgeManager.currentTime() - this.lastCheckTime > (long)this.checkPeriod) {
                            try {
                                this.checkWriteTableDistribution();
                            }
                            catch (IOException e) {
                                LOG.error((Object)"Check canary table distribution failed!", (Throwable)e);
                            }
                            this.lastCheckTime = EnvironmentEdgeManager.currentTime();
                        }
                        regionSink.initializeWriteLatency();
                        LongAdder writeTableLatency = regionSink.getWriteLatency();
                        taskFutures.addAll(Canary.sniff(this.admin, regionSink, this.admin.getTableDescriptor(this.writeTableName), this.executor, RegionTask.TaskType.WRITE, this.rawScanEnabled, writeTableLatency));
                    }
                    for (Future future : taskFutures) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException executionException) {
                            LOG.error((Object)"Sniff region failed!", (Throwable)executionException);
                        }
                    }
                    Map<String, LongAdder> actualReadTableLatency = regionSink.getReadLatencyMap();
                    for (Map.Entry<String, Long> entry : this.configuredReadTableTimeouts.entrySet()) {
                        String tableName = entry.getKey();
                        if (actualReadTableLatency.containsKey(tableName)) {
                            Long actual = actualReadTableLatency.get(tableName).longValue();
                            Long configured = entry.getValue();
                            LOG.info((Object)("Read operation for " + tableName + " took " + actual + " ms. The configured read timeout was " + configured + " ms."));
                            if (actual <= configured) continue;
                            LOG.error((Object)("Read operation for " + tableName + " exceeded the configured read timeout."));
                            continue;
                        }
                        LOG.error((Object)("Read operation for " + tableName + " failed!"));
                    }
                    if (this.writeSniffing) {
                        String string = this.writeTableName.getNameAsString();
                        long actualWriteLatency = regionSink.getWriteLatency().longValue();
                        LOG.info((Object)("Write operation for " + string + " took " + actualWriteLatency + " ms. The configured write timeout was " + this.configuredWriteTableTimeout + " ms."));
                        if (actualWriteLatency > this.configuredWriteTableTimeout) {
                            LOG.error((Object)("Write operation for " + string + " exceeded the configured write timeout."));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Run regionMonitor failed", (Throwable)e);
                    this.errorCode = 4;
                }
            }
            this.done = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String[] generateMonitorTables(String[] monitorTargets) throws IOException {
            String[] returnTables = null;
            if (!this.useRegExp) return monitorTargets;
            Pattern pattern = null;
            HTableDescriptor[] tds = null;
            TreeSet<String> tmpTables = new TreeSet<String>();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("reading list of tables", new Object[0]));
                }
                if ((tds = this.admin.listTables(pattern)) == null) {
                    tds = new HTableDescriptor[]{};
                }
                for (String monitorTarget : monitorTargets) {
                    pattern = Pattern.compile(monitorTarget);
                    for (HTableDescriptor td : tds) {
                        if (!pattern.matcher(td.getNameAsString()).matches()) continue;
                        tmpTables.add(td.getNameAsString());
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Communicate with admin failed", (Throwable)e);
                throw e;
            }
            if (tmpTables.size() > 0) {
                return tmpTables.toArray(new String[tmpTables.size()]);
            }
            String msg = "No HTable found, tablePattern:" + Arrays.toString(monitorTargets);
            LOG.error((Object)msg);
            this.errorCode = 2;
            throw new TableNotFoundException(msg);
        }

        private List<Future<Void>> sniff(RegionTask.TaskType taskType, RegionStdOutSink regionSink) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("reading list of tables", new Object[0]));
            }
            LinkedList<Future<Void>> taskFutures = new LinkedList<Future<Void>>();
            for (HTableDescriptor table : this.admin.listTables()) {
                if (!this.admin.isTableEnabled(table.getTableName()) || table.getTableName().equals(this.writeTableName)) continue;
                LongAdder readLatency = regionSink.initializeAndGetReadLatencyForTable(table.getNameAsString());
                taskFutures.addAll(Canary.sniff(this.admin, this.sink, table, this.executor, taskType, this.rawScanEnabled, readLatency));
            }
            return taskFutures;
        }

        private void checkWriteTableDistribution() throws IOException {
            List<Pair<HRegionInfo, ServerName>> pairs;
            int numberOfRegions;
            if (!this.admin.tableExists(this.writeTableName)) {
                int numberOfServers = this.admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers().size();
                if (numberOfServers == 0) {
                    throw new IllegalStateException("No live regionservers");
                }
                this.createWriteTable(numberOfServers);
            }
            if (!this.admin.isTableEnabled(this.writeTableName)) {
                this.admin.enableTable(this.writeTableName);
            }
            ClusterStatus status = this.admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS, ClusterStatus.Option.MASTER));
            int numberOfServers = status.getServersSize();
            if (status.getServers().contains(status.getMaster())) {
                --numberOfServers;
            }
            if ((float)(numberOfRegions = (pairs = MetaTableAccessor.getTableRegionsAndLocations(this.connection, this.writeTableName)).size()) < (float)numberOfServers * this.regionsLowerLimit || (float)numberOfRegions > (float)numberOfServers * this.regionsUpperLimit) {
                this.admin.disableTable(this.writeTableName);
                this.admin.deleteTable(this.writeTableName);
                this.createWriteTable(numberOfServers);
            }
            HashSet<ServerName> serverSet = new HashSet<ServerName>();
            for (Pair<HRegionInfo, ServerName> pair : pairs) {
                serverSet.add(pair.getSecond());
            }
            int numberOfCoveredServers = serverSet.size();
            if (numberOfCoveredServers < numberOfServers) {
                this.admin.balancer();
            }
        }

        private void createWriteTable(int numberOfServers) throws IOException {
            int numberOfRegions = (int)((float)numberOfServers * this.regionsLowerLimit);
            LOG.info((Object)("Number of live regionservers: " + numberOfServers + ", pre-splitting the canary table into " + numberOfRegions + " regions (current lower limit of regions per server is " + this.regionsLowerLimit + " and you can change it by config: " + "hbase.canary.write.perserver.regions.lowerLimit" + " )"));
            HTableDescriptor desc = new HTableDescriptor(this.writeTableName);
            HColumnDescriptor family = new HColumnDescriptor(Canary.CANARY_TABLE_FAMILY_NAME);
            family.setMaxVersions(1);
            family.setTimeToLive(this.writeDataTTL);
            desc.addFamily(family);
            byte[][] splits = new RegionSplitter.HexStringSplit().split(numberOfRegions);
            this.admin.createTable(desc, splits);
        }
    }

    public static abstract class Monitor
    implements Runnable,
    Closeable {
        protected Connection connection;
        protected Admin admin;
        protected String[] targets;
        protected boolean useRegExp;
        protected boolean treatFailureAsError;
        protected boolean initialized = false;
        protected boolean done = false;
        protected int errorCode = 0;
        protected Sink sink;
        protected ExecutorService executor;

        public boolean isDone() {
            return this.done;
        }

        public boolean hasError() {
            return this.errorCode != 0;
        }

        public boolean finalCheckForErrors() {
            if (this.errorCode != 0) {
                return true;
            }
            if (this.treatFailureAsError && (this.sink.getReadFailureCount() > 0L || this.sink.getWriteFailureCount() > 0L)) {
                this.errorCode = 5;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            if (this.admin != null) {
                this.admin.close();
            }
        }

        protected Monitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean treatFailureAsError) {
            if (null == connection) {
                throw new IllegalArgumentException("connection shall not be null");
            }
            this.connection = connection;
            this.targets = monitorTargets;
            this.useRegExp = useRegExp;
            this.treatFailureAsError = treatFailureAsError;
            this.sink = sink;
            this.executor = executor;
        }

        @Override
        public abstract void run();

        protected boolean initAdmin() {
            if (null == this.admin) {
                try {
                    this.admin = this.connection.getAdmin();
                }
                catch (Exception e) {
                    LOG.error((Object)"Initial HBaseAdmin failed...", (Throwable)e);
                    this.errorCode = 2;
                }
            } else if (this.admin.isAborted()) {
                LOG.error((Object)"HBaseAdmin aborted");
                this.errorCode = 2;
            }
            return !this.hasError();
        }
    }

    static class RegionServerTask
    implements Callable<Void> {
        private Connection connection;
        private String serverName;
        private HRegionInfo region;
        private ExtendedSink sink;
        private AtomicLong successes;

        RegionServerTask(Connection connection, String serverName, HRegionInfo region, ExtendedSink sink, AtomicLong successes) {
            this.connection = connection;
            this.serverName = serverName;
            this.region = region;
            this.sink = sink;
            this.successes = successes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            TableName tableName = null;
            Table table = null;
            Get get = null;
            byte[] startKey = null;
            Scan scan = null;
            StopWatch stopWatch = new StopWatch();
            stopWatch.reset();
            try {
                tableName = this.region.getTable();
                table = this.connection.getTable(tableName);
                startKey = this.region.getStartKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("reading from region server %s table %s region %s and key %s", this.serverName, this.region.getTable(), this.region.getRegionNameAsString(), Bytes.toStringBinary(startKey)));
                }
                if (startKey.length > 0) {
                    get = new Get(startKey);
                    get.setCacheBlocks(false);
                    get.setFilter(new FirstKeyOnlyFilter());
                    stopWatch.start();
                    table.get(get);
                    stopWatch.stop();
                } else {
                    scan = new Scan();
                    scan.setCacheBlocks(false);
                    scan.setFilter(new FirstKeyOnlyFilter());
                    scan.setCaching(1);
                    scan.setMaxResultSize(1L);
                    scan.setOneRowLimit();
                    stopWatch.start();
                    ResultScanner s = table.getScanner(scan);
                    s.next();
                    s.close();
                    stopWatch.stop();
                }
                this.successes.incrementAndGet();
                this.sink.publishReadTiming(tableName.getNameAsString(), this.serverName, stopWatch.getTime());
            }
            catch (TableNotFoundException tnfe) {
                LOG.error((Object)"Table may be deleted", (Throwable)tnfe);
            }
            catch (TableNotEnabledException tnee) {
                this.successes.incrementAndGet();
                LOG.debug((Object)"The targeted table was disabled.  Assuming success.");
            }
            catch (DoNotRetryIOException dnrioe) {
                this.sink.publishReadFailure(tableName.getNameAsString(), this.serverName);
                LOG.error((Object)dnrioe);
            }
            catch (IOException e) {
                this.sink.publishReadFailure(tableName.getNameAsString(), this.serverName);
                LOG.error((Object)e);
            }
            finally {
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Close table failed", (Throwable)e);
                    }
                }
                scan = null;
                get = null;
                startKey = null;
            }
            return null;
        }
    }

    static class RegionTask
    implements Callable<Void> {
        private Connection connection;
        private HRegionInfo region;
        private RegionStdOutSink sink;
        private TaskType taskType;
        private boolean rawScanEnabled;
        private ServerName serverName;
        private LongAdder readWriteLatency;

        RegionTask(Connection connection, HRegionInfo region, ServerName serverName, RegionStdOutSink sink, TaskType taskType, boolean rawScanEnabled, LongAdder rwLatency) {
            this.connection = connection;
            this.region = region;
            this.serverName = serverName;
            this.sink = sink;
            this.taskType = taskType;
            this.rawScanEnabled = rawScanEnabled;
            this.readWriteLatency = rwLatency;
        }

        @Override
        public Void call() {
            switch (this.taskType) {
                case READ: {
                    return this.read();
                }
                case WRITE: {
                    return this.write();
                }
            }
            return this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void read() {
            Table table = null;
            TableDescriptor tableDesc = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("reading table descriptor for table %s", this.region.getTable()));
                }
                table = this.connection.getTable(this.region.getTable());
                tableDesc = table.getDescriptor();
            }
            catch (IOException e) {
                LOG.debug((Object)"sniffRegion failed", (Throwable)e);
                this.sink.publishReadFailure(this.serverName, this.region, e);
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)"Close table failed", (Throwable)e);
                    }
                }
                return null;
            }
            byte[] startKey = null;
            Get get = null;
            Scan scan = null;
            ResultScanner rs = null;
            StopWatch stopWatch = new StopWatch();
            for (ColumnFamilyDescriptor column : tableDesc.getColumnFamilies()) {
                stopWatch.reset();
                startKey = this.region.getStartKey();
                if (startKey.length > 0) {
                    get = new Get(startKey);
                    get.setCacheBlocks(false);
                    get.setFilter(new FirstKeyOnlyFilter());
                    get.addFamily(column.getName());
                } else {
                    scan = new Scan();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("rawScan : %s for table: %s", this.rawScanEnabled, tableDesc.getTableName()));
                    }
                    scan.setRaw(this.rawScanEnabled);
                    scan.setCaching(1);
                    scan.setCacheBlocks(false);
                    scan.setFilter(new FirstKeyOnlyFilter());
                    scan.addFamily(column.getName());
                    scan.setMaxResultSize(1L);
                    scan.setOneRowLimit();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("reading from table %s region %s column family %s and key %s", tableDesc.getTableName(), this.region.getRegionNameAsString(), column.getNameAsString(), Bytes.toStringBinary(startKey)));
                }
                try {
                    stopWatch.start();
                    if (startKey.length > 0) {
                        table.get(get);
                    } else {
                        rs = table.getScanner(scan);
                        rs.next();
                    }
                    stopWatch.stop();
                    this.readWriteLatency.add(stopWatch.getTime());
                    this.sink.publishReadTiming(this.serverName, this.region, column, stopWatch.getTime());
                }
                catch (Exception e) {
                    this.sink.publishReadFailure(this.serverName, this.region, column, e);
                    this.sink.updateReadFailedHostList(this.region, this.serverName.getHostname());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    scan = null;
                    get = null;
                }
            }
            try {
                table.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Close table failed", (Throwable)e);
            }
            return null;
        }

        private Void write() {
            Table table = null;
            TableDescriptor tableDesc = null;
            try {
                table = this.connection.getTable(this.region.getTable());
                tableDesc = table.getDescriptor();
                byte[] rowToCheck = this.region.getStartKey();
                if (rowToCheck.length == 0) {
                    rowToCheck = new byte[]{0};
                }
                int writeValueSize = this.connection.getConfiguration().getInt("hbase.canary.write.value.size", 10);
                for (ColumnFamilyDescriptor column : tableDesc.getColumnFamilies()) {
                    Put put = new Put(rowToCheck);
                    byte[] value = new byte[writeValueSize];
                    Bytes.random(value);
                    put.addColumn(column.getName(), HConstants.EMPTY_BYTE_ARRAY, value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("writing to table %s region %s column family %s and key %s", tableDesc.getTableName(), this.region.getRegionNameAsString(), column.getNameAsString(), Bytes.toStringBinary(rowToCheck)));
                    }
                    try {
                        long startTime = System.currentTimeMillis();
                        table.put(put);
                        long time = System.currentTimeMillis() - startTime;
                        this.readWriteLatency.add(time);
                        this.sink.publishWriteTiming(this.serverName, this.region, column, time);
                    }
                    catch (Exception e) {
                        this.sink.publishWriteFailure(this.serverName, this.region, column, e);
                    }
                }
                table.close();
            }
            catch (IOException e) {
                this.sink.publishWriteFailure(this.serverName, this.region, e);
                this.sink.updateWriteFailedHostList(this.region, this.serverName.getHostname());
            }
            return null;
        }

        public static enum TaskType {
            READ,
            WRITE;

        }
    }

    static class ZookeeperTask
    implements Callable<Void> {
        private final Connection connection;
        private final String host;
        private String znode;
        private final int timeout;
        private ZookeeperStdOutSink sink;

        public ZookeeperTask(Connection connection, String host, String znode, int timeout, ZookeeperStdOutSink sink) {
            this.connection = connection;
            this.host = host;
            this.znode = znode;
            this.timeout = timeout;
            this.sink = sink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try (ZooKeeper zooKeeper = null;){
                zooKeeper = new ZooKeeper(this.host, this.timeout, EmptyWatcher.instance);
                Stat exists = zooKeeper.exists(this.znode, false);
                StopWatch stopwatch = new StopWatch();
                stopwatch.start();
                zooKeeper.getData(this.znode, false, exists);
                stopwatch.stop();
                this.sink.publishReadTiming(this.znode, this.host, stopwatch.getTime());
            }
            return null;
        }
    }

    public static class RegionStdOutSink
    extends StdOutSink {
        private Map<String, LongAdder> perTableReadLatency = new HashMap<String, LongAdder>();
        private LongAdder writeLatency = new LongAdder();

        public Map<String, LongAdder> getReadLatencyMap() {
            return this.perTableReadLatency;
        }

        public LongAdder initializeAndGetReadLatencyForTable(String tableName) {
            LongAdder initLatency = new LongAdder();
            this.perTableReadLatency.put(tableName, initLatency);
            return initLatency;
        }

        public void initializeWriteLatency() {
            this.writeLatency.reset();
        }

        public LongAdder getWriteLatency() {
            return this.writeLatency;
        }
    }

    public static class ZookeeperStdOutSink
    extends StdOutSink
    implements ExtendedSink {
        @Override
        public void publishReadFailure(String zNode, String server) {
            this.incReadFailureCount();
            LOG.error((Object)String.format("Read from zNode:%s on zookeeper instance:%s", zNode, server));
        }

        @Override
        public void publishReadTiming(String znode, String server, long msTime) {
            LOG.info((Object)String.format("Read from zNode:%s on zookeeper instance:%s in %dms", znode, server, msTime));
        }
    }

    public static class RegionServerStdOutSink
    extends StdOutSink
    implements ExtendedSink {
        @Override
        public void publishReadFailure(String table, String server) {
            this.incReadFailureCount();
            LOG.error((Object)String.format("Read from table:%s on region server:%s", table, server));
        }

        @Override
        public void publishReadTiming(String table, String server, long msTime) {
            LOG.info((Object)String.format("Read from table:%s on region server:%s in %dms", table, server, msTime));
        }
    }

    public static class StdOutSink
    implements Sink {
        private AtomicLong readFailureCount = new AtomicLong(0L);
        private AtomicLong writeFailureCount = new AtomicLong(0L);
        private Map<String, String> readFailures = new ConcurrentHashMap<String, String>();
        private Map<String, String> writeFailures = new ConcurrentHashMap<String, String>();

        @Override
        public long getReadFailureCount() {
            return this.readFailureCount.get();
        }

        @Override
        public long incReadFailureCount() {
            return this.readFailureCount.incrementAndGet();
        }

        @Override
        public void publishReadFailure(ServerName serverName, HRegionInfo region, Exception e) {
            this.readFailureCount.incrementAndGet();
            LOG.error((Object)String.format("read from region %s on regionserver %s failed", region.getRegionNameAsString(), serverName), (Throwable)e);
        }

        @Override
        public void publishReadFailure(ServerName serverName, HRegionInfo region, ColumnFamilyDescriptor column, Exception e) {
            this.readFailureCount.incrementAndGet();
            LOG.error((Object)String.format("read from region %s on regionserver %s column family %s failed", region.getRegionNameAsString(), serverName, column.getNameAsString()), (Throwable)e);
        }

        @Override
        public void updateReadFailedHostList(HRegionInfo region, String serverName) {
            this.readFailures.put(region.getRegionNameAsString(), serverName);
        }

        @Override
        public void publishReadTiming(ServerName serverName, HRegionInfo region, ColumnFamilyDescriptor column, long msTime) {
            LOG.info((Object)String.format("read from region %s on regionserver %s column family %s in %dms", region.getRegionNameAsString(), serverName, column.getNameAsString(), msTime));
        }

        @Override
        public Map<String, String> getReadFailures() {
            return this.readFailures;
        }

        @Override
        public Map<String, String> getWriteFailures() {
            return this.writeFailures;
        }

        @Override
        public long getWriteFailureCount() {
            return this.writeFailureCount.get();
        }

        @Override
        public void publishWriteFailure(ServerName serverName, HRegionInfo region, Exception e) {
            this.writeFailureCount.incrementAndGet();
            LOG.error((Object)String.format("write to region %s on regionserver %s failed", region.getRegionNameAsString(), serverName), (Throwable)e);
        }

        @Override
        public void publishWriteFailure(ServerName serverName, HRegionInfo region, ColumnFamilyDescriptor column, Exception e) {
            this.writeFailureCount.incrementAndGet();
            LOG.error((Object)String.format("write to region %s on regionserver %s column family %s failed", region.getRegionNameAsString(), serverName, column.getNameAsString()), (Throwable)e);
        }

        @Override
        public void publishWriteTiming(ServerName serverName, HRegionInfo region, ColumnFamilyDescriptor column, long msTime) {
            LOG.info((Object)String.format("write to region %s on regionserver %s column family %s in %dms", region.getRegionNameAsString(), serverName, column.getNameAsString(), msTime));
        }

        @Override
        public void updateWriteFailedHostList(HRegionInfo region, String serverName) {
            this.writeFailures.put(region.getRegionNameAsString(), serverName);
        }
    }

    public static interface ExtendedSink
    extends Sink {
        public void publishReadFailure(String var1, String var2);

        public void publishReadTiming(String var1, String var2, long var3);
    }

    public static interface Sink {
        public long getReadFailureCount();

        public long incReadFailureCount();

        public void publishReadFailure(ServerName var1, HRegionInfo var2, Exception var3);

        public void publishReadFailure(ServerName var1, HRegionInfo var2, ColumnFamilyDescriptor var3, Exception var4);

        public void updateReadFailedHostList(HRegionInfo var1, String var2);

        public Map<String, String> getReadFailures();

        public void publishReadTiming(ServerName var1, HRegionInfo var2, ColumnFamilyDescriptor var3, long var4);

        public long getWriteFailureCount();

        public void publishWriteFailure(ServerName var1, HRegionInfo var2, Exception var3);

        public void publishWriteFailure(ServerName var1, HRegionInfo var2, ColumnFamilyDescriptor var3, Exception var4);

        public void publishWriteTiming(ServerName var1, HRegionInfo var2, ColumnFamilyDescriptor var3, long var4);

        public void updateWriteFailedHostList(HRegionInfo var1, String var2);

        public Map<String, String> getWriteFailures();
    }
}

