/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.hadoop.hbase.util.SoftObjectPool;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.WeakObjectPool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IdReadWriteLock {
    private static final int NB_CONCURRENT_LOCKS = 1000;
    private final ObjectPool<Long, ReentrantReadWriteLock> lockPool;
    private final ReferenceType refType;

    public IdReadWriteLock() {
        this(ReferenceType.WEAK);
    }

    public IdReadWriteLock(ReferenceType referenceType) {
        this.refType = referenceType;
        switch (referenceType) {
            case SOFT: {
                this.lockPool = new SoftObjectPool<Long, ReentrantReadWriteLock>(new ObjectPool.ObjectFactory<Long, ReentrantReadWriteLock>(){

                    @Override
                    public ReentrantReadWriteLock createObject(Long id) {
                        return new ReentrantReadWriteLock();
                    }
                }, 1000);
                break;
            }
            default: {
                this.lockPool = new WeakObjectPool<Long, ReentrantReadWriteLock>(new ObjectPool.ObjectFactory<Long, ReentrantReadWriteLock>(){

                    @Override
                    public ReentrantReadWriteLock createObject(Long id) {
                        return new ReentrantReadWriteLock();
                    }
                }, 1000);
            }
        }
    }

    public ReentrantReadWriteLock getLock(long id) {
        this.lockPool.purge();
        ReentrantReadWriteLock readWriteLock = this.lockPool.get(id);
        return readWriteLock;
    }

    @VisibleForTesting
    int purgeAndGetEntryPoolSize() {
        this.gc();
        Threads.sleep(200L);
        this.lockPool.purge();
        return this.lockPool.size();
    }

    @SuppressWarnings(value={"DM_GC"}, justification="Intentional")
    private void gc() {
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForWaiters(long id, int numWaiters) throws InterruptedException {
        while (true) {
            ReentrantReadWriteLock readWriteLock;
            if ((readWriteLock = this.lockPool.get(id)) != null) {
                ReentrantReadWriteLock reentrantReadWriteLock = readWriteLock;
                synchronized (reentrantReadWriteLock) {
                    if (readWriteLock.getQueueLength() >= numWaiters) {
                        return;
                    }
                }
            }
            Thread.sleep(50L);
        }
    }

    @VisibleForTesting
    public ReferenceType getReferenceType() {
        return this.refType;
    }

    public static enum ReferenceType {
        WEAK,
        SOFT;

    }
}

