/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.BloomContext;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowColBloomContext
extends BloomContext {
    public RowColBloomContext(BloomFilterWriter generalBloomFilterWriter, CellComparator comparator) {
        super(generalBloomFilterWriter, comparator);
    }

    @Override
    public void addLastBloomKey(HFile.Writer writer) throws IOException {
        if (this.getLastCell() != null) {
            Cell firstOnRow = CellUtil.createFirstOnRowCol(this.getLastCell());
            byte[] key = CellUtil.getCellKeySerializedAsKeyValueKey(firstOnRow);
            writer.appendFileInfo(StoreFile.LAST_BLOOM_KEY, key);
        }
    }

    @Override
    protected boolean isNewKey(Cell cell) {
        if (this.getLastCell() != null) {
            return !CellUtil.matchingRowColumn(cell, this.getLastCell());
        }
        return true;
    }
}

