/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKDataMigrator {
    private static final Log LOG = LogFactory.getLog(ZKDataMigrator.class);

    @Deprecated
    public static Map<TableName, TableState.State> queryForTableStates(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        HashMap<TableName, TableState.State> rv = new HashMap<TableName, TableState.State>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.znodePaths.tableZNode);
        if (children == null) {
            return rv;
        }
        for (String child : children) {
            TableName tableName = TableName.valueOf(child);
            ZooKeeperProtos.DeprecatedTableState.State state = ZKDataMigrator.getTableState(zkw, tableName);
            TableState.State newState = TableState.State.ENABLED;
            if (state != null) {
                switch (state) {
                    case ENABLED: {
                        newState = TableState.State.ENABLED;
                        break;
                    }
                    case DISABLED: {
                        newState = TableState.State.DISABLED;
                        break;
                    }
                    case DISABLING: {
                        newState = TableState.State.DISABLING;
                        break;
                    }
                    case ENABLING: {
                        newState = TableState.State.ENABLING;
                        break;
                    }
                }
            }
            rv.put(tableName, newState);
        }
        return rv;
    }

    @Deprecated
    private static ZooKeeperProtos.DeprecatedTableState.State getTableState(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        String znode = ZKUtil.joinZNode(zkw.znodePaths.tableZNode, tableName.getNameAsString());
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix(data);
            ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, data, magicLen, data.length - magicLen);
            return builder.getState();
        }
        catch (IOException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause(e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }
}

