/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.AsyncProtobufLogWriter;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Throwables;
import org.apache.hadoop.hbase.shaded.io.netty.channel.Channel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AsyncFSWALProvider
extends AbstractFSWALProvider<AsyncFSWAL> {
    private static final Log LOG = LogFactory.getLog(AsyncFSWALProvider.class);
    private EventLoopGroup eventLoopGroup;
    private Class<? extends Channel> channelClass;

    @Override
    protected AsyncFSWAL createWAL() throws IOException {
        return new AsyncFSWAL(FSUtils.getWALFileSystem(this.conf), FSUtils.getWALRootDir(this.conf), AsyncFSWALProvider.getWALDirectoryName(this.factory.factoryId), "oldWALs", this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? META_WAL_PROVIDER_ID : null, this.eventLoopGroup.next(), this.channelClass);
    }

    @Override
    protected void doInit(Configuration conf) throws IOException {
        Pair<EventLoopGroup, Class<? extends Channel>> eventLoopGroupAndChannelClass = NettyAsyncFSWALConfigHelper.getEventLoopConfig(conf);
        if (eventLoopGroupAndChannelClass != null) {
            this.eventLoopGroup = eventLoopGroupAndChannelClass.getFirst();
            this.channelClass = eventLoopGroupAndChannelClass.getSecond();
        } else {
            this.eventLoopGroup = new NioEventLoopGroup(1, new DefaultThreadFactory("AsyncFSWAL", true, 10));
            this.channelClass = NioSocketChannel.class;
        }
    }

    public static AsyncWriter createAsyncWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable, EventLoop eventLoop, Class<? extends Channel> channelClass) throws IOException {
        Class<AsyncWriter> logWriterClass = conf.getClass("hbase.regionserver.hlog.async.writer.impl", AsyncProtobufLogWriter.class, AsyncWriter.class);
        try {
            AsyncWriter writer = logWriterClass.getConstructor(EventLoop.class, Class.class).newInstance(eventLoop, channelClass);
            writer.init(fs, path, conf, overwritable);
            return writer;
        }
        catch (Exception e) {
            LOG.debug((Object)"Error instantiating log writer.", (Throwable)e);
            Throwables.propagateIfPossible(e, IOException.class);
            throw new IOException("cannot get log writer", e);
        }
    }

    public static interface AsyncWriter
    extends WALProvider.AsyncWriter {
        public void init(FileSystem var1, Path var2, Configuration var3, boolean var4) throws IOException;
    }
}

