/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication", "Coprocesssor"})
public class WALEdit
implements HeapSize {
    private static final Log LOG = LogFactory.getLog(WALEdit.class);
    public static final byte[] METAFAMILY = Bytes.toBytes("METAFAMILY");
    @VisibleForTesting
    public static final byte[] METAROW = Bytes.toBytes("METAROW");
    @VisibleForTesting
    public static final byte[] COMPACTION = Bytes.toBytes("HBASE::COMPACTION");
    @VisibleForTesting
    public static final byte[] FLUSH = Bytes.toBytes("HBASE::FLUSH");
    @VisibleForTesting
    public static final byte[] REGION_EVENT = Bytes.toBytes("HBASE::REGION_EVENT");
    @VisibleForTesting
    public static final byte[] BULK_LOAD = Bytes.toBytes("HBASE::BULK_LOAD");
    private final boolean isReplay;
    private ArrayList<Cell> cells = null;

    public WALEdit() {
        this(false);
    }

    public WALEdit(boolean isReplay) {
        this(1, isReplay);
    }

    public WALEdit(int cellCount) {
        this(cellCount, false);
    }

    public WALEdit(int cellCount, boolean isReplay) {
        this.isReplay = isReplay;
        this.cells = new ArrayList(cellCount);
    }

    public static boolean isMetaEditFamily(byte[] f) {
        return Bytes.equals(METAFAMILY, f);
    }

    public static boolean isMetaEditFamily(Cell cell) {
        return CellUtil.matchingFamily(cell, METAFAMILY);
    }

    public boolean isMetaEdit() {
        for (Cell cell : this.cells) {
            if (WALEdit.isMetaEditFamily(cell)) continue;
            return false;
        }
        return true;
    }

    public boolean isReplay() {
        return this.isReplay;
    }

    public WALEdit add(Cell cell) {
        this.cells.add(cell);
        return this;
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int size() {
        return this.cells.size();
    }

    public ArrayList<Cell> getCells() {
        return this.cells;
    }

    @InterfaceAudience.Private
    public void setCells(ArrayList<Cell> cells) {
        this.cells = cells;
    }

    public int readFromCells(Codec.Decoder cellDecoder, int expectedCount) throws IOException {
        this.cells.clear();
        this.cells.ensureCapacity(expectedCount);
        while (this.cells.size() < expectedCount && cellDecoder.advance()) {
            this.cells.add(cellDecoder.current());
        }
        return this.cells.size();
    }

    @Override
    public long heapSize() {
        long ret = ClassSize.ARRAYLIST;
        for (Cell cell : this.cells) {
            ret += CellUtil.estimatedHeapSizeOf(cell);
        }
        return ret;
    }

    public long estimatedSerializedSizeOf() {
        long ret = 0L;
        for (Cell cell : this.cells) {
            ret += (long)CellUtil.estimatedSerializedSizeOf(cell);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.cells.size() + " = <");
        for (Cell cell : this.cells) {
            sb.append(cell);
            sb.append("; ");
        }
        sb.append(">]");
        return sb.toString();
    }

    public static WALEdit createFlushWALEdit(HRegionInfo hri, WALProtos.FlushDescriptor f) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, FLUSH, EnvironmentEdgeManager.currentTime(), f.toByteArray());
        return new WALEdit().add(kv);
    }

    public static WALProtos.FlushDescriptor getFlushDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn(cell, METAFAMILY, FLUSH)) {
            return WALProtos.FlushDescriptor.parseFrom(CellUtil.cloneValue(cell));
        }
        return null;
    }

    public static WALEdit createRegionEventWALEdit(HRegionInfo hri, WALProtos.RegionEventDescriptor regionEventDesc) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, REGION_EVENT, EnvironmentEdgeManager.currentTime(), regionEventDesc.toByteArray());
        return new WALEdit().add(kv);
    }

    public static WALProtos.RegionEventDescriptor getRegionEventDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn(cell, METAFAMILY, REGION_EVENT)) {
            return WALProtos.RegionEventDescriptor.parseFrom(CellUtil.cloneValue(cell));
        }
        return null;
    }

    public static WALEdit createCompaction(HRegionInfo hri, WALProtos.CompactionDescriptor c) {
        byte[] pbbytes = c.toByteArray();
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, COMPACTION, EnvironmentEdgeManager.currentTime(), pbbytes);
        return new WALEdit().add(kv);
    }

    public static byte[] getRowForRegion(HRegionInfo hri) {
        byte[] startKey = hri.getStartKey();
        if (startKey.length == 0) {
            return new byte[]{0};
        }
        return startKey;
    }

    public static WALProtos.CompactionDescriptor getCompaction(Cell kv) throws IOException {
        if (WALEdit.isCompactionMarker(kv)) {
            return WALProtos.CompactionDescriptor.parseFrom(CellUtil.cloneValue(kv));
        }
        return null;
    }

    public static boolean isCompactionMarker(Cell cell) {
        return CellUtil.matchingColumn(cell, METAFAMILY, COMPACTION);
    }

    public static WALEdit createBulkLoadEvent(HRegionInfo hri, WALProtos.BulkLoadDescriptor bulkLoadDescriptor) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, BULK_LOAD, EnvironmentEdgeManager.currentTime(), bulkLoadDescriptor.toByteArray());
        return new WALEdit().add(kv);
    }

    public static WALProtos.BulkLoadDescriptor getBulkLoadDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn(cell, METAFAMILY, BULK_LOAD)) {
            return WALProtos.BulkLoadDescriptor.parseFrom(CellUtil.cloneValue(cell));
        }
        return null;
    }
}

