/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Id;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.zookeeper.PendingWatcher;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZooKeeperWatcher
implements Watcher,
Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ZooKeeperWatcher.class);
    private String prefix;
    private String identifier;
    private String quorum;
    private final RecoverableZooKeeper recoverableZooKeeper;
    protected Abortable abortable;
    private boolean aborted = false;
    public final ZNodePaths znodePaths;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    public CountDownLatch saslLatch = new CountDownLatch(1);
    private final Configuration conf;
    private static final Pattern NAME_PATTERN = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
        this(conf, identifier, abortable, false);
    }

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable, boolean canCreateBaseZNode) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        this.quorum = ZKConfig.getZKQuorumServersString(conf);
        this.prefix = identifier;
        this.identifier = identifier + "0x0";
        this.abortable = abortable;
        this.znodePaths = new ZNodePaths(conf);
        PendingWatcher pendingWatcher = new PendingWatcher();
        this.recoverableZooKeeper = ZKUtil.connect(conf, this.quorum, pendingWatcher, identifier);
        pendingWatcher.prepare(this);
        if (canCreateBaseZNode) {
            try {
                this.createBaseZNodes();
            }
            catch (ZooKeeperConnectionException zce) {
                try {
                    this.recoverableZooKeeper.close();
                }
                catch (InterruptedException ie) {
                    LOG.debug((Object)("Encountered InterruptedException when closing " + this.recoverableZooKeeper));
                    Thread.currentThread().interrupt();
                }
                throw zce;
            }
        }
    }

    private void createBaseZNodes() throws ZooKeeperConnectionException {
        try {
            ZKUtil.createWithParents(this, this.znodePaths.baseZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.rsZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.drainingZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.tableZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.splitLogZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.backupMasterAddressesZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.tableLockZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.recoveringRegionsZNode);
            ZKUtil.createAndFailSilent(this, this.znodePaths.masterMaintZNode);
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), e);
        }
    }

    public boolean isClientReadable(String node) {
        return node.equals(this.znodePaths.baseZNode) || this.znodePaths.isAnyMetaReplicaZNode(node) || node.equals(this.znodePaths.masterAddressZNode) || node.equals(this.znodePaths.clusterIdZNode) || node.equals(this.znodePaths.rsZNode) || node.equals(this.znodePaths.tableZNode) || node.startsWith(this.znodePaths.tableZNode + "/");
    }

    public void checkAndSetZNodeAcls() {
        if (!ZKUtil.isSecureZooKeeper(this.getConfiguration())) {
            LOG.info((Object)"not a secure deployment, proceeding");
            return;
        }
        try {
            List<ACL> actualAcls = this.recoverableZooKeeper.getAcl(this.znodePaths.baseZNode, new Stat());
            if (!this.isBaseZnodeAclSetup(actualAcls)) {
                LOG.info((Object)"setting znode ACLs");
                this.setZnodeAclsRecursive(this.znodePaths.baseZNode);
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return;
        }
        catch (InterruptedException ie) {
            this.interruptedExceptionNoThrow(ie, false);
        }
        catch (IOException | KeeperException e) {
            LOG.warn((Object)"Received exception while checking and setting zookeeper ACLs", (Throwable)e);
        }
    }

    private void setZnodeAclsRecursive(String znode) throws KeeperException, InterruptedException {
        List<String> children = this.recoverableZooKeeper.getChildren(znode, false);
        for (String child : children) {
            this.setZnodeAclsRecursive(ZKUtil.joinZNode(znode, child));
        }
        ArrayList<ACL> acls = ZKUtil.createACL(this, znode, true);
        LOG.info((Object)("Setting ACLs for znode:" + znode + " , acl:" + acls));
        this.recoverableZooKeeper.setAcl(znode, acls, -1);
    }

    private boolean isBaseZnodeAclSetup(List<ACL> acls) throws IOException {
        String[] superUsers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Checking znode ACLs");
        }
        if ((superUsers = this.conf.getStrings("hbase.superuser")) != null && !this.checkACLForSuperUsers(superUsers, acls)) {
            return false;
        }
        String hbaseUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (acls.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ACL is empty");
            }
            return false;
        }
        for (ACL acl : acls) {
            int perms = acl.getPerms();
            Id id = acl.getId();
            if (ZooDefs.Ids.ANYONE_ID_UNSAFE.equals(id)) {
                if (perms == 1) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 1));
                }
                return false;
            }
            if (superUsers != null && ZooKeeperWatcher.isSuperUserId(superUsers, id)) {
                if (perms == 31) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 31));
                }
                return false;
            }
            if ("sasl".equals(id.getScheme())) {
                String name = id.getId();
                Matcher match = NAME_PATTERN.matcher(name);
                if (match.matches()) {
                    name = match.group(1);
                }
                if (name.equals(hbaseUser)) {
                    if (perms == 31) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 31));
                    }
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unexpected shortname in SASL ACL: " + id));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("unexpected ACL id '" + id + "'"));
            }
            return false;
        }
        return true;
    }

    private boolean checkACLForSuperUsers(String[] superUsers, List<ACL> acls) {
        for (String user : superUsers) {
            boolean hasAccess = false;
            if (AuthUtil.isGroupPrincipal(user)) continue;
            for (ACL acl : acls) {
                if (!user.equals(acl.getId().getId())) continue;
                if (acl.getPerms() == 31) {
                    hasAccess = true;
                    break;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)String.format("superuser '%s' does not have correct permissions: have 0x%x, want 0x%x", acl.getId().getId(), acl.getPerms(), 31));
                break;
            }
            if (hasAccess) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperUserId(String[] superUsers, Id id) {
        for (String user : superUsers) {
            if (AuthUtil.isGroupPrincipal(user) || !new Id("sasl", user).equals(id)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.identifier + ", quorum=" + this.quorum + ", baseZNode=" + this.znodePaths.baseZNode;
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    public List<String> getMetaReplicaNodes() throws KeeperException {
        List<String> childrenOfBaseNode = ZKUtil.listChildrenNoWatch(this, this.znodePaths.baseZNode);
        ArrayList<String> metaReplicaNodes = new ArrayList<String>(2);
        if (childrenOfBaseNode != null) {
            String pattern = this.conf.get("zookeeper.znode.metaserver", "meta-region-server");
            for (String child : childrenOfBaseNode) {
                if (!child.startsWith(pattern)) continue;
                metaReplicaNodes.add(child);
            }
        }
        return metaReplicaNodes;
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public void unregisterListener(ZooKeeperListener listener) {
        this.listeners.remove(listener);
    }

    public void unregisterAllListeners() {
        this.listeners.clear();
    }

    public List<ZooKeeperListener> getListeners() {
        return new ArrayList<ZooKeeperListener>(this.listeners);
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }

    public RecoverableZooKeeper getRecoverableZooKeeper() {
        return this.recoverableZooKeeper;
    }

    public void reconnectAfterExpiration() throws IOException, KeeperException, InterruptedException {
        this.recoverableZooKeeper.reconnectAfterExpiration();
    }

    public String getQuorum() {
        return this.quorum;
    }

    public ZNodePaths getZNodePaths() {
        return this.znodePaths;
    }

    @Override
    public void process(WatchedEvent event) {
        LOG.debug((Object)this.prefix("Received ZooKeeper Event, type=" + (Object)((Object)event.getType()) + ", state=" + (Object)((Object)event.getState()) + ", path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
        }
    }

    private void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                this.identifier = this.prefix + "-0x" + Long.toHexString(this.recoverableZooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                break;
            }
            case Disconnected: {
                LOG.debug((Object)this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                String msg = this.prefix(this.identifier + " received expired from ZooKeeper, aborting");
                if (this.abortable == null) break;
                this.abortable.abort(msg, new KeeperException.SessionExpiredException());
                break;
            }
            case ConnectedReadOnly: 
            case SaslAuthenticated: 
            case AuthFailed: {
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + (Object)((Object)event.getState()));
            }
        }
    }

    public void sync(String path) throws KeeperException {
        this.recoverableZooKeeper.sync(path, null, null);
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        LOG.error((Object)this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) throws KeeperException {
        this.interruptedExceptionNoThrow(ie, true);
        throw new KeeperException.SystemErrorException();
    }

    public void interruptedExceptionNoThrow(InterruptedException ie, boolean throwLater) {
        LOG.debug((Object)this.prefix("Received InterruptedException, will interrupt current thread" + (throwLater ? " and rethrow a SystemErrorException" : "")), (Throwable)ie);
        Thread.currentThread().interrupt();
    }

    @Override
    public void close() {
        try {
            this.recoverableZooKeeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        if (this.abortable != null) {
            this.abortable.abort(why, e);
        } else {
            this.aborted = true;
        }
    }

    @Override
    public boolean isAborted() {
        return this.abortable == null ? this.aborted : this.abortable.isAborted();
    }
}

