/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingDataNodeMessages;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReplicationBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BlockManager {
    public static final Logger LOG = LoggerFactory.getLogger(BlockManager.class);
    public static final Logger blockLog = NameNode.blockStateChangeLog;
    private static final String QUEUE_REASON_CORRUPT_STATE = "it has the wrong state or generation stamp";
    private static final String QUEUE_REASON_FUTURE_GENSTAMP = "generation stamp is in the future";
    private final Namesystem namesystem;
    private final DatanodeManager datanodeManager;
    private final HeartbeatManager heartbeatManager;
    private final BlockTokenSecretManager blockTokenSecretManager;
    private final PendingDataNodeMessages pendingDNMessages = new PendingDataNodeMessages();
    private volatile long pendingReplicationBlocksCount = 0L;
    private volatile long corruptReplicaBlocksCount = 0L;
    private volatile long underReplicatedBlocksCount = 0L;
    private volatile long scheduledReplicationBlocksCount = 0L;
    private final AtomicLong excessBlocksCount = new AtomicLong(0L);
    private final AtomicLong postponedMisreplicatedBlocksCount = new AtomicLong(0L);
    private final long startupDelayBlockDeletionInMs;
    private final long replicationRecheckInterval;
    final BlocksMap blocksMap;
    final Daemon replicationThread = new Daemon(new ReplicationMonitor());
    final CorruptReplicasMap corruptReplicas = new CorruptReplicasMap();
    private final InvalidateBlocks invalidateBlocks;
    private final Set<Block> postponedMisreplicatedBlocks = Sets.newHashSet();
    public final Map<String, LightWeightLinkedSet<Block>> excessReplicateMap = new TreeMap<String, LightWeightLinkedSet<Block>>();
    public final UnderReplicatedBlocks neededReplications = new UnderReplicatedBlocks();
    @VisibleForTesting
    final PendingReplicationBlocks pendingReplications;
    public final short maxReplication;
    int maxReplicationStreams;
    int replicationStreamsHardLimit;
    public final short minReplication;
    public final int defaultReplication;
    final int maxCorruptFilesReturned;
    final float blocksInvalidateWorkPct;
    final int blocksReplWorkMultiplier;
    final boolean shouldCheckForEnoughRacks;
    final boolean encryptDataTransfer;
    private final long maxNumBlocksToLog;
    private boolean shouldPostponeBlocksFromFuture = false;
    private Daemon replicationQueuesInitializer = null;
    private int numBlocksPerIteration;
    private double replicationQueuesInitProgress = 0.0;
    private BlockPlacementPolicy blockplacement;
    private final BlockStoragePolicySuite storagePolicySuite;
    private boolean checkNSRunning = true;

    public long getPendingReplicationBlocksCount() {
        return this.pendingReplicationBlocksCount;
    }

    public long getUnderReplicatedBlocksCount() {
        return this.underReplicatedBlocksCount;
    }

    public long getCorruptReplicaBlocksCount() {
        return this.corruptReplicaBlocksCount;
    }

    public long getScheduledReplicationBlocksCount() {
        return this.scheduledReplicationBlocksCount;
    }

    public long getPendingDeletionBlocksCount() {
        return this.invalidateBlocks.numBlocks();
    }

    public long getStartupDelayBlockDeletionInMs() {
        return this.startupDelayBlockDeletionInMs;
    }

    public long getExcessBlocksCount() {
        return this.excessBlocksCount.get();
    }

    public long getPostponedMisreplicatedBlocksCount() {
        return this.postponedMisreplicatedBlocksCount.get();
    }

    public int getPendingDataNodeMessageCount() {
        return this.pendingDNMessages.count();
    }

    public BlockManager(Namesystem namesystem, Configuration conf) throws IOException {
        this.namesystem = namesystem;
        this.datanodeManager = new DatanodeManager(this, namesystem, conf);
        this.heartbeatManager = this.datanodeManager.getHeartbeatManager();
        this.startupDelayBlockDeletionInMs = conf.getLong("dfs.namenode.startup.delay.block.deletion.sec", 0L) * 1000L;
        this.invalidateBlocks = new InvalidateBlocks(this.datanodeManager.blockInvalidateLimit, this.startupDelayBlockDeletionInMs);
        this.blocksMap = new BlocksMap(LightWeightGSet.computeCapacity(2.0, "BlocksMap"));
        this.blockplacement = BlockPlacementPolicy.getInstance(conf, this.datanodeManager.getFSClusterStats(), this.datanodeManager.getNetworkTopology(), this.datanodeManager.getHost2DatanodeMap());
        this.storagePolicySuite = BlockStoragePolicySuite.createDefaultSuite();
        this.pendingReplications = new PendingReplicationBlocks((long)conf.getInt("dfs.namenode.replication.pending.timeout-sec", -1) * 1000L);
        this.blockTokenSecretManager = BlockManager.createBlockTokenSecretManager(conf);
        this.maxCorruptFilesReturned = conf.getInt("dfs.corruptfilesreturned.max", 500);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        int maxR = conf.getInt("dfs.replication.max", 512);
        int minR = conf.getInt("dfs.namenode.replication.min", 1);
        if (minR <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " <= 0");
        }
        if (maxR > Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + maxR + " > " + Short.MAX_VALUE);
        }
        if (minR > maxR) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " > " + "dfs.replication.max" + " = " + maxR);
        }
        this.minReplication = (short)minR;
        this.maxReplication = (short)maxR;
        this.maxReplicationStreams = conf.getInt("dfs.namenode.replication.max-streams", 2);
        this.replicationStreamsHardLimit = conf.getInt("dfs.namenode.replication.max-streams-hard-limit", 4);
        this.shouldCheckForEnoughRacks = conf.get("net.topology.script.file.name") != null;
        this.blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        this.blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
        this.replicationRecheckInterval = (long)conf.getInt("dfs.namenode.replication.interval", 3) * 1000L;
        this.encryptDataTransfer = conf.getBoolean("dfs.encrypt.data.transfer", false);
        this.maxNumBlocksToLog = conf.getLong("dfs.namenode.max-num-blocks-to-log", 1000L);
        this.numBlocksPerIteration = conf.getInt("dfs.block.misreplication.processing.limit", 10000);
        LOG.info("defaultReplication         = " + this.defaultReplication);
        LOG.info("maxReplication             = " + this.maxReplication);
        LOG.info("minReplication             = " + this.minReplication);
        LOG.info("maxReplicationStreams      = " + this.maxReplicationStreams);
        LOG.info("shouldCheckForEnoughRacks  = " + this.shouldCheckForEnoughRacks);
        LOG.info("replicationRecheckInterval = " + this.replicationRecheckInterval);
        LOG.info("encryptDataTransfer        = " + this.encryptDataTransfer);
        LOG.info("maxNumBlocksToLog          = " + this.maxNumBlocksToLog);
    }

    private static BlockTokenSecretManager createBlockTokenSecretManager(Configuration conf) {
        boolean isEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        LOG.info("dfs.block.access.token.enable=" + isEnabled);
        if (!isEnabled) {
            if (UserGroupInformation.isSecurityEnabled()) {
                LOG.error("Security is enabled but block access tokens (via dfs.block.access.token.enable) aren't enabled. This may cause issues when clients attempt to talk to a DataNode.");
            }
            return null;
        }
        long updateMin = conf.getLong("dfs.block.access.key.update.interval", 600L);
        long lifetimeMin = conf.getLong("dfs.block.access.token.lifetime", 600L);
        String encryptionAlgorithm = conf.get("dfs.encrypt.data.transfer.algorithm");
        LOG.info("dfs.block.access.key.update.interval=" + updateMin + " min(s), " + "dfs.block.access.token.lifetime" + "=" + lifetimeMin + " min(s), " + "dfs.encrypt.data.transfer.algorithm" + "=" + encryptionAlgorithm);
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        boolean isHaEnabled = HAUtil.isHAEnabled(conf, nsId);
        if (isHaEnabled) {
            String otherNnId;
            String thisNnId = HAUtil.getNameNodeId(conf, nsId);
            return new BlockTokenSecretManager(updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L, thisNnId.compareTo(otherNnId = HAUtil.getNameNodeIdOfOtherNode(conf, nsId)) < 0 ? 0 : 1, null, encryptionAlgorithm);
        }
        return new BlockTokenSecretManager(updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L, 0, null, encryptionAlgorithm);
    }

    public BlockStoragePolicy getStoragePolicy(String policyName) {
        return this.storagePolicySuite.getPolicy(policyName);
    }

    public BlockStoragePolicy getStoragePolicy(byte policyId) {
        return this.storagePolicySuite.getPolicy(policyId);
    }

    public BlockStoragePolicy[] getStoragePolicies() {
        return this.storagePolicySuite.getAllPolicies();
    }

    public void setBlockPoolId(String blockPoolId) {
        if (this.isBlockTokenEnabled()) {
            this.blockTokenSecretManager.setBlockPoolId(blockPoolId);
        }
    }

    public BlockStoragePolicySuite getStoragePolicySuite() {
        return this.storagePolicySuite;
    }

    @VisibleForTesting
    public BlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenSecretManager;
    }

    @VisibleForTesting
    void enableRMTerminationForTesting() {
        this.checkNSRunning = false;
    }

    private boolean isBlockTokenEnabled() {
        return this.blockTokenSecretManager != null;
    }

    boolean shouldUpdateBlockKey(long updateTime) throws IOException {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.updateKeys(updateTime) : false;
    }

    public void activate(Configuration conf) {
        this.pendingReplications.start();
        this.datanodeManager.activate(conf);
        this.replicationThread.start();
    }

    public void close() {
        try {
            this.replicationThread.interrupt();
            this.replicationThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.datanodeManager.close();
        this.pendingReplications.stop();
        this.blocksMap.close();
    }

    public DatanodeManager getDatanodeManager() {
        return this.datanodeManager;
    }

    @VisibleForTesting
    public BlockPlacementPolicy getBlockPlacementPolicy() {
        return this.blockplacement;
    }

    public void setBlockPlacementPolicy(BlockPlacementPolicy newpolicy) {
        if (newpolicy == null) {
            throw new HadoopIllegalArgumentException("newpolicy == null");
        }
        this.blockplacement = newpolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaSave(PrintWriter out) {
        assert (this.namesystem.hasWriteLock());
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.datanodeManager.fetchDatanodes(live, dead, false);
        out.println("Live Datanodes: " + live.size());
        out.println("Dead Datanodes: " + dead.size());
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            out.println("Metasave: Blocks waiting for replication: " + this.neededReplications.size());
            for (Block block : this.neededReplications) {
                this.dumpBlockMeta(block, out);
            }
        }
        out.println("Mis-replicated blocks that have been postponed:");
        for (Block block : this.postponedMisreplicatedBlocks) {
            this.dumpBlockMeta(block, out);
        }
        this.pendingReplications.metaSave(out);
        this.invalidateBlocks.dump(out);
        this.getDatanodeManager().datanodeDump(out);
    }

    private void dumpBlockMeta(Block block, PrintWriter out) {
        ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeStorageInfo> containingLiveReplicasNodes = new ArrayList<DatanodeStorageInfo>();
        NumberReplicas numReplicas = new NumberReplicas();
        this.chooseSourceDatanode(block, containingNodes, containingLiveReplicasNodes, numReplicas, 5);
        assert (containingLiveReplicasNodes.size() >= numReplicas.liveReplicas());
        int usableReplicas = numReplicas.liveReplicas() + numReplicas.decommissionedReplicas();
        if (block instanceof BlockInfoContiguous) {
            BlockCollection bc = ((BlockInfoContiguous)block).getBlockCollection();
            String fileName = bc == null ? "[orphaned]" : bc.getName();
            out.print(fileName + ": ");
        }
        out.print(block + (usableReplicas > 0 ? "" : " MISSING") + " (replicas:" + " l: " + numReplicas.liveReplicas() + " d: " + numReplicas.decommissionedReplicas() + " c: " + numReplicas.corruptReplicas() + " e: " + numReplicas.excessReplicas() + ") ");
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            String state = "";
            if (corruptNodes != null && corruptNodes.contains(node)) {
                state = "(corrupt)";
            } else if (node.isDecommissioned() || node.isDecommissionInProgress()) {
                state = "(decommissioned)";
            }
            if (storage.areBlockContentsStale()) {
                state = state + " (block deletions maybe out of date)";
            }
            out.print(" " + node + state + " : ");
        }
        out.println("");
    }

    public int getMaxReplicationStreams() {
        return this.maxReplicationStreams;
    }

    public boolean checkMinReplication(Block block) {
        return this.countNodes(block).liveReplicas() >= this.minReplication;
    }

    private static boolean commitBlock(BlockInfoContiguousUnderConstruction block, Block commitBlock) throws IOException {
        if (block.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
            return false;
        }
        assert (block.getNumBytes() <= commitBlock.getNumBytes()) : "commitBlock length is less than the stored one " + commitBlock.getNumBytes() + " vs. " + block.getNumBytes();
        block.commitBlock(commitBlock);
        return true;
    }

    public boolean commitOrCompleteLastBlock(BlockCollection bc, Block commitBlock) throws IOException {
        if (commitBlock == null) {
            return false;
        }
        BlockInfoContiguous lastBlock = bc.getLastBlock();
        if (lastBlock == null) {
            return false;
        }
        if (lastBlock.isComplete()) {
            return false;
        }
        boolean b = BlockManager.commitBlock((BlockInfoContiguousUnderConstruction)lastBlock, commitBlock);
        if (this.countNodes(lastBlock).liveReplicas() >= this.minReplication) {
            this.completeBlock(bc, bc.numBlocks() - 1, false);
        }
        return b;
    }

    private BlockInfoContiguous completeBlock(BlockCollection bc, int blkIndex, boolean force) throws IOException {
        if (blkIndex < 0) {
            return null;
        }
        BlockInfoContiguous curBlock = bc.getBlocks()[blkIndex];
        if (curBlock.isComplete()) {
            return curBlock;
        }
        BlockInfoContiguousUnderConstruction ucBlock = (BlockInfoContiguousUnderConstruction)curBlock;
        int numNodes = ucBlock.numNodes();
        if (!force && numNodes < this.minReplication) {
            throw new IOException("Cannot complete block: block does not satisfy minimal replication requirement.");
        }
        if (!force && ucBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            throw new IOException("Cannot complete block: block has not been COMMITTED by the client");
        }
        BlockInfoContiguous completeBlock = ucBlock.convertToCompleteBlock();
        bc.setBlock(blkIndex, completeBlock);
        this.namesystem.adjustSafeModeBlockTotals(0, 1);
        this.namesystem.incrementSafeBlockCount(Math.min(numNodes, this.minReplication));
        return this.blocksMap.replaceBlock(completeBlock);
    }

    private BlockInfoContiguous completeBlock(BlockCollection bc, BlockInfoContiguous block, boolean force) throws IOException {
        BlockInfoContiguous[] fileBlocks = bc.getBlocks();
        for (int idx = 0; idx < fileBlocks.length; ++idx) {
            if (fileBlocks[idx] != block) continue;
            return this.completeBlock(bc, idx, force);
        }
        return block;
    }

    public BlockInfoContiguous forceCompleteBlock(BlockCollection bc, BlockInfoContiguousUnderConstruction block) throws IOException {
        block.commitBlock(block);
        return this.completeBlock(bc, block, true);
    }

    public LocatedBlock convertLastBlockToUnderConstruction(BlockCollection bc, long bytesToRemove) throws IOException {
        BlockInfoContiguous oldBlock = bc.getLastBlock();
        if (oldBlock == null || bc.getPreferredBlockSize() == oldBlock.getNumBytes() - bytesToRemove) {
            return null;
        }
        assert (oldBlock == this.getStoredBlock(oldBlock)) : "last block of the file is not in blocksMap";
        DatanodeStorageInfo[] targets = this.getStorages(oldBlock);
        BlockInfoContiguousUnderConstruction ucBlock = bc.setLastBlock(oldBlock, targets);
        this.blocksMap.replaceBlock(ucBlock);
        NumberReplicas replicas = this.countNodes(ucBlock);
        this.neededReplications.remove(ucBlock, replicas.liveReplicas(), replicas.decommissionedReplicas(), this.getReplication(ucBlock));
        this.pendingReplications.remove(ucBlock);
        for (DatanodeStorageInfo storage : targets) {
            this.invalidateBlocks.remove(storage.getDatanodeDescriptor(), oldBlock);
        }
        this.namesystem.adjustSafeModeBlockTotals(targets.length >= this.minReplication ? -1 : 0, -1);
        long fileLength = bc.computeContentSummary(this.getStoragePolicySuite()).getLength();
        long pos = fileLength - ucBlock.getNumBytes();
        return this.createLocatedBlock(ucBlock, pos, BlockTokenSecretManager.AccessMode.WRITE);
    }

    private List<DatanodeStorageInfo> getValidLocations(Block block) {
        ArrayList<DatanodeStorageInfo> locations = new ArrayList<DatanodeStorageInfo>(this.blocksMap.numNodes(block));
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            if (this.invalidateBlocks.contains(storage.getDatanodeDescriptor(), block)) continue;
            locations.add(storage);
        }
        return locations;
    }

    private List<LocatedBlock> createLocatedBlockList(BlockInfoContiguous[] blocks, long offset, long length, int nrBlocksToReturn, BlockTokenSecretManager.AccessMode mode) throws IOException {
        int curBlk = 0;
        long curPos = 0L;
        long blkSize = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks; ++curBlk) {
            blkSize = blocks[curBlk].getNumBytes();
            assert (blkSize > 0L) : "Block of size 0";
            if (curPos + blkSize > offset) break;
            curPos += blkSize;
        }
        if (nrBlocks > 0 && curBlk == nrBlocks) {
            return Collections.emptyList();
        }
        long endOff = offset + length;
        ArrayList<LocatedBlock> results = new ArrayList<LocatedBlock>(blocks.length);
        do {
            results.add(this.createLocatedBlock(blocks[curBlk], curPos, mode));
        } while ((curPos += blocks[++curBlk].getNumBytes()) < endOff && curBlk < blocks.length && results.size() < nrBlocksToReturn);
        return results;
    }

    private LocatedBlock createLocatedBlock(BlockInfoContiguous[] blocks, long endPos, BlockTokenSecretManager.AccessMode mode) throws IOException {
        long blkSize;
        int curBlk = 0;
        long curPos = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks && curPos + (blkSize = blocks[curBlk].getNumBytes()) < endPos; ++curBlk) {
            curPos += blkSize;
        }
        return this.createLocatedBlock(blocks[curBlk], curPos, mode);
    }

    private LocatedBlock createLocatedBlock(BlockInfoContiguous blk, long pos, BlockTokenSecretManager.AccessMode mode) throws IOException {
        LocatedBlock lb = this.createLocatedBlock(blk, pos);
        if (mode != null) {
            this.setBlockToken(lb, mode);
        }
        return lb;
    }

    private LocatedBlock createLocatedBlock(BlockInfoContiguous blk, long pos) throws IOException {
        int numNodes;
        int numCorruptReplicas;
        if (blk instanceof BlockInfoContiguousUnderConstruction) {
            if (blk.isComplete()) {
                throw new IOException("blk instanceof BlockInfoUnderConstruction && blk.isComplete(), blk=" + blk);
            }
            BlockInfoContiguousUnderConstruction uc = (BlockInfoContiguousUnderConstruction)blk;
            DatanodeStorageInfo[] storages = uc.getExpectedStorageLocations();
            ExtendedBlock eb = new ExtendedBlock(this.namesystem.getBlockPoolId(), blk);
            return new LocatedBlock(eb, storages, pos, false);
        }
        int numCorruptNodes = this.countNodes(blk).corruptReplicas();
        if (numCorruptNodes != (numCorruptReplicas = this.corruptReplicas.numCorruptReplicas(blk))) {
            LOG.warn("Inconsistent number of corrupt replicas for " + blk + " blockMap has " + numCorruptNodes + " but corrupt replicas map has " + numCorruptReplicas);
        }
        boolean isCorrupt = numCorruptNodes == (numNodes = this.blocksMap.numNodes(blk));
        int numMachines = isCorrupt ? numNodes : numNodes - numCorruptNodes;
        DatanodeStorageInfo[] machines = new DatanodeStorageInfo[numMachines];
        int j = 0;
        if (numMachines > 0) {
            for (DatanodeStorageInfo storage : this.blocksMap.getStorages(blk)) {
                DatanodeDescriptor d = storage.getDatanodeDescriptor();
                boolean replicaCorrupt = this.corruptReplicas.isReplicaCorrupt(blk, d);
                if (!isCorrupt && replicaCorrupt) continue;
                machines[j++] = storage;
            }
        }
        assert (j == machines.length) : "isCorrupt: " + isCorrupt + " numMachines: " + numMachines + " numNodes: " + numNodes + " numCorrupt: " + numCorruptNodes + " numCorruptRepls: " + numCorruptReplicas;
        ExtendedBlock eb = new ExtendedBlock(this.namesystem.getBlockPoolId(), blk);
        return new LocatedBlock(eb, machines, pos, isCorrupt);
    }

    public LocatedBlocks createLocatedBlocks(BlockInfoContiguous[] blocks, long fileSizeExcludeBlocksUnderConstruction, boolean isFileUnderConstruction, long offset, long length, boolean needBlockToken, boolean inSnapshot, FileEncryptionInfo feInfo) throws IOException {
        boolean isComplete;
        LocatedBlock lastlb;
        assert (this.namesystem.hasReadLock());
        if (blocks == null) {
            return null;
        }
        if (blocks.length == 0) {
            return new LocatedBlocks(0L, isFileUnderConstruction, Collections.emptyList(), null, false, feInfo);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("blocks = " + Arrays.asList(blocks));
        }
        BlockTokenSecretManager.AccessMode mode = needBlockToken ? BlockTokenSecretManager.AccessMode.READ : null;
        List<LocatedBlock> locatedblocks = this.createLocatedBlockList(blocks, offset, length, Integer.MAX_VALUE, mode);
        if (!inSnapshot) {
            BlockInfoContiguous last = blocks[blocks.length - 1];
            long lastPos = last.isComplete() ? fileSizeExcludeBlocksUnderConstruction - last.getNumBytes() : fileSizeExcludeBlocksUnderConstruction;
            lastlb = this.createLocatedBlock(last, lastPos, mode);
            isComplete = last.isComplete();
        } else {
            lastlb = this.createLocatedBlock(blocks, fileSizeExcludeBlocksUnderConstruction, mode);
            isComplete = true;
        }
        return new LocatedBlocks(fileSizeExcludeBlocksUnderConstruction, isFileUnderConstruction, locatedblocks, lastlb, isComplete, feInfo);
    }

    public ExportedBlockKeys getBlockKeys() {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.exportKeys() : ExportedBlockKeys.DUMMY_KEYS;
    }

    public void setBlockToken(LocatedBlock b, BlockTokenSecretManager.AccessMode mode) throws IOException {
        if (this.isBlockTokenEnabled()) {
            b.setBlockToken(this.blockTokenSecretManager.generateToken(NameNode.getRemoteUser().getShortUserName(), b.getBlock(), EnumSet.of(mode)));
        }
    }

    void addKeyUpdateCommand(List<DatanodeCommand> cmds, DatanodeDescriptor nodeinfo) {
        if (this.isBlockTokenEnabled() && nodeinfo.needKeyUpdate) {
            cmds.add(new KeyUpdateCommand(this.blockTokenSecretManager.exportKeys()));
            nodeinfo.needKeyUpdate = false;
        }
    }

    public DataEncryptionKey generateDataEncryptionKey() {
        if (this.isBlockTokenEnabled() && this.encryptDataTransfer) {
            return this.blockTokenSecretManager.generateDataEncryptionKey();
        }
        return null;
    }

    public short adjustReplication(short replication) {
        return replication < this.minReplication ? this.minReplication : (replication > this.maxReplication ? this.maxReplication : replication);
    }

    public void verifyReplication(String src, short replication, String clientName) throws IOException {
        if (replication >= this.minReplication && replication <= this.maxReplication) {
            return;
        }
        String text = "file " + src + (clientName != null ? " on client " + clientName : "") + ".\n" + "Requested replication " + replication;
        if (replication > this.maxReplication) {
            throw new IOException(text + " exceeds maximum " + this.maxReplication);
        }
        if (replication < this.minReplication) {
            throw new IOException(text + " is less than the required minimum " + this.minReplication);
        }
    }

    public boolean isSufficientlyReplicated(BlockInfoContiguous b) {
        int replication = Math.min(this.minReplication, this.getDatanodeManager().getNumLiveDataNodes());
        return this.countNodes(b).liveReplicas() >= replication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlocksWithLocations getBlocks(DatanodeID datanode, long size) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.readLock();
        try {
            this.namesystem.checkOperation(NameNode.OperationCategory.READ);
            BlocksWithLocations blocksWithLocations = this.getBlocksWithLocations(datanode, size);
            return blocksWithLocations;
        }
        finally {
            this.namesystem.readUnlock();
        }
    }

    private BlocksWithLocations getBlocksWithLocations(DatanodeID datanode, long size) throws UnregisteredNodeException {
        BlockInfoContiguous curBlock;
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(datanode);
        if (node == null) {
            blockLog.warn("BLOCK* getBlocks: Asking for blocks from an unrecorded node {}", (Object)datanode);
            throw new HadoopIllegalArgumentException("Datanode " + datanode + " not found.");
        }
        int numBlocks = node.numBlocks();
        if (numBlocks == 0) {
            return new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
        }
        Iterator<BlockInfoContiguous> iter = node.getBlockIterator();
        int startBlock = DFSUtil.getRandom().nextInt(numBlocks);
        for (int i = 0; i < startBlock; ++i) {
            iter.next();
        }
        ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
        long totalSize = 0L;
        while (totalSize < size && iter.hasNext()) {
            curBlock = iter.next();
            if (!curBlock.isComplete()) continue;
            totalSize += this.addBlock(curBlock, results);
        }
        if (totalSize < size) {
            iter = node.getBlockIterator();
            for (int i = 0; i < startBlock && totalSize < size; ++i) {
                curBlock = iter.next();
                if (!curBlock.isComplete()) continue;
                totalSize += this.addBlock(curBlock, results);
            }
        }
        return new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
    }

    void removeBlocksAssociatedTo(DatanodeDescriptor node) {
        Iterator<BlockInfoContiguous> it = node.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), node);
        }
        this.pendingDNMessages.removeAllMessagesForDatanode(node);
        node.resetBlocks();
        this.invalidateBlocks.remove(node);
    }

    void removeBlocksAssociatedTo(DatanodeStorageInfo storageInfo) {
        assert (this.namesystem.hasWriteLock());
        Iterator<BlockInfoContiguous> it = storageInfo.getBlockIterator();
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        while (it.hasNext()) {
            Block block = it.next();
            this.removeStoredBlock(block, node);
            this.invalidateBlocks.remove(node, block);
        }
        this.namesystem.checkSafeMode();
    }

    void addToInvalidates(Block block, DatanodeInfo datanode) {
        if (!this.namesystem.isPopulatingReplQueues()) {
            return;
        }
        this.invalidateBlocks.add(block, datanode, true);
    }

    private void addToInvalidates(Block b) {
        if (!this.namesystem.isPopulatingReplQueues()) {
            return;
        }
        StringBuilder datanodes = new StringBuilder();
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(b, DatanodeStorage.State.NORMAL)) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            this.invalidateBlocks.add(b, node, false);
            datanodes.append(node).append(" ");
        }
        if (datanodes.length() != 0) {
            blockLog.info("BLOCK* addToInvalidates: {} {}", (Object)b, (Object)datanodes.toString());
        }
    }

    void removeFromInvalidates(DatanodeInfo datanode) {
        if (!this.namesystem.isPopulatingReplQueues()) {
            return;
        }
        this.invalidateBlocks.remove(datanode);
    }

    public void findAndMarkBlockAsCorrupt(ExtendedBlock blk, DatanodeInfo dn, String storageID, String reason) throws IOException {
        assert (this.namesystem.hasWriteLock());
        BlockInfoContiguous storedBlock = this.getStoredBlock(blk.getLocalBlock());
        if (storedBlock == null) {
            blockLog.info("BLOCK* findAndMarkBlockAsCorrupt: {} not found", (Object)blk);
            return;
        }
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot mark " + blk + " as corrupt because datanode " + dn + " (" + dn.getDatanodeUuid() + ") does not exist");
        }
        this.markBlockAsCorrupt(new BlockToMarkCorrupt(storedBlock, blk.getGenerationStamp(), reason, CorruptReplicasMap.Reason.CORRUPTION_REPORTED), storageID == null ? null : node.getStorageInfo(storageID), node);
    }

    private void markBlockAsCorrupt(BlockToMarkCorrupt b, DatanodeStorageInfo storageInfo, DatanodeDescriptor node) throws IOException {
        boolean corruptedDuringWrite;
        BlockCollection bc = b.corrupted.getBlockCollection();
        if (bc == null) {
            blockLog.info("BLOCK markBlockAsCorrupt: {} cannot be marked as corrupt as it does not belong to any file", (Object)b);
            this.addToInvalidates(b.corrupted, node);
            return;
        }
        if (storageInfo != null) {
            storageInfo.addBlock(b.stored);
        }
        this.corruptReplicas.addToCorruptReplicasMap(b.corrupted, node, b.reason, b.reasonCode);
        NumberReplicas numberOfReplicas = this.countNodes(b.stored);
        boolean hasEnoughLiveReplicas = numberOfReplicas.liveReplicas() >= bc.getBlockReplication();
        boolean minReplicationSatisfied = numberOfReplicas.liveReplicas() >= this.minReplication;
        boolean hasMoreCorruptReplicas = minReplicationSatisfied && numberOfReplicas.liveReplicas() + numberOfReplicas.corruptReplicas() > bc.getBlockReplication();
        boolean bl = corruptedDuringWrite = minReplicationSatisfied && b.stored.getGenerationStamp() > b.corrupted.getGenerationStamp();
        if (hasEnoughLiveReplicas || hasMoreCorruptReplicas || corruptedDuringWrite) {
            this.invalidateBlock(b, node);
        } else if (this.namesystem.isPopulatingReplQueues()) {
            this.updateNeededReplications(b.stored, -1, 0);
        }
    }

    private boolean invalidateBlock(BlockToMarkCorrupt b, DatanodeInfo dn) throws IOException {
        blockLog.info("BLOCK* invalidateBlock: {} on {}", (Object)b, (Object)dn);
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot invalidate " + b + " because datanode " + dn + " does not exist.");
        }
        NumberReplicas nr = this.countNodes(b.stored);
        if (nr.replicasOnStaleNodes() > 0) {
            blockLog.info("BLOCK* invalidateBlocks: postponing invalidation of {} on {} because {} replica(s) are located on nodes with potentially out-of-date block reports", new Object[]{b, dn, nr.replicasOnStaleNodes()});
            this.postponeBlock(b.corrupted);
            return false;
        }
        if (nr.liveReplicas() >= 1) {
            this.addToInvalidates(b.corrupted, dn);
            this.removeStoredBlock(b.stored, node);
            blockLog.debug("BLOCK* invalidateBlocks: {} on {} listed for deletion.", (Object)b, (Object)dn);
            return true;
        }
        blockLog.info("BLOCK* invalidateBlocks: {} on {} is the only copy and was not deleted", (Object)b, (Object)dn);
        return false;
    }

    public void setPostponeBlocksFromFuture(boolean postpone) {
        this.shouldPostponeBlocksFromFuture = postpone;
    }

    private void postponeBlock(Block blk) {
        if (this.postponedMisreplicatedBlocks.add(blk)) {
            this.postponedMisreplicatedBlocksCount.incrementAndGet();
        }
    }

    void updateState() {
        this.pendingReplicationBlocksCount = this.pendingReplications.size();
        this.underReplicatedBlocksCount = this.neededReplications.size();
        this.corruptReplicaBlocksCount = this.corruptReplicas.size();
    }

    public int getUnderReplicatedNotMissingBlocks() {
        return this.neededReplications.getUnderReplicatedBlockCount();
    }

    int computeInvalidateWork(int nodesToProcess) {
        List<DatanodeInfo> nodes = this.invalidateBlocks.getDatanodes();
        Collections.shuffle(nodes);
        nodesToProcess = Math.min(nodes.size(), nodesToProcess);
        int blockCnt = 0;
        for (DatanodeInfo dnInfo : nodes) {
            int blocks = this.invalidateWorkForOneNode(dnInfo);
            if (blocks <= 0) continue;
            blockCnt += blocks;
            if (--nodesToProcess != 0) continue;
            break;
        }
        return blockCnt;
    }

    int computeReplicationWork(int blocksToProcess) {
        List<List<Block>> blocksToReplicate = null;
        this.namesystem.writeLock();
        try {
            blocksToReplicate = this.neededReplications.chooseUnderReplicatedBlocks(blocksToProcess);
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return this.computeReplicationWorkForBlocks(blocksToReplicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    int computeReplicationWorkForBlocks(List<List<Block>> blocksToReplicate) {
        block31: {
            block30: {
                bc = null;
                scheduledWork = 0;
                work = new LinkedList<ReplicationWork>();
                this.namesystem.writeLock();
                var5_5 = this.neededReplications;
                synchronized (var5_5) {
                    priority = 0;
lbl9:
                    // 2 sources

                    while (true) {
                        if (priority < blocksToReplicate.size()) {
                            var7_8 = blocksToReplicate.get(priority).iterator();
                            ** break block29
                        }
                        break block30;
                        break;
                    }
                }
                finally {
                    this.namesystem.writeUnlock();
                }
            }
            excludedNodes = new HashSet<DatanodeDescriptor>();
            var6_7 = work.iterator();
            break block31;
lbl-1000:
            // 1 sources

            {
                while (var7_8.hasNext()) {
                    var8_9 = var7_8.next();
                    bc = this.blocksMap.getBlockCollection(var8_9);
                    if (bc == null || bc.isUnderConstruction() && var8_9.equals(bc.getLastBlock())) {
                        this.neededReplications.remove(var8_9, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                        continue;
                    }
                    requiredReplication = bc.getBlockReplication();
                    containingNodes = new ArrayList<DatanodeDescriptor>();
                    liveReplicaNodes = new ArrayList<DatanodeStorageInfo>();
                    numReplicas = new NumberReplicas();
                    srcNode = this.chooseSourceDatanode(var8_9, containingNodes, liveReplicaNodes, numReplicas, priority);
                    if (srcNode == null) {
                        BlockManager.LOG.debug("Block " + var8_9 + " cannot be repl from any node");
                        continue;
                    }
                    if (!BlockManager.$assertionsDisabled && liveReplicaNodes.size() < numReplicas.liveReplicas()) {
                        throw new AssertionError();
                    }
                    numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(var8_9);
                    if (numEffectiveReplicas >= requiredReplication && (this.pendingReplications.getNumReplicas(var8_9) > 0 || this.blockHasEnoughRacks(var8_9))) {
                        this.neededReplications.remove(var8_9, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                        BlockManager.blockLog.info("BLOCK* Removing {} from neededReplications as it has enough replicas", (Object)var8_9);
                        continue;
                    }
                    additionalReplRequired = numReplicas.liveReplicas() < requiredReplication ? requiredReplication - numEffectiveReplicas : 1;
                    work.add(new ReplicationWork(var8_9, bc, srcNode, containingNodes, liveReplicaNodes, additionalReplRequired, priority));
                }
                ++priority;
                ** continue;
            }
        }
        while (var6_7.hasNext()) {
            rw = (ReplicationWork)var6_7.next();
            excludedNodes.clear();
            for (Object dn : ReplicationWork.access$100(rw)) {
                excludedNodes.add((DatanodeDescriptor)dn);
            }
            ReplicationWork.access$200(rw, this.blockplacement, this.storagePolicySuite, excludedNodes);
        }
        this.namesystem.writeLock();
        try {
            for (ReplicationWork rw : work) {
                var8_13 = ReplicationWork.access$300(rw);
                if (var8_13 == null || var8_13.length == 0) {
                    ReplicationWork.access$302(rw, null);
                    continue;
                }
                dn = this.neededReplications;
                synchronized (dn) {
                    block = ReplicationWork.access$400(rw);
                    priority = ReplicationWork.access$500(rw);
                    bc = this.blocksMap.getBlockCollection(block);
                    if (bc == null || bc.isUnderConstruction() && block.equals(bc.getLastBlock())) {
                        this.neededReplications.remove(block, priority);
                        ReplicationWork.access$302(rw, null);
                        this.neededReplications.decrementReplicationIndex(priority);
                        continue;
                    }
                    requiredReplication = bc.getBlockReplication();
                    numReplicas = this.countNodes(block);
                    numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(block);
                    if (numEffectiveReplicas >= requiredReplication && (this.pendingReplications.getNumReplicas(block) > 0 || this.blockHasEnoughRacks(block))) {
                        this.neededReplications.remove(block, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                        ReplicationWork.access$302(rw, null);
                        BlockManager.blockLog.info("BLOCK* Removing {} from neededReplications as it has enough replicas", (Object)block);
                        continue;
                    }
                    if (numReplicas.liveReplicas() >= requiredReplication && !this.blockHasEnoughRacks(block) && ReplicationWork.access$600(rw).getNetworkLocation().equals(var8_13[0].getDatanodeDescriptor().getNetworkLocation())) {
                        continue;
                    }
                    ReplicationWork.access$600(rw).addBlockToBeReplicated(block, var8_13);
                    ++scheduledWork;
                    DatanodeStorageInfo.incrementBlocksScheduled(var8_13);
                    this.pendingReplications.increment(block, DatanodeStorageInfo.toDatanodeDescriptors(var8_13));
                    BlockManager.blockLog.debug("BLOCK* block {} is moved from neededReplications to pendingReplications", (Object)block);
                    if (numEffectiveReplicas + var8_13.length >= requiredReplication) {
                        this.neededReplications.remove(block, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                    }
                }
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        if (BlockManager.blockLog.isInfoEnabled()) {
            for (ReplicationWork rw : work) {
                var8_15 = ReplicationWork.access$300(rw);
                if (var8_15 == null || var8_15.length == 0) continue;
                targetList = new StringBuilder("datanode(s)");
                for (k = 0; k < var8_15.length; ++k) {
                    targetList.append(' ');
                    targetList.append(var8_15[k].getDatanodeDescriptor());
                }
                BlockManager.blockLog.info("BLOCK* ask {} to replicate {} to {}", new Object[]{ReplicationWork.access$600(rw), ReplicationWork.access$400(rw), targetList});
            }
        }
        if (BlockManager.blockLog.isDebugEnabled()) {
            BlockManager.blockLog.debug("BLOCK* neededReplications = {} pendingReplications = {}", (Object)this.neededReplications.size(), (Object)this.pendingReplications.size());
        }
        return scheduledWork;
    }

    public DatanodeStorageInfo[] chooseTarget4WebHDFS(String src, DatanodeDescriptor clientnode, Set<Node> excludes, long blocksize) {
        return this.blockplacement.chooseTarget(src, 1, clientnode, Collections.emptyList(), false, excludes, blocksize, this.storagePolicySuite.getDefaultPolicy());
    }

    public DatanodeStorageInfo[] chooseTarget4AdditionalDatanode(String src, int numAdditionalNodes, Node clientnode, List<DatanodeStorageInfo> chosen, Set<Node> excludes, long blocksize, byte storagePolicyID) {
        BlockStoragePolicy storagePolicy = this.storagePolicySuite.getPolicy(storagePolicyID);
        return this.blockplacement.chooseTarget(src, numAdditionalNodes, clientnode, chosen, true, excludes, blocksize, storagePolicy);
    }

    public DatanodeStorageInfo[] chooseTarget4NewBlock(String src, int numOfReplicas, Node client, Set<Node> excludedNodes, long blocksize, List<String> favoredNodes, byte storagePolicyID) throws IOException {
        BlockStoragePolicy storagePolicy;
        List<DatanodeDescriptor> favoredDatanodeDescriptors = this.getDatanodeDescriptors(favoredNodes);
        DatanodeStorageInfo[] targets = this.blockplacement.chooseTarget(src, numOfReplicas, client, excludedNodes, blocksize, favoredDatanodeDescriptors, storagePolicy = this.storagePolicySuite.getPolicy(storagePolicyID));
        if (targets.length < this.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes instead of minReplication (=" + this.minReplication + ").  There are " + this.getDatanodeManager().getNetworkTopology().getNumOfLeaves() + " datanode(s) running and " + (excludedNodes == null ? "no" : Integer.valueOf(excludedNodes.size())) + " node(s) are excluded in this operation.");
        }
        return targets;
    }

    List<DatanodeDescriptor> getDatanodeDescriptors(List<String> nodes) {
        ArrayList<DatanodeDescriptor> datanodeDescriptors = null;
        if (nodes != null) {
            datanodeDescriptors = new ArrayList<DatanodeDescriptor>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                DatanodeDescriptor node = this.datanodeManager.getDatanodeDescriptor(nodes.get(i));
                if (node == null) continue;
                datanodeDescriptors.add(node);
            }
        }
        return datanodeDescriptors;
    }

    @VisibleForTesting
    DatanodeDescriptor chooseSourceDatanode(Block block, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> nodesContainingLiveReplicas, NumberReplicas numReplicas, int priority) {
        containingNodes.clear();
        nodesContainingLiveReplicas.clear();
        DatanodeDescriptor srcNode = null;
        int live = 0;
        int decommissioned = 0;
        int corrupt = 0;
        int excess = 0;
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(block);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            int countableReplica;
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            LightWeightLinkedSet<Block> excessBlocks = this.excessReplicateMap.get(node.getDatanodeUuid());
            int n = countableReplica = storage.getState() == DatanodeStorage.State.NORMAL ? 1 : 0;
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                corrupt += countableReplica;
            } else if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                decommissioned += countableReplica;
            } else if (excessBlocks != null && excessBlocks.contains(block)) {
                excess += countableReplica;
            } else {
                nodesContainingLiveReplicas.add(storage);
                live += countableReplica;
            }
            containingNodes.add(node);
            if (nodesCorrupt != null && nodesCorrupt.contains(node) || priority != 0 && !node.isDecommissionInProgress() && node.getNumberOfBlocksToBeReplicated() >= this.maxReplicationStreams || node.getNumberOfBlocksToBeReplicated() >= this.replicationStreamsHardLimit || excessBlocks != null && excessBlocks.contains(block) || node.isDecommissioned()) continue;
            if (srcNode == null) {
                srcNode = node;
                continue;
            }
            if (!DFSUtil.getRandom().nextBoolean()) continue;
            srcNode = node;
        }
        if (numReplicas != null) {
            numReplicas.initialize(live, decommissioned, corrupt, excess, 0);
        }
        return srcNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingReplications() {
        Block[] timedOutItems = this.pendingReplications.getTimedOutBlocks();
        if (timedOutItems != null) {
            this.namesystem.writeLock();
            try {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    BlockInfoContiguous bi = this.blocksMap.getStoredBlock(timedOutItems[i]);
                    if (bi == null) continue;
                    NumberReplicas num = this.countNodes(timedOutItems[i]);
                    if (!this.isNeededReplication(bi, this.getReplication(bi), num.liveReplicas())) continue;
                    this.neededReplications.add(bi, num.liveReplicas(), num.decommissionedReplicas(), this.getReplication(bi));
                }
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processReport(DatanodeID nodeID, DatanodeStorage storage, BlockListAsLongs newReport, BlockReportContext context, boolean lastStorageInRpc) throws IOException {
        long endTime;
        NameNodeMetrics metrics;
        DatanodeDescriptor node;
        this.namesystem.writeLock();
        long startTime = Time.monotonicNow();
        Collection<Block> invalidatedBlocks = null;
        try {
            node = this.datanodeManager.getDatanode(nodeID);
            if (node == null || !node.isAlive) {
                throw new IOException("ProcessReport from dead or unregistered node: " + nodeID);
            }
            Object storageInfo = node.getStorageInfo(storage.getStorageID());
            if (storageInfo == null) {
                storageInfo = node.updateStorage(storage);
            }
            if (this.namesystem.isInStartupSafeMode() && ((DatanodeStorageInfo)storageInfo).getBlockReportCount() > 0) {
                blockLog.info("BLOCK* processReport: discarded non-initial block report from {} because namenode still in startup phase", (Object)nodeID);
                boolean bl = !node.hasStaleStorages();
                return bl;
            }
            if (((DatanodeStorageInfo)storageInfo).getBlockReportCount() == 0) {
                this.processFirstBlockReport((DatanodeStorageInfo)storageInfo, newReport);
            } else {
                invalidatedBlocks = this.processReport((DatanodeStorageInfo)storageInfo, newReport);
            }
            ((DatanodeStorageInfo)storageInfo).receivedBlockReport();
            if (context != null) {
                ((DatanodeStorageInfo)storageInfo).setLastBlockReportId(context.getReportId());
                if (lastStorageInRpc) {
                    int rpcsSeen = node.updateBlockReportContext(context);
                    if (rpcsSeen >= context.getTotalRpcs()) {
                        List<DatanodeStorageInfo> zombies = node.removeZombieStorages();
                        if (zombies.isEmpty()) {
                            LOG.debug("processReport 0x{}: no zombie storages found.", (Object)Long.toHexString(context.getReportId()));
                        } else {
                            for (DatanodeStorageInfo zombie : zombies) {
                                this.removeZombieReplicas(context, zombie);
                            }
                        }
                        node.clearBlockReportContext();
                    } else {
                        LOG.debug("processReport 0x{}: {} more RPCs remaining in this report.", (Object)Long.toHexString(context.getReportId()), (Object)(context.getTotalRpcs() - rpcsSeen));
                    }
                }
            }
        }
        finally {
            long endTime2 = Time.monotonicNow();
            this.namesystem.writeUnlock();
        }
        if (invalidatedBlocks != null) {
            for (Block b : invalidatedBlocks) {
                blockLog.info("BLOCK* processReport: {} on node {} size {} does not belong to any file", new Object[]{b, node, b.getNumBytes()});
            }
        }
        if ((metrics = NameNode.getNameNodeMetrics()) != null) {
            metrics.addBlockReport((int)(endTime - startTime));
        }
        blockLog.info("BLOCK* processReport: from storage {} node {}, blocks: {}, hasStaleStorage: {}, processing time: {} msecs", new Object[]{storage.getStorageID(), nodeID, newReport.getNumberOfBlocks(), node.hasStaleStorages(), endTime - startTime});
        return !node.hasStaleStorages();
    }

    private void removeZombieReplicas(BlockReportContext context, DatanodeStorageInfo zombie) {
        LOG.warn("processReport 0x{}: removing zombie storage {}, which no longer exists on the DataNode.", (Object)Long.toHexString(context.getReportId()), (Object)zombie.getStorageID());
        assert (this.namesystem.hasWriteLock());
        Iterator<BlockInfoContiguous> iter = zombie.getBlockIterator();
        int prevBlocks = zombie.numBlocks();
        while (iter.hasNext()) {
            BlockInfoContiguous block = iter.next();
            this.removeStoredBlock(block, zombie.getDatanodeDescriptor());
            this.invalidateBlocks.remove(zombie.getDatanodeDescriptor(), block);
        }
        assert (zombie.numBlocks() == 0);
        LOG.warn("processReport 0x{}: removed {} replicas from storage {}, which no longer exists on the DataNode.", new Object[]{Long.toHexString(context.getReportId()), prevBlocks, zombie.getStorageID()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescanPostponedMisreplicatedBlocks() {
        if (this.getPostponedMisreplicatedBlocksCount() == 0L) {
            return;
        }
        long startTimeRescanPostponedMisReplicatedBlocks = Time.monotonicNow();
        long startPostponedMisReplicatedBlocksCount = this.getPostponedMisreplicatedBlocksCount();
        this.namesystem.writeLock();
        try {
            int i = 0;
            long startIndex = 0L;
            long blocksPerRescan = this.datanodeManager.getBlocksPerPostponedMisreplicatedBlocksRescan();
            long base = this.getPostponedMisreplicatedBlocksCount() - blocksPerRescan;
            if (base > 0L && (startIndex = DFSUtil.getRandom().nextLong() % (base + 1L)) < 0L) {
                startIndex += base + 1L;
            }
            Iterator<Block> it = this.postponedMisreplicatedBlocks.iterator();
            int tmp = 0;
            while ((long)tmp < startIndex) {
                it.next();
                ++tmp;
            }
            while (it.hasNext()) {
                Block b = it.next();
                if ((long)i >= blocksPerRescan) {
                    break;
                }
                BlockInfoContiguous bi = this.blocksMap.getStoredBlock(b);
                if (bi == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BLOCK* rescanPostponedMisreplicatedBlocks: Postponed mis-replicated block " + b + " no longer found " + "in block map.");
                    }
                    it.remove();
                    this.postponedMisreplicatedBlocksCount.decrementAndGet();
                } else {
                    MisReplicationResult res = this.processMisReplicatedBlock(bi);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BLOCK* rescanPostponedMisreplicatedBlocks: Re-scanned block " + b + ", result is " + (Object)((Object)res));
                    }
                    if (res != MisReplicationResult.POSTPONE) {
                        it.remove();
                        this.postponedMisreplicatedBlocksCount.decrementAndGet();
                    }
                }
                ++i;
            }
        }
        finally {
            this.namesystem.writeUnlock();
            long endPostponedMisReplicatedBlocksCount = this.getPostponedMisreplicatedBlocksCount();
            LOG.info("Rescan of postponedMisreplicatedBlocks completed in " + (Time.monotonicNow() - startTimeRescanPostponedMisReplicatedBlocks) + " msecs. " + endPostponedMisReplicatedBlocksCount + " blocks are left. " + (startPostponedMisReplicatedBlocksCount - endPostponedMisReplicatedBlocksCount) + " blocks are removed.");
        }
    }

    private Collection<Block> processReport(DatanodeStorageInfo storageInfo, BlockListAsLongs report) throws IOException {
        LinkedList<BlockInfoContiguous> toAdd = new LinkedList<BlockInfoContiguous>();
        TreeSet<Block> toRemove = new TreeSet<Block>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        this.reportDiff(storageInfo, report, toAdd, toRemove, toInvalidate, toCorrupt, toUC);
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        for (StatefulBlockInfo statefulBlockInfo : toUC) {
            this.addStoredBlockUnderConstruction(statefulBlockInfo, storageInfo);
        }
        for (Block block : toRemove) {
            this.removeStoredBlock(block, node);
        }
        int numBlocksLogged = 0;
        for (BlockInfoContiguous blockInfoContiguous : toAdd) {
            this.addStoredBlock(blockInfoContiguous, storageInfo, null, (long)numBlocksLogged < this.maxNumBlocksToLog);
            ++numBlocksLogged;
        }
        if ((long)numBlocksLogged > this.maxNumBlocksToLog) {
            blockLog.info("BLOCK* processReport: logged info for {} of {} reported.", (Object)this.maxNumBlocksToLog, (Object)numBlocksLogged);
        }
        for (Block block : toInvalidate) {
            this.addToInvalidates(block, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt, storageInfo, node);
        }
        return toInvalidate;
    }

    public void markBlockReplicasAsCorrupt(BlockInfoContiguous block, long oldGenerationStamp, long oldNumBytes, DatanodeStorageInfo[] newStorages) throws IOException {
        assert (this.namesystem.hasWriteLock());
        BlockToMarkCorrupt b = null;
        if (block.getGenerationStamp() != oldGenerationStamp) {
            b = new BlockToMarkCorrupt(block, oldGenerationStamp, "genstamp does not match " + oldGenerationStamp + " : " + block.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
        } else if (block.getNumBytes() != oldNumBytes) {
            b = new BlockToMarkCorrupt(block, "length does not match " + oldNumBytes + " : " + block.getNumBytes(), CorruptReplicasMap.Reason.SIZE_MISMATCH);
        } else {
            return;
        }
        for (DatanodeStorageInfo storage : this.getStorages(block)) {
            boolean isCorrupt = true;
            if (newStorages != null) {
                for (DatanodeStorageInfo newStorage : newStorages) {
                    if (newStorage == null || !storage.equals(newStorage)) continue;
                    isCorrupt = false;
                    break;
                }
            }
            if (!isCorrupt) continue;
            blockLog.info("BLOCK* markBlockReplicasAsCorrupt: mark block replica {} on {} as corrupt because the dn is not in the new committed storage list.", (Object)b, (Object)storage.getDatanodeDescriptor());
            this.markBlockAsCorrupt(b, storage, storage.getDatanodeDescriptor());
        }
    }

    private void processFirstBlockReport(DatanodeStorageInfo storageInfo, BlockListAsLongs report) throws IOException {
        if (report == null) {
            return;
        }
        assert (this.namesystem.hasWriteLock());
        assert (storageInfo.getBlockReportCount() == 0);
        for (BlockListAsLongs.BlockReportReplica iblk : report) {
            HdfsServerConstants.ReplicaState reportedState = iblk.getState();
            if (this.shouldPostponeBlocksFromFuture && this.namesystem.isGenStampInFuture(iblk)) {
                this.queueReportedBlock(storageInfo, iblk, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
                continue;
            }
            BlockInfoContiguous storedBlock = this.blocksMap.getStoredBlock(iblk);
            if (storedBlock == null) continue;
            HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
            BlockToMarkCorrupt c = this.checkReplicaCorrupt(iblk, reportedState, storedBlock, ucState, storageInfo.getDatanodeDescriptor());
            if (c != null) {
                if (this.shouldPostponeBlocksFromFuture) {
                    this.queueReportedBlock(storageInfo, iblk, reportedState, QUEUE_REASON_CORRUPT_STATE);
                    continue;
                }
                this.markBlockAsCorrupt(c, storageInfo, storageInfo.getDatanodeDescriptor());
                continue;
            }
            if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
                ((BlockInfoContiguousUnderConstruction)storedBlock).addReplicaIfNotPresent(storageInfo, iblk, reportedState);
                BlockInfoContiguousUnderConstruction blockUC = (BlockInfoContiguousUnderConstruction)storedBlock;
                if (this.namesystem.isInSnapshot(blockUC)) {
                    int numOfReplicas = blockUC.getNumExpectedLocations();
                    this.namesystem.incrementSafeBlockCount(numOfReplicas);
                }
            }
            if (reportedState != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            this.addStoredBlockImmediate(storedBlock, storageInfo);
        }
    }

    private void reportDiff(DatanodeStorageInfo storageInfo, BlockListAsLongs newReport, Collection<BlockInfoContiguous> toAdd, Collection<Block> toRemove, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        BlockInfoContiguous delimiter = new BlockInfoContiguous(new Block(), 1);
        DatanodeStorageInfo.AddBlockResult result = storageInfo.addBlock(delimiter);
        assert (result == DatanodeStorageInfo.AddBlockResult.ADDED) : "Delimiting block cannot be present in the node";
        int headIndex = 0;
        if (newReport == null) {
            newReport = BlockListAsLongs.EMPTY;
        }
        for (BlockListAsLongs.BlockReportReplica iblk : newReport) {
            int curIndex;
            HdfsServerConstants.ReplicaState iState;
            BlockInfoContiguous storedBlock = this.processReportedBlock(storageInfo, iblk, iState = iblk.getState(), toAdd, toInvalidate, toCorrupt, toUC);
            if (storedBlock == null || (curIndex = storedBlock.findStorageInfo(storageInfo)) < 0) continue;
            headIndex = storageInfo.moveBlockToHead(storedBlock, curIndex, headIndex);
        }
        DatanodeStorageInfo datanodeStorageInfo = storageInfo;
        datanodeStorageInfo.getClass();
        DatanodeStorageInfo.BlockIterator it = new DatanodeStorageInfo.BlockIterator(datanodeStorageInfo, delimiter.getNext(0));
        while (it.hasNext()) {
            toRemove.add((Block)it.next());
        }
        storageInfo.removeBlock(delimiter);
    }

    private BlockInfoContiguous processReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState, Collection<BlockInfoContiguous> toAdd, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        DatanodeDescriptor dn = storageInfo.getDatanodeDescriptor();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reported block " + block + " on " + dn + " size " + block.getNumBytes() + " replicaState = " + (Object)((Object)reportedState));
        }
        if (this.shouldPostponeBlocksFromFuture && this.namesystem.isGenStampInFuture(block)) {
            this.queueReportedBlock(storageInfo, block, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
            return null;
        }
        BlockInfoContiguous storedBlock = this.blocksMap.getStoredBlock(block);
        if (storedBlock == null) {
            toInvalidate.add(new Block(block));
            return null;
        }
        HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
        if (LOG.isDebugEnabled()) {
            LOG.debug("In memory blockUCState = " + (Object)((Object)ucState));
        }
        if (this.invalidateBlocks.contains(dn, block)) {
            return storedBlock;
        }
        BlockToMarkCorrupt c = this.checkReplicaCorrupt(block, reportedState, storedBlock, ucState, dn);
        if (c != null) {
            if (this.shouldPostponeBlocksFromFuture) {
                this.queueReportedBlock(storageInfo, storedBlock, reportedState, QUEUE_REASON_CORRUPT_STATE);
            } else {
                toCorrupt.add(c);
            }
            return storedBlock;
        }
        if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
            toUC.add(new StatefulBlockInfo((BlockInfoContiguousUnderConstruction)storedBlock, new Block(block), reportedState));
            return storedBlock;
        }
        if (reportedState == HdfsServerConstants.ReplicaState.FINALIZED && (storedBlock.findStorageInfo(storageInfo) == -1 || this.corruptReplicas.isReplicaCorrupt(storedBlock, dn))) {
            toAdd.add(storedBlock);
        }
        return storedBlock;
    }

    private void queueReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState, String reason) {
        assert (this.shouldPostponeBlocksFromFuture);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queueing reported block " + block + " in state " + (Object)((Object)reportedState) + " from datanode " + storageInfo.getDatanodeDescriptor() + " for later processing because " + reason + ".");
        }
        this.pendingDNMessages.enqueueReportedBlock(storageInfo, block, reportedState);
    }

    public void processQueuedMessagesForBlock(Block b) throws IOException {
        Queue<PendingDataNodeMessages.ReportedBlockInfo> queue = this.pendingDNMessages.takeBlockQueue(b);
        if (queue == null) {
            return;
        }
        this.processQueuedMessages(queue);
    }

    private void processQueuedMessages(Iterable<PendingDataNodeMessages.ReportedBlockInfo> rbis) throws IOException {
        for (PendingDataNodeMessages.ReportedBlockInfo rbi : rbis) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing previouly queued message " + rbi);
            }
            if (rbi.getReportedState() == null) {
                DatanodeStorageInfo storageInfo = rbi.getStorageInfo();
                this.removeStoredBlock(rbi.getBlock(), storageInfo.getDatanodeDescriptor());
                continue;
            }
            this.processAndHandleReportedBlock(rbi.getStorageInfo(), rbi.getBlock(), rbi.getReportedState(), null);
        }
    }

    public void processAllPendingDNMessages() throws IOException {
        assert (!this.shouldPostponeBlocksFromFuture) : "processAllPendingDNMessages() should be called after disabling block postponement.";
        int count = this.pendingDNMessages.count();
        if (count > 0) {
            LOG.info("Processing " + count + " messages from DataNodes " + "that were previously queued during standby state");
        }
        this.processQueuedMessages(this.pendingDNMessages.takeAll());
        assert (this.pendingDNMessages.count() == 0);
    }

    private BlockToMarkCorrupt checkReplicaCorrupt(Block reported, HdfsServerConstants.ReplicaState reportedState, BlockInfoContiguous storedBlock, HdfsServerConstants.BlockUCState ucState, DatanodeDescriptor dn) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case COMPLETE: 
                    case COMMITTED: {
                        if (storedBlock.getGenerationStamp() != reported.getGenerationStamp()) {
                            long reportedGS = reported.getGenerationStamp();
                            return new BlockToMarkCorrupt(storedBlock, reportedGS, "block is " + (Object)((Object)ucState) + " and reported genstamp " + reportedGS + " does not match genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                        }
                        if (storedBlock.getNumBytes() != reported.getNumBytes()) {
                            return new BlockToMarkCorrupt(storedBlock, "block is " + (Object)((Object)ucState) + " and reported length " + reported.getNumBytes() + " does not match " + "length in block map " + storedBlock.getNumBytes(), CorruptReplicasMap.Reason.SIZE_MISMATCH);
                        }
                        return null;
                    }
                    case UNDER_CONSTRUCTION: {
                        if (storedBlock.getGenerationStamp() > reported.getGenerationStamp()) {
                            long reportedGS = reported.getGenerationStamp();
                            return new BlockToMarkCorrupt(storedBlock, reportedGS, "block is " + (Object)((Object)ucState) + " and reported state " + (Object)((Object)reportedState) + ", But reported genstamp " + reportedGS + " does not match genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                        }
                        return null;
                    }
                }
                return null;
            }
            case RBW: 
            case RWR: {
                if (!storedBlock.isComplete()) {
                    return null;
                }
                if (storedBlock.getGenerationStamp() != reported.getGenerationStamp()) {
                    long reportedGS = reported.getGenerationStamp();
                    return new BlockToMarkCorrupt(storedBlock, reportedGS, "reported " + (Object)((Object)reportedState) + " replica with genstamp " + reportedGS + " does not match COMPLETE block's genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                }
                if (reportedState == HdfsServerConstants.ReplicaState.RBW) {
                    LOG.info("Received an RBW replica for " + storedBlock + " on " + dn + ": ignoring it, since it is " + "complete with the same genstamp");
                    return null;
                }
                return new BlockToMarkCorrupt(storedBlock, "reported replica has invalid state " + (Object)((Object)reportedState), CorruptReplicasMap.Reason.INVALID_STATE);
            }
        }
        String msg = "Unexpected replica state " + (Object)((Object)reportedState) + " for block: " + storedBlock + " on " + dn + " size " + storedBlock.getNumBytes();
        LOG.warn(msg);
        return new BlockToMarkCorrupt(storedBlock, msg, CorruptReplicasMap.Reason.INVALID_STATE);
    }

    private boolean isBlockUnderConstruction(BlockInfoContiguous storedBlock, HdfsServerConstants.BlockUCState ucState, HdfsServerConstants.ReplicaState reportedState) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case UNDER_CONSTRUCTION: 
                    case UNDER_RECOVERY: {
                        return true;
                    }
                }
                return false;
            }
            case RBW: 
            case RWR: {
                return !storedBlock.isComplete();
            }
        }
        return false;
    }

    void addStoredBlockUnderConstruction(StatefulBlockInfo ucBlock, DatanodeStorageInfo storageInfo) throws IOException {
        BlockInfoContiguousUnderConstruction block = ucBlock.storedBlock;
        block.addReplicaIfNotPresent(storageInfo, ucBlock.reportedBlock, ucBlock.reportedState);
        if (ucBlock.reportedState == HdfsServerConstants.ReplicaState.FINALIZED && !block.findDatanode(storageInfo.getDatanodeDescriptor())) {
            this.addStoredBlock(block, storageInfo, null, true);
        }
    }

    private void addStoredBlockImmediate(BlockInfoContiguous storedBlock, DatanodeStorageInfo storageInfo) throws IOException {
        assert (storedBlock != null && this.namesystem.hasWriteLock());
        if (!this.namesystem.isInStartupSafeMode() || this.namesystem.isPopulatingReplQueues()) {
            this.addStoredBlock(storedBlock, storageInfo, null, false);
            return;
        }
        DatanodeStorageInfo.AddBlockResult result = storageInfo.addBlock(storedBlock);
        int numCurrentReplica = this.countLiveNodes(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && numCurrentReplica >= this.minReplication) {
            this.completeBlock(storedBlock.getBlockCollection(), storedBlock, false);
        } else if (storedBlock.isComplete() && result == DatanodeStorageInfo.AddBlockResult.ADDED) {
            this.namesystem.incrementSafeBlockCount(numCurrentReplica);
        }
    }

    private Block addStoredBlock(BlockInfoContiguous block, DatanodeStorageInfo storageInfo, DatanodeDescriptor delNodeHint, boolean logEveryBlock) throws IOException {
        int curReplicaDelta;
        assert (block != null && this.namesystem.hasWriteLock());
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        BlockInfoContiguous storedBlock = block instanceof BlockInfoContiguousUnderConstruction ? this.blocksMap.getStoredBlock(block) : block;
        if (storedBlock == null || storedBlock.getBlockCollection() == null) {
            blockLog.info("BLOCK* addStoredBlock: {} on {} size {} but it does not belong to any file", new Object[]{block, node, block.getNumBytes()});
            return block;
        }
        BlockCollection bc = storedBlock.getBlockCollection();
        assert (bc != null) : "Block must belong to a file";
        DatanodeStorageInfo.AddBlockResult result = storageInfo.addBlock(storedBlock);
        if (result == DatanodeStorageInfo.AddBlockResult.ADDED) {
            curReplicaDelta = 1;
            if (logEveryBlock) {
                this.logAddStoredBlock(storedBlock, node);
            }
        } else if (result == DatanodeStorageInfo.AddBlockResult.REPLACED) {
            curReplicaDelta = 0;
            blockLog.warn("BLOCK* addStoredBlock: block {} moved to storageType {} on node {}", new Object[]{storedBlock, storageInfo.getStorageType(), node});
        } else {
            this.corruptReplicas.removeFromCorruptReplicasMap(block, node, CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
            curReplicaDelta = 0;
            blockLog.warn("BLOCK* addStoredBlock: Redundant addStoredBlock request received for {} on node {} size {}", new Object[]{storedBlock, node, storedBlock.getNumBytes()});
        }
        NumberReplicas num = this.countNodes(storedBlock);
        int numLiveReplicas = num.liveReplicas();
        int numCurrentReplica = numLiveReplicas + this.pendingReplications.getNumReplicas(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && numLiveReplicas >= this.minReplication) {
            storedBlock = this.completeBlock(bc, storedBlock, false);
        } else if (storedBlock.isComplete() && result == DatanodeStorageInfo.AddBlockResult.ADDED) {
            this.namesystem.incrementSafeBlockCount(numCurrentReplica);
        }
        if (bc.isUnderConstruction()) {
            return storedBlock;
        }
        if (!this.namesystem.isPopulatingReplQueues()) {
            return storedBlock;
        }
        short fileReplication = bc.getBlockReplication();
        if (!this.isNeededReplication(storedBlock, fileReplication, numCurrentReplica)) {
            this.neededReplications.remove(storedBlock, numCurrentReplica, num.decommissionedReplicas(), fileReplication);
        } else {
            this.updateNeededReplications(storedBlock, curReplicaDelta, 0);
        }
        if (numCurrentReplica > fileReplication) {
            this.processOverReplicatedBlock(storedBlock, fileReplication, node, delNodeHint);
        }
        int corruptReplicasCount = this.corruptReplicas.numCorruptReplicas(storedBlock);
        int numCorruptNodes = num.corruptReplicas();
        if (numCorruptNodes != corruptReplicasCount) {
            LOG.warn("Inconsistent number of corrupt replicas for " + storedBlock + "blockMap has " + numCorruptNodes + " but corrupt replicas map has " + corruptReplicasCount);
        }
        if (corruptReplicasCount > 0 && numLiveReplicas >= fileReplication) {
            this.invalidateCorruptReplicas(storedBlock);
        }
        return storedBlock;
    }

    private void logAddStoredBlock(BlockInfoContiguous storedBlock, DatanodeDescriptor node) {
        if (!blockLog.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder(500);
        sb.append("BLOCK* addStoredBlock: blockMap updated: ").append(node).append(" is added to ");
        storedBlock.appendStringTo(sb);
        sb.append(" size ").append(storedBlock.getNumBytes());
        blockLog.info(sb.toString());
    }

    private void invalidateCorruptReplicas(BlockInfoContiguous blk) {
        DatanodeDescriptor[] nodesCopy;
        Collection<DatanodeDescriptor> nodes = this.corruptReplicas.getNodes(blk);
        boolean removedFromBlocksMap = true;
        if (nodes == null) {
            return;
        }
        for (DatanodeDescriptor node : nodesCopy = nodes.toArray(new DatanodeDescriptor[0])) {
            try {
                if (this.invalidateBlock(new BlockToMarkCorrupt(blk, null, CorruptReplicasMap.Reason.ANY), node)) continue;
                removedFromBlocksMap = false;
            }
            catch (IOException e) {
                blockLog.info("invalidateCorruptReplicas error in deleting bad block {} on {}", new Object[]{blk, node, e});
                removedFromBlocksMap = false;
            }
        }
        if (removedFromBlocksMap) {
            this.corruptReplicas.removeFromCorruptReplicasMap(blk);
        }
    }

    public void processMisReplicatedBlocks() {
        assert (this.namesystem.hasWriteLock());
        this.stopReplicationInitializer();
        this.neededReplications.clear();
        this.replicationQueuesInitializer = new Daemon(){

            @Override
            public void run() {
                try {
                    BlockManager.this.processMisReplicatesAsync();
                }
                catch (InterruptedException ie) {
                    LOG.info("Interrupted while processing replication queues.");
                }
                catch (Exception e) {
                    LOG.error("Error while processing replication queues async", (Throwable)e);
                }
            }
        };
        this.replicationQueuesInitializer.setName("Replication Queue Initializer");
        this.replicationQueuesInitializer.start();
    }

    private void stopReplicationInitializer() {
        if (this.replicationQueuesInitializer != null) {
            this.replicationQueuesInitializer.interrupt();
            try {
                this.replicationQueuesInitializer.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for replicationQueueInitializer. Returning..");
                return;
            }
            finally {
                this.replicationQueuesInitializer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMisReplicatesAsync() throws InterruptedException {
        long nrInvalid = 0L;
        long nrOverReplicated = 0L;
        long nrUnderReplicated = 0L;
        long nrPostponed = 0L;
        long nrUnderConstruction = 0L;
        long startTimeMisReplicatedScan = Time.monotonicNow();
        Iterator<BlockInfoContiguous> blocksItr = this.blocksMap.getBlocks().iterator();
        long totalBlocks = this.blocksMap.size();
        this.replicationQueuesInitProgress = 0.0;
        long totalProcessed = 0L;
        long sleepDuration = Math.max(1, Math.min(this.numBlocksPerIteration / 1000, 10000));
        while (this.namesystem.isRunning() && !Thread.currentThread().isInterrupted()) {
            this.namesystem.writeLockInterruptibly();
            try {
                int processed;
                block12: for (processed = 0; processed < this.numBlocksPerIteration && blocksItr.hasNext(); ++processed) {
                    BlockInfoContiguous block = blocksItr.next();
                    MisReplicationResult res = this.processMisReplicatedBlock(block);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("block " + block + ": " + (Object)((Object)res));
                    }
                    switch (res) {
                        case UNDER_REPLICATED: {
                            ++nrUnderReplicated;
                            continue block12;
                        }
                        case OVER_REPLICATED: {
                            ++nrOverReplicated;
                            continue block12;
                        }
                        case INVALID: {
                            ++nrInvalid;
                            continue block12;
                        }
                        case POSTPONE: {
                            ++nrPostponed;
                            this.postponeBlock(block);
                            continue block12;
                        }
                        case UNDER_CONSTRUCTION: {
                            ++nrUnderConstruction;
                            continue block12;
                        }
                        case OK: {
                            continue block12;
                        }
                        default: {
                            throw new AssertionError((Object)("Invalid enum value: " + (Object)((Object)res)));
                        }
                    }
                }
                this.replicationQueuesInitProgress = Math.min((double)(totalProcessed += (long)processed) / (double)totalBlocks, 1.0);
                if (blocksItr.hasNext()) continue;
                LOG.info("Total number of blocks            = " + this.blocksMap.size());
                LOG.info("Number of invalid blocks          = " + nrInvalid);
                LOG.info("Number of under-replicated blocks = " + nrUnderReplicated);
                LOG.info("Number of  over-replicated blocks = " + nrOverReplicated + (nrPostponed > 0L ? " (" + nrPostponed + " postponed)" : ""));
                LOG.info("Number of blocks being written    = " + nrUnderConstruction);
                NameNode.stateChangeLog.info("STATE* Replication Queue initialization scan for invalid, over- and under-replicated blocks completed in " + (Time.monotonicNow() - startTimeMisReplicatedScan) + " msec");
                break;
            }
            finally {
                this.namesystem.writeUnlock();
                Thread.sleep(sleepDuration);
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            LOG.info("Interrupted while processing replication queues.");
        }
    }

    public double getReplicationQueuesInitProgress() {
        return this.replicationQueuesInitProgress;
    }

    private MisReplicationResult processMisReplicatedBlock(BlockInfoContiguous block) {
        NumberReplicas num;
        int numCurrentReplica;
        BlockCollection bc = block.getBlockCollection();
        if (bc == null) {
            this.addToInvalidates(block);
            return MisReplicationResult.INVALID;
        }
        if (!block.isComplete()) {
            return MisReplicationResult.UNDER_CONSTRUCTION;
        }
        short expectedReplication = bc.getBlockReplication();
        if (this.isNeededReplication(block, expectedReplication, numCurrentReplica = (num = this.countNodes(block)).liveReplicas()) && this.neededReplications.add(block, numCurrentReplica, num.decommissionedReplicas(), expectedReplication)) {
            return MisReplicationResult.UNDER_REPLICATED;
        }
        if (numCurrentReplica > expectedReplication) {
            if (num.replicasOnStaleNodes() > 0) {
                return MisReplicationResult.POSTPONE;
            }
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
            return MisReplicationResult.OVER_REPLICATED;
        }
        return MisReplicationResult.OK;
    }

    public void setReplication(short oldRepl, short newRepl, String src, Block ... blocks) {
        if (newRepl == oldRepl) {
            return;
        }
        for (Block b : blocks) {
            this.updateNeededReplications(b, 0, newRepl - oldRepl);
        }
        if (oldRepl > newRepl) {
            LOG.info("Decreasing replication from " + oldRepl + " to " + newRepl + " for " + src);
            for (Block b : blocks) {
                this.processOverReplicatedBlock(b, newRepl, null, null);
            }
        } else {
            LOG.info("Increasing replication from " + oldRepl + " to " + newRepl + " for " + src);
        }
    }

    private void processOverReplicatedBlock(Block block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        assert (this.namesystem.hasWriteLock());
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeStorageInfo> nonExcess = new ArrayList<DatanodeStorageInfo>();
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block, DatanodeStorage.State.NORMAL)) {
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (storage.areBlockContentsStale()) {
                LOG.info("BLOCK* processOverReplicatedBlock: Postponing processing of over-replicated " + block + " since storage + " + storage + "datanode " + cur + " does not yet have up-to-date " + "block information.");
                this.postponeBlock(block);
                return;
            }
            LightWeightLinkedSet<Block> excessBlocks = this.excessReplicateMap.get(cur.getDatanodeUuid());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            nonExcess.add(storage);
        }
        this.chooseExcessReplicates(nonExcess, block, replication, addedNode, delNodeHint, this.blockplacement);
    }

    private void chooseExcessReplicates(Collection<DatanodeStorageInfo> nonExcess, Block b, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint, BlockPlacementPolicy replicator) {
        assert (this.namesystem.hasWriteLock());
        BlockCollection bc = this.getBlockCollection(b);
        BlockStoragePolicy storagePolicy = this.storagePolicySuite.getPolicy(bc.getStoragePolicyID());
        List<StorageType> excessTypes = storagePolicy.chooseExcess(replication, DatanodeStorageInfo.toStorageTypes(nonExcess));
        HashMap<String, List<DatanodeStorageInfo>> rackMap = new HashMap<String, List<DatanodeStorageInfo>>();
        ArrayList<DatanodeStorageInfo> moreThanOne = new ArrayList<DatanodeStorageInfo>();
        ArrayList<DatanodeStorageInfo> exactlyOne = new ArrayList<DatanodeStorageInfo>();
        replicator.splitNodesWithRack(nonExcess, rackMap, moreThanOne, exactlyOne);
        boolean firstOne = true;
        DatanodeStorageInfo delNodeHintStorage = DatanodeStorageInfo.getDatanodeStorageInfo(nonExcess, delNodeHint);
        DatanodeStorageInfo addedNodeStorage = DatanodeStorageInfo.getDatanodeStorageInfo(nonExcess, addedNode);
        while (nonExcess.size() - replication > 0) {
            DatanodeStorageInfo cur = BlockManager.useDelHint(firstOne, delNodeHintStorage, addedNodeStorage, moreThanOne, excessTypes) ? delNodeHintStorage : replicator.chooseReplicaToDelete(bc, b, replication, moreThanOne, exactlyOne, excessTypes);
            firstOne = false;
            replicator.adjustSetsWithChosenReplica(rackMap, moreThanOne, exactlyOne, cur);
            nonExcess.remove(cur);
            this.addToExcessReplicate(cur.getDatanodeDescriptor(), b);
            this.addToInvalidates(b, cur.getDatanodeDescriptor());
            blockLog.info("BLOCK* chooseExcessReplicates: ({}, {}) is added to invalidated blocks set", (Object)cur, (Object)b);
        }
    }

    static boolean useDelHint(boolean isFirst, DatanodeStorageInfo delHint, DatanodeStorageInfo added, List<DatanodeStorageInfo> moreThan1Racks, List<StorageType> excessTypes) {
        if (!isFirst) {
            return false;
        }
        if (delHint == null) {
            return false;
        }
        if (!excessTypes.contains((Object)delHint.getStorageType())) {
            return false;
        }
        if (moreThan1Racks.contains(delHint)) {
            return true;
        }
        return added != null && !moreThan1Racks.contains(added);
    }

    private void addToExcessReplicate(DatanodeInfo dn, Block block) {
        assert (this.namesystem.hasWriteLock());
        LightWeightLinkedSet<Block> excessBlocks = this.excessReplicateMap.get(dn.getDatanodeUuid());
        if (excessBlocks == null) {
            excessBlocks = new LightWeightLinkedSet();
            this.excessReplicateMap.put(dn.getDatanodeUuid(), excessBlocks);
        }
        if (excessBlocks.add(block)) {
            this.excessBlocksCount.incrementAndGet();
            blockLog.debug("BLOCK* addToExcessReplicate: ({}, {}) is added to excessReplicateMap", (Object)dn, (Object)block);
        }
    }

    private void removeStoredBlock(DatanodeStorageInfo storageInfo, Block block, DatanodeDescriptor node) {
        if (this.shouldPostponeBlocksFromFuture && this.namesystem.isGenStampInFuture(block)) {
            this.queueReportedBlock(storageInfo, block, null, QUEUE_REASON_FUTURE_GENSTAMP);
            return;
        }
        this.removeStoredBlock(block, node);
    }

    public void removeStoredBlock(Block block, DatanodeDescriptor node) {
        LightWeightLinkedSet<Block> excessBlocks;
        blockLog.debug("BLOCK* removeStoredBlock: {} from {}", (Object)block, (Object)node);
        assert (this.namesystem.hasWriteLock());
        if (!this.blocksMap.removeNode(block, node)) {
            blockLog.debug("BLOCK* removeStoredBlock: {} has already been removed from node {}", (Object)block, (Object)node);
            return;
        }
        BlockCollection bc = this.blocksMap.getBlockCollection(block);
        if (bc != null) {
            this.namesystem.decrementSafeBlockCount(block);
            this.updateNeededReplications(block, -1, 0);
        }
        if ((excessBlocks = this.excessReplicateMap.get(node.getDatanodeUuid())) != null && excessBlocks.remove(block)) {
            this.excessBlocksCount.decrementAndGet();
            blockLog.debug("BLOCK* removeStoredBlock: {} is removed from excessBlocks", (Object)block);
            if (excessBlocks.size() == 0) {
                this.excessReplicateMap.remove(node.getDatanodeUuid());
            }
        }
        this.corruptReplicas.removeFromCorruptReplicasMap(block, node);
    }

    private long addBlock(Block block, List<BlocksWithLocations.BlockWithLocations> results) {
        List<DatanodeStorageInfo> locations = this.getValidLocations(block);
        if (locations.size() == 0) {
            return 0L;
        }
        String[] datanodeUuids = new String[locations.size()];
        String[] storageIDs = new String[datanodeUuids.length];
        StorageType[] storageTypes = new StorageType[datanodeUuids.length];
        for (int i = 0; i < locations.size(); ++i) {
            DatanodeStorageInfo s = locations.get(i);
            datanodeUuids[i] = s.getDatanodeDescriptor().getDatanodeUuid();
            storageIDs[i] = s.getStorageID();
            storageTypes[i] = s.getStorageType();
        }
        results.add(new BlocksWithLocations.BlockWithLocations(block, datanodeUuids, storageIDs, storageTypes));
        return block.getNumBytes();
    }

    @VisibleForTesting
    void addBlock(DatanodeStorageInfo storageInfo, Block block, String delHint) throws IOException {
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        node.decrementBlocksScheduled(storageInfo.getStorageType());
        DatanodeDescriptor delHintNode = null;
        if (delHint != null && delHint.length() != 0 && (delHintNode = this.datanodeManager.getDatanode(delHint)) == null) {
            blockLog.warn("BLOCK* blockReceived: {} is expected to be removed from an unrecorded node {}", (Object)block, (Object)delHint);
        }
        this.pendingReplications.decrement(block, node);
        this.processAndHandleReportedBlock(storageInfo, block, HdfsServerConstants.ReplicaState.FINALIZED, delHintNode);
    }

    private void processAndHandleReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState, DatanodeDescriptor delHintNode) throws IOException {
        LinkedList<BlockInfoContiguous> toAdd = new LinkedList<BlockInfoContiguous>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        this.processReportedBlock(storageInfo, block, reportedState, toAdd, toInvalidate, toCorrupt, toUC);
        assert (toUC.size() + toAdd.size() + toInvalidate.size() + toCorrupt.size() <= 1) : "The block should be only in one of the lists.";
        for (StatefulBlockInfo b : toUC) {
            this.addStoredBlockUnderConstruction(b, storageInfo);
        }
        long numBlocksLogged = 0L;
        for (BlockInfoContiguous blockInfoContiguous : toAdd) {
            this.addStoredBlock(blockInfoContiguous, storageInfo, delHintNode, numBlocksLogged < this.maxNumBlocksToLog);
            ++numBlocksLogged;
        }
        if (numBlocksLogged > this.maxNumBlocksToLog) {
            blockLog.info("BLOCK* addBlock: logged info for {} of {} reported.", (Object)this.maxNumBlocksToLog, (Object)numBlocksLogged);
        }
        for (Block block2 : toInvalidate) {
            blockLog.info("BLOCK* addBlock: block {} on node {} size {} does not belong to any file", new Object[]{block2, node, block2.getNumBytes()});
            this.addToInvalidates(block2, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt, storageInfo, node);
        }
    }

    public void processIncrementalBlockReport(DatanodeID nodeID, StorageReceivedDeletedBlocks srdb) throws IOException {
        assert (this.namesystem.hasWriteLock());
        int received = 0;
        int deleted = 0;
        int receiving = 0;
        DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
        if (node == null || !node.isAlive) {
            blockLog.warn("BLOCK* processIncrementalBlockReport is received from dead or unregistered node {}", (Object)nodeID);
            throw new IOException("Got incremental block report from unregistered or dead node");
        }
        DatanodeStorageInfo storageInfo = node.getStorageInfo(srdb.getStorage().getStorageID());
        if (storageInfo == null) {
            storageInfo = node.updateStorage(srdb.getStorage());
        }
        for (ReceivedDeletedBlockInfo rdbi : srdb.getBlocks()) {
            switch (rdbi.getStatus()) {
                case DELETED_BLOCK: {
                    this.removeStoredBlock(storageInfo, rdbi.getBlock(), node);
                    ++deleted;
                    break;
                }
                case RECEIVED_BLOCK: {
                    this.addBlock(storageInfo, rdbi.getBlock(), rdbi.getDelHints());
                    ++received;
                    break;
                }
                case RECEIVING_BLOCK: {
                    ++receiving;
                    this.processAndHandleReportedBlock(storageInfo, rdbi.getBlock(), HdfsServerConstants.ReplicaState.RBW, null);
                    break;
                }
                default: {
                    String msg = "Unknown block status code reported by " + nodeID + ": " + rdbi;
                    blockLog.warn(msg);
                    assert (false) : msg;
                    break;
                }
            }
            blockLog.debug("BLOCK* block {}: {} is received from {}", new Object[]{rdbi.getStatus(), rdbi.getBlock(), nodeID});
        }
        blockLog.debug("*BLOCK* NameNode.processIncrementalBlockReport: from {} receiving: {}, received: {}, deleted: {}", new Object[]{nodeID, receiving, received, deleted});
    }

    public NumberReplicas countNodes(Block b) {
        int decommissioned = 0;
        int live = 0;
        int corrupt = 0;
        int excess = 0;
        int stale = 0;
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(b, DatanodeStorage.State.NORMAL)) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
            } else if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++decommissioned;
            } else {
                LightWeightLinkedSet<Block> blocksExcess = this.excessReplicateMap.get(node.getDatanodeUuid());
                if (blocksExcess != null && blocksExcess.contains(b)) {
                    ++excess;
                } else {
                    ++live;
                }
            }
            if (!storage.areBlockContentsStale()) continue;
            ++stale;
        }
        return new NumberReplicas(live, decommissioned, corrupt, excess, stale);
    }

    int countLiveNodes(BlockInfoContiguous b) {
        if (!this.namesystem.isInStartupSafeMode()) {
            return this.countNodes(b).liveReplicas();
        }
        int live = 0;
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(b, DatanodeStorage.State.NORMAL)) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) continue;
            ++live;
        }
        return live;
    }

    void processOverReplicatedBlocksOnReCommission(DatanodeDescriptor srcNode) {
        if (!this.namesystem.isPopulatingReplQueues()) {
            return;
        }
        Iterator<BlockInfoContiguous> it = srcNode.getBlockIterator();
        int numOverReplicated = 0;
        while (it.hasNext()) {
            Block block = it.next();
            BlockCollection bc = this.blocksMap.getBlockCollection(block);
            short expectedReplication = bc.getBlockReplication();
            NumberReplicas num = this.countNodes(block);
            int numCurrentReplica = num.liveReplicas();
            if (numCurrentReplica <= expectedReplication) continue;
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
            ++numOverReplicated;
        }
        LOG.info("Invalidated " + numOverReplicated + " over-replicated blocks on " + srcNode + " during recommissioning");
    }

    boolean isNodeHealthyForDecommission(DatanodeDescriptor node) {
        if (!node.checkBlockReportReceived()) {
            LOG.info("Node {} hasn't sent its first block report.", (Object)node);
            return false;
        }
        if (node.isAlive) {
            return true;
        }
        this.updateState();
        if (this.pendingReplicationBlocksCount == 0L && this.underReplicatedBlocksCount == 0L) {
            LOG.info("Node {} is dead and there are no under-replicated blocks or blocks pending replication. Safe to decommission.", (Object)node);
            return true;
        }
        LOG.warn("Node {} is dead while decommission is in progress. Cannot be safely decommissioned since there is risk of reduced data durability or data loss. Either restart the failed node or force decommissioning by removing, calling refreshNodes, then re-adding to the excludes files.", (Object)node);
        return false;
    }

    public int getActiveBlockCount() {
        return this.blocksMap.size();
    }

    public DatanodeStorageInfo[] getStorages(BlockInfoContiguous block) {
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[block.numNodes()];
        int i = 0;
        for (DatanodeStorageInfo s : this.blocksMap.getStorages(block)) {
            storages[i++] = s;
        }
        return storages;
    }

    public int getTotalBlocks() {
        return this.blocksMap.size();
    }

    public void removeBlock(Block block) {
        assert (this.namesystem.hasWriteLock());
        block.setNumBytes(Long.MAX_VALUE);
        this.addToInvalidates(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
        this.blocksMap.removeBlock(block);
        this.pendingReplications.remove(block);
        this.neededReplications.remove(block, 5);
        if (this.postponedMisreplicatedBlocks.remove(block)) {
            this.postponedMisreplicatedBlocksCount.decrementAndGet();
        }
    }

    public BlockInfoContiguous getStoredBlock(Block block) {
        return this.blocksMap.getStoredBlock(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        this.namesystem.writeLock();
        try {
            if (!this.namesystem.isPopulatingReplQueues()) {
                return;
            }
            NumberReplicas repl = this.countNodes(block);
            int curExpectedReplicas = this.getReplication(block);
            if (this.isNeededReplication(block, curExpectedReplicas, repl.liveReplicas())) {
                this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
            } else {
                int oldReplicas = repl.liveReplicas() - curReplicasDelta;
                int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
                this.neededReplications.remove(block, oldReplicas, repl.decommissionedReplicas(), oldExpectedReplicas);
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public void checkReplication(BlockCollection bc) {
        short expected = bc.getBlockReplication();
        for (BlockInfoContiguous block : bc.getBlocks()) {
            NumberReplicas n = this.countNodes(block);
            if (this.isNeededReplication(block, expected, n.liveReplicas())) {
                this.neededReplications.add(block, n.liveReplicas(), n.decommissionedReplicas(), expected);
                continue;
            }
            if (n.liveReplicas() <= expected) continue;
            this.processOverReplicatedBlock(block, expected, null, null);
        }
    }

    private int getReplication(Block block) {
        BlockCollection bc = this.blocksMap.getBlockCollection(block);
        return bc == null ? (short)0 : bc.getBlockReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invalidateWorkForOneNode(DatanodeInfo dn) {
        List<Block> toInvalidate;
        this.namesystem.writeLock();
        try {
            if (this.namesystem.isInSafeMode()) {
                LOG.debug("In safemode, not computing replication work");
                int n = 0;
                return n;
            }
            DatanodeDescriptor dnDescriptor = this.datanodeManager.getDatanode(dn);
            if (dnDescriptor == null) {
                LOG.warn("DataNode " + dn + " cannot be found with UUID " + dn.getDatanodeUuid() + ", removing block invalidation work.");
                this.invalidateBlocks.remove(dn);
                int n = 0;
                return n;
            }
            toInvalidate = this.invalidateBlocks.invalidateWork(dnDescriptor);
            if (toInvalidate == null) {
                int n = 0;
                return n;
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        blockLog.info("BLOCK* {}: ask {} to delete {}", new Object[]{this.getClass().getSimpleName(), dn, toInvalidate});
        return toInvalidate.size();
    }

    boolean blockHasEnoughRacks(Block b) {
        if (!this.shouldCheckForEnoughRacks) {
            return true;
        }
        boolean enoughRacks = false;
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(b);
        int numExpectedReplicas = this.getReplication(b);
        String rackName = null;
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(b)) {
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            if (numExpectedReplicas == 1 || numExpectedReplicas > 1 && !this.datanodeManager.hasClusterEverBeenMultiRack()) {
                enoughRacks = true;
                break;
            }
            String rackNameNew = cur.getNetworkLocation();
            if (rackName == null) {
                rackName = rackNameNew;
                continue;
            }
            if (rackName.equals(rackNameNew)) continue;
            enoughRacks = true;
            break;
        }
        return enoughRacks;
    }

    boolean isNeededReplication(Block b, int expected, int current) {
        return current < expected || !this.blockHasEnoughRacks(b);
    }

    public long getMissingBlocksCount() {
        return this.neededReplications.getCorruptBlockSize();
    }

    public long getMissingReplOneBlocksCount() {
        return this.neededReplications.getCorruptReplOneBlockSize();
    }

    public BlockInfoContiguous addBlockCollection(BlockInfoContiguous block, BlockCollection bc) {
        return this.blocksMap.addBlockCollection(block, bc);
    }

    public BlockCollection getBlockCollection(Block b) {
        return this.blocksMap.getBlockCollection(b);
    }

    public Iterable<DatanodeStorageInfo> getStorages(Block block) {
        return this.blocksMap.getStorages(block);
    }

    public int numCorruptReplicas(Block block) {
        return this.corruptReplicas.numCorruptReplicas(block);
    }

    public void removeBlockFromMap(Block block) {
        this.blocksMap.removeBlock(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
    }

    public int getCapacity() {
        return this.blocksMap.getCapacity();
    }

    public long[] getCorruptReplicaBlockIds(int numExpectedBlocks, Long startingBlockId) {
        return this.corruptReplicas.getCorruptReplicaBlockIds(numExpectedBlocks, startingBlockId);
    }

    public Iterator<Block> getCorruptReplicaBlockIterator() {
        return this.neededReplications.iterator(4);
    }

    public Collection<DatanodeDescriptor> getCorruptReplicas(Block block) {
        return this.corruptReplicas.getNodes(block);
    }

    public String getCorruptReason(Block block, DatanodeDescriptor node) {
        return this.corruptReplicas.getCorruptReason(block, node);
    }

    public int numOfUnderReplicatedBlocks() {
        return this.neededReplications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeDatanodeWork() {
        if (this.namesystem.isInSafeMode()) {
            return 0;
        }
        int numlive = this.heartbeatManager.getLiveDatanodeCount();
        int blocksToProcess = numlive * this.blocksReplWorkMultiplier;
        int nodesToProcess = (int)Math.ceil((float)numlive * this.blocksInvalidateWorkPct);
        int workFound = this.computeReplicationWork(blocksToProcess);
        this.namesystem.writeLock();
        try {
            this.updateState();
            this.scheduledReplicationBlocksCount = workFound;
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return workFound += this.computeInvalidateWork(nodesToProcess);
    }

    public void clearQueues() {
        this.neededReplications.clear();
        this.pendingReplications.clear();
        this.excessReplicateMap.clear();
        this.invalidateBlocks.clear();
        this.datanodeManager.clearPendingQueues();
        this.postponedMisreplicatedBlocks.clear();
        this.postponedMisreplicatedBlocksCount.set(0L);
    }

    public void shutdown() {
        this.stopReplicationInitializer();
        this.blocksMap.close();
    }

    public void clear() {
        this.clearQueues();
        this.blocksMap.clear();
    }

    static enum MisReplicationResult {
        INVALID,
        UNDER_REPLICATED,
        OVER_REPLICATED,
        POSTPONE,
        UNDER_CONSTRUCTION,
        OK;

    }

    private static class ReplicationWork {
        private final Block block;
        private final BlockCollection bc;
        private final DatanodeDescriptor srcNode;
        private final List<DatanodeDescriptor> containingNodes;
        private final List<DatanodeStorageInfo> liveReplicaStorages;
        private final int additionalReplRequired;
        private DatanodeStorageInfo[] targets;
        private final int priority;

        public ReplicationWork(Block block, BlockCollection bc, DatanodeDescriptor srcNode, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> liveReplicaStorages, int additionalReplRequired, int priority) {
            this.block = block;
            this.bc = bc;
            this.srcNode = srcNode;
            this.srcNode.incrementPendingReplicationWithoutTargets();
            this.containingNodes = containingNodes;
            this.liveReplicaStorages = liveReplicaStorages;
            this.additionalReplRequired = additionalReplRequired;
            this.priority = priority;
            this.targets = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chooseTargets(BlockPlacementPolicy blockplacement, BlockStoragePolicySuite storagePolicySuite, Set<Node> excludedNodes) {
            try {
                this.targets = blockplacement.chooseTarget(this.bc.getName(), this.additionalReplRequired, this.srcNode, this.liveReplicaStorages, false, excludedNodes, this.block.getNumBytes(), storagePolicySuite.getPolicy(this.bc.getStoragePolicyID()));
            }
            finally {
                this.srcNode.decrementPendingReplicationWithoutTargets();
            }
        }

        static /* synthetic */ List access$100(ReplicationWork x0) {
            return x0.containingNodes;
        }

        static /* synthetic */ void access$200(ReplicationWork x0, BlockPlacementPolicy x1, BlockStoragePolicySuite x2, Set x3) {
            x0.chooseTargets(x1, x2, x3);
        }

        static /* synthetic */ DatanodeStorageInfo[] access$300(ReplicationWork x0) {
            return x0.targets;
        }

        static /* synthetic */ DatanodeStorageInfo[] access$302(ReplicationWork x0, DatanodeStorageInfo[] x1) {
            x0.targets = x1;
            return x1;
        }

        static /* synthetic */ Block access$400(ReplicationWork x0) {
            return x0.block;
        }

        static /* synthetic */ int access$500(ReplicationWork x0) {
            return x0.priority;
        }

        static /* synthetic */ DatanodeDescriptor access$600(ReplicationWork x0) {
            return x0.srcNode;
        }
    }

    private class ReplicationMonitor
    implements Runnable {
        private ReplicationMonitor() {
        }

        @Override
        public void run() {
            while (BlockManager.this.namesystem.isRunning()) {
                try {
                    if (BlockManager.this.namesystem.isPopulatingReplQueues()) {
                        BlockManager.this.computeDatanodeWork();
                        BlockManager.this.processPendingReplications();
                        BlockManager.this.rescanPostponedMisreplicatedBlocks();
                    }
                    Thread.sleep(BlockManager.this.replicationRecheckInterval);
                }
                catch (Throwable t) {
                    if (!BlockManager.this.namesystem.isRunning()) {
                        LOG.info("Stopping ReplicationMonitor.");
                        if (t instanceof InterruptedException) break;
                        LOG.info("ReplicationMonitor received an exception while shutting down.", t);
                        break;
                    }
                    if (!BlockManager.this.checkNSRunning && t instanceof InterruptedException) {
                        LOG.info("Stopping ReplicationMonitor for testing.");
                        break;
                    }
                    LOG.error("ReplicationMonitor thread received Runtime exception. ", t);
                    ExitUtil.terminate(1, t);
                }
            }
        }
    }

    private static class BlockToMarkCorrupt {
        final BlockInfoContiguous corrupted;
        final BlockInfoContiguous stored;
        final String reason;
        final CorruptReplicasMap.Reason reasonCode;

        BlockToMarkCorrupt(BlockInfoContiguous corrupted, BlockInfoContiguous stored, String reason, CorruptReplicasMap.Reason reasonCode) {
            Preconditions.checkNotNull(corrupted, "corrupted is null");
            Preconditions.checkNotNull(stored, "stored is null");
            this.corrupted = corrupted;
            this.stored = stored;
            this.reason = reason;
            this.reasonCode = reasonCode;
        }

        BlockToMarkCorrupt(BlockInfoContiguous stored, String reason, CorruptReplicasMap.Reason reasonCode) {
            this(stored, stored, reason, reasonCode);
        }

        BlockToMarkCorrupt(BlockInfoContiguous stored, long gs, String reason, CorruptReplicasMap.Reason reasonCode) {
            this(new BlockInfoContiguous(stored), stored, reason, reasonCode);
            this.corrupted.setGenerationStamp(gs);
        }

        public String toString() {
            return this.corrupted + "(" + (this.corrupted == this.stored ? "same as stored" : "stored=" + this.stored) + ")";
        }
    }

    static class StatefulBlockInfo {
        final BlockInfoContiguousUnderConstruction storedBlock;
        final Block reportedBlock;
        final HdfsServerConstants.ReplicaState reportedState;

        StatefulBlockInfo(BlockInfoContiguousUnderConstruction storedBlock, Block reportedBlock, HdfsServerConstants.ReplicaState reportedState) {
            this.storedBlock = storedBlock;
            this.reportedBlock = reportedBlock;
            this.reportedState = reportedState;
        }
    }
}

