/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FsDatasetCache {
    private static final Logger LOG = LoggerFactory.getLogger(FsDatasetCache.class);
    private final HashMap<ExtendedBlockId, Value> mappableBlockMap = new HashMap();
    private final AtomicLong numBlocksCached = new AtomicLong(0L);
    private final FsDatasetImpl dataset;
    private final ThreadPoolExecutor uncachingExecutor;
    private final ScheduledThreadPoolExecutor deferredUncachingExecutor;
    private final long revocationMs;
    private final long revocationPollingMs;
    private final UsedBytesCount usedBytesCount;
    private final long maxBytes;
    final AtomicLong numBlocksFailedToCache = new AtomicLong(0L);
    final AtomicLong numBlocksFailedToUncache = new AtomicLong(0L);

    public FsDatasetCache(FsDatasetImpl dataset) {
        this.dataset = dataset;
        this.maxBytes = dataset.datanode.getDnConf().getMaxLockedMemory();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FsDatasetCache-%d-" + dataset.toString()).build();
        this.usedBytesCount = new UsedBytesCount();
        this.uncachingExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), workerFactory);
        this.uncachingExecutor.allowCoreThreadTimeOut(true);
        this.deferredUncachingExecutor = new ScheduledThreadPoolExecutor(1, workerFactory);
        this.revocationMs = dataset.datanode.getConf().getLong("dfs.datanode.cache.revocation.timeout.ms", 900000L);
        long confRevocationPollingMs = dataset.datanode.getConf().getLong("dfs.datanode.cache.revocation.polling.ms", 500L);
        long minRevocationPollingMs = this.revocationMs / 2L;
        if (minRevocationPollingMs < confRevocationPollingMs) {
            throw new RuntimeException("configured value " + confRevocationPollingMs + "for " + "dfs.datanode.cache.revocation.polling.ms" + " is too high.  It must not be more than half of the " + "value of " + "dfs.datanode.cache.revocation.timeout.ms" + ".  Reconfigure this to " + minRevocationPollingMs);
        }
        this.revocationPollingMs = confRevocationPollingMs;
    }

    synchronized List<Long> getCachedBlocks(String bpid) {
        ArrayList<Long> blocks = new ArrayList<Long>();
        for (Map.Entry<ExtendedBlockId, Value> entry : this.mappableBlockMap.entrySet()) {
            if (!entry.getKey().getBlockPoolId().equals(bpid) || !entry.getValue().state.shouldAdvertise()) continue;
            blocks.add(entry.getKey().getBlockId());
        }
        return blocks;
    }

    synchronized void cacheBlock(long blockId, String bpid, String blockFileName, long length, long genstamp, Executor volumeExecutor) {
        ExtendedBlockId key = new ExtendedBlockId(blockId, bpid);
        Value prevValue = this.mappableBlockMap.get(key);
        if (prevValue != null) {
            LOG.debug("Block with id {}, pool {} already exists in the FsDatasetCache with state {}", new Object[]{blockId, bpid, prevValue.state});
            this.numBlocksFailedToCache.incrementAndGet();
            return;
        }
        this.mappableBlockMap.put(key, new Value(null, State.CACHING));
        volumeExecutor.execute(new CachingTask(key, blockFileName, length, genstamp));
        LOG.debug("Initiating caching for Block with id {}, pool {}", (Object)blockId, (Object)bpid);
    }

    synchronized void uncacheBlock(String bpid, long blockId) {
        ExtendedBlockId key = new ExtendedBlockId(blockId, bpid);
        Value prevValue = this.mappableBlockMap.get(key);
        boolean deferred = false;
        if (!this.dataset.datanode.getShortCircuitRegistry().processBlockMunlockRequest(key)) {
            deferred = true;
        }
        if (prevValue == null) {
            LOG.debug("Block with id {}, pool {} does not need to be uncached, because it is not currently in the mappableBlockMap.", (Object)blockId, (Object)bpid);
            this.numBlocksFailedToUncache.incrementAndGet();
            return;
        }
        switch (prevValue.state) {
            case CACHING: {
                LOG.debug("Cancelling caching for block with id {}, pool {}.", (Object)blockId, (Object)bpid);
                this.mappableBlockMap.put(key, new Value(prevValue.mappableBlock, State.CACHING_CANCELLED));
                break;
            }
            case CACHED: {
                this.mappableBlockMap.put(key, new Value(prevValue.mappableBlock, State.UNCACHING));
                if (deferred) {
                    LOG.debug("{} is anchored, and can't be uncached now.  Scheduling it for uncaching in {} ", (Object)key, (Object)DurationFormatUtils.formatDurationHMS(this.revocationPollingMs));
                    this.deferredUncachingExecutor.schedule(new UncachingTask(key, this.revocationMs), this.revocationPollingMs, TimeUnit.MILLISECONDS);
                    break;
                }
                LOG.debug("{} has been scheduled for immediate uncaching.", (Object)key);
                this.uncachingExecutor.execute(new UncachingTask(key, 0L));
                break;
            }
            default: {
                LOG.debug("Block with id {}, pool {} does not need to be uncached, because it is in state {}.", new Object[]{blockId, bpid, prevValue.state});
                this.numBlocksFailedToUncache.incrementAndGet();
            }
        }
    }

    public long getCacheUsed() {
        return this.usedBytesCount.get();
    }

    public long getCacheCapacity() {
        return this.maxBytes;
    }

    public long getNumBlocksFailedToCache() {
        return this.numBlocksFailedToCache.get();
    }

    public long getNumBlocksFailedToUncache() {
        return this.numBlocksFailedToUncache.get();
    }

    public long getNumBlocksCached() {
        return this.numBlocksCached.get();
    }

    public synchronized boolean isCached(String bpid, long blockId) {
        ExtendedBlockId block = new ExtendedBlockId(blockId, bpid);
        Value val = this.mappableBlockMap.get(block);
        return val != null && val.state.shouldAdvertise();
    }

    private class UncachingTask
    implements Runnable {
        private final ExtendedBlockId key;
        private final long revocationTimeMs;

        UncachingTask(ExtendedBlockId key, long revocationDelayMs) {
            this.key = key;
            this.revocationTimeMs = revocationDelayMs == 0L ? 0L : revocationDelayMs + Time.monotonicNow();
        }

        private boolean shouldDefer() {
            boolean anchored;
            if (this.revocationTimeMs == 0L) {
                return false;
            }
            boolean bl = anchored = !((FsDatasetCache)FsDatasetCache.this).dataset.datanode.getShortCircuitRegistry().processBlockMunlockRequest(this.key);
            if (!anchored) {
                LOG.debug("Uncaching {} now that it is no longer in use by any clients.", (Object)this.key);
                return false;
            }
            long delta = this.revocationTimeMs - Time.monotonicNow();
            if (delta < 0L) {
                LOG.warn("Forcibly uncaching {} after {} because client(s) {} refused to stop using it.", new Object[]{this.key, DurationFormatUtils.formatDurationHMS(this.revocationTimeMs), ((FsDatasetCache)FsDatasetCache.this).dataset.datanode.getShortCircuitRegistry().getClientNames(this.key)});
                return false;
            }
            LOG.info("Replica {} still can't be uncached because some clients continue to use it.  Will wait for {}", (Object)this.key, (Object)DurationFormatUtils.formatDurationHMS(delta));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Value value;
            if (this.shouldDefer()) {
                FsDatasetCache.this.deferredUncachingExecutor.schedule(this, FsDatasetCache.this.revocationPollingMs, TimeUnit.MILLISECONDS);
                return;
            }
            FsDatasetCache fsDatasetCache = FsDatasetCache.this;
            synchronized (fsDatasetCache) {
                value = (Value)FsDatasetCache.this.mappableBlockMap.get(this.key);
            }
            Preconditions.checkNotNull(value);
            Preconditions.checkArgument(value.state == State.UNCACHING);
            IOUtils.closeQuietly((Closeable)value.mappableBlock);
            fsDatasetCache = FsDatasetCache.this;
            synchronized (fsDatasetCache) {
                FsDatasetCache.this.mappableBlockMap.remove(this.key);
            }
            long newUsedBytes = FsDatasetCache.this.usedBytesCount.release(value.mappableBlock.getLength());
            FsDatasetCache.this.numBlocksCached.addAndGet(-1L);
            ((FsDatasetCache)FsDatasetCache.this).dataset.datanode.getMetrics().incrBlocksUncached(1);
            if (this.revocationTimeMs != 0L) {
                LOG.debug("Uncaching of {} completed. usedBytes = {}", (Object)this.key, (Object)newUsedBytes);
            } else {
                LOG.debug("Deferred uncaching of {} completed. usedBytes = {}", (Object)this.key, (Object)newUsedBytes);
            }
        }
    }

    private class CachingTask
    implements Runnable {
        private final ExtendedBlockId key;
        private final String blockFileName;
        private final long length;
        private final long genstamp;

        CachingTask(ExtendedBlockId key, String blockFileName, long length, long genstamp) {
            this.key = key;
            this.blockFileName = blockFileName;
            this.length = length;
            this.genstamp = genstamp;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class UsedBytesCount {
        private final AtomicLong usedBytes = new AtomicLong(0L);
        private final PageRounder rounder = new PageRounder();

        private UsedBytesCount() {
        }

        long reserve(long count) {
            long next;
            long cur;
            count = this.rounder.round(count);
            do {
                if ((next = (cur = this.usedBytes.get()) + count) <= FsDatasetCache.this.maxBytes) continue;
                return -1L;
            } while (!this.usedBytes.compareAndSet(cur, next));
            return next;
        }

        long release(long count) {
            count = this.rounder.round(count);
            return this.usedBytes.addAndGet(-count);
        }

        long get() {
            return this.usedBytes.get();
        }
    }

    public static class PageRounder {
        private final long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();

        public long round(long count) {
            long newCount = (count + (this.osPageSize - 1L)) / this.osPageSize;
            return newCount * this.osPageSize;
        }
    }

    private static enum State {
        CACHING,
        CACHING_CANCELLED,
        CACHED,
        UNCACHING;


        public boolean shouldAdvertise() {
            return this == CACHED;
        }
    }

    private static final class Value {
        final State state;
        final MappableBlock mappableBlock;

        Value(MappableBlock mappableBlock, State state) {
            this.mappableBlock = mappableBlock;
            this.state = state;
        }
    }
}

