/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MappableBlock
implements Closeable {
    private MappedByteBuffer mmap;
    private final long length;

    MappableBlock(MappedByteBuffer mmap, long length) {
        this.mmap = mmap;
        this.length = length;
        assert (length > 0L);
    }

    public long getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappableBlock load(long length, FileInputStream blockIn, FileInputStream metaIn, String blockFileName) throws IOException {
        MappableBlock mappableBlock = null;
        MappedByteBuffer mmap = null;
        FileChannel blockChannel = null;
        try {
            blockChannel = blockIn.getChannel();
            if (blockChannel == null) {
                throw new IOException("Block InputStream has no FileChannel.");
            }
            mmap = blockChannel.map(FileChannel.MapMode.READ_ONLY, 0L, length);
            NativeIO.POSIX.getCacheManipulator().mlock(blockFileName, mmap, length);
            MappableBlock.verifyChecksum(length, metaIn, blockChannel, blockFileName);
            mappableBlock = new MappableBlock(mmap, length);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)blockChannel);
            if (mappableBlock == null && mmap != null) {
                NativeIO.POSIX.munmap(mmap);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)blockChannel);
        if (mappableBlock == null && mmap != null) {
            NativeIO.POSIX.munmap(mmap);
        }
        return mappableBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyChecksum(long length, FileInputStream metaIn, FileChannel blockChannel, String blockFileName) throws IOException, ChecksumException {
        BlockMetadataHeader header = BlockMetadataHeader.readHeader(new DataInputStream(new BufferedInputStream(metaIn, BlockMetadataHeader.getHeaderSize())));
        FileChannel metaChannel = null;
        try {
            metaChannel = metaIn.getChannel();
            if (metaChannel == null) {
                throw new IOException("Block InputStream meta file has no FileChannel.");
            }
            DataChecksum checksum = header.getChecksum();
            int bytesPerChecksum = checksum.getBytesPerChecksum();
            int checksumSize = checksum.getChecksumSize();
            int numChunks = 0x800000 / bytesPerChecksum;
            ByteBuffer blockBuf = ByteBuffer.allocate(numChunks * bytesPerChecksum);
            ByteBuffer checksumBuf = ByteBuffer.allocate(numChunks * checksumSize);
            int bytesVerified = 0;
            while ((long)bytesVerified < length) {
                Preconditions.checkState(bytesVerified % bytesPerChecksum == 0, "Unexpected partial chunk before EOF");
                assert (bytesVerified % bytesPerChecksum == 0);
                int bytesRead = MappableBlock.fillBuffer(blockChannel, blockBuf);
                if (bytesRead == -1) {
                    throw new IOException("checksum verification failed: premature EOF");
                }
                blockBuf.flip();
                int chunks = (bytesRead + bytesPerChecksum - 1) / bytesPerChecksum;
                checksumBuf.limit(chunks * checksumSize);
                MappableBlock.fillBuffer(metaChannel, checksumBuf);
                checksumBuf.flip();
                checksum.verifyChunkedSums(blockBuf, checksumBuf, blockFileName, bytesVerified);
                bytesVerified += bytesRead;
                blockBuf.clear();
                checksumBuf.clear();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)metaChannel);
        }
    }

    private static int fillBuffer(FileChannel channel, ByteBuffer buf) throws IOException {
        int bytesRead = channel.read(buf);
        if (bytesRead < 0) {
            return bytesRead;
        }
        while (buf.remaining() > 0) {
            int n = channel.read(buf);
            if (n < 0) {
                return bytesRead;
            }
            bytesRead += n;
        }
        return bytesRead;
    }

    @Override
    public void close() {
        if (this.mmap != null) {
            NativeIO.POSIX.munmap(this.mmap);
            this.mmap = null;
        }
    }
}

