/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.util.Time;

class FSDirConcatOp {
    FSDirConcatOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus concat(FSDirectory fsd, String target, String[] srcs, boolean logRetryCache) throws IOException {
        Preconditions.checkArgument(!target.isEmpty(), "Target file name is empty");
        Preconditions.checkArgument(srcs != null && srcs.length > 0, "No sources given");
        assert (srcs != null);
        if (FSDirectory.LOG.isDebugEnabled()) {
            FSDirectory.LOG.debug("concat {} to {}", (Object)Arrays.toString(srcs), (Object)target);
        }
        INodesInPath targetIIP = fsd.getINodesInPath4Write(target);
        FSPermissionChecker pc = null;
        if (fsd.isPermissionEnabled()) {
            pc = fsd.getPermissionChecker();
            fsd.checkPathAccess(pc, targetIIP, FsAction.WRITE);
        }
        FSDirConcatOp.verifyTargetFile(fsd, target, targetIIP);
        INodeFile[] srcFiles = FSDirConcatOp.verifySrcFiles(fsd, srcs, targetIIP, pc);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target);
        }
        long timestamp = Time.now();
        fsd.writeLock();
        try {
            FSDirConcatOp.unprotectedConcat(fsd, targetIIP, srcFiles, timestamp);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logConcat(target, srcs, timestamp, logRetryCache);
        return fsd.getAuditFileInfo(targetIIP);
    }

    private static void verifyTargetFile(FSDirectory fsd, String target, INodesInPath targetIIP) throws IOException {
        if (fsd.getEZForPath(targetIIP) != null) {
            throw new HadoopIllegalArgumentException("concat can not be called for files in an encryption zone.");
        }
        INodeFile targetINode = INodeFile.valueOf(targetIIP.getLastINode(), target);
        if (targetINode.isUnderConstruction()) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is under construction");
        }
    }

    private static INodeFile[] verifySrcFiles(FSDirectory fsd, String[] srcs, INodesInPath targetIIP, FSPermissionChecker pc) throws IOException {
        HashSet<INodeFile> si = new HashSet<INodeFile>();
        INodeFile targetINode = targetIIP.getLastINode().asFile();
        INodeDirectory targetParent = targetINode.getParent();
        for (String src : srcs) {
            INode srcINode;
            INodeFile srcINodeFile;
            INodesInPath iip = fsd.getINodesInPath4Write(src);
            if (pc != null) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
                fsd.checkParentAccess(pc, iip, FsAction.WRITE);
            }
            if ((srcINodeFile = INodeFile.valueOf(srcINode = iip.getLastINode(), src)).getParent() != targetParent) {
                throw new HadoopIllegalArgumentException("Source file " + src + " is not in the same directory with the target " + targetIIP.getPath());
            }
            if (srcINode.isInLatestSnapshot(iip.getLatestSnapshotId())) {
                throw new SnapshotException("Concat: the source file " + src + " is in snapshot");
            }
            if (srcINode.isReference() && ((INodeReference.WithCount)srcINode.asReference().getReferredINode()).getReferenceCount() > 1) {
                throw new SnapshotException("Concat: the source file " + src + " is referred by some other reference in some snapshot.");
            }
            if (srcINode == targetINode) {
                throw new HadoopIllegalArgumentException("concat: the src file " + src + " is the same with the target file " + targetIIP.getPath());
            }
            if (srcINodeFile.isUnderConstruction() || srcINodeFile.numBlocks() == 0) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " is invalid or empty or underConstruction");
            }
            if (srcINodeFile.getPreferredBlockSize() > targetINode.getPreferredBlockSize()) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " has preferred block size " + srcINodeFile.getPreferredBlockSize() + " which is greater than the target file's preferred block size " + targetINode.getPreferredBlockSize());
            }
            si.add(srcINodeFile);
        }
        if (si.size() < srcs.length) {
            throw new HadoopIllegalArgumentException("concat: at least two of the source files are the same");
        }
        return si.toArray(new INodeFile[si.size()]);
    }

    private static QuotaCounts computeQuotaDeltas(FSDirectory fsd, INodeFile target, INodeFile[] srcList) {
        QuotaCounts deltas = new QuotaCounts.Builder().build();
        short targetRepl = target.getBlockReplication();
        for (INodeFile src : srcList) {
            short srcRepl = src.getBlockReplication();
            long fileSize = src.computeFileSize();
            if (targetRepl == srcRepl) continue;
            deltas.addStorageSpace(fileSize * (long)(targetRepl - srcRepl));
            BlockStoragePolicy bsp = fsd.getBlockStoragePolicySuite().getPolicy(src.getStoragePolicyID());
            if (bsp == null) continue;
            List<StorageType> srcTypeChosen = bsp.chooseStorageTypes(srcRepl);
            for (StorageType t : srcTypeChosen) {
                if (!t.supportTypeQuota()) continue;
                deltas.addTypeSpace(t, -fileSize);
            }
            List<StorageType> targetTypeChosen = bsp.chooseStorageTypes(targetRepl);
            for (StorageType t : targetTypeChosen) {
                if (!t.supportTypeQuota()) continue;
                deltas.addTypeSpace(t, fileSize);
            }
        }
        return deltas;
    }

    private static void verifyQuota(FSDirectory fsd, INodesInPath targetIIP, QuotaCounts deltas) throws QuotaExceededException {
        if (!fsd.getFSNamesystem().isImageLoaded() || fsd.shouldSkipQuotaChecks()) {
            return;
        }
        FSDirectory.verifyQuota(targetIIP, targetIIP.length() - 1, deltas, null);
    }

    static void unprotectedConcat(FSDirectory fsd, INodesInPath targetIIP, INodeFile[] srcList, long timestamp) throws IOException {
        assert (fsd.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSNamesystem.concat to " + targetIIP.getPath());
        }
        INodeFile trgInode = targetIIP.getLastINode().asFile();
        QuotaCounts deltas = FSDirConcatOp.computeQuotaDeltas(fsd, trgInode, srcList);
        FSDirConcatOp.verifyQuota(fsd, targetIIP, deltas);
        trgInode.recordModification(targetIIP.getLatestSnapshotId());
        INodeDirectory trgParent = targetIIP.getINode(-2).asDirectory();
        trgInode.concatBlocks(srcList);
        int count = 0;
        for (INodeFile nodeToRemove : srcList) {
            if (nodeToRemove == null) continue;
            nodeToRemove.setBlocks(null);
            nodeToRemove.getParent().removeChild(nodeToRemove);
            fsd.getINodeMap().remove(nodeToRemove);
            ++count;
        }
        trgInode.setModificationTime(timestamp, targetIIP.getLatestSnapshotId());
        trgParent.updateModificationTime(timestamp, targetIIP.getLatestSnapshotId());
        FSDirectory.unprotectedUpdateCount(targetIIP, targetIIP.length() - 1, deltas);
    }
}

