/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockRecoveryCommand
extends DatanodeCommand {
    final Collection<RecoveringBlock> recoveringBlocks;

    public BlockRecoveryCommand() {
        this(0);
    }

    public BlockRecoveryCommand(int capacity) {
        this(new ArrayList<RecoveringBlock>(capacity));
    }

    public BlockRecoveryCommand(Collection<RecoveringBlock> blocks) {
        super(6);
        this.recoveringBlocks = blocks;
    }

    public Collection<RecoveringBlock> getRecoveringBlocks() {
        return this.recoveringBlocks;
    }

    public void add(RecoveringBlock block) {
        this.recoveringBlocks.add(block);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockRecoveryCommand(\n  ");
        Joiner.on("\n  ").appendTo(sb, (Iterable<?>)this.recoveringBlocks);
        sb.append("\n)");
        return sb.toString();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class RecoveringBlock
    extends LocatedBlock {
        private final long newGenerationStamp;
        private final Block recoveryBlock;

        public RecoveringBlock(ExtendedBlock b, DatanodeInfo[] locs, long newGS) {
            super(b, locs, -1L, false);
            this.newGenerationStamp = newGS;
            this.recoveryBlock = null;
        }

        public RecoveringBlock(ExtendedBlock b, DatanodeInfo[] locs, Block recoveryBlock) {
            super(b, locs, -1L, false);
            this.newGenerationStamp = recoveryBlock.getGenerationStamp();
            this.recoveryBlock = recoveryBlock;
        }

        public long getNewGenerationStamp() {
            return this.newGenerationStamp;
        }

        public Block getNewBlock() {
            return this.recoveryBlock;
        }
    }
}

