/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamespaceInfo
extends StorageInfo {
    final String buildVersion;
    String blockPoolID = "";
    String softwareVersion;
    long capabilities;
    private static long CAPABILITIES_SUPPORTED = 0L;

    public NamespaceInfo() {
        super(HdfsServerConstants.NodeType.NAME_NODE);
        this.buildVersion = null;
        this.capabilities = CAPABILITIES_SUPPORTED;
    }

    public NamespaceInfo(int nsID, String clusterID, String bpID, long cT, String buildVersion, String softwareVersion) {
        this(nsID, clusterID, bpID, cT, buildVersion, softwareVersion, CAPABILITIES_SUPPORTED);
    }

    public NamespaceInfo(int nsID, String clusterID, String bpID, long cT, String buildVersion, String softwareVersion, long capabilities) {
        super(HdfsConstants.NAMENODE_LAYOUT_VERSION, nsID, clusterID, cT, HdfsServerConstants.NodeType.NAME_NODE);
        this.blockPoolID = bpID;
        this.buildVersion = buildVersion;
        this.softwareVersion = softwareVersion;
        this.capabilities = capabilities;
    }

    public NamespaceInfo(int nsID, String clusterID, String bpID, long cT) {
        this(nsID, clusterID, bpID, cT, Storage.getBuildVersion(), VersionInfo.getVersion());
    }

    public long getCapabilities() {
        return this.capabilities;
    }

    @VisibleForTesting
    public void setCapabilities(long capabilities) {
        this.capabilities = capabilities;
    }

    public boolean isCapabilitySupported(Capability capability) {
        Preconditions.checkArgument(capability != Capability.UNKNOWN, "cannot test for unknown capability");
        long mask = capability.getMask();
        return (this.capabilities & mask) == mask;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getBlockPoolID() {
        return this.blockPoolID;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public String toString() {
        return super.toString() + ";bpid=" + this.blockPoolID;
    }

    public void validateStorage(NNStorage storage) throws IOException {
        if (this.layoutVersion != storage.getLayoutVersion() || this.namespaceID != storage.getNamespaceID() || this.cTime != storage.cTime || !this.clusterID.equals(storage.getClusterID()) || !this.blockPoolID.equals(storage.getBlockPoolID())) {
            throw new IOException("Inconsistent namespace information:\nNamespaceInfo has:\nLV=" + this.layoutVersion + ";" + "NS=" + this.namespaceID + ";" + "cTime=" + this.cTime + ";" + "CID=" + this.clusterID + ";" + "BPID=" + this.blockPoolID + ".\nStorage has:\n" + "LV=" + storage.getLayoutVersion() + ";" + "NS=" + storage.getNamespaceID() + ";" + "cTime=" + storage.getCTime() + ";" + "CID=" + storage.getClusterID() + ";" + "BPID=" + storage.getBlockPoolID() + ".");
        }
    }

    public static enum Capability {
        UNKNOWN(false),
        STORAGE_BLOCK_REPORT_BUFFERS(true);

        private final long mask;

        private Capability(boolean isSupported) {
            int bits = this.ordinal() - 1;
            long l = this.mask = bits < 0 ? 0L : 1L << bits;
            if (isSupported) {
                CAPABILITIES_SUPPORTED = CAPABILITIES_SUPPORTED | this.mask;
            }
        }

        public long getMask() {
            return this.mask;
        }
    }
}

