/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;

public class TaskHeartbeatHandler
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(TaskHeartbeatHandler.class);
    private Thread lostTaskCheckerThread;
    private volatile boolean stopped;
    private int taskTimeOut = 300000;
    private int taskTimeOutCheckInterval = 30000;
    private final EventHandler eventHandler;
    private final Clock clock;
    private ConcurrentMap<TaskAttemptId, ReportTime> runningAttempts;

    public TaskHeartbeatHandler(EventHandler eventHandler, Clock clock, int numThreads) {
        super("TaskHeartbeatHandler");
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.runningAttempts = new ConcurrentHashMap<TaskAttemptId, ReportTime>(16, 0.75f, numThreads);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.taskTimeOut = conf.getInt("mapreduce.task.timeout", 300000);
        this.taskTimeOutCheckInterval = conf.getInt("mapreduce.task.timeout.check-interval-ms", 30000);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.lostTaskCheckerThread = new Thread(new PingChecker());
        this.lostTaskCheckerThread.setName("TaskHeartbeatHandler PingChecker");
        this.lostTaskCheckerThread.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.lostTaskCheckerThread != null) {
            this.lostTaskCheckerThread.interrupt();
        }
        super.serviceStop();
    }

    public void progressing(TaskAttemptId attemptID) {
        ReportTime time = (ReportTime)this.runningAttempts.get(attemptID);
        if (time != null) {
            time.setLastProgress(this.clock.getTime());
        }
    }

    public void register(TaskAttemptId attemptID) {
        this.runningAttempts.put(attemptID, new ReportTime(this.clock.getTime()));
    }

    public void unregister(TaskAttemptId attemptID) {
        this.runningAttempts.remove(attemptID);
    }

    private class PingChecker
    implements Runnable {
        private PingChecker() {
        }

        @Override
        public void run() {
            while (!TaskHeartbeatHandler.this.stopped && !Thread.currentThread().isInterrupted()) {
                Iterator iterator = TaskHeartbeatHandler.this.runningAttempts.entrySet().iterator();
                long currentTime = TaskHeartbeatHandler.this.clock.getTime();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    boolean taskTimedOut = TaskHeartbeatHandler.this.taskTimeOut > 0 && currentTime > ((ReportTime)entry.getValue()).getLastProgress() + (long)TaskHeartbeatHandler.this.taskTimeOut;
                    if (!taskTimedOut) continue;
                    iterator.remove();
                    TaskHeartbeatHandler.this.eventHandler.handle(new TaskAttemptDiagnosticsUpdateEvent((TaskAttemptId)entry.getKey(), "AttemptID:" + ((TaskAttemptId)entry.getKey()).toString() + " Timed out after " + TaskHeartbeatHandler.this.taskTimeOut / 1000 + " secs"));
                    TaskHeartbeatHandler.this.eventHandler.handle(new TaskAttemptEvent((TaskAttemptId)entry.getKey(), TaskAttemptEventType.TA_TIMED_OUT));
                }
                try {
                    Thread.sleep(TaskHeartbeatHandler.this.taskTimeOutCheckInterval);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"TaskHeartbeatHandler thread interrupted");
                    break;
                }
            }
        }
    }

    private static class ReportTime {
        private long lastProgress;

        public ReportTime(long time) {
            this.setLastProgress(time);
        }

        public synchronized void setLastProgress(long time) {
            this.lastProgress = time;
        }

        public synchronized long getLastProgress() {
            return this.lastProgress;
        }
    }
}

