/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.Avataar;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobMapTaskRescheduledEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;

public abstract class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Log LOG = LogFactory.getLog(TaskImpl.class);
    private static final String SPECULATION = "Speculation: ";
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected final TaskAttemptListener taskAttemptListener;
    protected final EventHandler eventHandler;
    private final TaskId taskId;
    private Map<TaskAttemptId, TaskAttempt> attempts;
    private final int maxAttempts;
    protected final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final MRAppMetrics metrics;
    protected final AppContext appContext;
    private long scheduledTime;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected boolean encryptedShuffle;
    protected Credentials credentials;
    protected Token<JobTokenIdentifier> jobToken;
    private TaskAttemptId commitAttempt;
    private TaskAttemptId successfulAttempt;
    private final Set<TaskAttemptId> failedAttempts;
    private final Set<TaskAttemptId> finishedAttempts;
    private final Set<TaskAttemptId> inProgressAttempts;
    private boolean historyTaskStartGenerated = false;
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition();
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition();
    private static final StateMachineFactory<TaskImpl, TaskStateInternal, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory<TaskImpl, TaskStateInternal, TaskEventType, TaskEvent>(TaskStateInternal.NEW).addTransition(TaskStateInternal.NEW, TaskStateInternal.SCHEDULED, TaskEventType.T_SCHEDULE, new InitialScheduleTransition()).addTransition(TaskStateInternal.NEW, TaskStateInternal.KILLED, TaskEventType.T_KILL, (SingleArcTransition<TaskImpl, TaskEvent>)new KillNewTransition()).addTransition(TaskStateInternal.NEW, EnumSet.of(TaskStateInternal.FAILED, TaskStateInternal.KILLED, TaskStateInternal.RUNNING, TaskStateInternal.SUCCEEDED), TaskEventType.T_RECOVER, new RecoverTransition()).addTransition(TaskStateInternal.SCHEDULED, TaskStateInternal.RUNNING, TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition<TaskImpl, TaskEvent>)new LaunchTransition()).addTransition(TaskStateInternal.SCHEDULED, TaskStateInternal.KILL_WAIT, TaskEventType.T_KILL, KILL_TRANSITION).addTransition(TaskStateInternal.SCHEDULED, TaskStateInternal.SCHEDULED, TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition(TaskStateInternal.SCHEDULED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.FAILED), TaskEventType.T_ATTEMPT_FAILED, new AttemptFailedTransition()).addTransition(TaskStateInternal.RUNNING, TaskStateInternal.RUNNING, TaskEventType.T_ATTEMPT_LAUNCHED).addTransition(TaskStateInternal.RUNNING, TaskStateInternal.RUNNING, TaskEventType.T_ATTEMPT_COMMIT_PENDING, (SingleArcTransition<TaskImpl, TaskEvent>)new AttemptCommitPendingTransition()).addTransition(TaskStateInternal.RUNNING, TaskStateInternal.RUNNING, TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition<TaskImpl, TaskEvent>)new RedundantScheduleTransition()).addTransition(TaskStateInternal.RUNNING, TaskStateInternal.SUCCEEDED, TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition<TaskImpl, TaskEvent>)new AttemptSucceededTransition()).addTransition(TaskStateInternal.RUNNING, TaskStateInternal.RUNNING, TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition(TaskStateInternal.RUNNING, EnumSet.of(TaskStateInternal.RUNNING, TaskStateInternal.FAILED), TaskEventType.T_ATTEMPT_FAILED, new AttemptFailedTransition()).addTransition(TaskStateInternal.RUNNING, TaskStateInternal.KILL_WAIT, TaskEventType.T_KILL, KILL_TRANSITION).addTransition(TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), TaskEventType.T_ATTEMPT_KILLED, new KillWaitAttemptKilledTransition()).addTransition(TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), TaskEventType.T_ATTEMPT_SUCCEEDED, new KillWaitAttemptSucceededTransition()).addTransition(TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), TaskEventType.T_ATTEMPT_FAILED, new KillWaitAttemptFailedTransition()).addTransition(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILL_WAIT, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition(TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED, TaskStateInternal.FAILED), TaskEventType.T_ATTEMPT_FAILED, new RetroactiveFailureTransition()).addTransition(TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED), TaskEventType.T_ATTEMPT_KILLED, new RetroactiveKilledTransition()).addTransition(TaskStateInternal.SUCCEEDED, TaskStateInternal.SUCCEEDED, TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition<TaskImpl, TaskEvent>)new AttemptSucceededAtSucceededTransition()).addTransition(TaskStateInternal.SUCCEEDED, TaskStateInternal.SUCCEEDED, EnumSet.of(TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_KILL)).addTransition(TaskStateInternal.FAILED, TaskStateInternal.FAILED, EnumSet.of(TaskEventType.T_KILL, new TaskEventType[]{TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_KILLED, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_SUCCEEDED})).addTransition(TaskStateInternal.KILLED, TaskStateInternal.KILLED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ATTEMPT_KILLED, TaskEventType.T_ADD_SPEC_ATTEMPT)).installTopology();
    private final StateMachine<TaskStateInternal, TaskEventType, TaskEvent> stateMachine;
    protected int nextAttemptNumber = 0;
    private static final Comparator<JobHistoryParser.TaskAttemptInfo> TA_INFO_COMPARATOR = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo a, JobHistoryParser.TaskAttemptInfo b) {
            long diff = a.getFinishTime() - b.getFinishTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
    };

    @Override
    public TaskState getState() {
        this.readLock.lock();
        try {
            TaskState taskState = TaskImpl.getExternalState(this.getInternalState());
            return taskState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskImpl(JobId jobId, TaskType taskType, int partition, EventHandler eventHandler, Path remoteJobConfFile, JobConf conf, TaskAttemptListener taskAttemptListener, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, int appAttemptId, MRAppMetrics metrics, AppContext appContext) {
        this.conf = conf;
        this.clock = clock;
        this.jobFile = remoteJobConfFile;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.finishedAttempts = new HashSet<TaskAttemptId>(2);
        this.failedAttempts = new HashSet<TaskAttemptId>(2);
        this.inProgressAttempts = new HashSet<TaskAttemptId>(2);
        this.maxAttempts = this.getMaxAttempts();
        this.taskId = MRBuilderUtils.newTaskId(jobId, partition, taskType);
        this.partition = partition;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.metrics = metrics;
        this.appContext = appContext;
        this.encryptedShuffle = conf.getBoolean("mapreduce.shuffle.ssl.enabled", false);
        this.stateMachine = stateMachineFactory.make(this);
        this.nextAttemptNumber = (appAttemptId - 1) * 1000;
    }

    @Override
    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map<TaskAttemptId, TaskAttempt> map = this.attempts;
                return map;
            }
            LinkedHashMap<TaskAttemptId, TaskAttempt> result = new LinkedHashMap<TaskAttemptId, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TaskAttemptId, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskId getID() {
        return this.taskId;
    }

    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskStateInternal.SUCCEEDED || this.getInternalState() == TaskStateInternal.FAILED || this.getInternalState() == TaskStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskReport getReport() {
        TaskReport report = this.recordFactory.newRecordInstance(TaskReport.class);
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(bestAttempt == null ? 0.0f : bestAttempt.getProgress());
            report.setStatus(bestAttempt == null ? "" : bestAttempt.getReport().getStateString());
            for (TaskAttempt attempt : this.attempts.values()) {
                if (!TaskAttemptState.RUNNING.equals((Object)attempt.getState())) continue;
                report.addRunningAttempt(attempt.getID());
            }
            report.setSuccessfulAttempt(this.successfulAttempt);
            for (TaskAttempt att : this.attempts.values()) {
                String prefix = "AttemptID:" + att.getID() + " Info:";
                for (CharSequence charSequence : att.getDiagnostics()) {
                    report.addDiagnostics(prefix + charSequence);
                }
            }
            report.setCounters(TypeConverter.toYarn(bestAttempt == null ? TaskAttemptImpl.EMPTY_COUNTERS : bestAttempt.getCounters()));
            TaskReport taskReport = report;
            return taskReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getCounters() {
        Counters counters = null;
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            counters = bestAttempt != null ? bestAttempt.getCounters() : TaskAttemptImpl.EMPTY_COUNTERS;
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt == null) {
                float f = 0.0f;
                return f;
            }
            float f = bestAttempt.getProgress();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public TaskStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskStateInternal taskStateInternal = this.stateMachine.getCurrentState();
            return taskStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskState getExternalState(TaskStateInternal smState) {
        if (smState == TaskStateInternal.KILL_WAIT) {
            return TaskState.KILLED;
        }
        return TaskState.valueOf(smState.name());
    }

    private long getLaunchTime() {
        long taskLaunchTime = 0L;
        boolean launchTimeSet = false;
        for (TaskAttempt at : this.attempts.values()) {
            long attemptLaunchTime = at.getLaunchTime();
            if (attemptLaunchTime != 0L && !launchTimeSet) {
                launchTimeSet = true;
                taskLaunchTime = attemptLaunchTime;
                continue;
            }
            if (attemptLaunchTime == 0L || taskLaunchTime <= attemptLaunchTime) continue;
            taskLaunchTime = attemptLaunchTime;
        }
        if (!launchTimeSet) {
            return this.scheduledTime;
        }
        return taskLaunchTime;
    }

    private long getFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private long getFinishTime(TaskAttemptId taId) {
        if (taId == null) {
            return this.clock.getTime();
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (!at.getID().equals(taId)) continue;
            return at.getFinishTime();
        }
        return finishTime;
    }

    private TaskStateInternal finished(TaskStateInternal finalState) {
        if (this.getInternalState() == TaskStateInternal.RUNNING) {
            this.metrics.endRunningTask(this);
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        if (this.successfulAttempt != null) {
            return this.attempts.get(this.successfulAttempt);
        }
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            float attemptProgress;
            switch (at.getState()) {
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!((attemptProgress = at.getProgress()) > progress)) continue;
            result = at;
            progress = attemptProgress;
        }
        return result;
    }

    @Override
    public boolean canCommit(TaskAttemptId taskAttemptID) {
        this.readLock.lock();
        boolean canCommit = false;
        try {
            if (this.commitAttempt != null) {
                canCommit = taskAttemptID.equals(this.commitAttempt);
                LOG.info((Object)("Result of canCommit for " + taskAttemptID + ":" + canCommit));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return canCommit;
    }

    protected abstract TaskAttemptImpl createAttempt();

    protected abstract int getMaxAttempts();

    protected TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt(Avataar avataar) {
        TaskAttemptImpl attempt = this.addAttempt(avataar);
        this.inProgressAttempts.add(attempt.getID());
        if (this.failedAttempts.size() > 0) {
            this.eventHandler.handle(new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_RESCHEDULE));
        } else {
            this.eventHandler.handle(new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_SCHEDULE));
        }
    }

    private TaskAttemptImpl addAttempt(Avataar avataar) {
        TaskAttemptImpl attempt = this.createAttempt();
        attempt.setAvataar(avataar);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created attempt " + attempt.getID()));
        }
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap<TaskAttemptId, TaskAttempt> newAttempts = new LinkedHashMap<TaskAttemptId, TaskAttempt>(this.maxAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                this.attempts.put(attempt.getID(), attempt);
                break;
            }
            default: {
                this.attempts.put(attempt.getID(), attempt);
            }
        }
        ++this.nextAttemptNumber;
        return attempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(TaskEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskID() + " of type " + event.getType()));
        }
        try {
            this.writeLock.lock();
            TaskStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition((TaskEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.taskId), (Throwable)e);
                this.internalError((TaskEventType)((Object)event.getType()));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.taskId + " Task Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void internalError(TaskEventType type) {
        LOG.error((Object)("Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle(new JobDiagnosticsUpdateEvent(this.taskId.getJobId(), "Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle(new JobEvent(this.taskId.getJobId(), JobEventType.INTERNAL_ERROR));
    }

    private void handleTaskAttemptCompletion(TaskAttemptId attemptId, TaskAttemptCompletionEventStatus status) {
        TaskAttempt attempt = this.attempts.get(attemptId);
        if (attempt.getNodeHttpAddress() != null) {
            TaskAttemptCompletionEvent tce = this.recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
            tce.setEventId(-1);
            String scheme = this.encryptedShuffle ? "https://" : "http://";
            tce.setMapOutputServerAddress(StringInterner.weakIntern(scheme + attempt.getNodeHttpAddress().split(":")[0] + ":" + attempt.getShufflePort()));
            tce.setStatus(status);
            tce.setAttemptId(attempt.getID());
            int runTime = 0;
            if (attempt.getFinishTime() != 0L && attempt.getLaunchTime() != 0L) {
                runTime = (int)(attempt.getFinishTime() - attempt.getLaunchTime());
            }
            tce.setAttemptRunTime(runTime);
            this.eventHandler.handle(new JobTaskAttemptCompletedEvent(tce));
        }
    }

    private void sendTaskStartedEvent() {
        TaskStartedEvent tse = new TaskStartedEvent(TypeConverter.fromYarn(this.taskId), this.getLaunchTime(), TypeConverter.fromYarn(this.taskId.getTaskType()), this.getSplitsAsString());
        this.eventHandler.handle(new JobHistoryEvent(this.taskId.getJobId(), tse));
        this.historyTaskStartGenerated = true;
    }

    private static TaskFinishedEvent createTaskFinishedEvent(TaskImpl task, TaskStateInternal taskState) {
        TaskFinishedEvent tfe = new TaskFinishedEvent(TypeConverter.fromYarn(task.taskId), TypeConverter.fromYarn(task.successfulAttempt), task.getFinishTime(task.successfulAttempt), TypeConverter.fromYarn(task.taskId.getTaskType()), taskState.toString(), task.getCounters());
        return tfe;
    }

    private static TaskFailedEvent createTaskFailedEvent(TaskImpl task, List<String> diag, TaskStateInternal taskState, TaskAttemptId taId) {
        StringBuilder errorSb = new StringBuilder();
        if (diag != null) {
            for (String d : diag) {
                errorSb.append(", ").append(d);
            }
        }
        TaskFailedEvent taskFailedEvent = new TaskFailedEvent(TypeConverter.fromYarn(task.taskId), task.getFinishTime(taId), TypeConverter.fromYarn(task.getType()), errorSb.toString(), taskState.toString(), taId == null ? null : TypeConverter.fromYarn(taId), task.getCounters());
        return taskFailedEvent;
    }

    private static void unSucceed(TaskImpl task) {
        task.commitAttempt = null;
        task.successfulAttempt = null;
    }

    private void sendTaskSucceededEvents() {
        this.eventHandler.handle(new JobTaskEvent(this.taskId, TaskState.SUCCEEDED));
        LOG.info((Object)("Task succeeded with attempt " + this.successfulAttempt));
        if (this.historyTaskStartGenerated) {
            TaskFinishedEvent tfe = TaskImpl.createTaskFinishedEvent(this, TaskStateInternal.SUCCEEDED);
            this.eventHandler.handle(new JobHistoryEvent(this.taskId.getJobId(), tfe));
        }
    }

    protected String getSplitsAsString() {
        return "";
    }

    private TaskStateInternal recover(JobHistoryParser.TaskInfo taskInfo, OutputCommitter committer, boolean recoverTaskOutput) {
        LOG.info((Object)("Recovering task " + this.taskId + " from prior app attempt, status was " + taskInfo.getTaskStatus()));
        this.scheduledTime = taskInfo.getStartTime();
        this.sendTaskStartedEvent();
        Collection<JobHistoryParser.TaskAttemptInfo> attemptInfos = taskInfo.getAllTaskAttempts().values();
        if (attemptInfos.size() > 0) {
            this.metrics.launchedTask(this);
        }
        int savedNextAttemptNumber = this.nextAttemptNumber;
        ArrayList<JobHistoryParser.TaskAttemptInfo> taInfos = new ArrayList<JobHistoryParser.TaskAttemptInfo>(taskInfo.getAllTaskAttempts().values());
        Collections.sort(taInfos, TA_INFO_COMPARATOR);
        for (JobHistoryParser.TaskAttemptInfo taInfo : taInfos) {
            this.nextAttemptNumber = taInfo.getAttemptId().getId();
            TaskAttemptImpl attempt = this.addAttempt(Avataar.VIRGIN);
            attempt.handle(new TaskAttemptRecoverEvent(attempt.getID(), taInfo, committer, recoverTaskOutput));
            this.finishedAttempts.add(attempt.getID());
            TaskAttemptCompletionEventStatus taces = null;
            TaskAttemptState attemptState = attempt.getState();
            switch (attemptState) {
                case FAILED: {
                    taces = TaskAttemptCompletionEventStatus.FAILED;
                    break;
                }
                case KILLED: {
                    taces = TaskAttemptCompletionEventStatus.KILLED;
                    break;
                }
                case SUCCEEDED: {
                    taces = TaskAttemptCompletionEventStatus.SUCCEEDED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected attempt state during recovery: " + (Object)((Object)attemptState));
                }
            }
            if (attemptState == TaskAttemptState.FAILED) {
                this.failedAttempts.add(attempt.getID());
                if (this.failedAttempts.size() >= this.maxAttempts) {
                    taces = TaskAttemptCompletionEventStatus.TIPFAILED;
                }
            }
            if (this.successfulAttempt != null) continue;
            this.handleTaskAttemptCompletion(attempt.getID(), taces);
            if (attemptState != TaskAttemptState.SUCCEEDED) continue;
            this.successfulAttempt = attempt.getID();
        }
        this.nextAttemptNumber = savedNextAttemptNumber;
        TaskStateInternal taskState = TaskStateInternal.valueOf(taskInfo.getTaskStatus());
        switch (taskState) {
            case SUCCEEDED: {
                if (this.successfulAttempt != null) {
                    this.sendTaskSucceededEvents();
                    break;
                }
                LOG.info((Object)("Missing successful attempt for task " + this.taskId + ", recovering as RUNNING"));
                taskState = TaskStateInternal.RUNNING;
                this.metrics.runningTask(this);
                this.addAndScheduleAttempt(Avataar.VIRGIN);
                break;
            }
            case FAILED: 
            case KILLED: {
                if (taskState == TaskStateInternal.KILLED && attemptInfos.size() == 0) {
                    this.metrics.endWaitingTask(this);
                }
                TaskFailedEvent tfe = new TaskFailedEvent(taskInfo.getTaskId(), taskInfo.getFinishTime(), taskInfo.getTaskType(), taskInfo.getError(), taskInfo.getTaskStatus(), taskInfo.getFailedDueToAttemptId(), taskInfo.getCounters());
                this.eventHandler.handle(new JobHistoryEvent(this.taskId.getJobId(), tfe));
                this.eventHandler.handle(new JobTaskEvent(this.taskId, TaskImpl.getExternalState(taskState)));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected recovered task state: " + (Object)((Object)taskState)));
            }
        }
        return taskState;
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg) {
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle(new TaskAttemptKillEvent(attempt.getID(), logMsg));
        }
    }

    static class LaunchTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        LaunchTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            task.metrics.launchedTask(task);
            task.metrics.runningTask(task);
        }
    }

    private static class KillTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            for (TaskAttempt attempt : task.attempts.values()) {
                task.killUnfinishedAttempt(attempt, "Task KILL is received. Killing attempt!");
            }
            task.inProgressAttempts.clear();
        }
    }

    private static class KillNewTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillNewTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            if (task.historyTaskStartGenerated) {
                TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, null, TaskStateInternal.KILLED, null);
                task.eventHandler.handle(new JobHistoryEvent(task.taskId.getJobId(), taskFailedEvent));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
            }
            task.eventHandler.handle(new JobTaskEvent(task.taskId, TaskImpl.getExternalState(TaskStateInternal.KILLED)));
            task.metrics.endWaitingTask(task);
        }
    }

    private static class AttemptSucceededAtSucceededTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptSucceededAtSucceededTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            task.finishedAttempts.add(castEvent.getTaskAttemptID());
            task.inProgressAttempts.remove(castEvent.getTaskAttemptID());
        }
    }

    private static class RetroactiveKilledTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private RetroactiveKilledTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskAttemptId attemptId = null;
            if (event instanceof TaskTAttemptEvent) {
                TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
                attemptId = castEvent.getTaskAttemptID();
                if (task.getInternalState() == TaskStateInternal.SUCCEEDED && !attemptId.equals(task.successfulAttempt)) {
                    task.finishedAttempts.add(castEvent.getTaskAttemptID());
                    task.inProgressAttempts.remove(castEvent.getTaskAttemptID());
                    return TaskStateInternal.SUCCEEDED;
                }
            }
            if (!TaskType.MAP.equals((Object)task.getType())) {
                LOG.error((Object)("Unexpected event for REDUCE task " + event.getType()));
                task.internalError((TaskEventType)((Object)event.getType()));
            }
            TaskImpl.unSucceed(task);
            task.handleTaskAttemptCompletion(attemptId, TaskAttemptCompletionEventStatus.KILLED);
            task.eventHandler.handle(new JobMapTaskRescheduledEvent(task.taskId));
            task.addAndScheduleAttempt(Avataar.VIRGIN);
            return TaskStateInternal.SCHEDULED;
        }
    }

    private static class RetroactiveFailureTransition
    extends AttemptFailedTransition {
        private RetroactiveFailureTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            if (task.getInternalState() == TaskStateInternal.SUCCEEDED && !castEvent.getTaskAttemptID().equals(task.successfulAttempt)) {
                task.finishedAttempts.add(castEvent.getTaskAttemptID());
                task.inProgressAttempts.remove(castEvent.getTaskAttemptID());
                return TaskStateInternal.SUCCEEDED;
            }
            if (!TaskType.MAP.equals((Object)task.getType())) {
                LOG.error((Object)("Unexpected event for REDUCE task " + event.getType()));
                task.internalError((TaskEventType)((Object)event.getType()));
            }
            task.eventHandler.handle(new JobMapTaskRescheduledEvent(task.taskId));
            TaskImpl.unSucceed(task);
            task.inProgressAttempts.add(castEvent.getTaskAttemptID());
            return super.transition(task, event);
        }

        @Override
        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return TaskStateInternal.SCHEDULED;
        }
    }

    private static class AttemptFailedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private AttemptFailedTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskAttempt attempt;
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            TaskAttemptId taskAttemptId = castEvent.getTaskAttemptID();
            task.failedAttempts.add(taskAttemptId);
            if (taskAttemptId.equals(task.commitAttempt)) {
                task.commitAttempt = null;
            }
            if ((attempt = (TaskAttempt)task.attempts.get(taskAttemptId)).getAssignedContainerMgrAddress() != null) {
                task.eventHandler.handle(new ContainerFailedEvent(attempt.getID(), attempt.getAssignedContainerMgrAddress()));
            }
            task.finishedAttempts.add(taskAttemptId);
            if (task.failedAttempts.size() < task.maxAttempts) {
                task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.FAILED);
                task.inProgressAttempts.remove(taskAttemptId);
                if (task.inProgressAttempts.size() == 0 && task.successfulAttempt == null) {
                    task.addAndScheduleAttempt(Avataar.VIRGIN);
                }
            } else {
                task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.TIPFAILED);
                for (TaskAttempt taskAttempt : task.attempts.values()) {
                    task.killUnfinishedAttempt(taskAttempt, "Task has failed. Killing attempt!");
                }
                task.inProgressAttempts.clear();
                if (task.historyTaskStartGenerated) {
                    TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, attempt.getDiagnostics(), TaskStateInternal.FAILED, taskAttemptId);
                    task.eventHandler.handle(new JobHistoryEvent(task.taskId.getJobId(), taskFailedEvent));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
                }
                task.eventHandler.handle(new JobTaskEvent(task.taskId, TaskState.FAILED));
                return task.finished(TaskStateInternal.FAILED);
            }
            return this.getDefaultState(task);
        }

        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return task.getInternalState();
        }
    }

    private static class KillWaitAttemptFailedTransition
    extends KillWaitAttemptKilledTransition {
        public KillWaitAttemptFailedTransition() {
            super(TaskAttemptCompletionEventStatus.FAILED);
        }
    }

    private static class KillWaitAttemptSucceededTransition
    extends KillWaitAttemptKilledTransition {
        public KillWaitAttemptSucceededTransition() {
            super(TaskAttemptCompletionEventStatus.SUCCEEDED);
        }
    }

    private static class KillWaitAttemptKilledTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        protected TaskStateInternal finalState = TaskStateInternal.KILLED;
        protected final TaskAttemptCompletionEventStatus taCompletionEventStatus;

        public KillWaitAttemptKilledTransition() {
            this(TaskAttemptCompletionEventStatus.KILLED);
        }

        public KillWaitAttemptKilledTransition(TaskAttemptCompletionEventStatus taCompletionEventStatus) {
            this.taCompletionEventStatus = taCompletionEventStatus;
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskAttemptId taskAttemptId = ((TaskTAttemptEvent)event).getTaskAttemptID();
            task.handleTaskAttemptCompletion(taskAttemptId, this.taCompletionEventStatus);
            task.finishedAttempts.add(taskAttemptId);
            if (task.finishedAttempts.size() == task.attempts.size()) {
                if (task.historyTaskStartGenerated) {
                    TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, null, this.finalState, null);
                    task.eventHandler.handle(new JobHistoryEvent(task.taskId.getJobId(), taskFailedEvent));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
                }
                task.eventHandler.handle(new JobTaskEvent(task.taskId, TaskImpl.getExternalState(this.finalState)));
                return this.finalState;
            }
            return task.getInternalState();
        }
    }

    private static class AttemptKilledTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptKilledTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            TaskAttemptId taskAttemptId = ((TaskTAttemptEvent)event).getTaskAttemptID();
            task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.KILLED);
            task.finishedAttempts.add(taskAttemptId);
            task.inProgressAttempts.remove(taskAttemptId);
            if (task.successfulAttempt == null) {
                task.addAndScheduleAttempt(Avataar.VIRGIN);
            }
            if (task.commitAttempt != null && task.commitAttempt == taskAttemptId) {
                task.commitAttempt = null;
            }
        }
    }

    private static class AttemptSucceededTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptSucceededTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent taskTAttemptEvent = (TaskTAttemptEvent)event;
            TaskAttemptId taskAttemptId = taskTAttemptEvent.getTaskAttemptID();
            task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.SUCCEEDED);
            task.finishedAttempts.add(taskAttemptId);
            task.inProgressAttempts.remove(taskAttemptId);
            task.successfulAttempt = taskAttemptId;
            task.sendTaskSucceededEvents();
            for (TaskAttempt attempt : task.attempts.values()) {
                if (attempt.getID() == task.successfulAttempt || attempt.isFinished()) continue;
                LOG.info((Object)("Issuing kill to other attempt " + attempt.getID()));
                task.eventHandler.handle(new TaskAttemptKillEvent(attempt.getID(), TaskImpl.SPECULATION + task.successfulAttempt + " succeeded first!"));
            }
            task.finished(TaskStateInternal.SUCCEEDED);
        }
    }

    private static class AttemptCommitPendingTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptCommitPendingTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent ev = (TaskTAttemptEvent)event;
            TaskAttemptId attemptID = ev.getTaskAttemptID();
            if (task.commitAttempt == null) {
                task.commitAttempt = attemptID;
                LOG.info((Object)(attemptID + " given a go for committing the task output."));
            } else {
                LOG.info((Object)(task.commitAttempt + " already given a go for committing the task output, so killing " + attemptID));
                task.eventHandler.handle(new TaskAttemptKillEvent(attemptID, TaskImpl.SPECULATION + task.commitAttempt + " committed first!"));
            }
        }
    }

    private static class RedundantScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private RedundantScheduleTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            LOG.info((Object)("Scheduling a redundant attempt for task " + task.taskId));
            task.addAndScheduleAttempt(Avataar.SPECULATIVE);
        }
    }

    private static class InitialScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private InitialScheduleTransition() {
        }

        @Override
        public void transition(TaskImpl task, TaskEvent event) {
            task.addAndScheduleAttempt(Avataar.VIRGIN);
            task.scheduledTime = task.clock.getTime();
            task.sendTaskStartedEvent();
        }
    }

    private static class RecoverTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private RecoverTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskRecoverEvent tre = (TaskRecoverEvent)event;
            return task.recover(tre.getTaskInfo(), tre.getOutputCommitter(), tre.getRecoverTaskOutput());
        }
    }
}

