/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsHBaseServerWrapperImpl
implements MetricsHBaseServerWrapper {
    private RpcServer server;

    MetricsHBaseServerWrapperImpl(RpcServer server) {
        this.server = server;
    }

    private boolean isServerStarted() {
        return this.server != null && this.server.isStarted();
    }

    @Override
    public long getTotalQueueSize() {
        if (!this.isServerStarted()) {
            return 0L;
        }
        return this.server.callQueueSizeInBytes.sum();
    }

    @Override
    public int getGeneralQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getGeneralQueueLength();
    }

    @Override
    public int getReplicationQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReplicationQueueLength();
    }

    @Override
    public int getPriorityQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getPriorityQueueLength();
    }

    @Override
    public int getNumOpenConnections() {
        if (!this.isServerStarted()) {
            return 0;
        }
        return this.server.getNumOpenConnections();
    }

    @Override
    public int getActiveRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveRpcHandlerCount();
    }

    @Override
    public long getNumGeneralCallsDropped() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0L;
        }
        return this.server.getScheduler().getNumGeneralCallsDropped();
    }

    @Override
    public long getNumLifoModeSwitches() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0L;
        }
        return this.server.getScheduler().getNumLifoModeSwitches();
    }

    @Override
    public int getWriteQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getWriteQueueLength();
    }

    @Override
    public int getReadQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReadQueueLength();
    }

    @Override
    public int getScanQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getScanQueueLength();
    }

    @Override
    public int getActiveWriteRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveWriteRpcHandlerCount();
    }

    @Override
    public int getActiveReadRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveReadRpcHandlerCount();
    }

    @Override
    public int getActiveScanRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveScanRpcHandlerCount();
    }
}

