/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterAnnotationReadingPriorityFunction
extends AnnotationReadingPriorityFunction {
    public MasterAnnotationReadingPriorityFunction(RSRpcServices rpcServices) {
        this(rpcServices, rpcServices.getClass());
    }

    public MasterAnnotationReadingPriorityFunction(RSRpcServices rpcServices, Class<? extends RSRpcServices> clz) {
        super(rpcServices, clz);
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        int priorityByAnnotation = this.getAnnotatedPriority(header);
        if (priorityByAnnotation >= 0) {
            return priorityByAnnotation;
        }
        if (param instanceof RegionServerStatusProtos.ReportRegionStateTransitionRequest) {
            RegionServerStatusProtos.ReportRegionStateTransitionRequest tRequest = (RegionServerStatusProtos.ReportRegionStateTransitionRequest)param;
            for (RegionServerStatusProtos.RegionStateTransition rst : tRequest.getTransitionList()) {
                if (rst.getRegionInfoList() == null) continue;
                for (HBaseProtos.RegionInfo info : rst.getRegionInfoList()) {
                    TableName tn = ProtobufUtil.toTableName(info.getTableName());
                    if (!tn.isSystemTable()) continue;
                    return 200;
                }
            }
            return 0;
        }
        return this.getBasePriority(header, param);
    }
}

