/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class GlobalQuotaSettingsImpl
extends GlobalQuotaSettings {
    private final QuotaProtos.Throttle throttleProto;
    private final Boolean bypassGlobals;
    private final QuotaProtos.SpaceQuota spaceProto;

    protected GlobalQuotaSettingsImpl(String username, TableName tableName, String namespace, QuotaProtos.Quotas quotas) {
        this(username, tableName, namespace, quotas != null && quotas.hasThrottle() ? quotas.getThrottle() : null, quotas != null && quotas.hasBypassGlobals() ? Boolean.valueOf(quotas.getBypassGlobals()) : null, quotas != null && quotas.hasSpace() ? quotas.getSpace() : null);
    }

    protected GlobalQuotaSettingsImpl(String userName, TableName tableName, String namespace, QuotaProtos.Throttle throttleProto, Boolean bypassGlobals, QuotaProtos.SpaceQuota spaceProto) {
        super(userName, tableName, namespace);
        this.throttleProto = throttleProto;
        this.bypassGlobals = bypassGlobals;
        this.spaceProto = spaceProto;
    }

    @Override
    public List<QuotaSettings> getQuotaSettings() {
        ArrayList<QuotaSettings> settings = new ArrayList<QuotaSettings>();
        if (this.throttleProto != null) {
            settings.addAll(QuotaSettingsFactory.fromThrottle(this.getUserName(), this.getTableName(), this.getNamespace(), this.throttleProto));
        }
        if (this.bypassGlobals != null && this.bypassGlobals.booleanValue()) {
            settings.add(new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(this.getUserName(), this.getTableName(), this.getNamespace(), true));
        }
        if (this.spaceProto != null) {
            settings.add(QuotaSettingsFactory.fromSpace(this.getTableName(), this.getNamespace(), this.spaceProto));
        }
        return settings;
    }

    protected QuotaProtos.Throttle getThrottleProto() {
        return this.throttleProto;
    }

    protected Boolean getBypassGlobals() {
        return this.bypassGlobals;
    }

    protected QuotaProtos.SpaceQuota getSpaceProto() {
        return this.spaceProto;
    }

    protected QuotaProtos.Quotas toQuotas() {
        QuotaProtos.Quotas.Builder builder = QuotaProtos.Quotas.newBuilder();
        if (this.getThrottleProto() != null) {
            builder.setThrottle(this.getThrottleProto());
        }
        if (this.getBypassGlobals() != null) {
            builder.setBypassGlobals(this.getBypassGlobals());
        }
        if (this.getSpaceProto() != null) {
            builder.setSpace(this.getSpaceProto());
        }
        return builder.build();
    }

    @Override
    protected GlobalQuotaSettingsImpl merge(QuotaSettings other) throws IOException {
        QuotaProtos.SpaceQuota.Builder spaceBuilder;
        QuotaProtos.Throttle.Builder throttleBuilder;
        this.validateQuotaTarget(other);
        QuotaProtos.Throttle.Builder builder = throttleBuilder = this.throttleProto == null ? null : this.throttleProto.toBuilder();
        if (other instanceof ThrottleSettings) {
            ThrottleSettings otherThrottle = (ThrottleSettings)other;
            if (!otherThrottle.proto.hasType() || !otherThrottle.proto.hasTimedQuota()) {
                throttleBuilder = null;
            } else {
                QuotaProtos.ThrottleRequest otherProto = otherThrottle.proto;
                this.validateTimedQuota(otherProto.getTimedQuota());
                if (throttleBuilder == null) {
                    throttleBuilder = QuotaProtos.Throttle.newBuilder();
                }
                switch (otherProto.getType()) {
                    case REQUEST_NUMBER: {
                        throttleBuilder.setReqNum(otherProto.getTimedQuota());
                        break;
                    }
                    case REQUEST_SIZE: {
                        throttleBuilder.setReqSize(otherProto.getTimedQuota());
                        break;
                    }
                    case WRITE_NUMBER: {
                        throttleBuilder.setWriteNum(otherProto.getTimedQuota());
                        break;
                    }
                    case WRITE_SIZE: {
                        throttleBuilder.setWriteSize(otherProto.getTimedQuota());
                        break;
                    }
                    case READ_NUMBER: {
                        throttleBuilder.setReadNum(otherProto.getTimedQuota());
                        break;
                    }
                    case READ_SIZE: {
                        throttleBuilder.setReadSize(otherProto.getTimedQuota());
                    }
                }
            }
        }
        QuotaProtos.SpaceQuota.Builder builder2 = spaceBuilder = this.spaceProto == null ? null : this.spaceProto.toBuilder();
        if (other instanceof SpaceLimitSettings) {
            SpaceLimitSettings settingsToMerge;
            QuotaProtos.SpaceLimitRequest spaceRequest;
            if (spaceBuilder == null) {
                spaceBuilder = QuotaProtos.SpaceQuota.newBuilder();
            }
            if ((spaceRequest = (settingsToMerge = (SpaceLimitSettings)other).getProto()).hasQuota()) {
                QuotaProtos.SpaceQuota quotaToMerge = spaceRequest.getQuota();
                if (!Objects.equals(this.getTableName(), settingsToMerge.getTableName()) && !Objects.equals(this.getNamespace(), settingsToMerge.getNamespace())) {
                    throw new IllegalArgumentException("Cannot merge " + settingsToMerge + " into " + this);
                }
                if (quotaToMerge.getRemove()) {
                    spaceBuilder.setRemove(true).clearSoftLimit().clearViolationPolicy();
                } else {
                    spaceBuilder.mergeFrom(quotaToMerge);
                }
            }
        }
        Boolean bypassGlobals = this.bypassGlobals;
        if (other instanceof QuotaSettingsFactory.QuotaGlobalsSettingsBypass) {
            bypassGlobals = ((QuotaSettingsFactory.QuotaGlobalsSettingsBypass)other).getBypass();
        }
        if (throttleBuilder == null && (spaceBuilder == null || spaceBuilder.hasRemove() && spaceBuilder.getRemove()) && bypassGlobals == null) {
            return null;
        }
        return new GlobalQuotaSettingsImpl(this.getUserName(), this.getTableName(), this.getNamespace(), throttleBuilder == null ? null : throttleBuilder.build(), bypassGlobals, spaceBuilder == null ? null : spaceBuilder.build());
    }

    private void validateTimedQuota(QuotaProtos.TimedQuota timedQuota) throws IOException {
        if (timedQuota.getSoftLimit() < 1L) {
            throw new DoNotRetryIOException(new UnsupportedOperationException("The throttle limit must be greater then 0, got " + timedQuota.getSoftLimit()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GlobalQuota: ");
        if (this.throttleProto != null) {
            Map<ThrottleType, QuotaProtos.TimedQuota> throttleQuotas = this.buildThrottleQuotas(this.throttleProto);
            builder.append(" { TYPE => THROTTLE ");
            for (Map.Entry<ThrottleType, QuotaProtos.TimedQuota> entry : throttleQuotas.entrySet()) {
                ThrottleType type = entry.getKey();
                QuotaProtos.TimedQuota timedQuota = entry.getValue();
                builder.append("{THROTTLE_TYPE => ").append(type.name()).append(", LIMIT => ");
                if (timedQuota.hasSoftLimit()) {
                    switch (type) {
                        case REQUEST_NUMBER: 
                        case WRITE_NUMBER: 
                        case READ_NUMBER: {
                            builder.append(String.format("%dreq", timedQuota.getSoftLimit()));
                            break;
                        }
                        case REQUEST_SIZE: 
                        case WRITE_SIZE: 
                        case READ_SIZE: {
                            builder.append(GlobalQuotaSettingsImpl.sizeToString(timedQuota.getSoftLimit()));
                        }
                    }
                } else if (timedQuota.hasShare()) {
                    builder.append(String.format("%.2f%%", Float.valueOf(timedQuota.getShare())));
                }
                builder.append('/');
                builder.append(GlobalQuotaSettingsImpl.timeToString(ProtobufUtil.toTimeUnit(timedQuota.getTimeUnit())));
                if (!timedQuota.hasScope()) continue;
                builder.append(", SCOPE => ");
                builder.append(timedQuota.getScope().toString());
            }
            builder.append("} } ");
        } else {
            builder.append(" {} ");
        }
        if (this.bypassGlobals != null) {
            builder.append(" { GLOBAL_BYPASS => " + this.bypassGlobals + " } ");
        }
        if (this.spaceProto != null) {
            builder.append(" { TYPE => SPACE");
            if (this.getTableName() != null) {
                builder.append(", TABLE => ").append(this.getTableName());
            }
            if (this.getNamespace() != null) {
                builder.append(", NAMESPACE => ").append(this.getNamespace());
            }
            if (this.spaceProto.getRemove()) {
                builder.append(", REMOVE => ").append(this.spaceProto.getRemove());
            } else {
                builder.append(", LIMIT => ").append(GlobalQuotaSettingsImpl.sizeToString(this.spaceProto.getSoftLimit()));
                builder.append(", VIOLATION_POLICY => ").append(this.spaceProto.getViolationPolicy());
            }
            builder.append(" } ");
        }
        return builder.toString();
    }

    private Map<ThrottleType, QuotaProtos.TimedQuota> buildThrottleQuotas(QuotaProtos.Throttle proto) {
        HashMap<ThrottleType, QuotaProtos.TimedQuota> quotas = new HashMap<ThrottleType, QuotaProtos.TimedQuota>();
        if (proto.hasReadNum()) {
            quotas.put(ThrottleType.READ_NUMBER, proto.getReadNum());
        }
        if (proto.hasReadSize()) {
            quotas.put(ThrottleType.READ_SIZE, proto.getReadSize());
        }
        if (proto.hasReqNum()) {
            quotas.put(ThrottleType.REQUEST_NUMBER, proto.getReqNum());
        }
        if (proto.hasReqSize()) {
            quotas.put(ThrottleType.REQUEST_SIZE, proto.getReqSize());
        }
        if (proto.hasWriteNum()) {
            quotas.put(ThrottleType.WRITE_NUMBER, proto.getWriteNum());
        }
        if (proto.hasWriteSize()) {
            quotas.put(ThrottleType.WRITE_SIZE, proto.getWriteSize());
        }
        return quotas;
    }

    private void clearThrottleBuilder(QuotaProtos.Throttle.Builder builder) {
        builder.clearReadNum();
        builder.clearReadSize();
        builder.clearReqNum();
        builder.clearReqSize();
        builder.clearWriteNum();
        builder.clearWriteSize();
    }
}

