/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.MasterFifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.regionserver.FifoRpcSchedulerFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterFifoRpcSchedulerFactory
extends FifoRpcSchedulerFactory {
    @Override
    public RpcScheduler create(Configuration conf, PriorityFunction priority, Abortable server) {
        int totalHandlerCount = conf.getInt("hbase.regionserver.handler.count", 30);
        int rsReportHandlerCount = Math.max(1, conf.getInt("hbase.master.server.report.handler.count", totalHandlerCount / 2));
        int callHandlerCount = Math.max(1, totalHandlerCount - rsReportHandlerCount);
        return new MasterFifoRpcScheduler(conf, callHandlerCount, rsReportHandlerCount);
    }
}

