/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MutableSegment
extends Segment {
    public static final long DEEP_OVERHEAD = Segment.DEEP_OVERHEAD + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.SYNC_TIMERANGE_TRACKER;

    protected MutableSegment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB, MemStoreSizing memstoreSizing) {
        super(cellSet, comparator, memStoreLAB, TimeRangeTracker.create(TimeRangeTracker.Type.SYNC));
        this.incMemStoreSize(0L, DEEP_OVERHEAD, 0L);
        if (memstoreSizing != null) {
            memstoreSizing.incMemStoreSize(0L, DEEP_OVERHEAD, 0L);
        }
    }

    public void add(Cell cell, boolean mslabUsed, MemStoreSizing memStoreSizing) {
        this.internalAdd(cell, mslabUsed, memStoreSizing);
    }

    public void upsert(Cell cell, long readpoint, MemStoreSizing memStoreSizing) {
        this.internalAdd(cell, false, memStoreSizing);
        Cell firstCell = PrivateCellUtil.createFirstOnRowColTS(cell, Long.MAX_VALUE);
        SortedSet<Cell> ss = this.tailSet(firstCell);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            Cell cur = (Cell)it.next();
            if (cell == cur) continue;
            if (!CellUtil.matchingRows(cell, cur) || !CellUtil.matchingQualifier(cell, cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getSequenceId() > readpoint) continue;
            if (versionsVisible >= 1) {
                int cellLen = MutableSegment.getCellLength(cur);
                long heapSize = this.heapSizeChange(cur, true);
                long offHeapSize = this.offHeapSizeChange(cur, true);
                this.incMemStoreSize(-cellLen, -heapSize, -offHeapSize);
                if (memStoreSizing != null) {
                    memStoreSizing.decMemStoreSize(cellLen, heapSize, offHeapSize);
                }
                it.remove();
                continue;
            }
            ++versionsVisible;
        }
    }

    @VisibleForTesting
    Cell first() {
        return this.getCellSet().first();
    }

    @Override
    protected long indexEntrySize() {
        return ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY;
    }
}

