/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.AtomicLongMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DumpReplicationQueues
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger((String)DumpReplicationQueues.class.getName());
    private List<String> deadRegionServers = new ArrayList<String>();
    private List<String> deletedQueues = new ArrayList<String>();
    private AtomicLongMap<String> peersQueueSize = AtomicLongMap.create();
    private long totalSizeOfWALs = 0L;
    private long numWalsNotFound = 0L;

    static DumpOptions parseOpts(Queue<String> args) {
        DumpOptions opts = new DumpOptions();
        String cmd = null;
        while ((cmd = args.poll()) != null) {
            if (cmd.equals("-h") || cmd.equals("--h") || cmd.equals("--help")) {
                args.add(cmd);
                break;
            }
            String hdfs = "--hdfs";
            if (cmd.equals("--hdfs")) {
                opts.setHdfs(true);
                continue;
            }
            String distributed = "--distributed";
            if (cmd.equals("--distributed")) {
                opts.setDistributed(true);
                continue;
            }
            DumpReplicationQueues.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
            if (opts.isDistributed() || !opts.isHdfs()) continue;
            DumpReplicationQueues.printUsageAndExit("ERROR: --hdfs option can only be used with --distributed: " + cmd, -1);
        }
        return opts;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new DumpReplicationQueues(), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        LinkedList<String> argv = new LinkedList<String>();
        argv.addAll(Arrays.asList(args));
        DumpOptions opts = DumpReplicationQueues.parseOpts(argv);
        if (!argv.isEmpty()) {
            errCode = 0;
            this.printUsage();
            return errCode;
        }
        return this.dumpReplicationQueues(opts);
    }

    protected void printUsage() {
        DumpReplicationQueues.printUsage(((Object)((Object)this)).getClass().getName(), null);
    }

    protected static void printUsage(String message) {
        DumpReplicationQueues.printUsage(DumpReplicationQueues.class.getName(), message);
    }

    protected static void printUsage(String className, String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: hbase " + className + " \\");
        System.err.println("  <OPTIONS> [-D<property=value>]*");
        System.err.println();
        System.err.println("General Options:");
        System.err.println(" -h|--h|--help  Show this help and exit.");
        System.err.println(" --distributed  Poll each RS and print its own replication queue. Default only polls ZooKeeper");
        System.err.println(" --hdfs         Use HDFS to calculate usage of WALs by replication. It could be overestimated if replicating to multiple peers. --distributed flag is also needed.");
    }

    protected static void printUsageAndExit(String message, int exitCode) {
        DumpReplicationQueues.printUsage(message);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpReplicationQueues(DumpOptions opts) throws Exception {
        Configuration conf = this.getConf();
        HBaseAdmin.available(conf);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection(conf);
        Admin admin = connection.getAdmin();
        try (ZKWatcher zkw = new ZKWatcher(conf, "DumpReplicationQueues" + System.currentTimeMillis(), new WarnOnlyAbortable(), true);){
            LOG.info("Our Quorum: " + zkw.getQuorum());
            List<TableCFs> replicatedTableCFs = admin.listReplicatedTableCFs();
            if (replicatedTableCFs.isEmpty()) {
                LOG.info("No tables with a configured replication peer were found.");
                int n = 0;
                return n;
            }
            LOG.info("Replicated Tables: " + replicatedTableCFs);
            List<ReplicationPeerDescription> peers = admin.listReplicationPeers();
            if (peers.isEmpty()) {
                LOG.info("Replication is enabled but no peer configuration was found.");
            }
            System.out.println("Dumping replication peers and configurations:");
            System.out.println(this.dumpPeersState(peers));
            if (opts.isDistributed()) {
                LOG.info("Found [--distributed], will poll each RegionServer.");
                Set<String> peerIds = peers.stream().map(peer -> peer.getPeerId()).collect(Collectors.toSet());
                System.out.println(this.dumpQueues(zkw, peerIds, opts.isHdfs()));
                System.out.println(this.dumpReplicationSummary());
            } else {
                System.out.print("Dumping replication znodes via ZooKeeper:");
                System.out.println(ZKUtil.getReplicationZnodesDump(zkw));
            }
            int n = 0;
            return n;
        }
    }

    public String dumpReplicationSummary() {
        StringBuilder sb = new StringBuilder();
        if (!this.deletedQueues.isEmpty()) {
            sb.append("Found " + this.deletedQueues.size() + " deleted queues, run hbck -fixReplication in order to remove the deleted replication queues\n");
            for (String string : this.deletedQueues) {
                sb.append("    " + string + "\n");
            }
        }
        if (!this.deadRegionServers.isEmpty()) {
            sb.append("Found " + this.deadRegionServers.size() + " dead regionservers, restart one regionserver to transfer the queues of dead regionservers\n");
            for (String string : this.deadRegionServers) {
                sb.append("    " + string + "\n");
            }
        }
        if (!this.peersQueueSize.isEmpty()) {
            sb.append("Dumping all peers's number of WALs in replication queue\n");
            for (Map.Entry entry : this.peersQueueSize.asMap().entrySet()) {
                sb.append("    PeerId: " + (String)entry.getKey() + " , sizeOfLogQueue: " + entry.getValue() + "\n");
            }
        }
        sb.append("    Total size of WALs on HDFS: " + StringUtils.humanSize(this.totalSizeOfWALs) + "\n");
        if (this.numWalsNotFound > 0L) {
            sb.append("    ERROR: There are " + this.numWalsNotFound + " WALs not found!!!\n");
        }
        return sb.toString();
    }

    public String dumpPeersState(List<ReplicationPeerDescription> peers) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (ReplicationPeerDescription peer : peers) {
            ReplicationPeerConfig peerConfig = peer.getPeerConfig();
            sb.append("Peer: " + peer.getPeerId() + "\n");
            sb.append("    State: " + (peer.isEnabled() ? "ENABLED" : "DISABLED") + "\n");
            sb.append("    Cluster Name: " + peerConfig.getClusterKey() + "\n");
            sb.append("    Replication Endpoint: " + peerConfig.getReplicationEndpointImpl() + "\n");
            Map<String, String> currentConf = peerConfig.getConfiguration();
            if (currentConf.size() > 1) {
                sb.append("    Peer Configuration: " + currentConf + "\n");
            }
            sb.append("    Peer Table CFs: " + peerConfig.getTableCFsMap() + "\n");
            sb.append("    Peer Namespaces: " + peerConfig.getNamespaces() + "\n");
        }
        return sb.toString();
    }

    public String dumpQueues(ZKWatcher zkw, Set<String> peerIds, boolean hdfs) throws Exception {
        StringBuilder sb = new StringBuilder();
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage(zkw, this.getConf());
        ReplicationTracker replicationTracker = ReplicationFactory.getReplicationTracker(zkw, new WarnOnlyAbortable(), new WarnOnlyStoppable());
        HashSet<String> liveRegionServers = new HashSet<String>(replicationTracker.getListOfRegionServers());
        List<ServerName> regionservers = queueStorage.getListOfReplicators();
        if (regionservers == null || regionservers.isEmpty()) {
            return sb.toString();
        }
        for (ServerName regionserver : regionservers) {
            List<String> queueIds = queueStorage.getAllQueues(regionserver);
            if (!liveRegionServers.contains(regionserver.getServerName())) {
                this.deadRegionServers.add(regionserver.getServerName());
            }
            for (String queueId : queueIds) {
                ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                List<String> wals = queueStorage.getWALsInQueue(regionserver, queueId);
                if (!peerIds.contains(queueInfo.getPeerId())) {
                    this.deletedQueues.add(regionserver + "/" + queueId);
                    sb.append(this.formatQueue(regionserver, queueStorage, queueInfo, queueId, wals, true, hdfs));
                    continue;
                }
                sb.append(this.formatQueue(regionserver, queueStorage, queueInfo, queueId, wals, false, hdfs));
            }
        }
        return sb.toString();
    }

    private String formatQueue(ServerName regionserver, ReplicationQueueStorage queueStorage, ReplicationQueueInfo queueInfo, String queueId, List<String> wals, boolean isDeleted, boolean hdfs) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Dumping replication queue info for RegionServer: [" + regionserver + "]\n");
        sb.append("    Queue znode: " + queueId + "\n");
        sb.append("    PeerID: " + queueInfo.getPeerId() + "\n");
        sb.append("    Recovered: " + queueInfo.isQueueRecovered() + "\n");
        List<ServerName> deadServers = queueInfo.getDeadRegionServers();
        if (deadServers.isEmpty()) {
            sb.append("    No dead RegionServers found in this queue.\n");
        } else {
            sb.append("    Dead RegionServers: " + deadServers + "\n");
        }
        sb.append("    Was deleted: " + isDeleted + "\n");
        sb.append("    Number of WALs in replication queue: " + wals.size() + "\n");
        this.peersQueueSize.addAndGet(queueInfo.getPeerId(), wals.size());
        for (String wal : wals) {
            long position = queueStorage.getWALPosition(regionserver, queueInfo.getPeerId(), wal);
            sb.append("    Replication position for " + wal + ": " + (position > 0L ? Long.valueOf(position) : "0 (not started or nothing to replicate)") + "\n");
        }
        if (hdfs) {
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            sb.append("    Total size of WALs on HDFS for this queue: " + StringUtils.humanSize(this.getTotalWALSize(fs, wals, regionserver)) + "\n");
        }
        return sb.toString();
    }

    private long getTotalWALSize(FileSystem fs, List<String> wals, ServerName server) throws IOException {
        long size = 0L;
        for (String wal : wals) {
            FileStatus fileStatus;
            try {
                fileStatus = new WALLink(this.getConf(), server.getServerName(), wal).getFileStatus(fs);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    ++this.numWalsNotFound;
                    LOG.warn("WAL " + wal + " couldn't be found, skipping", (Throwable)e);
                    continue;
                }
                LOG.warn("Can't get file status of WAL " + wal + ", skipping", (Throwable)e);
                continue;
            }
            size += fileStatus.getLen();
        }
        this.totalSizeOfWALs += size;
        return size;
    }

    private static class WarnOnlyStoppable
    implements Stoppable {
        private WarnOnlyStoppable() {
        }

        @Override
        public void stop(String why) {
            LOG.warn("DumpReplicationQueue received stop, ignoring.  Reason: " + why);
        }

        @Override
        public boolean isStopped() {
            return false;
        }
    }

    private static class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            LOG.warn("DumpReplicationQueue received abort, ignoring.  Reason: " + why);
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.toString(), e);
            }
        }

        @Override
        public boolean isAborted() {
            return false;
        }
    }

    static class DumpOptions {
        boolean hdfs = false;
        boolean distributed = false;

        public DumpOptions() {
        }

        public DumpOptions(DumpOptions that) {
            this.hdfs = that.hdfs;
            this.distributed = that.distributed;
        }

        boolean isHdfs() {
            return this.hdfs;
        }

        boolean isDistributed() {
            return this.distributed;
        }

        void setHdfs(boolean hdfs) {
            this.hdfs = hdfs;
        }

        void setDistributed(boolean distributed) {
            this.distributed = distributed;
        }
    }
}

