/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.wal.BoundedGroupingStrategy;
import org.apache.hadoop.hbase.wal.NamespaceGroupingStrategy;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionGroupingProvider
implements WALProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RegionGroupingProvider.class);
    public static final String REGION_GROUPING_STRATEGY = "hbase.wal.regiongrouping.strategy";
    public static final String DEFAULT_REGION_GROUPING_STRATEGY = Strategies.defaultStrategy.name();
    public static final String DELEGATE_PROVIDER = "hbase.wal.regiongrouping.delegate.provider";
    public static final String DEFAULT_DELEGATE_PROVIDER = WALFactory.Providers.defaultProvider.name();
    private static final String META_WAL_GROUP_NAME = "meta";
    private final ConcurrentMap<String, WALProvider> cached = new ConcurrentHashMap<String, WALProvider>();
    private final KeyLocker<String> createLock = new KeyLocker();
    private RegionGroupingStrategy strategy;
    private WALFactory factory;
    private List<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
    private String providerId;
    private Class<? extends WALProvider> providerClass;

    RegionGroupingStrategy getStrategy(Configuration conf, String key, String defaultValue) throws IOException {
        Class clazz;
        try {
            clazz = Strategies.valueOf((String)conf.get((String)key, (String)defaultValue)).clazz;
        }
        catch (IllegalArgumentException exception) {
            clazz = conf.getClass(key, IdentityGroupingStrategy.class, RegionGroupingStrategy.class);
        }
        LOG.info("Instantiating RegionGroupingStrategy of type " + clazz);
        try {
            RegionGroupingStrategy result = (RegionGroupingStrategy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.init(conf, this.providerId);
            return result;
        }
        catch (Exception e) {
            LOG.error("couldn't set up region grouping strategy, check config key hbase.wal.regiongrouping.strategy");
            LOG.debug("Exception details for failure to load region grouping strategy.", (Throwable)e);
            throw new IOException("couldn't set up region grouping strategy", e);
        }
    }

    @Override
    public void init(WALFactory factory, Configuration conf, String providerId) throws IOException {
        if (null != this.strategy) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        StringBuilder sb = new StringBuilder().append(factory.factoryId);
        if (providerId != null) {
            if (providerId.startsWith(".")) {
                sb.append(providerId);
            } else {
                sb.append(".").append(providerId);
            }
        }
        this.providerId = sb.toString();
        this.strategy = this.getStrategy(conf, REGION_GROUPING_STRATEGY, DEFAULT_REGION_GROUPING_STRATEGY);
        this.providerClass = factory.getProviderClass(DELEGATE_PROVIDER, DEFAULT_DELEGATE_PROVIDER);
    }

    private WALProvider createProvider(String group) throws IOException {
        if (".meta".equals(this.providerId)) {
            return this.factory.createProvider(this.providerClass, ".meta");
        }
        return this.factory.createProvider(this.providerClass, group);
    }

    @Override
    public List<WAL> getWALs() {
        return this.cached.values().stream().flatMap(p -> p.getWALs().stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WAL getWAL(String group) throws IOException {
        WALProvider provider = (WALProvider)this.cached.get(group);
        if (provider == null) {
            ReentrantLock lock = this.createLock.acquireLock(group);
            try {
                provider = (WALProvider)this.cached.get(group);
                if (provider == null) {
                    provider = this.createProvider(group);
                    this.listeners.forEach(provider::addWALActionsListener);
                    this.cached.put(group, provider);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return provider.getWAL(null);
    }

    @Override
    public WAL getWAL(RegionInfo region) throws IOException {
        String group;
        if (".meta".equals(this.providerId)) {
            group = META_WAL_GROUP_NAME;
        } else {
            byte[] namespace;
            byte[] id;
            if (region != null) {
                id = region.getEncodedNameAsBytes();
                namespace = region.getTable().getNamespace();
            } else {
                id = HConstants.EMPTY_BYTE_ARRAY;
                namespace = null;
            }
            group = this.strategy.group(id, namespace);
        }
        return this.getWAL(group);
    }

    @Override
    public void shutdown() throws IOException {
        IOException failure = null;
        for (WALProvider provider : this.cached.values()) {
            try {
                provider.shutdown();
            }
            catch (IOException e) {
                LOG.error("Problem shutting down wal provider '" + provider + "': " + e.getMessage());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Details of problem shutting down wal provider '" + provider + "'", (Throwable)e);
                }
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void close() throws IOException {
        IOException failure = null;
        for (WALProvider provider : this.cached.values()) {
            try {
                provider.close();
            }
            catch (IOException e) {
                LOG.error("Problem closing wal provider '" + provider + "': " + e.getMessage());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Details of problem closing wal provider '" + provider + "'", (Throwable)e);
                }
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public long getNumLogFiles() {
        long numLogFiles = 0L;
        for (WALProvider provider : this.cached.values()) {
            numLogFiles += provider.getNumLogFiles();
        }
        return numLogFiles;
    }

    @Override
    public long getLogFileSize() {
        long logFileSize = 0L;
        for (WALProvider provider : this.cached.values()) {
            logFileSize += provider.getLogFileSize();
        }
        return logFileSize;
    }

    @Override
    public void addWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    static class IdentityGroupingStrategy
    implements RegionGroupingStrategy {
        IdentityGroupingStrategy() {
        }

        @Override
        public void init(Configuration config, String providerId) {
        }

        @Override
        public String group(byte[] identifier, byte[] namespace) {
            return Bytes.toString(identifier);
        }
    }

    static enum Strategies {
        defaultStrategy(BoundedGroupingStrategy.class),
        identity(IdentityGroupingStrategy.class),
        bounded(BoundedGroupingStrategy.class),
        namespace(NamespaceGroupingStrategy.class);

        final Class<? extends RegionGroupingStrategy> clazz;

        private Strategies(Class<? extends RegionGroupingStrategy> clazz) {
            this.clazz = clazz;
        }
    }

    public static interface RegionGroupingStrategy {
        public static final String GROUP_NAME_DELIMITER = ".";

        public String group(byte[] var1, byte[] var2);

        public void init(Configuration var1, String var2);
    }
}

