/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.coordination.ZKSplitLogManagerCoordination;
import org.apache.hadoop.hbase.coordination.ZkSplitLogWorkerCoordination;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureMemberRpcs;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ZkCoordinatedStateManager
implements CoordinatedStateManager {
    protected ZKWatcher watcher;
    protected SplitLogWorkerCoordination splitLogWorkerCoordination;
    protected SplitLogManagerCoordination splitLogManagerCoordination;

    public ZkCoordinatedStateManager(Server server) {
        this.watcher = server.getZooKeeper();
        this.splitLogWorkerCoordination = new ZkSplitLogWorkerCoordination(server.getServerName(), this.watcher);
        this.splitLogManagerCoordination = new ZKSplitLogManagerCoordination(server.getConfiguration(), this.watcher);
    }

    @Override
    public SplitLogWorkerCoordination getSplitLogWorkerCoordination() {
        return this.splitLogWorkerCoordination;
    }

    @Override
    public SplitLogManagerCoordination getSplitLogManagerCoordination() {
        return this.splitLogManagerCoordination;
    }

    @Override
    public ProcedureCoordinatorRpcs getProcedureCoordinatorRpcs(String procType, String coordNode) throws IOException {
        return new ZKProcedureCoordinator(this.watcher, procType, coordNode);
    }

    @Override
    public ProcedureMemberRpcs getProcedureMemberRpcs(String procType) throws KeeperException {
        return new ZKProcedureMemberRpcs(this.watcher, procType);
    }
}

