/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.fusesource.leveldbjni.internal;

import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import org.apache.hadoop.hbase.shaded.org.fusesource.leveldbjni.internal.NativeIterator;
import org.apache.hadoop.hbase.shaded.org.iq80.leveldb.DBIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JniDBIterator
implements DBIterator {
    private final NativeIterator iterator;

    JniDBIterator(NativeIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public void close() {
        this.iterator.delete();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(byte[] key) {
        try {
            this.iterator.seek(key);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound()) {
                throw new NoSuchElementException();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToFirst() {
        this.iterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.iterator.seekToLast();
    }

    @Override
    public Map.Entry<byte[], byte[]> peekNext() {
        if (!this.iterator.isValid()) {
            throw new NoSuchElementException();
        }
        try {
            return new AbstractMap.SimpleImmutableEntry<byte[], byte[]>(this.iterator.key(), this.iterator.value());
        }
        catch (NativeDB.DBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.isValid();
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        Map.Entry<byte[], byte[]> rc = this.peekNext();
        try {
            this.iterator.next();
        }
        catch (NativeDB.DBException e) {
            throw new RuntimeException(e);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrev() {
        boolean bl;
        block9: {
            block8: {
                if (!this.iterator.isValid()) {
                    return false;
                }
                this.iterator.prev();
                try {
                    bl = this.iterator.isValid();
                    if (!this.iterator.isValid()) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.iterator.isValid()) {
                            this.iterator.next();
                        } else {
                            this.iterator.seekToFirst();
                        }
                        throw throwable;
                    }
                    catch (NativeDB.DBException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.iterator.next();
                break block9;
            }
            this.iterator.seekToFirst();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<byte[], byte[]> peekPrev() {
        Map.Entry<byte[], byte[]> entry;
        block8: {
            block7: {
                this.iterator.prev();
                try {
                    entry = this.peekNext();
                    if (!this.iterator.isValid()) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.iterator.isValid()) {
                            this.iterator.next();
                        } else {
                            this.iterator.seekToFirst();
                        }
                        throw throwable;
                    }
                    catch (NativeDB.DBException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.iterator.next();
                break block8;
            }
            this.iterator.seekToFirst();
        }
        return entry;
    }

    @Override
    public Map.Entry<byte[], byte[]> prev() {
        Map.Entry<byte[], byte[]> rc = this.peekPrev();
        try {
            this.iterator.prev();
        }
        catch (NativeDB.DBException e) {
            throw new RuntimeException(e);
        }
        return rc;
    }
}

