/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;
import org.apache.hadoop.hbase.zookeeper.ZKMetadata;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ZKAsyncRegistry
implements AsyncRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ZKAsyncRegistry.class);
    private final ReadOnlyZKClient zk;
    private final ZNodePaths znodePaths;

    ZKAsyncRegistry(Configuration conf) {
        this.znodePaths = new ZNodePaths(conf);
        this.zk = new ReadOnlyZKClient(conf);
    }

    private <T> CompletableFuture<T> getAndConvert(String path, Converter<T> converter) {
        CompletableFuture future = new CompletableFuture();
        FutureUtils.addListener(this.zk.get(path), (data, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            try {
                future.complete(converter.convert((byte[])data));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static String getClusterId(byte[] data) throws DeserializationException {
        if (data == null || data.length == 0) {
            return null;
        }
        data = ZKMetadata.removeMetaData(data);
        return ClusterId.parseFrom(data).toString();
    }

    @Override
    public CompletableFuture<String> getClusterId() {
        return this.getAndConvert(this.znodePaths.clusterIdZNode, ZKAsyncRegistry::getClusterId);
    }

    @VisibleForTesting
    ReadOnlyZKClient getZKClient() {
        return this.zk;
    }

    private static ZooKeeperProtos.MetaRegionServer getMetaProto(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        data = ZKMetadata.removeMetaData(data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        return ZooKeeperProtos.MetaRegionServer.parser().parseFrom(data, prefixLen, data.length - prefixLen);
    }

    private static void tryComplete(MutableInt remaining, HRegionLocation[] locs, CompletableFuture<RegionLocations> future) {
        remaining.decrement();
        if (remaining.intValue() > 0) {
            return;
        }
        future.complete(new RegionLocations(locs));
    }

    private Pair<RegionState.State, ServerName> getStateAndServerName(ZooKeeperProtos.MetaRegionServer proto) {
        RegionState.State state = proto.hasState() ? RegionState.State.convert(proto.getState()) : RegionState.State.OPEN;
        HBaseProtos.ServerName snProto = proto.getServer();
        return Pair.newPair(state, ServerName.valueOf(snProto.getHostName(), snProto.getPort(), snProto.getStartCode()));
    }

    private void getMetaRegionLocation(CompletableFuture<RegionLocations> future, List<String> metaReplicaZNodes) {
        if (metaReplicaZNodes.isEmpty()) {
            future.completeExceptionally(new IOException("No meta znode available"));
        }
        HRegionLocation[] locs = new HRegionLocation[metaReplicaZNodes.size()];
        MutableInt remaining = new MutableInt(locs.length);
        for (String metaReplicaZNode : metaReplicaZNodes) {
            int replicaId = this.znodePaths.getMetaReplicaIdFromZnode(metaReplicaZNode);
            String path = ZNodePaths.joinZNode(this.znodePaths.baseZNode, metaReplicaZNode);
            if (replicaId == 0) {
                FutureUtils.addListener(this.getAndConvert(path, ZKAsyncRegistry::getMetaProto), (proto, error) -> {
                    if (error != null) {
                        future.completeExceptionally((Throwable)error);
                        return;
                    }
                    if (proto == null) {
                        future.completeExceptionally(new IOException("Meta znode is null"));
                        return;
                    }
                    Pair<RegionState.State, ServerName> stateAndServerName = this.getStateAndServerName((ZooKeeperProtos.MetaRegionServer)proto);
                    if (stateAndServerName.getFirst() != RegionState.State.OPEN) {
                        LOG.warn("Meta region is in state " + (Object)((Object)stateAndServerName.getFirst()));
                    }
                    locs[0] = new HRegionLocation(RegionReplicaUtil.getRegionInfoForDefaultReplica(RegionInfoBuilder.FIRST_META_REGIONINFO), stateAndServerName.getSecond());
                    ZKAsyncRegistry.tryComplete(remaining, locs, future);
                });
                continue;
            }
            FutureUtils.addListener(this.getAndConvert(path, ZKAsyncRegistry::getMetaProto), (proto, error) -> {
                if (future.isDone()) {
                    return;
                }
                if (error != null) {
                    LOG.warn("Failed to fetch " + path, error);
                    locs[replicaId] = null;
                } else if (proto == null) {
                    LOG.warn("Meta znode for replica " + replicaId + " is null");
                    locs[replicaId] = null;
                } else {
                    Pair<RegionState.State, ServerName> stateAndServerName = this.getStateAndServerName((ZooKeeperProtos.MetaRegionServer)proto);
                    if (stateAndServerName.getFirst() != RegionState.State.OPEN) {
                        LOG.warn("Meta region for replica " + replicaId + " is in state " + (Object)((Object)stateAndServerName.getFirst()));
                        locs[replicaId] = null;
                    } else {
                        locs[replicaId] = new HRegionLocation(RegionReplicaUtil.getRegionInfoForReplica(RegionInfoBuilder.FIRST_META_REGIONINFO, replicaId), stateAndServerName.getSecond());
                    }
                }
                ZKAsyncRegistry.tryComplete(remaining, locs, future);
            });
        }
    }

    @Override
    public CompletableFuture<RegionLocations> getMetaRegionLocation() {
        CompletableFuture<RegionLocations> future = new CompletableFuture<RegionLocations>();
        FutureUtils.addListener(this.zk.list(this.znodePaths.baseZNode).thenApply(children -> children.stream().filter(c -> c.startsWith(this.znodePaths.metaZNodePrefix)).collect(Collectors.toList())), (metaReplicaZNodes, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            this.getMetaRegionLocation(future, (List<String>)metaReplicaZNodes);
        });
        return future;
    }

    @Override
    public CompletableFuture<Integer> getCurrentNrHRS() {
        return this.zk.exists(this.znodePaths.rsZNode).thenApply(s -> s != null ? s.getNumChildren() : 0);
    }

    private static ZooKeeperProtos.Master getMasterProto(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        data = ZKMetadata.removeMetaData(data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        return ZooKeeperProtos.Master.parser().parseFrom(data, prefixLen, data.length - prefixLen);
    }

    @Override
    public CompletableFuture<ServerName> getMasterAddress() {
        return this.getAndConvert(this.znodePaths.masterAddressZNode, ZKAsyncRegistry::getMasterProto).thenApply(proto -> {
            if (proto == null) {
                return null;
            }
            HBaseProtos.ServerName snProto = proto.getMaster();
            return ServerName.valueOf(snProto.getHostName(), snProto.getPort(), snProto.getStartCode());
        });
    }

    @Override
    public CompletableFuture<Integer> getMasterInfoPort() {
        return this.getAndConvert(this.znodePaths.masterAddressZNode, ZKAsyncRegistry::getMasterProto).thenApply(proto -> proto != null ? proto.getInfoPort() : 0);
    }

    @Override
    public void close() {
        this.zk.close();
    }

    private static interface Converter<T> {
        public T convert(byte[] var1) throws Exception;
    }
}

