/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InclusiveCombinedBlockCache
extends CombinedBlockCache {
    public InclusiveCombinedBlockCache(LruBlockCache l1, BlockCache l2) {
        super(l1, l2);
        l1.setVictimCache(l2);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        return this.onHeapCache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.onHeapCache.cacheBlock(cacheKey, buf, inMemory);
        this.l2Cache.cacheBlock(cacheKey, buf, inMemory);
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        boolean l1Result = this.onHeapCache.evictBlock(cacheKey);
        boolean l2Result = this.l2Cache.evictBlock(cacheKey);
        return l1Result || l2Result;
    }
}

