/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MetaFixer {
    private static final Logger LOG = LoggerFactory.getLogger(MetaFixer.class);
    private final MasterServices masterServices;

    MetaFixer(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    void fix() throws IOException {
        CatalogJanitor.Report report = this.masterServices.getCatalogJanitor().getLastReport();
        if (report == null) {
            LOG.info("CatalogJanitor has not generated a report yet; run 'catalogjanitor_run' in shell or wait until CatalogJanitor chore runs.");
            return;
        }
        this.fixHoles(report);
        this.fixOverlaps(report);
    }

    boolean fixHoles(CatalogJanitor.Report report) throws IOException {
        boolean result = false;
        List<Pair<RegionInfo, RegionInfo>> holes = report.getHoles();
        if (holes.isEmpty()) {
            LOG.debug("No holes.");
            return result;
        }
        for (Pair<RegionInfo, RegionInfo> p : holes) {
            RegionInfo ri = this.getHoleCover(p);
            if (ri == null) continue;
            Configuration configuration = this.masterServices.getConfiguration();
            HRegion.createRegionDir(configuration, ri, FSUtils.getRootDir(configuration));
            Put put = MetaTableAccessor.makePutFromRegionInfo(ri, Long.MAX_VALUE);
            MetaTableAccessor.putsToMetaTable(this.masterServices.getConnection(), Arrays.asList(put));
            LOG.info("Fixed hole by adding {}; region is NOT assigned (assign to online).", (Object)ri);
            result = true;
        }
        return result;
    }

    private RegionInfo getHoleCover(Pair<RegionInfo, RegionInfo> hole) {
        RegionInfo holeCover = null;
        RegionInfo left = hole.getFirst();
        RegionInfo right = hole.getSecond();
        if (left.getTable().equals(right.getTable())) {
            if (Bytes.compareTo(left.getEndKey(), right.getStartKey()) >= 0) {
                LOG.warn("Skipping hole fix; left-side endKey is not less than right-side startKey; left=<{}>, right=<{}>", (Object)left, (Object)right);
                return holeCover;
            }
            holeCover = this.buildRegionInfo(left.getTable(), left.getEndKey(), right.getStartKey());
        } else {
            boolean leftUndefined = left.equals(RegionInfo.UNDEFINED);
            boolean rightUnefined = right.equals(RegionInfo.UNDEFINED);
            boolean last = left.isLast();
            boolean first = right.isFirst();
            if (leftUndefined && rightUnefined) {
                LOG.warn("Skipping hole fix; both the hole left-side and right-side RegionInfos are UNDEFINED; left=<{}>, right=<{}>", (Object)left, (Object)right);
                return holeCover;
            }
            if (leftUndefined || last) {
                holeCover = this.buildRegionInfo(right.getTable(), HConstants.EMPTY_START_ROW, right.getStartKey());
            } else if (rightUnefined || first) {
                holeCover = this.buildRegionInfo(left.getTable(), left.getEndKey(), HConstants.EMPTY_END_ROW);
            } else {
                LOG.warn("Skipping hole fix; don't know what to do with left=<{}>, right=<{}>", (Object)left, (Object)right);
                return holeCover;
            }
        }
        return holeCover;
    }

    private RegionInfo buildRegionInfo(TableName tn, byte[] start, byte[] end) {
        return RegionInfoBuilder.newBuilder(tn).setStartKey(start).setEndKey(end).build();
    }

    boolean fixOverlaps(CatalogJanitor.Report report) throws IOException {
        boolean result = false;
        List<Pair<RegionInfo, RegionInfo>> overlaps = report.getOverlaps();
        if (overlaps.isEmpty()) {
            LOG.debug("No overlaps.");
            return result;
        }
        for (Pair<RegionInfo, RegionInfo> p : overlaps) {
            RegionInfo ri = this.getHoleCover(p);
            if (ri == null) continue;
            Configuration configuration = this.masterServices.getConfiguration();
            HRegion.createRegionDir(configuration, ri, FSUtils.getRootDir(configuration));
            Put put = MetaTableAccessor.makePutFromRegionInfo(ri, Long.MAX_VALUE);
            MetaTableAccessor.putsToMetaTable(this.masterServices.getConnection(), Arrays.asList(put));
            LOG.info("Fixed hole by adding {}; region is NOT assigned (assign to online).", (Object)ri);
            result = true;
        }
        return result;
    }
}

