/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.HbckChore;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.HttpJspBase;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.JspSourceDependent;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.PageContextImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.glassfish.jsp.api.ResourceInjector;

public final class hbck_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static List<String> _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public List<String> getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block34: {
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            JspWriter out = null;
            hbck_jsp page = this;
            JspWriter _jspx_out = null;
            PageContext _jspx_page_context = null;
            try {
                response.setContentType("text/html;charset=UTF-8");
                _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                application = pageContext.getServletContext();
                config = pageContext.getServletConfig();
                session = pageContext.getSession();
                _jspx_out = out = pageContext.getOut();
                this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                out.write("\n\n\n\n\n\n\n\n\n\n\n");
                HMaster master = (HMaster)this.getServletContext().getAttribute("master");
                pageContext.setAttribute("pageTitle", (Object)("HBase Master HBCK Report: " + master.getServerName()));
                HbckChore hbckChore = master.getHbckChore();
                Map<String, Pair<ServerName, List<ServerName>>> inconsistentRegions = null;
                Map<String, ServerName> orphanRegionsOnRS = null;
                Map<String, Path> orphanRegionsOnFS = null;
                long startTimestamp = 0L;
                long endTimestamp = 0L;
                if (hbckChore != null) {
                    inconsistentRegions = hbckChore.getInconsistentRegions();
                    orphanRegionsOnRS = hbckChore.getOrphanRegionsOnRS();
                    orphanRegionsOnFS = hbckChore.getOrphanRegionsOnFS();
                    startTimestamp = hbckChore.getCheckingStartTimestamp();
                    endTimestamp = hbckChore.getCheckingEndTimestamp();
                }
                ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTimestamp), ZoneId.systemDefault());
                String iso8601start = startTimestamp == 0L ? "-1" : zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTimestamp), ZoneId.systemDefault());
                String iso8601end = startTimestamp == 0L ? "-1" : zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                CatalogJanitor cj = master.getCatalogJanitor();
                CatalogJanitor.Report report = cj == null ? null : cj.getLastReport();
                out.write(10);
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)("header.jsp?" + JspRuntimeLibrary.URLEncode((String)"pageTitle", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)((String)PageContextImpl.evaluateExpression((String)"${pageTitle}", String.class, (PageContext)_jspx_page_context, null)), (String)request.getCharacterEncoding())), (JspWriter)out, (boolean)false);
                out.write("\n\n<div class=\"container-fluid content\">\n\n  ");
                if (!master.isInitialized()) {
                    out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h1>Master is not initialized</h1>\n    </div>\n  </div>\n  ");
                    JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                    out.write("\n  ");
                } else {
                    out.write("\n\n  <div class=\"row\">\n    <div class=\"page-header\">\n  <p><span>This page displays two reports. Only the report titles show if reports are empty.</span></p>\n    </div>\n  </div>\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h1>HBCK Chore Report</h1>\n      <p>\n        ");
                    if (hbckChore.isDisabled()) {
                        out.write("\n          <span>HBCK chore is currently disabled. Set hbase.master.hbck.chore.interval > 0 in the config & do a rolling-restart to enable it.</span>\n        ");
                    } else if (startTimestamp == 0L && endTimestamp == 0L) {
                        out.write("\n          <span>No report created. Execute <i>hbck_chore_run</i> in hbase shell to generate a new sub-report.</span>\n        ");
                    } else if (startTimestamp > 0L && endTimestamp == 0L) {
                        out.write("\n          <span>Checking started at ");
                        out.print(iso8601start);
                        out.write(". Please wait for checking to generate a new sub-report.</span>\n        ");
                    } else {
                        out.write("\n          <span>Checking started at ");
                        out.print(iso8601start);
                        out.write(" and generated report at ");
                        out.print(iso8601end);
                        out.write(". Execute <i>hbck_chore_run</i> in hbase shell to generate a new sub-report.</span>\n        ");
                    }
                    out.write("\n      </p>\n    </div>\n  </div>\n\n\n\n  ");
                    if (inconsistentRegions != null && inconsistentRegions.size() > 0) {
                        out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Inconsistent Regions</h2>\n    </div>\n  </div>\n      <p>\n        <span>\n        There are three cases: 1. Master thought this region opened, but no regionserver reported it (Fix: use assigns\n        command; 2. Master thought this region opened on Server1, but regionserver reported Server2 (Fix:\n        need to check the server is still exist. If not, schedule SCP for it. If exist, restart Server2 and Server1):\n        3. More than one regionservers reported opened this region (Fix: restart the RegionServers).\n        Notice: the reported online regionservers may be not right when there are regions in transition.\n        Please check them in regionserver's web UI.\n        </span>\n      </p>\n\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Region Encoded Name</th>\n      <th>Location in META</th>\n      <th>Reported Online RegionServers</th>\n    </tr>\n    ");
                        for (Map.Entry<String, Pair<ServerName, List<ServerName>>> entry : inconsistentRegions.entrySet()) {
                            out.write("\n    <tr>\n      <td>");
                            out.print(entry.getKey());
                            out.write("</td>\n      <td>");
                            out.print((Object)entry.getValue().getFirst());
                            out.write("</td>\n      <td>");
                            out.print(entry.getValue().getSecond().stream().map(ServerName::getServerName).collect(Collectors.joining(", ")));
                            out.write("</td>\n    </tr>\n    ");
                        }
                        out.write("\n\n    <p>");
                        out.print(inconsistentRegions.size());
                        out.write(" region(s) in set.</p>\n  </table>\n  ");
                    }
                    out.write("\n\n  ");
                    if (orphanRegionsOnRS != null && orphanRegionsOnRS.size() > 0) {
                        out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Orphan Regions on RegionServer</h2>\n    </div>\n  </div>\n\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Region Encoded Name</th>\n      <th>Reported Online RegionServer</th>\n    </tr>\n    ");
                        for (Map.Entry<String, Serializable> entry : orphanRegionsOnRS.entrySet()) {
                            out.write("\n    <tr>\n      <td>");
                            out.print(entry.getKey());
                            out.write("</td>\n      <td>");
                            out.print((Object)entry.getValue());
                            out.write("</td>\n    </tr>\n    ");
                        }
                        out.write("\n\n    <p>");
                        out.print(orphanRegionsOnRS.size());
                        out.write(" region(s) in set.</p>\n  </table>\n  ");
                    }
                    out.write("\n\n  ");
                    if (orphanRegionsOnFS != null && orphanRegionsOnFS.size() > 0) {
                        out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Orphan Regions on FileSystem</h2>\n    </div>\n  </div>\n\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Region Encoded Name</th>\n      <th>FileSystem Path</th>\n    </tr>\n    ");
                        for (Map.Entry<String, Serializable> entry : orphanRegionsOnFS.entrySet()) {
                            out.write("\n    <tr>\n      <td>");
                            out.print(entry.getKey());
                            out.write("</td>\n      <td>");
                            out.print((Object)entry.getValue());
                            out.write("</td>\n    </tr>\n    ");
                        }
                        out.write("\n\n    <p>");
                        out.print(orphanRegionsOnFS.size());
                        out.write(" region(s) in set.</p>\n  </table>\n  ");
                    }
                    out.write("\n\n  ");
                    zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault());
                    String iso8601Now = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    String string = "-1";
                    if (report != null) {
                        zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(report.getCreateTime()), ZoneId.systemDefault());
                        String string2 = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }
                    out.write("\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>CatalogJanitor <em>hbase:meta</em> Consistency Issues</h1>\n      <p>\n        ");
                    if (report != null) {
                        void var26_32;
                        out.write("\n          <span>Report created: ");
                        out.print((String)var26_32);
                        out.write(" (now=");
                        out.print(iso8601Now);
                        out.write("). Run <i>catalogjanitor_run</i> in hbase shell to generate a new sub-report.</span></p>\n        ");
                    } else {
                        out.write("\n          <span>No report created. Run <i>catalogjanitor_run</i> in hbase shell to generate a new sub-report.</span>\n        ");
                    }
                    out.write("\n    </div>\n  </div>\n  ");
                    if (report != null && !report.isEmpty()) {
                        out.write("\n      ");
                        if (!report.getHoles().isEmpty()) {
                            out.write("\n          <div class=\"row inner_header\">\n            <div class=\"page-header\">\n              <h2>Holes</h2>\n            </div>\n          </div>\n          <table class=\"table table-striped\">\n            <tr>\n              <th>RegionInfo</th>\n              <th>RegionInfo</th>\n            </tr>\n            ");
                            for (Pair<RegionInfo, RegionInfo> pair : report.getHoles()) {
                                out.write("\n            <tr>\n              <td>");
                                out.print((Object)pair.getFirst());
                                out.write("</td>\n              <td>");
                                out.print((Object)pair.getSecond());
                                out.write("</td>\n            </tr>\n            ");
                            }
                            out.write("\n\n            <p>");
                            out.print(report.getHoles().size());
                            out.write(" hole(s).</p>\n          </table>\n      ");
                        }
                        out.write("\n      ");
                        if (!report.getOverlaps().isEmpty()) {
                            out.write("\n            <div class=\"row inner_header\">\n              <div class=\"page-header\">\n                <h2>Overlaps</h2>\n              </div>\n            </div>\n            <table class=\"table table-striped\">\n              <tr>\n                <th>RegionInfo</th>\n                <th>Other RegionInfo</th>\n              </tr>\n              ");
                            for (Pair<RegionInfo, RegionInfo> pair : report.getOverlaps()) {
                                out.write("\n              <tr>\n                <td>");
                                out.print((Object)pair.getFirst());
                                out.write("</td>\n                <td>");
                                out.print((Object)pair.getSecond());
                                out.write("</td>\n              </tr>\n              ");
                            }
                            out.write("\n\n              <p>");
                            out.print(report.getOverlaps().size());
                            out.write(" overlap(s).</p>\n            </table>\n      ");
                        }
                        out.write("\n      ");
                        if (!report.getUnknownServers().isEmpty()) {
                            out.write("\n            <div class=\"row inner_header\">\n              <div class=\"page-header\">\n                <h2>Unknown Servers</h2>\n              </div>\n            </div>\n            <table class=\"table table-striped\">\n              <tr>\n                <th>RegionInfo</th>\n                <th>ServerName</th>\n              </tr>\n              ");
                            for (Pair<RegionInfo, Object> pair : report.getUnknownServers()) {
                                out.write("\n              <tr>\n                <td>");
                                out.print((Object)pair.getFirst());
                                out.write("</td>\n                <td>");
                                out.print(pair.getSecond());
                                out.write("</td>\n              </tr>\n              ");
                            }
                            out.write("\n\n              <p>");
                            out.print(report.getUnknownServers().size());
                            out.write(" unknown servers(s).</p>\n            </table>\n      ");
                        }
                        out.write("\n      ");
                        if (!report.getEmptyRegionInfo().isEmpty()) {
                            out.write("\n            <div class=\"row inner_header\">\n              <div class=\"page-header\">\n                <h2>Empty <em>info:regioninfo</em></h2>\n              </div>\n            </div>\n            <table class=\"table table-striped\">\n              <tr>\n                <th>Row</th>\n              </tr>\n              ");
                            for (byte[] byArray : report.getEmptyRegionInfo()) {
                                out.write("\n              <tr>\n                <td>");
                                out.print(Bytes.toStringBinary(byArray));
                                out.write("</td>\n              </tr>\n              ");
                            }
                            out.write("\n\n              <p>");
                            out.print(report.getEmptyRegionInfo().size());
                            out.write(" emptyRegionInfo(s).</p>\n            </table>\n      ");
                        }
                        out.write("\n  ");
                    }
                    out.write("\n\n  ");
                }
                out.write("\n</div>\n\n");
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"footer.jsp", (JspWriter)out, (boolean)false);
                out.write(10);
            }
            catch (Throwable t) {
                try {
                    if (t instanceof SkipPageException) break block34;
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                    throw new ServletException(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

