/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RecoverMetaProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerCrashException;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ServerCrashProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ServerCrashState>
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCrashProcedure.class);
    private ServerName serverName;
    private boolean notifiedDeadServer = false;
    private List<RegionInfo> regionsOnCrashedServer;
    private boolean carryingMeta = false;
    private boolean shouldSplitWal;

    public ServerCrashProcedure(MasterProcedureEnv env, ServerName serverName, boolean shouldSplitWal, boolean carryingMeta) {
        this.serverName = serverName;
        this.shouldSplitWal = shouldSplitWal;
        this.carryingMeta = carryingMeta;
        this.setOwner(env.getRequestUser());
    }

    public ServerCrashProcedure() {
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws ProcedureSuspendedException, ProcedureYieldException {
        MasterServices services = env.getMasterServices();
        if (!this.notifiedDeadServer) {
            services.getServerManager().getDeadServers().notifyServer(this.serverName);
            this.notifiedDeadServer = true;
        }
        try {
            switch (state) {
                case SERVER_CRASH_START: {
                    LOG.info("Start " + this);
                    if (this.carryingMeta) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_META_LOGS);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_SPLIT_META_LOGS: {
                    this.splitMetaLogs(env);
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN_META);
                    break;
                }
                case SERVER_CRASH_ASSIGN_META: {
                    this.handleRIT(env, Arrays.asList(RegionInfoBuilder.FIRST_META_REGIONINFO));
                    this.addChildProcedure(new AssignProcedure[]{env.getAssignmentManager().createAssignProcedure(RegionInfoBuilder.FIRST_META_REGIONINFO)});
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_PROCESS_META: {
                    this.processMeta(env);
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_GET_REGIONS);
                    break;
                }
                case SERVER_CRASH_GET_REGIONS: {
                    if (env.getAssignmentManager().waitMetaLoaded(this)) {
                        throw new ProcedureSuspendedException();
                    }
                    this.regionsOnCrashedServer = services.getAssignmentManager().getRegionStates().getServerRegionInfoSet(this.serverName);
                    if (!this.shouldSplitWal) {
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_SPLIT_LOGS);
                    break;
                }
                case SERVER_CRASH_SPLIT_LOGS: {
                    this.splitLogs(env);
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
                    break;
                }
                case SERVER_CRASH_ASSIGN: {
                    if (this.filterDefaultMetaRegions(this.regionsOnCrashedServer)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Assigning regions " + RegionInfo.getShortNameToLog(this.regionsOnCrashedServer) + ", " + this + "; cycles=" + this.getCycles());
                        }
                        List<RegionInfo> toAssign = this.handleRIT(env, this.regionsOnCrashedServer);
                        AssignmentManager am = env.getAssignmentManager();
                        int size = toAssign.size();
                        if (toAssign.removeIf(r -> !AssignProcedure.assign(env.getMasterServices(), r))) {
                            LOG.debug("Dropped {} assigns because against disabling/disabled tables", (Object)(size - toAssign.size()));
                        }
                        this.addChildProcedure(am.createRoundRobinAssignProcedures(toAssign));
                        this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_HANDLE_RIT2);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                    break;
                }
                case SERVER_CRASH_HANDLE_RIT2: {
                    this.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_FINISH);
                    break;
                }
                case SERVER_CRASH_FINISH: {
                    services.getAssignmentManager().getRegionStates().removeServer(this.serverName);
                    services.getServerManager().getDeadServers().finish(this.serverName);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed state=" + state + ", retry " + this + "; cycles=" + this.getCycles(), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void processMeta(MasterProcedureEnv env) throws IOException {
        LOG.debug("{}; processing hbase:meta", (Object)this);
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        for (RegionInfo hri : am.getRegionStates().getServerRegionInfoSet(this.serverName)) {
            if (!this.isDefaultMetaRegion(hri)) continue;
            this.addChildProcedure(new RecoverMetaProcedure[]{new RecoverMetaProcedure(this.serverName, this.shouldSplitWal)});
        }
    }

    private boolean filterDefaultMetaRegions(List<RegionInfo> regions) {
        if (regions == null) {
            return false;
        }
        regions.removeIf(this::isDefaultMetaRegion);
        return !regions.isEmpty();
    }

    private boolean isDefaultMetaRegion(RegionInfo hri) {
        return hri.getTable().equals(TableName.META_TABLE_NAME) && RegionReplicaUtil.isDefaultReplica(hri);
    }

    private void splitMetaLogs(MasterProcedureEnv env) throws IOException {
        LOG.debug("Splitting meta WALs {}", (Object)this);
        MasterWalManager mwm = env.getMasterServices().getMasterWalManager();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        am.getRegionStates().metaLogSplitting(this.serverName);
        mwm.splitMetaLog(this.serverName);
        am.getRegionStates().metaLogSplit(this.serverName);
        LOG.debug("Done splitting meta WALs {}", (Object)this);
    }

    private void splitLogs(MasterProcedureEnv env) throws IOException {
        LOG.debug("Splitting WALs {}", (Object)this);
        MasterWalManager mwm = env.getMasterServices().getMasterWalManager();
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        am.getRegionStates().logSplitting(this.serverName);
        mwm.splitLog(this.serverName);
        if (!this.carryingMeta) {
            mwm.archiveMetaLog(this.serverName);
        }
        am.getRegionStates().logSplit(this.serverName);
        LOG.debug("Done splitting WALs {}", (Object)this);
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws IOException {
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected MasterProcedureProtos.ServerCrashState getState(int stateId) {
        return MasterProcedureProtos.ServerCrashState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ServerCrashState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ServerCrashState getInitialState() {
        return MasterProcedureProtos.ServerCrashState.SERVER_CRASH_START;
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitServerExclusiveLock(this, this.getServerName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeServerExclusiveLock(this, this.getServerName());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" server=");
        sb.append(this.serverName);
        sb.append(", splitWal=");
        sb.append(this.shouldSplitWal);
        sb.append(", meta=");
        sb.append(this.carryingMeta);
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ServerCrashStateData.Builder state = MasterProcedureProtos.ServerCrashStateData.newBuilder().setServerName(ProtobufUtil.toServerName(this.serverName)).setCarryingMeta(this.carryingMeta).setShouldSplitWal(this.shouldSplitWal);
        if (this.regionsOnCrashedServer != null && !this.regionsOnCrashedServer.isEmpty()) {
            for (RegionInfo hri : this.regionsOnCrashedServer) {
                state.addRegionsOnCrashedServer(ProtobufUtil.toRegionInfo(hri));
            }
        }
        serializer.serialize(state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ServerCrashStateData state = serializer.deserialize(MasterProcedureProtos.ServerCrashStateData.class);
        this.serverName = ProtobufUtil.toServerName(state.getServerName());
        this.carryingMeta = state.hasCarryingMeta() ? state.getCarryingMeta() : false;
        this.shouldSplitWal = state.getShouldSplitWal();
        int size = state.getRegionsOnCrashedServerCount();
        if (size > 0) {
            this.regionsOnCrashedServer = new ArrayList<RegionInfo>(size);
            for (HBaseProtos.RegionInfo ri : state.getRegionsOnCrashedServerList()) {
                this.regionsOnCrashedServer.add(ProtobufUtil.toRegionInfo(ri));
            }
        }
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return this.carryingMeta;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CRASH_HANDLER;
    }

    @Override
    protected boolean isYieldBeforeExecuteFromState(MasterProcedureEnv env, MasterProcedureProtos.ServerCrashState state) {
        return true;
    }

    @Override
    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return false;
    }

    private List<RegionInfo> handleRIT(MasterProcedureEnv env, List<RegionInfo> regions) {
        if (regions == null || regions.isEmpty()) {
            return Collections.emptyList();
        }
        AssignmentManager am = env.getMasterServices().getAssignmentManager();
        ArrayList<RegionInfo> toAssign = new ArrayList<RegionInfo>(regions);
        Iterator it = toAssign.iterator();
        ServerCrashException sce = null;
        while (it.hasNext()) {
            RegionInfo hri = (RegionInfo)it.next();
            RegionTransitionProcedure rtp = am.getRegionStates().getRegionTransitionProcedure(hri);
            if (rtp == null) continue;
            ServerName rtpServerName = rtp.getServer(env);
            if (rtpServerName == null) {
                LOG.warn("RIT with ServerName null! " + rtp);
                continue;
            }
            if (!rtpServerName.equals(this.serverName)) continue;
            LOG.info("pid=" + this.getProcId() + " found RIT " + rtp + "; " + rtp.getRegionState(env).toShortString());
            if (sce == null) {
                sce = new ServerCrashException(this.getProcId(), this.getServerName());
            }
            if (!rtp.remoteCallFailed(env, this.serverName, (IOException)sce)) continue;
            it.remove();
        }
        return toAssign;
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getMasterServices().getMasterMetrics().getServerCrashProcMetrics();
    }
}

