/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellChunkMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellChunkImmutableSegment
extends ImmutableSegment {
    public static final long DEEP_OVERHEAD_CCM = ImmutableSegment.DEEP_OVERHEAD + (long)ClassSize.CELL_CHUNK_MAP;
    public static final float INDEX_CHUNK_UNUSED_SPACE_PRECENTAGE = 0.1f;

    protected CellChunkImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, MemStoreCompactionStrategy.Action action) {
        super(null, comparator, memStoreLAB);
        long indexOverhead = DEEP_OVERHEAD_CCM;
        boolean onHeap = this.getMemStoreLAB().isOnHeap();
        if (onHeap) {
            this.incMemStoreSize(0L, indexOverhead, 0L, 0);
        } else {
            this.incMemStoreSize(0L, 0L, indexOverhead, 0);
        }
        this.initializeCellSet(numOfCells, iterator, action);
    }

    protected CellChunkImmutableSegment(CSLMImmutableSegment segment, MemStoreSizing memstoreSizing, MemStoreCompactionStrategy.Action action) {
        super(segment);
        long indexOverhead = -CSLMImmutableSegment.DEEP_OVERHEAD_CSLM + DEEP_OVERHEAD_CCM;
        boolean onHeap = this.getMemStoreLAB().isOnHeap();
        if (onHeap) {
            this.incMemStoreSize(0L, indexOverhead, 0L, 0);
            memstoreSizing.incMemStoreSize(0L, indexOverhead, 0L, 0);
        } else {
            this.incMemStoreSize(0L, -CSLMImmutableSegment.DEEP_OVERHEAD_CSLM, DEEP_OVERHEAD_CCM, 0);
            memstoreSizing.incMemStoreSize(0L, -CSLMImmutableSegment.DEEP_OVERHEAD_CSLM, DEEP_OVERHEAD_CCM, 0);
        }
        int numOfCells = segment.getCellsCount();
        this.reinitializeCellSet(numOfCells, segment.getScanner(Long.MAX_VALUE), segment.getCellSet(), action);
        long newSegmentSizeDelta = (long)numOfCells * (this.indexEntrySize() - (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY);
        if (onHeap) {
            this.incMemStoreSize(0L, newSegmentSizeDelta, 0L, 0);
            memstoreSizing.incMemStoreSize(0L, newSegmentSizeDelta, 0L, 0);
        } else {
            this.incMemStoreSize(0L, 0L, newSegmentSizeDelta, 0);
            memstoreSizing.incMemStoreSize(0L, 0L, newSegmentSizeDelta, 0);
        }
    }

    @Override
    protected long indexEntryOnHeapSize(boolean onHeap) {
        if (onHeap) {
            return this.indexEntrySize();
        }
        return 0L;
    }

    @Override
    protected long indexEntryOffHeapSize(boolean offHeap) {
        if (offHeap) {
            return this.indexEntrySize();
        }
        return 0L;
    }

    @Override
    protected long indexEntrySize() {
        return (long)ClassSize.CELL_CHUNK_MAP_ENTRY - (long)KeyValue.FIXED_OVERHEAD;
    }

    @Override
    protected boolean canBeFlattened() {
        return false;
    }

    private void initializeCellSet(int numOfCells, MemStoreSegmentsIterator iterator, MemStoreCompactionStrategy.Action action) {
        int numOfCellsAfterCompaction = 0;
        int currentChunkIdx = 0;
        int offsetInCurentChunk = 4;
        int numUniqueKeys = 0;
        Cell prev = null;
        Chunk[] chunks = this.allocIndexChunks(numOfCells);
        while (iterator.hasNext()) {
            boolean alreadyCopied = false;
            Cell c = (Cell)iterator.next();
            ++numOfCellsAfterCompaction;
            assert (c instanceof ExtendedCell);
            if (((ExtendedCell)c).getChunkId() == -1) {
                c = this.copyCellIntoMSLAB(c);
                alreadyCopied = true;
            }
            if (offsetInCurentChunk + ClassSize.CELL_CHUNK_MAP_ENTRY > chunks[currentChunkIdx].size) {
                ++currentChunkIdx;
                offsetInCurentChunk = 4;
            }
            if (action == MemStoreCompactionStrategy.Action.COMPACT && !alreadyCopied) {
                c = this.maybeCloneWithAllocator(c, false);
            }
            offsetInCurentChunk = this.createCellReference((ByteBufferKeyValue)c, chunks[currentChunkIdx].getData(), offsetInCurentChunk);
            this.updateMetaInfo(c, true, null);
            if (action == MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS) {
                if (prev != null) {
                    if (!CellUtil.matchingRowColumnBytes(prev, c)) {
                        ++numUniqueKeys;
                    }
                } else {
                    ++numUniqueKeys;
                }
            }
            prev = c;
        }
        if (action == MemStoreCompactionStrategy.Action.COMPACT) {
            numUniqueKeys = numOfCells;
        } else if (action != MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS) {
            numUniqueKeys = -1;
        }
        CellChunkMap ccm = new CellChunkMap(this.getComparator(), chunks, 0, numOfCellsAfterCompaction, false);
        this.setCellSet(null, new CellSet(ccm, numUniqueKeys));
    }

    private void reinitializeCellSet(int numOfCells, KeyValueScanner segmentScanner, CellSet oldCellSet, MemStoreCompactionStrategy.Action action) {
        Chunk[] chunks = this.allocIndexChunks(numOfCells);
        int currentChunkIdx = 0;
        int offsetInCurentChunk = 4;
        int numUniqueKeys = 0;
        Cell prev = null;
        try {
            Cell curCell;
            while ((curCell = segmentScanner.next()) != null) {
                assert (curCell instanceof ExtendedCell);
                if (((ExtendedCell)curCell).getChunkId() == -1) {
                    curCell = this.copyCellIntoMSLAB(curCell);
                }
                if (offsetInCurentChunk + ClassSize.CELL_CHUNK_MAP_ENTRY > chunks[currentChunkIdx].size) {
                    ++currentChunkIdx;
                    offsetInCurentChunk = 4;
                }
                offsetInCurentChunk = this.createCellReference((ByteBufferKeyValue)curCell, chunks[currentChunkIdx].getData(), offsetInCurentChunk);
                if (action == MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
                    if (prev != null) {
                        if (!CellUtil.matchingRowColumn(prev, curCell)) {
                            ++numUniqueKeys;
                        }
                    } else {
                        ++numUniqueKeys;
                    }
                }
                prev = curCell;
            }
            if (action != MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
                numUniqueKeys = -1;
            }
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        finally {
            segmentScanner.close();
        }
        CellChunkMap ccm = new CellChunkMap(this.getComparator(), chunks, 0, numOfCells, false);
        this.setCellSet(oldCellSet, new CellSet(ccm, numUniqueKeys));
    }

    private int createCellReference(ByteBufferKeyValue cell, ByteBuffer idxBuffer, int idxOffset) {
        int offset = idxOffset;
        int dataChunkID = cell.getChunkId();
        offset = ByteBufferUtils.putInt(idxBuffer, offset, dataChunkID);
        offset = ByteBufferUtils.putInt(idxBuffer, offset, cell.getOffset());
        offset = ByteBufferUtils.putInt(idxBuffer, offset, KeyValueUtil.length(cell));
        offset = ByteBufferUtils.putLong(idxBuffer, offset, cell.getSequenceId());
        return offset;
    }

    private int calculateNumberOfChunks(int numOfCells, int chunkSize) {
        int numOfCellsInChunk = this.calcNumOfCellsInChunk(chunkSize);
        int numberOfChunks = numOfCells / numOfCellsInChunk;
        if (numOfCells % numOfCellsInChunk != 0) {
            ++numberOfChunks;
        }
        return numberOfChunks;
    }

    private ChunkCreator.ChunkType useIndexChunks(int numOfCells) {
        int dataChunkSize = ChunkCreator.getInstance().getChunkSize();
        int numOfCellsInChunk = this.calcNumOfCellsInChunk(dataChunkSize);
        int cellsInLastChunk = numOfCells % numOfCellsInChunk;
        if (cellsInLastChunk == 0) {
            return ChunkCreator.ChunkType.DATA_CHUNK;
        }
        int chunkSpace = dataChunkSize - 4;
        int freeSpaceInLastChunk = chunkSpace - cellsInLastChunk * ClassSize.CELL_CHUNK_MAP_ENTRY;
        if ((float)freeSpaceInLastChunk > 0.1f * (float)chunkSpace) {
            return ChunkCreator.ChunkType.INDEX_CHUNK;
        }
        return ChunkCreator.ChunkType.DATA_CHUNK;
    }

    private int calcNumOfCellsInChunk(int chunkSize) {
        int chunkSpace = chunkSize - 4;
        int numOfCellsInChunk = chunkSpace / ClassSize.CELL_CHUNK_MAP_ENTRY;
        return numOfCellsInChunk;
    }

    private Chunk[] allocIndexChunks(int numOfCells) {
        ChunkCreator.ChunkType chunkType = this.useIndexChunks(numOfCells);
        int chunkSize = ChunkCreator.getInstance().getChunkSize(chunkType);
        int numberOfChunks = this.calculateNumberOfChunks(numOfCells, chunkSize);
        Chunk[] chunks = new Chunk[numberOfChunks];
        for (int i = 0; i < numberOfChunks; ++i) {
            chunks[i] = this.getMemStoreLAB().getNewExternalChunk(chunkType);
        }
        return chunks;
    }

    private Cell copyCellIntoMSLAB(Cell cell) {
        long oldHeapSize = this.heapSizeChange(cell, true);
        long oldOffHeapSize = this.offHeapSizeChange(cell, true);
        long oldCellSize = CellChunkImmutableSegment.getCellLength(cell);
        cell = this.maybeCloneWithAllocator(cell, true);
        long newHeapSize = this.heapSizeChange(cell, true);
        long newOffHeapSize = this.offHeapSizeChange(cell, true);
        long newCellSize = CellChunkImmutableSegment.getCellLength(cell);
        long heapOverhead = newHeapSize - oldHeapSize;
        long offHeapOverhead = newOffHeapSize - oldOffHeapSize;
        this.incMemStoreSize(newCellSize - oldCellSize, heapOverhead, offHeapOverhead, 0);
        return cell;
    }
}

