/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsRegionWrapperImpl
implements MetricsRegionWrapper,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRegionWrapperImpl.class);
    public static final int PERIOD = 45;
    public static final String UNKNOWN = "unknown";
    private final HRegion region;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long numStoreFiles;
    private long memstoreSize;
    private long storeFileSize;
    private long maxStoreFileAge;
    private long minStoreFileAge;
    private long avgStoreFileAge;
    private long numReferenceFiles;
    private long maxFlushQueueSize;
    private long maxCompactionQueueSize;
    private ScheduledFuture<?> regionMetricsUpdateTask;

    public MetricsRegionWrapperImpl(HRegion region) {
        this.region = region;
        this.executor = CompatibilitySingletonFactory.getInstance(MetricsExecutor.class).getExecutor();
        this.runnable = new HRegionMetricsWrapperRunnable();
        this.regionMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, 45L, 45L, TimeUnit.SECONDS);
    }

    @Override
    public String getTableName() {
        TableDescriptor tableDesc = this.region.getTableDescriptor();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getQualifierAsString();
    }

    @Override
    public String getNamespace() {
        TableDescriptor tableDesc = this.region.getTableDescriptor();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getNamespaceAsString();
    }

    @Override
    public String getRegionName() {
        RegionInfo regionInfo = this.region.getRegionInfo();
        if (regionInfo == null) {
            return UNKNOWN;
        }
        return regionInfo.getEncodedName();
    }

    @Override
    public long getNumStores() {
        Map<byte[], HStore> stores = this.region.stores;
        if (stores == null) {
            return 0L;
        }
        return stores.size();
    }

    @Override
    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    @Override
    public long getMemStoreSize() {
        return this.memstoreSize;
    }

    @Override
    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    @Override
    public long getReadRequestCount() {
        return this.region.getReadRequestsCount();
    }

    @Override
    public long getFilteredReadRequestCount() {
        return this.region.getFilteredReadRequestsCount();
    }

    @Override
    public long getWriteRequestCount() {
        return this.region.getWriteRequestsCount();
    }

    @Override
    public long getNumFilesCompacted() {
        return this.region.compactionNumFilesCompacted.sum();
    }

    @Override
    public long getNumBytesCompacted() {
        return this.region.compactionNumBytesCompacted.sum();
    }

    @Override
    public long getNumCompactionsCompleted() {
        return this.region.compactionsFinished.sum();
    }

    @Override
    public long getLastMajorCompactionAge() {
        long lastMajorCompactionTs = 0L;
        try {
            lastMajorCompactionTs = this.region.getOldestHfileTs(true);
        }
        catch (IOException ioe) {
            LOG.error("Could not load HFile info ", (Throwable)ioe);
        }
        long now = EnvironmentEdgeManager.currentTime();
        return now - lastMajorCompactionTs;
    }

    @Override
    public long getNumCompactionsFailed() {
        return this.region.compactionsFailed.sum();
    }

    @Override
    public long getNumCompactionsQueued() {
        return this.region.compactionsQueued.sum();
    }

    @Override
    public long getNumFlushesQueued() {
        return this.region.flushesQueued.sum();
    }

    @Override
    public long getMaxCompactionQueueSize() {
        return this.maxCompactionQueueSize;
    }

    @Override
    public long getMaxFlushQueueSize() {
        return this.maxFlushQueueSize;
    }

    @Override
    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    @Override
    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    @Override
    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    @Override
    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    @Override
    public int getRegionHashCode() {
        return this.region.hashCode();
    }

    @Override
    public void close() throws IOException {
        this.regionMetricsUpdateTask.cancel(true);
    }

    @Override
    public int getReplicaId() {
        return this.region.getRegionInfo().getReplicaId();
    }

    public class HRegionMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            long tempNumStoreFiles = 0L;
            long tempMemstoreSize = 0L;
            long tempStoreFileSize = 0L;
            long tempMaxStoreFileAge = 0L;
            long tempMinStoreFileAge = Long.MAX_VALUE;
            long tempNumReferenceFiles = 0L;
            long tempMaxCompactionQueueSize = 0L;
            long tempMaxFlushQueueSize = 0L;
            long avgAgeNumerator = 0L;
            long numHFiles = 0L;
            if (((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores != null) {
                for (Store store : ((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores.values()) {
                    OptionalLong storeMinStoreFileAge;
                    tempNumStoreFiles += (long)store.getStorefilesCount();
                    tempMemstoreSize += store.getMemStoreSize().getDataSize();
                    tempStoreFileSize += store.getStorefilesSize();
                    OptionalLong storeMaxStoreFileAge = store.getMaxStoreFileAge();
                    if (storeMaxStoreFileAge.isPresent() && storeMaxStoreFileAge.getAsLong() > tempMaxStoreFileAge) {
                        tempMaxStoreFileAge = storeMaxStoreFileAge.getAsLong();
                    }
                    if ((storeMinStoreFileAge = store.getMinStoreFileAge()).isPresent() && storeMinStoreFileAge.getAsLong() < tempMinStoreFileAge) {
                        tempMinStoreFileAge = storeMinStoreFileAge.getAsLong();
                    }
                    long storeHFiles = store.getNumHFiles();
                    numHFiles += storeHFiles;
                    tempNumReferenceFiles += store.getNumReferenceFiles();
                    OptionalDouble storeAvgStoreFileAge = store.getAvgStoreFileAge();
                    if (!storeAvgStoreFileAge.isPresent()) continue;
                    avgAgeNumerator += (long)storeAvgStoreFileAge.getAsDouble() * storeHFiles;
                }
            }
            MetricsRegionWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
            MetricsRegionWrapperImpl.this.memstoreSize = tempMemstoreSize;
            MetricsRegionWrapperImpl.this.storeFileSize = tempStoreFileSize;
            MetricsRegionWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
            if (tempMinStoreFileAge != Long.MAX_VALUE) {
                MetricsRegionWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
            }
            if (numHFiles != 0L) {
                MetricsRegionWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
            }
            MetricsRegionWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
            tempMaxCompactionQueueSize = MetricsRegionWrapperImpl.this.getNumCompactionsQueued();
            tempMaxFlushQueueSize = MetricsRegionWrapperImpl.this.getNumFlushesQueued();
            if (tempMaxCompactionQueueSize > MetricsRegionWrapperImpl.this.maxCompactionQueueSize) {
                MetricsRegionWrapperImpl.this.maxCompactionQueueSize = tempMaxCompactionQueueSize;
            }
            if (tempMaxFlushQueueSize > MetricsRegionWrapperImpl.this.maxFlushQueueSize) {
                MetricsRegionWrapperImpl.this.maxFlushQueueSize = tempMaxFlushQueueSize;
            }
        }
    }
}

