/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Version;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateImpl;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.emit.StandardEmitter;
import org.apache.hadoop.hbase.shaded.org.jamon.escaping.Escaping;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl;
import org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl;
import org.apache.hadoop.hbase.tool.Canary;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JvmVersion;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
extends AbstractTemplateImpl
implements MasterStatusTmpl.Intf {
    private final HMaster master;
    private final AssignmentManager assignmentManager;
    private final boolean catalogJanitorEnabled;
    private final Set<ServerName> deadServers;
    private final String filter;
    private final String format;
    private final Map<String, Integer> frags;
    private final ServerName metaLocation;
    private final ServerManager serverManager;
    private final List<ServerName> servers;

    public String formatZKString() {
        StringBuilder quorums = new StringBuilder();
        String zkQuorum = this.master.getZooKeeper().getQuorum();
        if (null == zkQuorum) {
            return quorums.toString();
        }
        String[] zks = zkQuorum.split(",");
        if (zks.length == 0) {
            return quorums.toString();
        }
        for (int i = 0; i < zks.length; ++i) {
            quorums.append(zks[i].trim());
            if (i == zks.length - 1) continue;
            quorums.append("<br/>");
        }
        return quorums.toString();
    }

    public static String getUserTables(HMaster master, List<TableDescriptor> tables) {
        if (master.isInitialized()) {
            try {
                Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
                if (descriptorMap != null) {
                    for (TableDescriptor desc : descriptorMap.values()) {
                        if (desc.getTableName().isSystemTable()) continue;
                        tables.add(desc);
                    }
                }
            }
            catch (IOException e) {
                return "Got user tables error, " + e.getMessage();
            }
        }
        return null;
    }

    protected static MasterStatusTmpl.ImplData __jamon_setOptionalArguments(MasterStatusTmpl.ImplData p_implData) {
        if (!p_implData.getAssignmentManager__IsNotDefault()) {
            p_implData.setAssignmentManager(null);
        }
        if (!p_implData.getCatalogJanitorEnabled__IsNotDefault()) {
            p_implData.setCatalogJanitorEnabled(true);
        }
        if (!p_implData.getDeadServers__IsNotDefault()) {
            p_implData.setDeadServers(null);
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getFrags__IsNotDefault()) {
            p_implData.setFrags(null);
        }
        if (!p_implData.getMetaLocation__IsNotDefault()) {
            p_implData.setMetaLocation(null);
        }
        if (!p_implData.getServerManager__IsNotDefault()) {
            p_implData.setServerManager(null);
        }
        if (!p_implData.getServers__IsNotDefault()) {
            p_implData.setServers(null);
        }
        return p_implData;
    }

    public MasterStatusTmplImpl(TemplateManager p_templateManager, MasterStatusTmpl.ImplData p_implData) {
        super(p_templateManager, MasterStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
        this.assignmentManager = p_implData.getAssignmentManager();
        this.catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
        this.deadServers = p_implData.getDeadServers();
        this.filter = p_implData.getFilter();
        this.format = p_implData.getFormat();
        this.frags = p_implData.getFrags();
        this.metaLocation = p_implData.getMetaLocation();
        this.serverManager = p_implData.getServerManager();
        this.servers = p_implData.getServers();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_0 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_0.setFilter(this.filter);
            __jamon__var_0.setFormat("json");
            __jamon__var_0.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n");
        ServerManager serverManager = this.master.getServerManager();
        AssignmentManager assignmentManager = this.master.getAssignmentManager();
        jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
        if (this.master.isActiveMaster()) {
            jamonWriter.write("Master: ");
        } else {
            jamonWriter.write("Backup Master: ");
        }
        jamonWriter.write("\n    ");
        Escaping.NONE.write(StandardEmitter.valueOf(this.master.getServerName().getHostname()), jamonWriter);
        jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
        if (this.master.isActiveMaster()) {
            jamonWriter.write("\n                    <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                    <li><a href=\"/hbck.jsp\">HBCK Report</a></li>\n                ");
        }
        jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
        }
        jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
        if (this.master.isActiveMaster()) {
            jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
            Escaping.NONE.write(StandardEmitter.valueOf(this.master.getServerName().getHostname()), jamonWriter);
            jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
            if (JvmVersion.isBadJvmVersion()) {
                jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
                Escaping.NONE.write(StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
                jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (this.master.isInitialized() && !this.catalogJanitorEnabled) {
                jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (this.master.isInMaintenanceMode()) {
                jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This is because hbase.master.maintenance_mode is\n          set to true. Under the maintenance mode, no quota or no Master coprocessor is loaded.\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (!this.master.isBalancerOn()) {
                jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (!this.master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT)) {
                jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (!this.master.isSplitOrMergeEnabled(MasterSwitchType.MERGE)) {
                jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (this.master.getAssignmentManager() != null) {
                jamonWriter.write("\n          ");
                AssignmentManagerStatusTmpl __jamon__var_1 = new AssignmentManagerStatusTmpl(this.getTemplateManager());
                __jamon__var_1.renderNoFlush(jamonWriter, this.master.getAssignmentManager());
                jamonWriter.write("\n        ");
            }
            jamonWriter.write("\n        ");
            if (!this.master.isInMaintenanceMode()) {
                jamonWriter.write("\n          ");
                if (this.master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null) {
                    jamonWriter.write("\n            <section>\n              <h2><a name=\"rsgroup\">RSGroup</a></h2>\n              ");
                    RSGroupListTmpl __jamon__var_2 = new RSGroupListTmpl(this.getTemplateManager());
                    __jamon__var_2.renderNoFlush(jamonWriter, this.master, serverManager);
                    jamonWriter.write("\n            </section>\n          ");
                }
                jamonWriter.write("\n        ");
            }
            jamonWriter.write("\n        <section>\n            <h2><a name=\"regionservers\">Region Servers</a></h2>\n            ");
            RegionServerListTmpl __jamon__var_3 = new RegionServerListTmpl(this.getTemplateManager());
            __jamon__var_3.setServers(this.servers);
            __jamon__var_3.renderNoFlush(jamonWriter, this.master);
            jamonWriter.write("\n\n            ");
            if (this.deadServers != null) {
                jamonWriter.write("\n                ");
                this.__jamon_innerUnit__deadRegionServers(jamonWriter);
                jamonWriter.write("\n            ");
            }
            jamonWriter.write("\n        </section>\n        <section>\n            ");
            BackupMasterStatusTmpl __jamon__var_4 = new BackupMasterStatusTmpl(this.getTemplateManager());
            __jamon__var_4.renderNoFlush(jamonWriter, this.master);
            jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"tables\">Tables</a></h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
            if (this.metaLocation != null) {
                jamonWriter.write("\n                            ");
                this.__jamon_innerUnit__userTables(jamonWriter);
                jamonWriter.write("\n                        ");
            }
            jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
            if (this.metaLocation != null) {
                jamonWriter.write("\n                            ");
                this.__jamon_innerUnit__catalogTables(jamonWriter);
                jamonWriter.write("\n                        ");
            }
            jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
            this.__jamon_innerUnit__userSnapshots(jamonWriter);
            jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2><a name=\"peers\">Peers</a></h2>\n            ");
            this.__jamon_innerUnit__peerConfigs(jamonWriter);
            jamonWriter.write("\n        </section>\n\t");
        } else {
            jamonWriter.write("\n        <section>\n            ");
            BackupMasterStatusTmpl __jamon__var_5 = new BackupMasterStatusTmpl(this.getTemplateManager());
            __jamon__var_5.renderNoFlush(jamonWriter, this.master);
            jamonWriter.write("\n        </section>\n\t");
        }
        jamonWriter.write("\n\n\n        <section>\n            ");
        TaskMonitorTmpl __jamon__var_6 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_6.setFilter(this.filter);
        __jamon__var_6.setParent("/master-status");
        __jamon__var_6.renderNoFlush(jamonWriter);
        jamonWriter.write("\n        </section>\n\n        <section>\n            <h2><a name=\"attributes\">Software Attributes</a></h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf(VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.NONE.write(StandardEmitter.valueOf(VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.NONE.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(Version.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf(Version.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(Version.getBuildDate()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
        Escaping.NONE.write(StandardEmitter.valueOf(this.formatZKString()), jamonWriter);
        jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
        Escaping.NONE.write(StandardEmitter.valueOf(this.master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>Cluster Key</td>\n                    <td> ");
        Escaping.NONE.write(StandardEmitter.valueOf(this.formatZKString()), jamonWriter);
        jamonWriter.write(":");
        Escaping.NONE.write(StandardEmitter.valueOf(this.master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Key to add this cluster as a peer for replication. Use 'help \"add_peer\"' in the shell for details.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(FSUtils.getRootDir(this.master.getConfiguration()).toString()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf(new Date(this.master.getMasterStartTime())), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
        if (this.master.isActiveMaster()) {
            jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf(new Date(this.master.getMasterActiveTime())), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf(this.master.getClusterId() != null ? this.master.getClusterId() : "Not set"), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf(this.master.getServerManager() == null ? "0.00" : StringUtils.limitDecimalTo2((double)this.master.getServerManager().getAverageLoad())), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
            if (this.frags != null) {
                jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(this.frags.get("-TOTAL-") != null ? this.frags.get("-TOTAL-") + "%" : "n/a"), jamonWriter);
                jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
            }
            jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf(this.master.getMasterCoprocessorHost() == null ? "[]" : Arrays.toString(this.master.getMasterCoprocessors())), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf(this.master.getLoadBalancerClassName()), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
        }
        jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script>\n    $(document).ready(function()\n        {\n            $(\"#baseStatsTable\").tablesorter();\n            $(\"#memoryStatsTable\").tablesorter();\n            $(\"#requestStatsTable\").tablesorter();\n            $(\"#storeStatsTable\").tablesorter();\n            $(\"#compactionStatsTable\").tablesorter();\n\n            $(\"#userTables\").tablesorter();\n        }\n    );\n    </script>\n  </body>\n</html>\n\n");
    }

    private void __jamon_innerUnit__catalogTables(Writer jamonWriter) throws IOException {
        List<TableDescriptor> sysTables;
        List<TableDescriptor> list = sysTables = this.master.isInitialized() ? this.master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;
        if (sysTables != null && sysTables.size() > 0) {
            jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
            if (this.frags != null) {
                jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
            }
            jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
            for (TableDescriptor systemTable : sysTables) {
                jamonWriter.write("\n<tr>\n");
                TableName tableName = systemTable.getTableName();
                jamonWriter.write("<td><a href=\"table.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf(tableName), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf(tableName), jamonWriter);
                jamonWriter.write("</a></td>\n    ");
                if (this.frags != null) {
                    jamonWriter.write("\n        <td align=\"center\">");
                    Escaping.NONE.write(StandardEmitter.valueOf(this.frags.get(tableName.getNameAsString()) != null ? this.frags.get(tableName.getNameAsString()) + "%" : "n/a"), jamonWriter);
                    jamonWriter.write("</td>\n    ");
                }
                jamonWriter.write("\n    ");
                String description = null;
                if (tableName.equals(TableName.META_TABLE_NAME)) {
                    description = "The hbase:meta table holds references to all User Table regions.";
                } else if (tableName.equals(Canary.DEFAULT_WRITE_TABLE_NAME)) {
                    description = "The hbase:canary table is used to sniff the write availbility of each regionserver.";
                } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)) {
                    description = "The hbase:acl table holds information about acl.";
                } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)) {
                    description = "The hbase:labels table holds information about visibility labels.";
                } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)) {
                    description = "The hbase:namespace table holds information about namespaces.";
                } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)) {
                    description = "The hbase:quota table holds quota information about number or size of requests in a given time frame.";
                } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))) {
                    description = "The hbase:rsgroup table holds information about regionserver groups.";
                } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
                    description = "The hbase:replication table tracks cross cluster replication through WAL file offsets.";
                }
                jamonWriter.write("<td>");
                Escaping.NONE.write(StandardEmitter.valueOf(description), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
            }
            jamonWriter.write("\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__deadRegionServers(Writer jamonWriter) throws IOException {
        if (this.deadServers != null && this.deadServers.size() > 0) {
            jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
            DeadServer deadServerUtil = this.master.getServerManager().getDeadServers();
            Object[] deadServerNames = this.deadServers.toArray(new ServerName[this.deadServers.size()]);
            Arrays.sort(deadServerNames);
            for (Object deadServerName : deadServerNames) {
                jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(deadServerName), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath((ServerName)deadServerName)), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
            Escaping.NONE.write(StandardEmitter.valueOf(this.deadServers.size()), jamonWriter);
            jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__peerConfigs(Writer jamonWriter) throws IOException {
        List<ReplicationPeerDescription> peers = null;
        if (this.master.getReplicationPeerManager() != null) {
            peers = this.master.getReplicationPeerManager().listPeers(null);
        }
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Endpoint</th>\n        <th>State</th>\n        <th>IsSerial</th>\n        <th>Bandwidth</th>\n        <th>ReplicateAll</th>\n        <th>Namespaces</th>\n        <th>Exclude Namespaces</th>\n        <th>Table Cfs</th>\n        <th>Exclude Table Cfs</th>\n    </tr>\n");
        if (peers != null && peers.size() > 0) {
            jamonWriter.write("\n    ");
            for (ReplicationPeerDescription peer : peers) {
                jamonWriter.write("\n    ");
                String peerId = peer.getPeerId();
                ReplicationPeerConfig peerConfig = peer.getPeerConfig();
                jamonWriter.write("<tr>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peerId), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getReplicationEndpointImpl()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peer.isEnabled() ? "ENABLED" : "DISABLED"), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.isSerial()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getBandwidth() == 0L ? "UNLIMITED" : StringUtils.humanReadableInt((long)peerConfig.getBandwidth())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.replicateAllUserTables()), jamonWriter);
                jamonWriter.write("</td>\n        <td>\n           ");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getNamespaces()).replaceAll(";", "; ")), jamonWriter);
                jamonWriter.write("\n        </td>\n        <td>\n            ");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getExcludeNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeNamespaces()).replaceAll(";", "; ")), jamonWriter);
                jamonWriter.write("\n        </td>\n        <td>\n           ");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
                jamonWriter.write("\n        </td>\n        <td>\n           ");
                Escaping.NONE.write(StandardEmitter.valueOf(peerConfig.getExcludeTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
                jamonWriter.write("\n        </td>\n    </tr>\n    ");
            }
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n<tr><td>Total: ");
        Escaping.NONE.write(StandardEmitter.valueOf(peers != null ? peers.size() : 0), jamonWriter);
        jamonWriter.write("</td></tr>\n</table>\n");
    }

    private void __jamon_innerUnit__userSnapshots(Writer jamonWriter) throws IOException {
        List<SnapshotProtos.SnapshotDescription> snapshots;
        List<SnapshotProtos.SnapshotDescription> list = snapshots = this.master.isInitialized() ? this.master.getSnapshotManager().getCompletedSnapshots() : null;
        if (snapshots != null && snapshots.size() > 0) {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
            for (SnapshotProtos.SnapshotDescription snapshotDesc : snapshots) {
                jamonWriter.write("\n    ");
                TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
                jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
                jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
                jamonWriter.write("</a>\n        </td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("\n    <p>");
            Escaping.NONE.write(StandardEmitter.valueOf(snapshots.size()), jamonWriter);
            jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__userTables(Writer jamonWriter) throws IOException {
        ArrayList<TableDescriptor> tables = new ArrayList<TableDescriptor>();
        String errorMessage = MasterStatusTmplImpl.getUserTables(this.master, tables);
        if (tables.size() == 0 && errorMessage != null) {
            jamonWriter.write("\n<p> ");
            Escaping.NONE.write(StandardEmitter.valueOf(errorMessage), jamonWriter);
            jamonWriter.write(" </p>\n");
        }
        jamonWriter.write("\n\n");
        if (tables != null && tables.size() > 0) {
            jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Namespace</th>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Name</th>\n        ");
            if (this.frags != null) {
                jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
            }
            jamonWriter.write("\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">State</th>\n        <th style=\"text-align: center\" colspan=\"8\">Regions</th>\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">Description</th>\n    </tr>\n    <tr>\n        <th>OPEN</th>\n        <th>OPENING</th>\n        <th>CLOSED</th>\n        <th>CLOSING</th>\n        <th>OFFLINE</th>\n        <th>FAILED</th>\n        <th>SPLIT</th>\n        <th>Other</th>\n    </tr>\n</thead>\n<tbody>\n    ");
            for (TableDescriptor desc : tables) {
                jamonWriter.write("\n    ");
                HTableDescriptor htDesc = new HTableDescriptor(desc);
                TableName tableName = htDesc.getTableName();
                TableState tableState = this.master.getTableStateManager().getTableState(tableName);
                Map<RegionState.State, List<RegionInfo>> tableRegions = this.master.getAssignmentManager().getRegionStates().getRegionByStateOfTable(tableName);
                int openRegionsCount = tableRegions.get((Object)RegionState.State.OPEN).size();
                int openingRegionsCount = tableRegions.get((Object)RegionState.State.OPENING).size();
                int closedRegionsCount = tableRegions.get((Object)RegionState.State.CLOSED).size();
                int closingRegionsCount = tableRegions.get((Object)RegionState.State.CLOSING).size();
                int offlineRegionsCount = tableRegions.get((Object)RegionState.State.OFFLINE).size();
                int splitRegionsCount = tableRegions.get((Object)RegionState.State.SPLIT).size();
                int failedRegionsCount = tableRegions.get((Object)RegionState.State.FAILED_OPEN).size() + tableRegions.get((Object)RegionState.State.FAILED_CLOSE).size();
                int otherRegionsCount = 0;
                for (List<RegionInfo> list : tableRegions.values()) {
                    otherRegionsCount += list.size();
                }
                otherRegionsCount = otherRegionsCount - openRegionsCount - failedRegionsCount - offlineRegionsCount - splitRegionsCount - openingRegionsCount - closedRegionsCount - closingRegionsCount;
                jamonWriter.write("<tr>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
                jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
                jamonWriter.write(">");
                Escaping.NONE.write(StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
                jamonWriter.write("</a> </td>\n        ");
                if (this.frags != null) {
                    jamonWriter.write("\n            <td align=\"center\">");
                    Escaping.NONE.write(StandardEmitter.valueOf(this.frags.get(tableName.getNameAsString()) != null ? this.frags.get(tableName.getNameAsString()) + "%" : "n/a"), jamonWriter);
                    jamonWriter.write("</td>\n        ");
                }
                jamonWriter.write("\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((Object)tableState.getState()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(openRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        ");
                if (openingRegionsCount > 0) {
                    jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
                    Escaping.NONE.write(StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
                    jamonWriter.write("&state=OPENING\">");
                    Escaping.NONE.write(StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
                    jamonWriter.write("</td> ");
                } else {
                    jamonWriter.write("<td>");
                    Escaping.NONE.write(StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
                    jamonWriter.write("</td> ");
                }
                jamonWriter.write("\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        ");
                if (closingRegionsCount > 0) {
                    jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
                    Escaping.NONE.write(StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
                    jamonWriter.write("&state=CLOSING\">");
                    Escaping.NONE.write(StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
                    jamonWriter.write("</td> ");
                } else {
                    jamonWriter.write("<td>");
                    Escaping.NONE.write(StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
                    jamonWriter.write("</td> ");
                }
                jamonWriter.write("\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("\n    <p>");
            Escaping.NONE.write(StandardEmitter.valueOf(tables.size()), jamonWriter);
            jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</tbody>\n</table>\n");
        }
        jamonWriter.write("\n");
    }
}

