/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.util.LossyCounting;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetaTableMetrics
implements RegionCoprocessor {
    private ExampleRegionObserverMeta observer;
    private Map<String, Optional<Metric>> requestsMap;
    private MetricRegistry registry;
    private LossyCounting clientMetricsLossyCounting;
    private LossyCounting regionMetricsLossyCounting;
    private boolean active = false;
    private ImmutableMap<Class, MetaTableOps> opsNameMap = ImmutableMap.builder().put(Put.class, MetaTableOps.PUT).put(Get.class, MetaTableOps.GET).put(Delete.class, MetaTableOps.DELETE).build();

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this.observer);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        this.observer = new ExampleRegionObserverMeta();
        if (env instanceof RegionCoprocessorEnvironment && ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable() != null && ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable().equals(TableName.META_TABLE_NAME)) {
            RegionCoprocessorEnvironment regionCoprocessorEnv = (RegionCoprocessorEnvironment)env;
            this.registry = regionCoprocessorEnv.getMetricRegistryForRegionServer();
            this.requestsMap = new ConcurrentHashMap<String, Optional<Metric>>();
            this.clientMetricsLossyCounting = new LossyCounting("clientMetaMetrics");
            this.regionMetricsLossyCounting = new LossyCounting("regionMetaMetrics");
            this.active = true;
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
        if (this.requestsMap != null) {
            for (String meterName : this.requestsMap.keySet()) {
                this.registry.remove(meterName);
            }
        }
    }

    class ExampleRegionObserverMeta
    implements RegionCoprocessor,
    RegionObserver {
        ExampleRegionObserverMeta() {
        }

        @Override
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        @Override
        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            this.registerAndMarkMetrics(e, get);
        }

        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            this.registerAndMarkMetrics(e, put);
        }

        @Override
        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            this.registerAndMarkMetrics(e, delete);
        }

        private void registerAndMarkMetrics(ObserverContext<RegionCoprocessorEnvironment> e, Row row) {
            if (!MetaTableMetrics.this.active || !this.isMetaTableOp(e)) {
                return;
            }
            this.tableMetricRegisterAndMark(row);
            this.clientMetricRegisterAndMark();
            this.regionMetricRegisterAndMark(row);
            this.opMetricRegisterAndMark(row);
            this.opWithClientMetricRegisterAndMark(row);
        }

        private void markMeterIfPresent(String requestMeter) {
            if (requestMeter.isEmpty()) {
                return;
            }
            Optional optionalMetric = (Optional)MetaTableMetrics.this.requestsMap.get(requestMeter);
            if (optionalMetric != null && optionalMetric.isPresent()) {
                Meter metric = (Meter)optionalMetric.get();
                metric.mark();
            }
        }

        private void registerMeterIfNotPresent(String requestMeter) {
            if (requestMeter.isEmpty()) {
                return;
            }
            if (!MetaTableMetrics.this.requestsMap.containsKey(requestMeter)) {
                MetaTableMetrics.this.registry.meter(requestMeter);
                MetaTableMetrics.this.requestsMap.put(requestMeter, MetaTableMetrics.this.registry.get(requestMeter));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerLossyCountingMeterIfNotPresent(String requestMeter, LossyCounting lossyCounting) {
            if (requestMeter.isEmpty()) {
                return;
            }
            LossyCounting lossyCounting2 = lossyCounting;
            synchronized (lossyCounting2) {
                Set<String> metersToBeRemoved = lossyCounting.addByOne(requestMeter);
                boolean isNewMeter = !MetaTableMetrics.this.requestsMap.containsKey(requestMeter);
                boolean requestMeterRemoved = metersToBeRemoved.contains(requestMeter);
                if (isNewMeter) {
                    if (requestMeterRemoved) {
                        metersToBeRemoved.remove(requestMeter);
                    } else {
                        MetaTableMetrics.this.registry.meter(requestMeter);
                        MetaTableMetrics.this.requestsMap.put(requestMeter, MetaTableMetrics.this.registry.get(requestMeter));
                    }
                }
                for (String meter : metersToBeRemoved) {
                    MetaTableMetrics.this.requestsMap.remove(meter);
                    MetaTableMetrics.this.registry.remove(meter);
                }
            }
        }

        private String getTableNameFromOp(Row op) {
            String tableName = null;
            String tableRowKey = new String(op.getRow(), StandardCharsets.UTF_8);
            if (tableRowKey.isEmpty()) {
                return null;
            }
            tableName = tableRowKey.split(",").length > 0 ? tableRowKey.split(",")[0] : null;
            return tableName;
        }

        private String getRegionIdFromOp(Row op) {
            String regionId = null;
            String tableRowKey = new String(op.getRow(), StandardCharsets.UTF_8);
            if (tableRowKey.isEmpty()) {
                return null;
            }
            regionId = tableRowKey.split(",").length > 2 ? tableRowKey.split(",")[2] : null;
            return regionId;
        }

        private boolean isMetaTableOp(ObserverContext<RegionCoprocessorEnvironment> e) {
            return TableName.META_TABLE_NAME.equals(e.getEnvironment().getRegionInfo().getTable());
        }

        private void clientMetricRegisterAndMark() {
            String clientIP;
            String string = clientIP = RpcServer.getRemoteIp() != null ? RpcServer.getRemoteIp().toString() : "";
            if (clientIP == null || clientIP.isEmpty()) {
                return;
            }
            String clientRequestMeter = this.clientRequestMeterName(clientIP);
            this.registerLossyCountingMeterIfNotPresent(clientRequestMeter, MetaTableMetrics.this.clientMetricsLossyCounting);
            this.markMeterIfPresent(clientRequestMeter);
        }

        private void tableMetricRegisterAndMark(Row op) {
            String tableName = this.getTableNameFromOp(op);
            if (tableName == null || tableName.isEmpty()) {
                return;
            }
            String tableRequestMeter = this.tableMeterName(tableName);
            this.registerAndMarkMeterIfNotPresent(tableRequestMeter);
        }

        private void regionMetricRegisterAndMark(Row op) {
            String regionId = this.getRegionIdFromOp(op);
            if (regionId == null || regionId.isEmpty()) {
                return;
            }
            String regionRequestMeter = this.regionMeterName(regionId);
            this.registerLossyCountingMeterIfNotPresent(regionRequestMeter, MetaTableMetrics.this.regionMetricsLossyCounting);
            this.markMeterIfPresent(regionRequestMeter);
        }

        private void opMetricRegisterAndMark(Row op) {
            String opMeterName = this.opMeterName(op);
            if (opMeterName == null || opMeterName.isEmpty()) {
                return;
            }
            this.registerAndMarkMeterIfNotPresent(opMeterName);
        }

        private void opWithClientMetricRegisterAndMark(Object op) {
            String opWithClientMeterName = this.opWithClientMeterName(op);
            if (opWithClientMeterName == null || opWithClientMeterName.isEmpty()) {
                return;
            }
            this.registerAndMarkMeterIfNotPresent(opWithClientMeterName);
        }

        private void registerAndMarkMeterIfNotPresent(String name) {
            this.registerMeterIfNotPresent(name);
            this.markMeterIfPresent(name);
        }

        private String opWithClientMeterName(Object op) {
            String clientIP;
            String string = clientIP = RpcServer.getRemoteIp() != null ? RpcServer.getRemoteIp().toString() : "";
            if (clientIP.isEmpty()) {
                return "";
            }
            MetaTableOps ops = (MetaTableOps)((Object)MetaTableMetrics.this.opsNameMap.get(op.getClass()));
            String opWithClientMeterName = "";
            switch (ops) {
                case GET: {
                    opWithClientMeterName = String.format("MetaTable_client_%s_get_request", clientIP);
                    break;
                }
                case PUT: {
                    opWithClientMeterName = String.format("MetaTable_client_%s_put_request", clientIP);
                    break;
                }
                case DELETE: {
                    opWithClientMeterName = String.format("MetaTable_client_%s_delete_request", clientIP);
                    break;
                }
            }
            return opWithClientMeterName;
        }

        private String opMeterName(Object op) {
            MetaTableOps ops = (MetaTableOps)((Object)MetaTableMetrics.this.opsNameMap.get(op.getClass()));
            String opMeterName = "";
            switch (ops) {
                case GET: {
                    opMeterName = "MetaTable_get_request";
                    break;
                }
                case PUT: {
                    opMeterName = "MetaTable_put_request";
                    break;
                }
                case DELETE: {
                    opMeterName = "MetaTable_delete_request";
                    break;
                }
            }
            return opMeterName;
        }

        private String tableMeterName(String tableName) {
            return String.format("MetaTable_table_%s_request", tableName);
        }

        private String clientRequestMeterName(String clientIP) {
            if (clientIP.isEmpty()) {
                return "";
            }
            return String.format("MetaTable_client_%s_lossy_request", clientIP);
        }

        private String regionMeterName(String regionId) {
            return String.format("MetaTable_region_%s_lossy_request", regionId);
        }
    }

    static enum MetaTableOps {
        GET,
        PUT,
        DELETE;

    }
}

