/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemLinkResolver;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputSaslHelper;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageLite;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hbase.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.protobuf.ProtobufDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleState;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateEvent;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateHandler;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FanOutOneBlockAsyncDFSOutputHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FanOutOneBlockAsyncDFSOutputHelper.class);
    public static final String ASYNC_DFS_OUTPUT_CREATE_MAX_RETRIES = "hbase.fs.async.create.retries";
    public static final int DEFAULT_ASYNC_DFS_OUTPUT_CREATE_MAX_RETRIES = 10;
    private static final ByteBufAllocator ALLOC = PooledByteBufAllocator.DEFAULT;
    public static final long HEART_BEAT_SEQNO = -1L;
    public static final int READ_TIMEOUT = 60000;
    private static final DatanodeInfo[] EMPTY_DN_ARRAY = new DatanodeInfo[0];
    private static final LeaseManager LEASE_MANAGER;
    private static final DFSClientAdaptor DFS_CLIENT_ADAPTOR;
    private static final FileCreator FILE_CREATOR;

    private FanOutOneBlockAsyncDFSOutputHelper() {
    }

    private static DFSClientAdaptor createDFSClientAdaptor() throws NoSuchMethodException {
        final Method isClientRunningMethod = DFSClient.class.getDeclaredMethod("isClientRunning", new Class[0]);
        isClientRunningMethod.setAccessible(true);
        return new DFSClientAdaptor(){

            @Override
            public boolean isClientRunning(DFSClient client) {
                try {
                    return (Boolean)isClientRunningMethod.invoke((Object)client, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static LeaseManager createLeaseManager() throws NoSuchMethodException {
        final Method beginFileLeaseMethod = DFSClient.class.getDeclaredMethod("beginFileLease", Long.TYPE, DFSOutputStream.class);
        beginFileLeaseMethod.setAccessible(true);
        final Method endFileLeaseMethod = DFSClient.class.getDeclaredMethod("endFileLease", Long.TYPE);
        endFileLeaseMethod.setAccessible(true);
        return new LeaseManager(){

            @Override
            public void begin(DFSClient client, long inodeId) {
                try {
                    beginFileLeaseMethod.invoke((Object)client, inodeId, null);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void end(DFSClient client, long inodeId) {
                try {
                    endFileLeaseMethod.invoke((Object)client, inodeId);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static FileCreator createFileCreator3() throws NoSuchMethodException {
        Method createMethod = ClientProtocol.class.getMethod("create", String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class, String.class);
        return (instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions) -> (HdfsFileStatus)createMethod.invoke((Object)instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions, null);
    }

    private static FileCreator createFileCreator2() throws NoSuchMethodException {
        Method createMethod = ClientProtocol.class.getMethod("create", String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class);
        return (instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions) -> (HdfsFileStatus)createMethod.invoke((Object)instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions);
    }

    private static FileCreator createFileCreator() throws NoSuchMethodException {
        try {
            return FanOutOneBlockAsyncDFSOutputHelper.createFileCreator3();
        }
        catch (NoSuchMethodException e) {
            LOG.debug("ClientProtocol::create wrong number of arguments, should be hadoop 2.x");
            return FanOutOneBlockAsyncDFSOutputHelper.createFileCreator2();
        }
    }

    static void beginFileLease(DFSClient client, long inodeId) {
        LEASE_MANAGER.begin(client, inodeId);
    }

    static void endFileLease(DFSClient client, long inodeId) {
        LEASE_MANAGER.end(client, inodeId);
    }

    static DataChecksum createChecksum(DFSClient client) {
        return client.getConf().createChecksum(null);
    }

    static DataTransferProtos.Status getStatus(DataTransferProtos.PipelineAckProto ack) {
        Integer headerFlag;
        List flagList = ack.getFlagList();
        if (flagList.isEmpty()) {
            DataTransferProtos.Status reply = ack.getReply(0);
            headerFlag = PipelineAck.combineHeader((PipelineAck.ECN)PipelineAck.ECN.DISABLED, (DataTransferProtos.Status)reply);
        } else {
            headerFlag = (Integer)flagList.get(0);
        }
        return PipelineAck.getStatusFromHeader((int)headerFlag);
    }

    private static void processWriteBlockResponse(Channel channel, final DatanodeInfo dnInfo, final Promise<Channel> promise, final int timeoutMs) {
        channel.pipeline().addLast(new IdleStateHandler(timeoutMs, 0L, 0L, TimeUnit.MILLISECONDS), new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)DataTransferProtos.BlockOpResponseProto.getDefaultInstance()), new SimpleChannelInboundHandler<DataTransferProtos.BlockOpResponseProto>(){

            @Override
            protected void channelRead0(ChannelHandlerContext ctx, DataTransferProtos.BlockOpResponseProto resp) throws Exception {
                ChannelHandler handler;
                DataTransferProtos.Status pipelineStatus = resp.getStatus();
                if (PipelineAck.isRestartOOBStatus((DataTransferProtos.Status)pipelineStatus)) {
                    throw new IOException("datanode " + dnInfo + " is restarting");
                }
                String logInfo = "ack with firstBadLink as " + resp.getFirstBadLink();
                if (resp.getStatus() != DataTransferProtos.Status.SUCCESS) {
                    if (resp.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                        throw new InvalidBlockTokenException("Got access token error, status message " + resp.getMessage() + ", " + logInfo);
                    }
                    throw new IOException("Got error, status=" + resp.getStatus().name() + ", status message " + resp.getMessage() + ", " + logInfo);
                }
                ChannelPipeline p = ctx.pipeline();
                while ((handler = p.removeLast()) != null && !(handler instanceof IdleStateHandler)) {
                }
                ctx.channel().config().setAutoRead(false);
                promise.trySuccess(ctx.channel());
            }

            @Override
            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                promise.tryFailure(new IOException("connection to " + dnInfo + " is closed"));
            }

            @Override
            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                    promise.tryFailure(new IOException("Timeout(" + timeoutMs + "ms) waiting for response"));
                } else {
                    super.userEventTriggered(ctx, evt);
                }
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                promise.tryFailure(cause);
            }
        });
    }

    private static void requestWriteBlock(Channel channel, StorageType storageType, DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder) throws IOException {
        DataTransferProtos.OpWriteBlockProto proto = writeBlockProtoBuilder.setStorageType(PBHelperClient.convertStorageType((StorageType)storageType)).build();
        int protoLen = proto.getSerializedSize();
        ByteBuf buffer = channel.alloc().buffer(3 + CodedOutputStream.computeRawVarint32Size(protoLen) + protoLen);
        buffer.writeShort(28);
        buffer.writeByte(Op.WRITE_BLOCK.code);
        proto.writeDelimitedTo((OutputStream)new ByteBufOutputStream(buffer));
        channel.writeAndFlush(buffer);
    }

    private static void initialize(Configuration conf, final Channel channel, final DatanodeInfo dnInfo, final StorageType storageType, final DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder, final int timeoutMs, DFSClient client, Token<BlockTokenIdentifier> accessToken, final Promise<Channel> promise) throws IOException {
        Promise<Void> saslPromise = channel.eventLoop().newPromise();
        FanOutOneBlockAsyncDFSOutputSaslHelper.trySaslNegotiate(conf, channel, dnInfo, timeoutMs, client, accessToken, saslPromise);
        saslPromise.addListener((GenericFutureListener<Future<Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isSuccess()) {
                    FanOutOneBlockAsyncDFSOutputHelper.processWriteBlockResponse(channel, dnInfo, promise, timeoutMs);
                    FanOutOneBlockAsyncDFSOutputHelper.requestWriteBlock(channel, storageType, writeBlockProtoBuilder);
                } else {
                    promise.tryFailure(future.cause());
                }
            }
        });
    }

    private static List<Future<Channel>> connectToDataNodes(final Configuration conf, final DFSClient client, String clientName, final LocatedBlock locatedBlock, long maxBytesRcvd, long latestGS, BlockConstructionStage stage, DataChecksum summer, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        StorageType[] storageTypes = locatedBlock.getStorageTypes();
        DatanodeInfo[] datanodeInfos = locatedBlock.getLocations();
        boolean connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        final int timeoutMs = conf.getInt("dfs.client.socket-timeout", 60000);
        ExtendedBlock blockCopy = new ExtendedBlock(locatedBlock.getBlock());
        blockCopy.setNumBytes(locatedBlock.getBlockSize());
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(PBHelperClient.convert((ExtendedBlock)blockCopy)).setToken(PBHelperClient.convert((Token)locatedBlock.getBlockToken()))).setClientName(clientName).build();
        DataTransferProtos.ChecksumProto checksumProto = DataTransferProtoUtil.toProto((DataChecksum)summer);
        final DataTransferProtos.OpWriteBlockProto.Builder writeBlockProtoBuilder = DataTransferProtos.OpWriteBlockProto.newBuilder().setHeader(header).setStage(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf((String)stage.name())).setPipelineSize(1).setMinBytesRcvd(locatedBlock.getBlock().getNumBytes()).setMaxBytesRcvd(maxBytesRcvd).setLatestGenerationStamp(latestGS).setRequestedChecksum(checksumProto).setCachingStrategy(DataTransferProtos.CachingStrategyProto.newBuilder().setDropBehind(true).build());
        ArrayList<Future<Channel>> futureList = new ArrayList<Future<Channel>>(datanodeInfos.length);
        for (int i = 0; i < datanodeInfos.length; ++i) {
            final DatanodeInfo dnInfo = datanodeInfos[i];
            final StorageType storageType = storageTypes[i];
            final Promise promise = eventLoopGroup.next().newPromise();
            futureList.add(promise);
            String dnAddr = dnInfo.getXferAddr(connectToDnViaHostname);
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(channelClass)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, timeoutMs)).handler(new ChannelInitializer<Channel>(){

                @Override
                protected void initChannel(Channel ch) throws Exception {
                }
            })).connect(NetUtils.createSocketAddr((String)dnAddr)).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        FanOutOneBlockAsyncDFSOutputHelper.initialize(conf, future.channel(), dnInfo, storageType, writeBlockProtoBuilder, timeoutMs, client, (Token<BlockTokenIdentifier>)locatedBlock.getBlockToken(), promise);
                    } else {
                        promise.tryFailure(future.cause());
                    }
                }
            });
        }
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private static FanOutOneBlockAsyncDFSOutput createOutput(DistributedFileSystem dfs, String src, boolean overwrite, boolean createParent, short replication, long blockSize, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws IOException {
        Configuration conf = dfs.getConf();
        FSUtils fsUtils = FSUtils.getInstance((FileSystem)dfs, conf);
        DFSClient client = dfs.getClient();
        String clientName = client.getClientName();
        ClientProtocol namenode = client.getNamenode();
        int createMaxRetries = conf.getInt(ASYNC_DFS_OUTPUT_CREATE_MAX_RETRIES, 10);
        DatanodeInfo[] excludesNodes = EMPTY_DN_ARRAY;
        int retry = 0;
        while (true) {
            block27: {
                FanOutOneBlockAsyncDFSOutput fanOutOneBlockAsyncDFSOutput;
                block25: {
                    HdfsFileStatus stat;
                    block26: {
                        try {
                            stat = FILE_CREATOR.create(namenode, src, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE)), createParent, replication, blockSize, CryptoProtocolVersion.supported());
                        }
                        catch (Exception e) {
                            if (e instanceof RemoteException) {
                                throw (RemoteException)((Object)e);
                            }
                            throw new NameNodeException(e);
                        }
                        FanOutOneBlockAsyncDFSOutputHelper.beginFileLease(client, stat.getFileId());
                        boolean succ = false;
                        LocatedBlock locatedBlock = null;
                        List<Future<Channel>> futureList = null;
                        try {
                            DataChecksum summer = FanOutOneBlockAsyncDFSOutputHelper.createChecksum(client);
                            locatedBlock = namenode.addBlock(src, client.getClientName(), null, excludesNodes, stat.getFileId(), null, null);
                            ArrayList<Channel> datanodeList = new ArrayList<Channel>();
                            futureList = FanOutOneBlockAsyncDFSOutputHelper.connectToDataNodes(conf, client, clientName, locatedBlock, 0L, 0L, BlockConstructionStage.PIPELINE_SETUP_CREATE, summer, eventLoopGroup, channelClass);
                            int n = futureList.size();
                            for (int i = 0; i < n; ++i) {
                                try {
                                    datanodeList.add(futureList.get(i).syncUninterruptibly().getNow());
                                    continue;
                                }
                                catch (Exception e) {
                                    excludesNodes = ArrayUtils.add(excludesNodes, locatedBlock.getLocations()[i]);
                                    throw e;
                                }
                            }
                            Encryptor encryptor = FanOutOneBlockAsyncDFSOutputSaslHelper.createEncryptor(conf, stat, client);
                            FanOutOneBlockAsyncDFSOutput output = new FanOutOneBlockAsyncDFSOutput(conf, fsUtils, dfs, client, namenode, clientName, src, stat.getFileId(), locatedBlock, encryptor, datanodeList, summer, ALLOC);
                            succ = true;
                            fanOutOneBlockAsyncDFSOutput = output;
                            if (succ) break block25;
                            if (futureList == null) break block26;
                        }
                        catch (RemoteException e) {
                            block28: {
                                LOG.warn("create fan-out dfs output {} failed, retry = {}", new Object[]{src, retry, e});
                                if (FanOutOneBlockAsyncDFSOutputHelper.shouldRetryCreate(e)) {
                                    if (retry >= createMaxRetries) {
                                        throw e.unwrapRemoteException();
                                    }
                                } else {
                                    throw e.unwrapRemoteException();
                                }
                                if (succ) break block27;
                                if (futureList == null) break block28;
                                for (Future<Channel> f : futureList) {
                                    f.addListener((GenericFutureListener<Future<Channel>>)new FutureListener<Channel>(){

                                        @Override
                                        public void operationComplete(Future<Channel> future) throws Exception {
                                            if (future.isSuccess()) {
                                                future.getNow().close();
                                            }
                                        }
                                    });
                                }
                            }
                            FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, stat.getFileId());
                        }
                        catch (IOException e2) {
                            block29: {
                                LOG.warn("create fan-out dfs output {} failed, retry = {}", new Object[]{src, retry, e2});
                                if (retry >= createMaxRetries) {
                                    throw e2;
                                }
                                overwrite = true;
                                try {
                                    Thread.sleep(ConnectionUtils.getPauseTime(100L, retry));
                                }
                                catch (InterruptedException ie) {
                                    throw new InterruptedIOException();
                                }
                                if (succ) break block27;
                                if (futureList == null) break block29;
                                for (Future<Channel> f : futureList) {
                                    f.addListener((GenericFutureListener<Future<Channel>>)new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, stat.getFileId());
                            {
                                catch (Throwable throwable) {
                                    if (!succ) {
                                        if (futureList != null) {
                                            for (Future f : futureList) {
                                                f.addListener(new /* invalid duplicate definition of identical inner class */);
                                            }
                                        }
                                        FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, stat.getFileId());
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        for (Future<Channel> f : futureList) {
                            f.addListener((GenericFutureListener<Future<Channel>>)new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, stat.getFileId());
                }
                return fanOutOneBlockAsyncDFSOutput;
            }
            ++retry;
        }
    }

    public static FanOutOneBlockAsyncDFSOutput createOutput(final DistributedFileSystem dfs, Path f, final boolean overwrite, final boolean createParent, final short replication, final long blockSize, final EventLoopGroup eventLoopGroup, final Class<? extends Channel> channelClass) throws IOException {
        return (FanOutOneBlockAsyncDFSOutput)new FileSystemLinkResolver<FanOutOneBlockAsyncDFSOutput>(){

            public FanOutOneBlockAsyncDFSOutput doCall(Path p) throws IOException, UnresolvedLinkException {
                return FanOutOneBlockAsyncDFSOutputHelper.createOutput(dfs, p.toUri().getPath(), overwrite, createParent, replication, blockSize, eventLoopGroup, (Class<? extends Channel>)channelClass);
            }

            public FanOutOneBlockAsyncDFSOutput next(FileSystem fs, Path p) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.resolve((FileSystem)dfs, f);
    }

    public static boolean shouldRetryCreate(RemoteException e) {
        return e.getClassName().endsWith("RetryStartFileException");
    }

    static void completeFile(DFSClient client, ClientProtocol namenode, String src, String clientName, ExtendedBlock block, long fileId) {
        int retry = 0;
        while (true) {
            try {
                if (namenode.complete(src, clientName, block, fileId)) {
                    FanOutOneBlockAsyncDFSOutputHelper.endFileLease(client, fileId);
                    return;
                }
                LOG.warn("complete file " + src + " not finished, retry = " + retry);
            }
            catch (RemoteException e) {
                IOException ioe = e.unwrapRemoteException();
                if (ioe instanceof LeaseExpiredException) {
                    LOG.warn("lease for file " + src + " is expired, give up", (Throwable)e);
                    return;
                }
                LOG.warn("complete file " + src + " failed, retry = " + retry, (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("complete file " + src + " failed, retry = " + retry, (Throwable)e);
            }
            FanOutOneBlockAsyncDFSOutputHelper.sleepIgnoreInterrupt(retry);
            ++retry;
        }
    }

    static void sleepIgnoreInterrupt(int retry) {
        try {
            Thread.sleep(ConnectionUtils.getPauseTime(100L, retry));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        try {
            LEASE_MANAGER = FanOutOneBlockAsyncDFSOutputHelper.createLeaseManager();
            DFS_CLIENT_ADAPTOR = FanOutOneBlockAsyncDFSOutputHelper.createDFSClientAdaptor();
            FILE_CREATOR = FanOutOneBlockAsyncDFSOutputHelper.createFileCreator();
        }
        catch (Exception e) {
            String msg = "Couldn't properly initialize access to HDFS internals. Please update your WAL Provider to not make use of the 'asyncfs' provider. See HBASE-16110 for more information.";
            LOG.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    public static class NameNodeException
    extends IOException {
        private static final long serialVersionUID = 3143237406477095390L;

        public NameNodeException(Throwable cause) {
            super(cause);
        }
    }

    static final class CancelOnClose
    implements CancelableProgressable {
        private final DFSClient client;

        public CancelOnClose(DFSClient client) {
            this.client = client;
        }

        @Override
        public boolean progress() {
            return DFS_CLIENT_ADAPTOR.isClientRunning(this.client);
        }
    }

    private static interface FileCreator {
        default public HdfsFileStatus create(ClientProtocol instance, String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws Exception {
            try {
                return (HdfsFileStatus)this.createObject(instance, src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        public Object createObject(ClientProtocol var1, String var2, FsPermission var3, String var4, EnumSetWritable<CreateFlag> var5, boolean var6, short var7, long var8, CryptoProtocolVersion[] var10) throws Exception;
    }

    private static interface DFSClientAdaptor {
        public boolean isClientRunning(DFSClient var1);
    }

    private static interface LeaseManager {
        public void begin(DFSClient var1, long var2);

        public void end(DFSClient var1, long var2);
    }
}

