/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import java.io.IOException;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.policies.DefaultViolationPolicyEnforcement;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DisableTableViolationPolicyEnforcement
extends DefaultViolationPolicyEnforcement {
    private static final Logger LOG = LoggerFactory.getLogger(DisableTableViolationPolicyEnforcement.class);

    @Override
    public void enable() throws IOException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Starting disable of " + this.getTableName());
            }
            this.getRegionServerServices().getClusterConnection().getAdmin().disableTable(this.getTableName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Disable is complete for " + this.getTableName());
            }
        }
        catch (TableNotEnabledException tableNotEnabledException) {
            // empty catch block
        }
    }

    @Override
    public void disable() throws IOException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Starting enable of " + this.getTableName());
            }
            this.getRegionServerServices().getClusterConnection().getAdmin().enableTable(this.getTableName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Enable is complete for " + this.getTableName());
            }
        }
        catch (TableNotDisabledException | TableNotFoundException doNotRetryIOException) {
            // empty catch block
        }
    }

    @Override
    public void check(Mutation m) throws SpaceLimitingException {
        throw new SpaceLimitingException(this.getPolicyName(), "This table is disabled due to violating a space quota.");
    }

    @Override
    public String getPolicyName() {
        return SpaceViolationPolicy.DISABLE.name();
    }
}

