/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatencies;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerTableMetrics {
    private final MetricsTableLatencies latencies = CompatibilitySingletonFactory.getInstance(MetricsTableLatencies.class);

    public void updatePut(TableName table, long time) {
        this.latencies.updatePut(table.getNameAsString(), time);
    }

    public void updatePutBatch(TableName table, long time) {
        this.latencies.updatePutBatch(table.getNameAsString(), time);
    }

    public void updateGet(TableName table, long time) {
        this.latencies.updateGet(table.getNameAsString(), time);
    }

    public void updateIncrement(TableName table, long time) {
        this.latencies.updateIncrement(table.getNameAsString(), time);
    }

    public void updateAppend(TableName table, long time) {
        this.latencies.updateAppend(table.getNameAsString(), time);
    }

    public void updateDelete(TableName table, long time) {
        this.latencies.updateDelete(table.getNameAsString(), time);
    }

    public void updateDeleteBatch(TableName table, long time) {
        this.latencies.updateDeleteBatch(table.getNameAsString(), time);
    }

    public void updateScanTime(TableName table, long time) {
        this.latencies.updateScanTime(table.getNameAsString(), time);
    }

    public void updateScanSize(TableName table, long size) {
        this.latencies.updateScanSize(table.getNameAsString(), size);
    }
}

