/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerRequestDecoder
extends ChannelInboundHandlerAdapter {
    private final ChannelGroup allChannels;
    private final MetricsHBaseServer metrics;
    private NettyServerRpcConnection connection;

    public NettyRpcServerRequestDecoder(ChannelGroup allChannels, MetricsHBaseServer metrics) {
        this.allChannels = allChannels;
        this.metrics = metrics;
    }

    void setConnection(NettyServerRpcConnection connection) {
        this.connection = connection;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add(ctx.channel());
        NettyRpcServer.LOG.trace("Connection {}; # active connections={}", (Object)ctx.channel().remoteAddress(), (Object)(this.allChannels.size() - 1));
        super.channelActive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf input = (ByteBuf)msg;
        this.metrics.receivedBytes(input.readableBytes() + 4);
        this.connection.process(input);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.remove(ctx.channel());
        NettyRpcServer.LOG.trace("Disconnection {}; # active connections={}", (Object)ctx.channel().remoteAddress(), (Object)(this.allChannels.size() - 1));
        super.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        this.allChannels.remove(ctx.channel());
        NettyRpcServer.LOG.trace("Connection {}; caught unexpected downstream exception.", (Object)ctx.channel().remoteAddress(), (Object)e.getCause());
        ctx.channel().close();
    }
}

