/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class SortedCompactionPolicy
extends CompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SortedCompactionPolicy.class);
    private final Random random = new Random();

    public SortedCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    public List<HStoreFile> preSelectCompactionForCoprocessor(Collection<HStoreFile> candidates, List<HStoreFile> filesCompacting) {
        return this.getCurrentEligibleFiles(new ArrayList<HStoreFile>(candidates), filesCompacting);
    }

    public CompactionRequestImpl selectCompaction(Collection<HStoreFile> candidateFiles, List<HStoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
        boolean isAllFiles;
        ArrayList<HStoreFile> candidateSelection = new ArrayList<HStoreFile>(candidateFiles);
        int futureFiles = filesCompacting.isEmpty() ? 0 : 1;
        boolean mayBeStuck = (long)(candidateFiles.size() - filesCompacting.size() + futureFiles) >= this.storeConfigInfo.getBlockingFileCount();
        candidateSelection = this.getCurrentEligibleFiles(candidateSelection, filesCompacting);
        LOG.debug("Selecting compaction from " + candidateFiles.size() + " store files, " + filesCompacting.size() + " compacting, " + candidateSelection.size() + " eligible, " + this.storeConfigInfo.getBlockingFileCount() + " blocking");
        boolean bl = isAllFiles = candidateFiles.size() == candidateSelection.size();
        if (!forceMajor || !isAllFiles) {
            candidateSelection = this.skipLargeFiles(candidateSelection, mayUseOffPeak);
            isAllFiles = candidateFiles.size() == candidateSelection.size();
        }
        boolean isTryingMajor = forceMajor && isAllFiles && isUserCompaction || (forceMajor && isAllFiles || this.shouldPerformMajorCompaction(candidateSelection)) && candidateSelection.size() < this.comConf.getMaxFilesToCompact();
        boolean isAfterSplit = StoreUtils.hasReferences(candidateSelection);
        CompactionRequestImpl result = this.createCompactionRequest(candidateSelection, isTryingMajor || isAfterSplit, mayUseOffPeak, mayBeStuck);
        ArrayList<HStoreFile> filesToCompact = Lists.newArrayList(result.getFiles());
        this.removeExcessFiles(filesToCompact, isUserCompaction, isTryingMajor);
        result.updateFiles(filesToCompact);
        isAllFiles = candidateFiles.size() == filesToCompact.size();
        result.setOffPeak(!filesToCompact.isEmpty() && !isAllFiles && mayUseOffPeak);
        result.setIsMajor(isTryingMajor && isAllFiles, isAllFiles);
        return result;
    }

    protected abstract CompactionRequestImpl createCompactionRequest(ArrayList<HStoreFile> var1, boolean var2, boolean var3, boolean var4) throws IOException;

    @Override
    public abstract boolean shouldPerformMajorCompaction(Collection<HStoreFile> var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextMajorCompactTime(Collection<HStoreFile> filesToCompact) {
        long period = this.comConf.getMajorCompactionPeriod();
        if (period <= 0L) {
            return period;
        }
        double jitterPct = this.comConf.getMajorCompactionJitter();
        if (jitterPct <= 0.0) {
            return period;
        }
        OptionalInt seed = StoreUtils.getDeterministicRandomSeed(filesToCompact);
        if (seed.isPresent()) {
            double rnd;
            SortedCompactionPolicy sortedCompactionPolicy = this;
            synchronized (sortedCompactionPolicy) {
                this.random.setSeed(seed.getAsInt());
                rnd = this.random.nextDouble();
            }
            long jitter = Math.round((double)period * jitterPct);
            return period + jitter - Math.round((double)(2L * jitter) * rnd);
        }
        return 0L;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return compactionSize > this.comConf.getThrottlePoint();
    }

    public abstract boolean needsCompaction(Collection<HStoreFile> var1, List<HStoreFile> var2);

    protected ArrayList<HStoreFile> getCurrentEligibleFiles(ArrayList<HStoreFile> candidateFiles, List<HStoreFile> filesCompacting) {
        if (!filesCompacting.isEmpty()) {
            HStoreFile last = filesCompacting.get(filesCompacting.size() - 1);
            int idx = candidateFiles.indexOf(last);
            Preconditions.checkArgument(idx != -1);
            candidateFiles.subList(0, idx + 1).clear();
        }
        return candidateFiles;
    }

    protected ArrayList<HStoreFile> skipLargeFiles(ArrayList<HStoreFile> candidates, boolean mayUseOffpeak) {
        int pos;
        for (pos = 0; pos < candidates.size() && !candidates.get(pos).isReference() && candidates.get(pos).getReader().length() > this.comConf.getMaxCompactSize(mayUseOffpeak); ++pos) {
        }
        if (pos > 0) {
            LOG.debug("Some files are too large. Excluding " + pos + " files from compaction candidates");
            candidates.subList(0, pos).clear();
        }
        return candidates;
    }

    protected void filterBulk(ArrayList<HStoreFile> candidates) {
        candidates.removeIf(HStoreFile::excludeFromMinorCompaction);
    }

    protected void removeExcessFiles(ArrayList<HStoreFile> candidates, boolean isUserCompaction, boolean isMajorCompaction) {
        int excess = candidates.size() - this.comConf.getMaxFilesToCompact();
        if (excess > 0) {
            if (isMajorCompaction && isUserCompaction) {
                LOG.debug("Warning, compacting more than " + this.comConf.getMaxFilesToCompact() + " files because of a user-requested major compaction");
            } else {
                LOG.debug("Too many admissible files. Excluding " + excess + " files from compaction candidates");
                candidates.subList(this.comConf.getMaxFilesToCompact(), candidates.size()).clear();
            }
        }
    }

    protected ArrayList<HStoreFile> checkMinFilesCriteria(ArrayList<HStoreFile> candidates, int minFiles) {
        if (candidates.size() < minFiles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not compacting files because we only have " + candidates.size() + " files ready for compaction. Need " + minFiles + " to initiate.");
            }
            candidates.clear();
        }
        return candidates;
    }
}

