/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ZKReplicationStorageBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ZKReplicationQueueStorage
extends ZKReplicationStorageBase
implements ReplicationQueueStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ZKReplicationQueueStorage.class);
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY = "zookeeper.znode.replication.hfile.refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT = "hfile-refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_REGIONS_KEY = "zookeeper.znode.replication.regions";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_REGIONS_DEFAULT = "regions";
    private final String queuesZNode;
    private final String hfileRefsZNode;
    @VisibleForTesting
    final String regionsZNode;

    public ZKReplicationQueueStorage(ZKWatcher zookeeper, Configuration conf) {
        super(zookeeper, conf);
        String queuesZNodeName = conf.get("zookeeper.znode.replication.rs", "rs");
        String hfileRefsZNodeName = conf.get(ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY, ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT);
        this.queuesZNode = ZNodePaths.joinZNode(this.replicationZNode, queuesZNodeName);
        this.hfileRefsZNode = ZNodePaths.joinZNode(this.replicationZNode, hfileRefsZNodeName);
        this.regionsZNode = ZNodePaths.joinZNode(this.replicationZNode, conf.get(ZOOKEEPER_ZNODE_REPLICATION_REGIONS_KEY, ZOOKEEPER_ZNODE_REPLICATION_REGIONS_DEFAULT));
    }

    @Override
    public String getRsNode(ServerName serverName) {
        return ZNodePaths.joinZNode(this.queuesZNode, serverName.getServerName());
    }

    private String getQueueNode(ServerName serverName, String queueId) {
        return ZNodePaths.joinZNode(this.getRsNode(serverName), queueId);
    }

    private String getFileNode(String queueNode, String fileName) {
        return ZNodePaths.joinZNode(queueNode, fileName);
    }

    private String getFileNode(ServerName serverName, String queueId, String fileName) {
        return this.getFileNode(this.getQueueNode(serverName, queueId), fileName);
    }

    @VisibleForTesting
    String getSerialReplicationRegionPeerNode(String encodedRegionName, String peerId) {
        if (encodedRegionName == null || encodedRegionName.length() != 32) {
            throw new IllegalArgumentException("Invalid encoded region name: " + encodedRegionName + ", length should be 32.");
        }
        return new StringBuilder(this.regionsZNode).append('/').append(encodedRegionName, 0, 2).append('/').append(encodedRegionName, 2, 4).append('/').append(encodedRegionName, 4, encodedRegionName.length()).append("-").append(peerId).toString();
    }

    @Override
    public void removeQueue(ServerName serverName, String queueId) throws ReplicationException {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.getQueueNode(serverName, queueId));
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to delete queue (serverName=" + serverName + ", queueId=" + queueId + ")", e);
        }
    }

    @Override
    public void addWAL(ServerName serverName, String queueId, String fileName) throws ReplicationException {
        try {
            ZKUtil.createWithParents(this.zookeeper, this.getFileNode(serverName, queueId, fileName));
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to add wal to queue (serverName=" + serverName + ", queueId=" + queueId + ", fileName=" + fileName + ")", e);
        }
    }

    @Override
    public void removeWAL(ServerName serverName, String queueId, String fileName) throws ReplicationException {
        String fileNode = this.getFileNode(serverName, queueId, fileName);
        try {
            ZKUtil.deleteNode(this.zookeeper, fileNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn("{} already deleted when removing log", (Object)fileNode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to remove wal from queue (serverName=" + serverName + ", queueId=" + queueId + ", fileName=" + fileName + ")", e);
        }
    }

    private void addLastSeqIdsToOps(String queueId, Map<String, Long> lastSeqIds, List<ZKUtil.ZKUtilOp> listOfOps) throws KeeperException, ReplicationException {
        String peerId = new ReplicationQueueInfo(queueId).getPeerId();
        for (Map.Entry<String, Long> lastSeqEntry : lastSeqIds.entrySet()) {
            String path = this.getSerialReplicationRegionPeerNode(lastSeqEntry.getKey(), peerId);
            Pair<Long, Integer> p = this.getLastSequenceIdWithVersion(lastSeqEntry.getKey(), peerId);
            byte[] data = ZKUtil.positionToByteArray(lastSeqEntry.getValue());
            if (p.getSecond() < 0) {
                ZKUtil.createWithParents(this.zookeeper, path.substring(0, path.lastIndexOf(47)));
                listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(path, data));
                continue;
            }
            int v0 = p.getSecond();
            long lastPushedSeqId = p.getFirst();
            if (lastSeqEntry.getValue() <= lastPushedSeqId) continue;
            listOfOps.add(ZKUtil.ZKUtilOp.setData(path, data, v0));
        }
    }

    @Override
    public void setWALPosition(ServerName serverName, String queueId, String fileName, long position, Map<String, Long> lastSeqIds) throws ReplicationException {
        try {
            int retry = 0;
            while (true) {
                ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
                if (position > 0L) {
                    listOfOps.add(ZKUtil.ZKUtilOp.setData(this.getFileNode(serverName, queueId, fileName), ZKUtil.positionToByteArray(position)));
                }
                this.addLastSeqIdsToOps(queueId, lastSeqIds, listOfOps);
                if (listOfOps.isEmpty()) {
                    return;
                }
                try {
                    ZKUtil.multiOrSequential(this.zookeeper, listOfOps, false);
                    return;
                }
                catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                    LOG.warn("Bad version(or node exist) when persist the last pushed sequence id to zookeeper storage, Retry = " + retry + ", serverName=" + serverName + ", queueId=" + queueId + ", fileName=" + fileName);
                    ++retry;
                    continue;
                }
                break;
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to set log position (serverName=" + serverName + ", queueId=" + queueId + ", fileName=" + fileName + ", position=" + position + ")", e);
        }
    }

    @VisibleForTesting
    protected Pair<Long, Integer> getLastSequenceIdWithVersion(String encodedRegionName, String peerId) throws KeeperException {
        Stat stat = new Stat();
        String path = this.getSerialReplicationRegionPeerNode(encodedRegionName, peerId);
        byte[] data = ZKUtil.getDataNoWatch(this.zookeeper, path, stat);
        if (data == null) {
            return Pair.newPair(-1L, -1);
        }
        try {
            return Pair.newPair(ZKUtil.parseWALPositionFrom(data), stat.getVersion());
        }
        catch (DeserializationException de) {
            LOG.warn("Failed to parse log position (region=" + encodedRegionName + ", peerId=" + peerId + "), data=" + Bytes.toStringBinary(data));
            return Pair.newPair(-1L, stat.getVersion());
        }
    }

    @Override
    public long getLastSequenceId(String encodedRegionName, String peerId) throws ReplicationException {
        try {
            return this.getLastSequenceIdWithVersion(encodedRegionName, peerId).getFirst();
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get last pushed sequence id (encodedRegionName=" + encodedRegionName + ", peerId=" + peerId + ")", e);
        }
    }

    @Override
    public void setLastSequenceIds(String peerId, Map<String, Long> lastSeqIds) throws ReplicationException {
        try {
            ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
            for (Map.Entry<String, Long> lastSeqEntry : lastSeqIds.entrySet()) {
                String path = this.getSerialReplicationRegionPeerNode(lastSeqEntry.getKey(), peerId);
                ZKUtil.createWithParents(this.zookeeper, path);
                listOfOps.add(ZKUtil.ZKUtilOp.setData(path, ZKUtil.positionToByteArray(lastSeqEntry.getValue())));
            }
            if (!listOfOps.isEmpty()) {
                ZKUtil.multiOrSequential(this.zookeeper, listOfOps, true);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to set last sequence ids, peerId=" + peerId + ", size of lastSeqIds=" + lastSeqIds.size(), e);
        }
    }

    @Override
    public void removeLastSequenceIds(String peerId) throws ReplicationException {
        String suffix = "-" + peerId;
        try {
            StringBuilder sb = new StringBuilder(this.regionsZNode);
            int regionsZNodeLength = this.regionsZNode.length();
            int levelOneLength = regionsZNodeLength + 3;
            int levelTwoLength = levelOneLength + 3;
            List<String> levelOneDirs = ZKUtil.listChildrenNoWatch(this.zookeeper, this.regionsZNode);
            if (CollectionUtils.isEmpty(levelOneDirs)) {
                return;
            }
            for (String levelOne : levelOneDirs) {
                sb.append('/').append(levelOne);
                for (String levelTwo : ZKUtil.listChildrenNoWatch(this.zookeeper, sb.toString())) {
                    sb.append('/').append(levelTwo);
                    for (String znode : ZKUtil.listChildrenNoWatch(this.zookeeper, sb.toString())) {
                        if (!znode.endsWith(suffix)) continue;
                        sb.append('/').append(znode);
                        ZKUtil.deleteNode(this.zookeeper, sb.toString());
                        sb.setLength(levelTwoLength);
                    }
                    sb.setLength(levelOneLength);
                }
                sb.setLength(regionsZNodeLength);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to remove all last sequence ids, peerId=" + peerId, e);
        }
    }

    @Override
    public void removeLastSequenceIds(String peerId, List<String> encodedRegionNames) throws ReplicationException {
        try {
            List<ZKUtil.ZKUtilOp> listOfOps = encodedRegionNames.stream().map(n -> this.getSerialReplicationRegionPeerNode((String)n, peerId)).map(ZKUtil.ZKUtilOp::deleteNodeFailSilent).collect(Collectors.toList());
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, true);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to remove last sequence ids, peerId=" + peerId + ", encodedRegionNames.size=" + encodedRegionNames.size(), e);
        }
    }

    @Override
    public long getWALPosition(ServerName serverName, String queueId, String fileName) throws ReplicationException {
        byte[] bytes;
        try {
            bytes = ZKUtil.getData(this.zookeeper, this.getFileNode(serverName, queueId, fileName));
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Failed to get log position (serverName=" + serverName + ", queueId=" + queueId + ", fileName=" + fileName + ")", e);
        }
        try {
            return ZKUtil.parseWALPositionFrom(bytes);
        }
        catch (DeserializationException de) {
            LOG.warn("Failed parse log position (serverName={}, queueId={}, fileName={})", new Object[]{serverName, queueId, fileName});
            return 0L;
        }
    }

    @Override
    public Pair<String, SortedSet<String>> claimQueue(ServerName sourceServerName, String queueId, ServerName destServerName) throws ReplicationException {
        LOG.info("Atomically moving {}/{}'s WALs to {}", new Object[]{sourceServerName, queueId, destServerName});
        try {
            ZKUtil.createWithParents(this.zookeeper, this.getRsNode(destServerName));
        }
        catch (KeeperException e) {
            throw new ReplicationException("Claim queue queueId=" + queueId + " from " + sourceServerName + " to " + destServerName + " failed when creating the node for " + destServerName, e);
        }
        String newQueueId = queueId + "-" + sourceServerName;
        try {
            String oldQueueNode = this.getQueueNode(sourceServerName, queueId);
            List<String> wals = ZKUtil.listChildrenNoWatch(this.zookeeper, oldQueueNode);
            if (CollectionUtils.isEmpty(wals)) {
                ZKUtil.deleteNodeFailSilent(this.zookeeper, oldQueueNode);
                LOG.info("Removed empty {}/{}", (Object)sourceServerName, (Object)queueId);
                return new Pair<String, SortedSet<String>>(newQueueId, Collections.emptySortedSet());
            }
            String newQueueNode = this.getQueueNode(destServerName, newQueueId);
            ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
            TreeSet<String> logQueue = new TreeSet<String>();
            listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(newQueueNode, HConstants.EMPTY_BYTE_ARRAY));
            for (String wal : wals) {
                String oldWalNode = this.getFileNode(oldQueueNode, wal);
                byte[] logOffset = ZKUtil.getData(this.zookeeper, oldWalNode);
                LOG.debug("Creating {} with data {}", (Object)wal, (Object)Bytes.toStringBinary(logOffset));
                String newWalNode = this.getFileNode(newQueueNode, wal);
                listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(newWalNode, logOffset));
                listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldWalNode));
                logQueue.add(wal);
            }
            listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldQueueNode));
            LOG.trace("The multi list size is {}", (Object)listOfOps.size());
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, false);
            LOG.info("Atomically moved {}/{}'s WALs to {}", new Object[]{sourceServerName, queueId, destServerName});
            return new Pair<String, SortedSet<String>>(newQueueId, logQueue);
        }
        catch (KeeperException.BadVersionException | KeeperException.NoNodeException | KeeperException.NodeExistsException | KeeperException.NotEmptyException e) {
            LOG.info("Claim queue queueId={} from {} to {} failed with {}, someone else took the log?", new Object[]{queueId, sourceServerName, destServerName, e.toString()});
            return new Pair<String, SortedSet<String>>(newQueueId, Collections.emptySortedSet());
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Claim queue queueId=" + queueId + " from " + sourceServerName + " to " + destServerName + " failed", e);
        }
    }

    @Override
    public void removeReplicatorIfQueueIsEmpty(ServerName serverName) throws ReplicationException {
        try {
            ZKUtil.deleteNodeFailSilent(this.zookeeper, this.getRsNode(serverName));
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to remove replicator for " + serverName, e);
        }
    }

    private List<ServerName> getListOfReplicators0() throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.queuesZNode);
        if (children == null) {
            children = Collections.emptyList();
        }
        return children.stream().map(ServerName::parseServerName).collect(Collectors.toList());
    }

    @Override
    public List<ServerName> getListOfReplicators() throws ReplicationException {
        try {
            return this.getListOfReplicators0();
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get list of replicators", e);
        }
    }

    private List<String> getWALsInQueue0(ServerName serverName, String queueId) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.getQueueNode(serverName, queueId));
        return children != null ? children : Collections.emptyList();
    }

    @Override
    public List<String> getWALsInQueue(ServerName serverName, String queueId) throws ReplicationException {
        try {
            return this.getWALsInQueue0(serverName, queueId);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get wals in queue (serverName=" + serverName + ", queueId=" + queueId + ")", e);
        }
    }

    private List<String> getAllQueues0(ServerName serverName) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.getRsNode(serverName));
        return children != null ? children : Collections.emptyList();
    }

    @Override
    public List<String> getAllQueues(ServerName serverName) throws ReplicationException {
        try {
            return this.getAllQueues0(serverName);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get all queues (serverName=" + serverName + ")", e);
        }
    }

    @VisibleForTesting
    protected int getQueuesZNodeCversion() throws KeeperException {
        Stat stat = new Stat();
        ZKUtil.getDataNoWatch(this.zookeeper, this.queuesZNode, stat);
        return stat.getCversion();
    }

    @Override
    public Set<String> getAllWALs() throws ReplicationException {
        try {
            int retry = 0;
            while (true) {
                int v0 = this.getQueuesZNodeCversion();
                List<ServerName> rss = this.getListOfReplicators0();
                if (rss.isEmpty()) {
                    LOG.debug("Didn't find a RegionServer that replicates, won't prevent deletions.");
                    return Collections.emptySet();
                }
                HashSet<String> wals = new HashSet<String>();
                for (ServerName rs : rss) {
                    for (String queueId : this.getAllQueues0(rs)) {
                        wals.addAll(this.getWALsInQueue0(rs, queueId));
                    }
                }
                int v1 = this.getQueuesZNodeCversion();
                if (v0 == v1) {
                    return wals;
                }
                LOG.info("Replication queue node cversion changed from %d to %d, retry = %d", new Object[]{v0, v1, retry});
                ++retry;
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get all wals", e);
        }
    }

    private String getHFileRefsPeerNode(String peerId) {
        return ZNodePaths.joinZNode(this.hfileRefsZNode, peerId);
    }

    private String getHFileNode(String peerNode, String fileName) {
        return ZNodePaths.joinZNode(peerNode, fileName);
    }

    @Override
    public void addPeerToHFileRefs(String peerId) throws ReplicationException {
        String peerNode = this.getHFileRefsPeerNode(peerId);
        try {
            if (ZKUtil.checkExists(this.zookeeper, peerNode) == -1) {
                LOG.info("Adding peer {} to hfile reference queue.", (Object)peerId);
                ZKUtil.createWithParents(this.zookeeper, peerNode);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to add peer " + peerId + " to hfile reference queue.", e);
        }
    }

    @Override
    public void removePeerFromHFileRefs(String peerId) throws ReplicationException {
        String peerNode = this.getHFileRefsPeerNode(peerId);
        try {
            if (ZKUtil.checkExists(this.zookeeper, peerNode) == -1) {
                LOG.debug("Peer {} not found in hfile reference queue.", (Object)peerNode);
            } else {
                LOG.info("Removing peer {} from hfile reference queue.", (Object)peerNode);
                ZKUtil.deleteNodeRecursively(this.zookeeper, peerNode);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to remove peer " + peerId + " from hfile reference queue.", e);
        }
    }

    @Override
    public void addHFileRefs(String peerId, List<Pair<Path, Path>> pairs) throws ReplicationException {
        String peerNode = this.getHFileRefsPeerNode(peerId);
        LOG.debug("Adding hfile references {} in queue {}", pairs, (Object)peerNode);
        List<ZKUtil.ZKUtilOp> listOfOps = pairs.stream().map(p -> ((Path)p.getSecond()).getName()).map(n -> this.getHFileNode(peerNode, (String)n)).map(f -> ZKUtil.ZKUtilOp.createAndFailSilent(f, HConstants.EMPTY_BYTE_ARRAY)).collect(Collectors.toList());
        LOG.debug("The multi list size for adding hfile references in zk for node {} is {}", (Object)peerNode, (Object)listOfOps.size());
        try {
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, true);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to add hfile reference to peer " + peerId, e);
        }
    }

    @Override
    public void removeHFileRefs(String peerId, List<String> files) throws ReplicationException {
        String peerNode = this.getHFileRefsPeerNode(peerId);
        LOG.debug("Removing hfile references {} from queue {}", files, (Object)peerNode);
        List<ZKUtil.ZKUtilOp> listOfOps = files.stream().map(n -> this.getHFileNode(peerNode, (String)n)).map(ZKUtil.ZKUtilOp::deleteNodeFailSilent).collect(Collectors.toList());
        LOG.debug("The multi list size for removing hfile references in zk for node {} is {}", (Object)peerNode, (Object)listOfOps.size());
        try {
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, true);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to remove hfile reference from peer " + peerId, e);
        }
    }

    private List<String> getAllPeersFromHFileRefsQueue0() throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.hfileRefsZNode);
        return children != null ? children : Collections.emptyList();
    }

    @Override
    public List<String> getAllPeersFromHFileRefsQueue() throws ReplicationException {
        try {
            return this.getAllPeersFromHFileRefsQueue0();
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get list of all peers in hfile references node.", e);
        }
    }

    private List<String> getReplicableHFiles0(String peerId) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.getHFileRefsPeerNode(peerId));
        return children != null ? children : Collections.emptyList();
    }

    @Override
    public List<String> getReplicableHFiles(String peerId) throws ReplicationException {
        try {
            return this.getReplicableHFiles0(peerId);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get list of hfile references for peer " + peerId, e);
        }
    }

    @VisibleForTesting
    protected int getHFileRefsZNodeCversion() throws ReplicationException {
        Stat stat = new Stat();
        try {
            ZKUtil.getDataNoWatch(this.zookeeper, this.hfileRefsZNode, stat);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get stat of replication hfile references node.", e);
        }
        return stat.getCversion();
    }

    @Override
    public Set<String> getAllHFileRefs() throws ReplicationException {
        try {
            int retry = 0;
            while (true) {
                int v0 = this.getHFileRefsZNodeCversion();
                List<String> peers = this.getAllPeersFromHFileRefsQueue();
                if (peers.isEmpty()) {
                    LOG.debug("Didn't find any peers with hfile references, won't prevent deletions.");
                    return Collections.emptySet();
                }
                HashSet<String> hfileRefs = new HashSet<String>();
                for (String peer : peers) {
                    hfileRefs.addAll(this.getReplicableHFiles0(peer));
                }
                int v1 = this.getHFileRefsZNodeCversion();
                if (v0 == v1) {
                    return hfileRefs;
                }
                LOG.debug("Replication hfile references node cversion changed from %d to %d, retry = %d", new Object[]{v0, v1, retry});
                ++retry;
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to get all hfile refs", e);
        }
    }
}

