/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.LogRecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BoundedLogWriterCreationOutputSink
extends LogRecoveredEditsOutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(BoundedLogWriterCreationOutputSink.class);
    private ConcurrentHashMap<String, Long> regionRecoverStatMap = new ConcurrentHashMap();

    public BoundedLogWriterCreationOutputSink(WALSplitter walSplitter, WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        super(walSplitter, controller, entryBuffers, numWriters);
    }

    @Override
    public List<Path> finishWritingAndClose() throws IOException {
        List<Path> result;
        boolean isSuccessful;
        try {
            isSuccessful = this.finishWriting(false);
        }
        finally {
            result = this.close();
        }
        if (isSuccessful) {
            this.splits = result;
        }
        return this.splits;
    }

    @Override
    boolean executeCloseTask(CompletionService<Void> completionService, List<IOException> thrown, final List<Path> paths) throws InterruptedException, ExecutionException {
        for (final Map.Entry<byte[], WALSplitter.RegionEntryBuffer> buffer : this.entryBuffers.buffers.entrySet()) {
            LOG.info("Submitting writeThenClose of {}", (Object)Arrays.toString(buffer.getValue().encodedRegionName));
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Path dst = BoundedLogWriterCreationOutputSink.this.writeThenClose((WALSplitter.RegionEntryBuffer)buffer.getValue());
                    paths.add(dst);
                    return null;
                }
            });
        }
        boolean progress_failed = false;
        int n = this.entryBuffers.buffers.size();
        for (int i = 0; i < n; ++i) {
            Future<Void> future = completionService.take();
            future.get();
            if (progress_failed || this.reporter == null || this.reporter.progress()) continue;
            progress_failed = true;
        }
        return progress_failed;
    }

    @Override
    public Map<byte[], Long> getOutputCounts() {
        HashMap<byte[], Long> regionRecoverStatMapResult = new HashMap<byte[], Long>();
        for (Map.Entry<String, Long> entry : this.regionRecoverStatMap.entrySet()) {
            regionRecoverStatMapResult.put(Bytes.toBytes(entry.getKey()), entry.getValue());
        }
        return regionRecoverStatMapResult;
    }

    @Override
    public int getNumberOfRecoveredRegions() {
        return this.regionRecoverStatMap.size();
    }

    @Override
    public void append(WALSplitter.RegionEntryBuffer buffer) throws IOException {
        this.writeThenClose(buffer);
    }

    private Path writeThenClose(WALSplitter.RegionEntryBuffer buffer) throws IOException {
        String encodedRegionName;
        Long value;
        WALSplitter.WriterAndPath wap = this.appendBuffer(buffer, false);
        if (wap != null && (value = this.regionRecoverStatMap.putIfAbsent(encodedRegionName = Bytes.toString(buffer.encodedRegionName), wap.editsWritten)) != null) {
            Long newValue = this.regionRecoverStatMap.get(encodedRegionName) + wap.editsWritten;
            this.regionRecoverStatMap.put(encodedRegionName, newValue);
        }
        Path dst = null;
        ArrayList<IOException> thrown = new ArrayList<IOException>();
        if (wap != null) {
            dst = this.closeWriter(Bytes.toString(buffer.encodedRegionName), wap, thrown);
        }
        if (!thrown.isEmpty()) {
            throw MultipleIOException.createIOException(thrown);
        }
        return dst;
    }
}

