/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FavoredNodesPlan {
    private Map<String, List<ServerName>> favoredNodesMap = new ConcurrentHashMap<String, List<ServerName>>();

    public void updateFavoredNodesMap(RegionInfo region, List<ServerName> servers) {
        if (region == null || servers == null || servers.isEmpty()) {
            return;
        }
        this.favoredNodesMap.put(region.getRegionNameAsString(), servers);
    }

    public List<ServerName> removeFavoredNodes(RegionInfo region) {
        return this.favoredNodesMap.remove(region.getRegionNameAsString());
    }

    public List<ServerName> getFavoredNodes(RegionInfo region) {
        return this.favoredNodesMap.get(region.getRegionNameAsString());
    }

    public static Position getFavoredServerPosition(List<ServerName> favoredNodes, ServerName server) {
        if (favoredNodes == null || server == null || favoredNodes.size() != 3) {
            return null;
        }
        for (Position p : Position.values()) {
            if (!ServerName.isSameAddress(favoredNodes.get(p.ordinal()), server)) continue;
            return p;
        }
        return null;
    }

    public Map<String, List<ServerName>> getAssignmentMap() {
        return this.favoredNodesMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Map<String, List<ServerName>> comparedMap = ((FavoredNodesPlan)o).getAssignmentMap();
        if (comparedMap.size() != this.favoredNodesMap.size()) {
            return false;
        }
        for (Map.Entry<String, List<ServerName>> entry : comparedMap.entrySet()) {
            List<ServerName> serverList = this.favoredNodesMap.get(entry.getKey());
            if (serverList == null && entry.getValue() != null) {
                return false;
            }
            if (serverList == null || serverList.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.favoredNodesMap.hashCode();
    }

    public static enum Position {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

