/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferArray;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferIOEngine
implements IOEngine {
    private ByteBufferArray bufferArray;
    private final long capacity;

    public ByteBufferIOEngine(long capacity) throws IOException {
        this.capacity = capacity;
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            @Override
            public ByteBuffer allocate(long size) throws IOException {
                return ByteBuffer.allocateDirect((int)size);
            }
        };
        this.bufferArray = new ByteBufferArray(capacity, allocator);
    }

    public String toString() {
        return "ioengine=" + this.getClass().getSimpleName() + ", capacity=" + String.format("%,d", this.capacity);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean usesSharedMemory() {
        return true;
    }

    @Override
    public Cacheable read(long offset, int length, CacheableDeserializer<Cacheable> deserializer) throws IOException {
        ByteBuff dstBuffer = this.bufferArray.asSubByteBuff(offset, length);
        return deserializer.deserialize(dstBuffer, true, Cacheable.MemoryType.SHARED);
    }

    @Override
    public void write(ByteBuffer srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void write(ByteBuff srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void sync() {
    }

    @Override
    public void shutdown() {
    }
}

