/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetaFixer;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.GCMultipleMergedRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CatalogJanitor
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger((String)CatalogJanitor.class.getName());
    private final AtomicBoolean alreadyRunning = new AtomicBoolean(false);
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final MasterServices services;
    private volatile Report lastReport;

    CatalogJanitor(MasterServices services) {
        super("CatalogJanitor-" + services.getServerName().toShortString(), services, services.getConfiguration().getInt("hbase.catalogjanitor.interval", 300000));
        this.services = services;
    }

    @Override
    protected boolean initialChore() {
        try {
            if (this.getEnabled()) {
                this.scan();
            }
        }
        catch (IOException e) {
            LOG.warn("Failed initial janitorial scan of hbase:meta table", (Throwable)e);
            return false;
        }
        return true;
    }

    boolean setEnabled(boolean enabled) {
        boolean alreadyEnabled = this.enabled.getAndSet(enabled);
        if (!enabled && alreadyEnabled) {
            while (this.alreadyRunning.get()) {
                Threads.sleepWithoutInterrupt(100L);
            }
        }
        return alreadyEnabled;
    }

    boolean getEnabled() {
        return this.enabled.get();
    }

    @Override
    protected void chore() {
        try {
            AssignmentManager am = this.services.getAssignmentManager();
            if (this.getEnabled() && !this.services.isInMaintenanceMode() && !this.services.getServerManager().isClusterShutdown() && CatalogJanitor.isMetaLoaded(am)) {
                this.scan();
            } else {
                LOG.warn("CatalogJanitor is disabled! Enabled=" + this.getEnabled() + ", maintenanceMode=" + this.services.isInMaintenanceMode() + ", am=" + am + ", metaLoaded=" + CatalogJanitor.isMetaLoaded(am) + ", hasRIT=" + CatalogJanitor.isRIT(am) + " clusterShutDown=" + this.services.getServerManager().isClusterShutdown());
            }
        }
        catch (IOException e) {
            LOG.warn("Failed janitorial scan of hbase:meta table", (Throwable)e);
        }
    }

    private static boolean isMetaLoaded(AssignmentManager am) {
        return am != null && am.isMetaLoaded();
    }

    private static boolean isRIT(AssignmentManager am) {
        return CatalogJanitor.isMetaLoaded(am) && am.hasRegionsInTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int scan() throws IOException {
        int gcs = 0;
        try {
            Report report;
            if (!this.alreadyRunning.compareAndSet(false, true)) {
                LOG.debug("CatalogJanitor already running");
                int n = gcs;
                return n;
            }
            this.lastReport = report = this.scanForReport();
            if (!report.isEmpty()) {
                LOG.warn(report.toString());
            }
            if (CatalogJanitor.isRIT(this.services.getAssignmentManager())) {
                LOG.warn("Playing-it-safe skipping merge/split gc'ing of regions from hbase:meta while regions-in-transition (RIT)");
            }
            Map<RegionInfo, Result> mergedRegions = report.mergedRegions;
            for (Map.Entry<RegionInfo, Result> e : mergedRegions.entrySet()) {
                if (this.services.isInMaintenanceMode()) break;
                List<RegionInfo> parents = MetaTableAccessor.getMergeRegions(e.getValue().rawCells());
                if (parents == null || !this.cleanMergeRegion(e.getKey(), parents)) continue;
                ++gcs;
            }
            Map<RegionInfo, Result> splitParents = report.splitParents;
            HashSet<String> parentNotCleaned = new HashSet<String>();
            for (Map.Entry<RegionInfo, Result> e : splitParents.entrySet()) {
                if (this.services.isInMaintenanceMode()) break;
                if (!parentNotCleaned.contains(e.getKey().getEncodedName()) && this.cleanParent(e.getKey(), e.getValue())) {
                    ++gcs;
                    continue;
                }
                PairOfSameType<RegionInfo> daughters = MetaTableAccessor.getDaughterRegions(e.getValue());
                parentNotCleaned.add(daughters.getFirst().getEncodedName());
                parentNotCleaned.add(daughters.getSecond().getEncodedName());
            }
            int n = gcs;
            return n;
        }
        finally {
            this.alreadyRunning.set(false);
        }
    }

    Report scanForReport() throws IOException {
        ReportMakingVisitor visitor = new ReportMakingVisitor(this.services);
        MetaTableAccessor.scanMetaForTableRegions(this.services.getConnection(), visitor, null);
        return visitor.getReport();
    }

    public Report getLastReport() {
        return this.lastReport;
    }

    private boolean cleanMergeRegion(RegionInfo mergedRegion, List<RegionInfo> parents) throws IOException {
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, mergedRegion.getTable());
        TableDescriptor htd = this.getDescriptor(mergedRegion.getTable());
        HRegionFileSystem regionFs = null;
        try {
            regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, mergedRegion, true);
        }
        catch (IOException e) {
            LOG.warn("Merged region does not exist: " + mergedRegion.getEncodedName());
        }
        if (regionFs == null || !regionFs.hasReferences(htd)) {
            LOG.debug("Deleting parents ({}) from fs; merged child {} no longer holds references", (Object)parents.stream().map(r -> RegionInfo.getShortNameToLog(r)).collect(Collectors.joining(", ")), (Object)mergedRegion);
            ProcedureExecutor<MasterProcedureEnv> pe = this.services.getMasterProcedureExecutor();
            pe.submitProcedure(new GCMultipleMergedRegionsProcedure(pe.getEnvironment(), mergedRegion, parents));
            for (RegionInfo ri : parents) {
                this.services.getAssignmentManager().getRegionStates().deleteRegion(ri);
                this.services.getServerManager().removeRegion(ri);
            }
            return true;
        }
        return false;
    }

    boolean cleanParent(RegionInfo parent, Result rowContent) throws IOException {
        if (MetaTableAccessor.hasMergeRegions(rowContent.rawCells())) {
            return false;
        }
        PairOfSameType<RegionInfo> daughters = MetaTableAccessor.getDaughterRegions(rowContent);
        Pair<Boolean, Boolean> a = this.checkDaughterInFs(parent, daughters.getFirst());
        Pair<Boolean, Boolean> b = this.checkDaughterInFs(parent, daughters.getSecond());
        if (this.hasNoReferences(a) && this.hasNoReferences(b)) {
            String daughterA = daughters.getFirst() != null ? daughters.getFirst().getShortNameToLog() : "null";
            String daughterB = daughters.getSecond() != null ? daughters.getSecond().getShortNameToLog() : "null";
            LOG.debug("Deleting region " + parent.getShortNameToLog() + " because daughters -- " + daughterA + ", " + daughterB + " -- no longer hold references");
            ProcedureExecutor<MasterProcedureEnv> pe = this.services.getMasterProcedureExecutor();
            pe.submitProcedure(new GCRegionProcedure(pe.getEnvironment(), parent));
            this.services.getAssignmentManager().getRegionStates().deleteRegion(parent);
            this.services.getServerManager().removeRegion(parent);
            return true;
        }
        return false;
    }

    private boolean hasNoReferences(Pair<Boolean, Boolean> p) {
        return p.getFirst() == false || p.getSecond() == false;
    }

    private Pair<Boolean, Boolean> checkDaughterInFs(RegionInfo parent, RegionInfo daughter) throws IOException {
        if (daughter == null) {
            return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
        }
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, daughter.getTable());
        Path daughterRegionDir = new Path(tabledir, daughter.getEncodedName());
        try {
            if (!FSUtils.isExists(fs, daughterRegionDir)) {
                return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
            }
        }
        catch (IOException ioe) {
            LOG.error("Error trying to determine if daughter region exists, assuming exists and has references", (Throwable)ioe);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        boolean references = false;
        TableDescriptor parentDescriptor = this.getDescriptor(parent.getTable());
        try {
            ColumnFamilyDescriptor family;
            HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, daughter, true);
            ColumnFamilyDescriptor[] columnFamilyDescriptorArray = parentDescriptor.getColumnFamilies();
            int n = columnFamilyDescriptorArray.length;
            for (int i = 0; i < n && !(references = regionFs.hasReferences((family = columnFamilyDescriptorArray[i]).getNameAsString())); ++i) {
            }
        }
        catch (IOException e) {
            LOG.error("Error trying to determine referenced files from : " + daughter.getEncodedName() + ", to: " + parent.getEncodedName() + " assuming has references", (Throwable)e);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        return new Pair<Boolean, Boolean>(Boolean.TRUE, references);
    }

    private TableDescriptor getDescriptor(TableName tableName) throws IOException {
        return this.services.getTableDescriptors().get(tableName);
    }

    public boolean cleanMergeQualifier(RegionInfo region) throws IOException {
        List<RegionInfo> parents = MetaTableAccessor.getMergeRegions(this.services.getConnection(), region.getRegionName());
        if (parents == null || parents.isEmpty()) {
            return true;
        }
        return this.cleanMergeRegion(region, parents);
    }

    private static void checkLog4jProperties() {
        String filename = "log4j.properties";
        try {
            InputStream inStream = CatalogJanitor.class.getClassLoader().getResourceAsStream(filename);
            if (inStream != null) {
                new Properties().load(inStream);
            } else {
                System.out.println("No " + filename + " on classpath; Add one else no logging output!");
            }
        }
        catch (IOException e) {
            LOG.error("Log4j check failed", (Throwable)e);
        }
    }

    public static void main(String[] args) throws IOException {
        CatalogJanitor.checkLog4jProperties();
        ReportMakingVisitor visitor = new ReportMakingVisitor(null);
        Configuration configuration = HBaseConfiguration.create();
        configuration.setBoolean("hbase.defaults.for.version.skip", true);
        try (Connection connection = ConnectionFactory.createConnection(configuration);){
            Get g = new Get(Bytes.toBytes("t2,40,1564119846424.1db8c57d64e0733e0f027aaeae7a0bf0."));
            g.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            try (Table t = connection.getTable(TableName.META_TABLE_NAME);){
                Result r = t.get(g);
                byte[] row = g.getRow();
                int n = row.length - 2;
                row[n] = (byte)(row[n] << row[row.length - 2]);
                Put p = new Put(g.getRow());
                p.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                t.put(p);
            }
            MetaTableAccessor.scanMetaForTableRegions(connection, visitor, null);
            Report report = visitor.getReport();
            LOG.info(report != null ? report.toString() : "empty");
        }
    }

    static class ReportMakingVisitor
    implements MetaTableAccessor.CloseableVisitor {
        private final MasterServices services;
        private volatile boolean closed;
        private Report report = new Report();
        private RegionInfo previous = null;
        private RegionInfo highestEndKeyRegionInfo = null;

        ReportMakingVisitor(MasterServices services) {
            this.services = services;
        }

        Report getReport() {
            if (!this.closed) {
                throw new RuntimeException("Report not ready until after close()");
            }
            return this.report;
        }

        @Override
        public boolean visit(Result r) {
            if (r == null || r.isEmpty()) {
                return true;
            }
            ++this.report.count;
            RegionInfo regionInfo = this.metaTableConsistencyCheck(r);
            if (regionInfo != null) {
                LOG.trace(regionInfo.toString());
                if (regionInfo.isSplitParent()) {
                    this.report.splitParents.put(regionInfo, r);
                }
                if (MetaTableAccessor.hasMergeRegions(r.rawCells())) {
                    this.report.mergedRegions.put(regionInfo, r);
                }
            }
            return true;
        }

        private RegionInfo metaTableConsistencyCheck(Result metaTableRow) {
            RegionInfo ri;
            RegionLocations locations = MetaTableAccessor.getRegionLocations(metaTableRow);
            if (locations == null) {
                ri = MetaTableAccessor.getRegionInfo(metaTableRow, MetaTableAccessor.getRegionInfoColumn());
            } else {
                ri = locations.getDefaultRegionLocation().getRegion();
                this.checkServer(locations);
            }
            if (ri == null) {
                this.report.emptyRegionInfo.add(metaTableRow.getRow());
                return ri;
            }
            if (!Bytes.equals(metaTableRow.getRow(), ri.getRegionName())) {
                LOG.warn("INCONSISTENCY: Row name is not equal to serialized info:regioninfo content; row={} {}; See if RegionInfo is referenced in another hbase:meta row? Delete?", (Object)Bytes.toStringBinary(metaTableRow.getRow()), (Object)ri.getRegionNameAsString());
                return null;
            }
            if (ri.isSplitParent()) {
                return ri;
            }
            if (!this.isTableDisabled(ri)) {
                if (this.isTableTransition(ri)) {
                    if (this.previous != null && !this.previous.isLast() || !ri.isFirst()) {
                        this.addHole(this.previous == null ? RegionInfo.UNDEFINED : this.previous, ri);
                    }
                } else if (!this.previous.isNext(ri)) {
                    if (this.previous.isOverlap(ri)) {
                        this.addOverlap(this.previous, ri);
                    } else if (ri.isOverlap(this.highestEndKeyRegionInfo)) {
                        this.addOverlap(this.highestEndKeyRegionInfo, ri);
                    } else {
                        this.addHole(this.previous, ri);
                    }
                } else if (ri.isOverlap(this.highestEndKeyRegionInfo)) {
                    this.addOverlap(this.highestEndKeyRegionInfo, ri);
                }
            }
            this.previous = ri;
            this.highestEndKeyRegionInfo = MetaFixer.getRegionInfoWithLargestEndKey(this.highestEndKeyRegionInfo, ri);
            return ri;
        }

        private void addOverlap(RegionInfo a, RegionInfo b) {
            this.report.overlaps.add(new Pair<RegionInfo, RegionInfo>(a, b));
        }

        private void addHole(RegionInfo a, RegionInfo b) {
            this.report.holes.add(new Pair<RegionInfo, RegionInfo>(a, b));
        }

        boolean isTableDisabled(RegionInfo ri) {
            if (ri == null) {
                return false;
            }
            if (this.services == null) {
                return false;
            }
            if (this.services.getTableStateManager() == null) {
                return false;
            }
            TableState state = null;
            try {
                state = this.services.getTableStateManager().getTableState(ri.getTable());
            }
            catch (IOException e) {
                LOG.warn("Failed getting table state", (Throwable)e);
            }
            return state != null && state.isDisabledOrDisabling();
        }

        private void checkServer(RegionLocations locations) {
            if (this.services == null) {
                return;
            }
            if (locations == null) {
                return;
            }
            block3: for (HRegionLocation location : locations.getRegionLocations()) {
                ServerName sn = location.getServerName();
                if (sn == null) continue;
                if (location.getRegion() == null) {
                    LOG.warn("Empty RegionInfo in {}", (Object)location);
                    continue;
                }
                if (location.getRegion().isSplitParent() || this.isTableDisabled(location.getRegion())) continue;
                ServerManager.ServerLiveState state = this.services.getServerManager().isServerKnownAndOnline(sn);
                switch (state) {
                    case UNKNOWN: {
                        this.report.unknownServers.add(new Pair<RegionInfo, ServerName>(location.getRegion(), sn));
                        continue block3;
                    }
                }
            }
        }

        private boolean isTableTransition(RegionInfo ri) {
            return this.previous == null || !this.previous.getTable().equals(ri.getTable());
        }

        @Override
        public void close() throws IOException {
            if (this.previous != null && !this.previous.isLast()) {
                this.addHole(this.previous, RegionInfo.UNDEFINED);
            }
            this.closed = true;
        }
    }

    public static class Report {
        private final long now = EnvironmentEdgeManager.currentTime();
        final Map<RegionInfo, Result> splitParents = new TreeMap<RegionInfo, Result>(new SplitParentFirstComparator());
        final Map<RegionInfo, Result> mergedRegions = new TreeMap<RegionInfo, Result>(RegionInfo.COMPARATOR);
        int count = 0;
        private final List<Pair<RegionInfo, RegionInfo>> holes = new ArrayList<Pair<RegionInfo, RegionInfo>>();
        private final List<Pair<RegionInfo, RegionInfo>> overlaps = new ArrayList<Pair<RegionInfo, RegionInfo>>();
        private final List<Pair<RegionInfo, ServerName>> unknownServers = new ArrayList<Pair<RegionInfo, ServerName>>();
        private final List<byte[]> emptyRegionInfo = new ArrayList<byte[]>();

        @VisibleForTesting
        Report() {
        }

        public long getCreateTime() {
            return this.now;
        }

        public List<Pair<RegionInfo, RegionInfo>> getHoles() {
            return this.holes;
        }

        public List<Pair<RegionInfo, RegionInfo>> getOverlaps() {
            return this.overlaps;
        }

        public List<Pair<RegionInfo, ServerName>> getUnknownServers() {
            return this.unknownServers;
        }

        public List<byte[]> getEmptyRegionInfo() {
            return this.emptyRegionInfo;
        }

        public boolean isEmpty() {
            return this.holes.isEmpty() && this.overlaps.isEmpty() && this.unknownServers.isEmpty() && this.emptyRegionInfo.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Pair<RegionInfo, RegionInfo> pair : this.holes) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("hole=").append(pair.getFirst().getRegionNameAsString()).append("/").append(pair.getSecond().getRegionNameAsString());
            }
            for (Pair<RegionInfo, RegionInfo> pair : this.overlaps) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("overlap=").append(pair.getFirst().getRegionNameAsString()).append("/").append(pair.getSecond().getRegionNameAsString());
            }
            for (byte[] byArray : this.emptyRegionInfo) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("empty=").append(Bytes.toStringBinary(byArray));
            }
            for (Pair<RegionInfo, Object> pair : this.unknownServers) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("unknown_server=").append(pair.getSecond()).append("/").append(pair.getFirst().getRegionNameAsString());
            }
            return sb.toString();
        }
    }

    static class SplitParentFirstComparator
    implements Comparator<RegionInfo> {
        Comparator<byte[]> rowEndKeyComparator = new Bytes.RowEndKeyComparator();

        SplitParentFirstComparator() {
        }

        @Override
        public int compare(RegionInfo left, RegionInfo right) {
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int result = left.getTable().compareTo(right.getTable());
            if (result != 0) {
                return result;
            }
            result = Bytes.compareTo(left.getStartKey(), right.getStartKey());
            if (result != 0) {
                return result;
            }
            result = this.rowEndKeyComparator.compare(right.getEndKey(), left.getEndKey());
            return result;
        }
    }
}

