/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.MonitoredTaskImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MonitoredRPCHandlerImpl
extends MonitoredTaskImpl
implements MonitoredRPCHandler {
    private String clientAddress;
    private int remotePort;
    private long rpcQueueTime;
    private long rpcStartTime;
    private String methodName = "";
    private Object[] params = new Object[0];
    private Message packet;

    public MonitoredRPCHandlerImpl() {
        this.setState(MonitoredTask.State.WAITING);
    }

    @Override
    public synchronized MonitoredRPCHandlerImpl clone() {
        return (MonitoredRPCHandlerImpl)super.clone();
    }

    @Override
    public String getStatus() {
        if (this.getState() != MonitoredTask.State.RUNNING) {
            return super.getStatus();
        }
        return super.getStatus() + " from " + this.getClient() + ": " + this.getRPC();
    }

    @Override
    public long getRPCQueueTime() {
        if (this.getState() != MonitoredTask.State.RUNNING) {
            return -1L;
        }
        return this.rpcQueueTime;
    }

    @Override
    public long getRPCStartTime() {
        if (this.getState() != MonitoredTask.State.RUNNING) {
            return -1L;
        }
        return this.rpcStartTime;
    }

    @Override
    public synchronized String getRPC() {
        return this.getRPC(false);
    }

    @Override
    public synchronized String getRPC(boolean withParams) {
        if (this.getState() != MonitoredTask.State.RUNNING) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.methodName);
        if (withParams) {
            buffer.append("(");
            for (int i = 0; i < this.params.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.params[i]);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public long getRPCPacketLength() {
        if (this.getState() != MonitoredTask.State.RUNNING || this.packet == null) {
            return -1L;
        }
        return this.packet.getSerializedSize();
    }

    @Override
    public String getClient() {
        return this.clientAddress + ":" + this.remotePort;
    }

    @Override
    public boolean isRPCRunning() {
        return this.getState() == MonitoredTask.State.RUNNING;
    }

    @Override
    public synchronized boolean isOperationRunning() {
        if (!this.isRPCRunning()) {
            return false;
        }
        for (Object param : this.params) {
            if (!(param instanceof Operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void setRPC(String methodName, Object[] params, long queueTime) {
        long now;
        this.methodName = methodName;
        this.params = params;
        this.rpcStartTime = now = System.currentTimeMillis();
        this.setWarnTime(now);
        this.rpcQueueTime = queueTime;
        this.state = MonitoredTask.State.RUNNING;
    }

    @Override
    public void setRPCPacket(Message param) {
        this.packet = param;
    }

    @Override
    public void setConnection(String clientAddress, int remotePort) {
        this.clientAddress = clientAddress;
        this.remotePort = remotePort;
    }

    @Override
    public synchronized void markComplete(String status) {
        super.markComplete(status);
        this.params = null;
        this.packet = null;
    }

    @Override
    public synchronized Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (this.getState() != MonitoredTask.State.RUNNING) {
            return map;
        }
        HashMap<String, Object> rpcJSON = new HashMap<String, Object>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        map.put("rpcCall", rpcJSON);
        rpcJSON.put("queuetimems", this.getRPCQueueTime());
        rpcJSON.put("starttimems", this.getRPCStartTime());
        rpcJSON.put("clientaddress", this.clientAddress);
        rpcJSON.put("remoteport", this.remotePort);
        rpcJSON.put("packetlength", this.getRPCPacketLength());
        rpcJSON.put("method", this.methodName);
        rpcJSON.put("params", paramList);
        for (Object param : this.params) {
            if (param instanceof byte[]) {
                paramList.add(Bytes.toStringBinary((byte[])param));
                continue;
            }
            if (param instanceof Operation) {
                paramList.add(((Operation)param).toMap());
                continue;
            }
            paramList.add(param.toString());
        }
        return map;
    }

    @Override
    public String toString() {
        if (this.getState() != MonitoredTask.State.RUNNING) {
            return super.toString();
        }
        return super.toString() + ", queuetimems=" + this.getRPCQueueTime() + ", starttimems=" + this.getRPCStartTime() + ", clientaddress=" + this.clientAddress + ", remoteport=" + this.remotePort + ", packetlength=" + this.getRPCPacketLength() + ", rpcMethod=" + this.getRPC();
    }
}

