/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseSaslRpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSaslRpcServer.class);
    private final SaslServer saslServer;
    private UserGroupInformation attemptingUser;

    public HBaseSaslRpcServer(AuthMethod method, final Map<String, String> saslProps, SecretManager<TokenIdentifier> secretManager) throws IOException {
        switch (method) {
            case DIGEST: {
                if (secretManager == null) {
                    throw new AccessDeniedException("Server is not configured to do DIGEST authentication.");
                }
                this.saslServer = Sasl.createSaslServer(AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, new SaslDigestCallbackHandler(secretManager));
                break;
            }
            case KERBEROS: {
                String[] names;
                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                String fullName = current.getUserName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Kerberos principal name is " + fullName);
                }
                if ((names = SaslUtil.splitKerberosName(fullName)).length != 3) {
                    throw new AccessDeniedException("Kerberos principal name does NOT have the expected hostname part: " + fullName);
                }
                try {
                    this.saslServer = (SaslServer)current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslServer>(){

                        @Override
                        public SaslServer run() throws SaslException {
                            return Sasl.createSaslServer(AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], saslProps, new SaslGssCallbackHandler());
                        }
                    });
                    break;
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            default: {
                throw new IOException("Unknown authentication method " + (Object)((Object)method));
            }
        }
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.saslServer.evaluateResponse(response);
    }

    public void dispose() {
        SaslUtil.safeDispose(this.saslServer);
    }

    public UserGroupInformation getAttemptingUser() {
        return this.attemptingUser;
    }

    public byte[] wrap(byte[] buf, int off, int len) throws SaslException {
        return this.saslServer.wrap(buf, off, len);
    }

    public byte[] unwrap(byte[] buf, int off, int len) throws SaslException {
        return this.saslServer.unwrap(buf, off, len);
    }

    public String getNegotiatedQop() {
        return (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
    }

    public String getAuthorizationID() {
        return this.saslServer.getAuthorizationID();
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = SaslUtil.decodeIdentifier(id);
        TokenIdentifier tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
        }
        return (T)tokenIdentifier;
    }

    private static class SaslGssCallbackHandler
    implements CallbackHandler {
        private SaslGssCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL server GSSAPI callback: setting canonicalized client ID: " + authzid);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    private class SaslDigestCallbackHandler
    implements CallbackHandler {
        private SecretManager<TokenIdentifier> secretManager;

        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager) {
            this.secretManager = secretManager;
        }

        private char[] getPassword(TokenIdentifier tokenid) throws SecretManager.InvalidToken {
            return SaslUtil.encodePassword(this.secretManager.retrievePassword(tokenid));
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                TokenIdentifier tokenIdentifier = HBaseSaslRpcServer.getIdentifier(nc.getDefaultName(), this.secretManager);
                char[] password = this.getPassword(tokenIdentifier);
                UserGroupInformation user = tokenIdentifier.getUser();
                HBaseSaslRpcServer.this.attemptingUser = user;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser());
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isTraceEnabled()) {
                        String username = HBaseSaslRpcServer.getIdentifier(authzid, this.secretManager).getUser().getUserName();
                        LOG.trace("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

