/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class ZKLeaderManager
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZKLeaderManager.class);
    private final Object lock = new Object();
    private final AtomicBoolean leaderExists = new AtomicBoolean();
    private final String leaderZNode;
    private final byte[] nodeId;
    private final Stoppable candidate;

    public ZKLeaderManager(ZKWatcher watcher, String leaderZNode, byte[] identifier, Stoppable candidate) {
        super(watcher);
        this.leaderZNode = leaderZNode;
        this.nodeId = identifier;
        this.candidate = candidate;
    }

    public void start() {
        try {
            this.watcher.registerListener(this);
            String parent = ZKUtil.getParent(this.leaderZNode);
            if (ZKUtil.checkExists(this.watcher, parent) < 0) {
                ZKUtil.createWithParents(this.watcher, parent);
            }
        }
        catch (KeeperException ke) {
            this.watcher.abort("Unhandled zk exception when starting", ke);
            this.candidate.stop("Unhandled zk exception starting up: " + ke.getMessage());
        }
    }

    @Override
    public void nodeCreated(String path) {
        if (this.leaderZNode.equals(path) && !this.candidate.isStopped()) {
            this.handleLeaderChange();
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (this.leaderZNode.equals(path) && !this.candidate.isStopped()) {
            this.handleLeaderChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLeaderChange() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.leaderZNode)) {
                    LOG.info("Found new leader for znode: " + this.leaderZNode);
                    this.leaderExists.set(true);
                } else {
                    LOG.info("Leader change, but no new leader found");
                    this.leaderExists.set(false);
                    this.lock.notifyAll();
                }
            }
        }
        catch (KeeperException ke) {
            this.watcher.abort("ZooKeeper error checking for leader znode", ke);
            this.candidate.stop("ZooKeeper error checking for leader: " + ke.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBecomeLeader() {
        while (!this.candidate.isStopped()) {
            try {
                if (ZKUtil.createEphemeralNodeAndWatch(this.watcher, this.leaderZNode, this.nodeId)) {
                    this.leaderExists.set(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Claimed the leader znode as '" + Bytes.toStringBinary(this.nodeId) + "'");
                    }
                    return;
                }
                byte[] currentId = ZKUtil.getDataAndWatch(this.watcher, this.leaderZNode);
                if (currentId != null && Bytes.equals(currentId, this.nodeId)) {
                    LOG.info("Found existing leader with our ID (" + Bytes.toStringBinary(this.nodeId) + "), removing");
                    ZKUtil.deleteNode(this.watcher, this.leaderZNode);
                    this.leaderExists.set(false);
                } else {
                    LOG.info("Found existing leader with ID: " + Bytes.toStringBinary(this.nodeId));
                    this.leaderExists.set(true);
                }
            }
            catch (KeeperException ke) {
                this.watcher.abort("Unexpected error from ZK, stopping candidate", ke);
                this.candidate.stop("Unexpected error from ZK: " + ke.getMessage());
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                while (this.leaderExists.get() && !this.candidate.isStopped()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Interrupted waiting on leader", (Throwable)ie);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepDownAsLeader() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.leaderExists.get()) {
                    return;
                }
                byte[] leaderId = ZKUtil.getData(this.watcher, this.leaderZNode);
                if (leaderId != null && Bytes.equals(this.nodeId, leaderId)) {
                    LOG.info("Stepping down as leader");
                    ZKUtil.deleteNodeFailSilent(this.watcher, this.leaderZNode);
                    this.leaderExists.set(false);
                } else {
                    LOG.info("Not current leader, no need to step down");
                }
            }
        }
        catch (KeeperException ke) {
            this.watcher.abort("Unhandled zookeeper exception removing leader node", ke);
            this.candidate.stop("Unhandled zookeeper exception removing leader node: " + ke.getMessage());
        }
        catch (InterruptedException e) {
            this.watcher.abort("Unhandled zookeeper exception removing leader node", e);
            this.candidate.stop("Unhandled zookeeper exception removing leader node: " + e.getMessage());
        }
    }

    public boolean hasLeader() {
        return this.leaderExists.get();
    }
}

